/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoCredential;
import com.mongodb.MongoCredentialsStore;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bson.util.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class MongoAuthority {
    private final Type type;
    private final List<ServerAddress> serverAddresses;
    private final MongoCredentialsStore credentialsStore;

    public static MongoAuthority direct(ServerAddress serverAddress) {
        return MongoAuthority.direct(serverAddress, (MongoCredential)null);
    }

    public static MongoAuthority direct(ServerAddress serverAddress, MongoCredential credentials) {
        return MongoAuthority.direct(serverAddress, new MongoCredentialsStore(credentials));
    }

    public static MongoAuthority direct(ServerAddress serverAddress, MongoCredentialsStore credentialsStore) {
        return new MongoAuthority(serverAddress, credentialsStore);
    }

    public static MongoAuthority dynamicSet(List<ServerAddress> serverAddresses) {
        return MongoAuthority.dynamicSet(serverAddresses, (MongoCredential)null);
    }

    public static MongoAuthority dynamicSet(List<ServerAddress> serverAddresses, MongoCredential credentials) {
        return MongoAuthority.dynamicSet(serverAddresses, new MongoCredentialsStore(credentials));
    }

    public static MongoAuthority dynamicSet(List<ServerAddress> serverAddresses, MongoCredentialsStore credentialsStore) {
        return new MongoAuthority(serverAddresses, Type.Set, credentialsStore);
    }

    private MongoAuthority(ServerAddress serverAddress, MongoCredentialsStore credentialsStore) {
        if (serverAddress == null) {
            throw new IllegalArgumentException("serverAddress can not be null");
        }
        if (credentialsStore == null) {
            throw new IllegalArgumentException("credentialsStore can not be null");
        }
        this.serverAddresses = Arrays.asList(serverAddress);
        this.credentialsStore = credentialsStore;
        this.type = Type.Direct;
    }

    private MongoAuthority(List<ServerAddress> serverAddresses, Type type, MongoCredentialsStore credentialsStore) {
        if (serverAddresses == null) {
            throw new IllegalArgumentException("serverAddresses can not be null");
        }
        if (credentialsStore == null) {
            throw new IllegalArgumentException("credentialsStore can not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type can not be null");
        }
        if (type == Type.Direct) {
            throw new IllegalArgumentException("type can not be Direct with a list of server addresses");
        }
        this.type = type;
        this.serverAddresses = new ArrayList<ServerAddress>(serverAddresses);
        this.credentialsStore = credentialsStore;
    }

    public List<ServerAddress> getServerAddresses() {
        return this.serverAddresses == null ? null : Collections.unmodifiableList(this.serverAddresses);
    }

    public MongoCredentialsStore getCredentialsStore() {
        return this.credentialsStore;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoAuthority that = (MongoAuthority)o;
        if (!this.credentialsStore.equals(that.credentialsStore)) {
            return false;
        }
        if (!this.serverAddresses.equals(that.serverAddresses)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.credentialsStore.hashCode();
        result = 31 * result + this.serverAddresses.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "MongoAuthority{type=" + (Object)((Object)this.type) + ", serverAddresses=" + this.serverAddresses + ", credentials=" + this.credentialsStore + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        Direct,
        Set;

    }
}

