/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class NativeAuthenticationHelper {
    static DBObject getAuthCommand(String userName, char[] password, String nonce) {
        return NativeAuthenticationHelper.getAuthCommand(userName, NativeAuthenticationHelper.createHash(userName, password), nonce);
    }

    static DBObject getAuthCommand(String userName, byte[] authHash, String nonce) {
        String key = nonce + userName + new String(authHash);
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("authenticate", (Object)1);
        cmd.put("user", (Object)userName);
        cmd.put("nonce", (Object)nonce);
        cmd.put("key", (Object)Util.hexMD5(key.getBytes()));
        return cmd;
    }

    static BasicDBObject getNonceCommand() {
        return new BasicDBObject("getnonce", (Object)1);
    }

    static byte[] createHash(String userName, char[] password) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(userName.length() + 20 + password.length);
        try {
            bout.write(userName.getBytes());
            bout.write(":mongo:".getBytes());
            for (char ch : password) {
                if (ch >= '\u0080') {
                    throw new IllegalArgumentException("can't handle non-ascii passwords yet");
                }
                bout.write((byte)ch);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("impossible", ioe);
        }
        return Util.hexMD5(bout.toByteArray()).getBytes();
    }

    private NativeAuthenticationHelper() {
    }
}

