/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc.ha;

import com.mysql.cj.api.PingTarget;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.jdbc.Statement;
import com.mysql.cj.api.jdbc.ha.BalanceStrategy;
import com.mysql.cj.api.jdbc.ha.LoadBalanceExceptionChecker;
import com.mysql.cj.api.jdbc.ha.LoadBalancedConnection;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.core.ConnectionString;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.log.NullLogger;
import com.mysql.cj.core.util.Util;
import com.mysql.cj.jdbc.ConnectionGroup;
import com.mysql.cj.jdbc.ConnectionGroupManager;
import com.mysql.cj.jdbc.ConnectionImpl;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.ha.BestResponseTimeBalanceStrategy;
import com.mysql.cj.jdbc.ha.LoadBalancedAutoCommitInterceptor;
import com.mysql.cj.jdbc.ha.LoadBalancedMySQLConnection;
import com.mysql.cj.jdbc.ha.MultiHostConnectionProxy;
import com.mysql.cj.jdbc.ha.RandomBalanceStrategy;
import com.mysql.cj.jdbc.ha.StandardLoadBalanceExceptionChecker;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;

public class LoadBalancedConnectionProxy
extends MultiHostConnectionProxy
implements PingTarget {
    private ConnectionGroup connectionGroup = null;
    private long connectionGroupProxyID = 0L;
    protected Map<String, ConnectionImpl> liveConnections;
    private Map<String, Integer> hostsToListIndexMap;
    private Map<ConnectionImpl, String> connectionsToHostsMap;
    private long activePhysicalConnections = 0L;
    private long totalPhysicalConnections = 0L;
    private long[] responseTimes;
    private int retriesAllDown;
    private BalanceStrategy balancer;
    private int autoCommitSwapThreshold = 0;
    private int globalBlacklistTimeout = 0;
    private static Map<String, Long> globalBlacklist = new HashMap<String, Long>();
    private String hostToRemove = null;
    private boolean inTransaction = false;
    private long transactionStartTime = 0L;
    private long transactionCount = 0L;
    private LoadBalanceExceptionChecker exceptionChecker;
    private Log log = new NullLogger("LoadBalancingConnectionProxy");

    public static LoadBalancedConnection createProxyInstance(ConnectionString connectionString) throws SQLException {
        LoadBalancedConnectionProxy connProxy = new LoadBalancedConnectionProxy(connectionString);
        return (LoadBalancedConnection)Proxy.newProxyInstance(LoadBalancedConnection.class.getClassLoader(), new Class[]{LoadBalancedConnection.class, JdbcConnection.class}, (InvocationHandler)connProxy);
    }

    public LoadBalancedConnectionProxy(ConnectionString connectionString) throws SQLException {
        List<String> hosts = ConnectionString.getHosts(connectionString.getProperties());
        Properties props = connectionString.getProperties();
        String group = props.getProperty("loadBalanceConnectionGroup", null);
        boolean enableJMX = false;
        String enableJMXAsString = props.getProperty("ha.enableJMX", "false");
        try {
            enableJMX = Boolean.parseBoolean(enableJMXAsString);
        }
        catch (Exception e2) {
            throw SQLError.createSQLException(Messages.getString("MultihostConnection.badValueForHaEnableJMX", new Object[]{enableJMXAsString}), "S1009", null);
        }
        if (group != null) {
            this.connectionGroup = ConnectionGroupManager.getConnectionGroupInstance(group);
            if (enableJMX) {
                ConnectionGroupManager.registerJmx();
            }
            this.connectionGroupProxyID = this.connectionGroup.registerConnectionProxy(this, hosts);
            hosts = new ArrayList<String>(this.connectionGroup.getInitialHosts());
        }
        int numHosts = this.initializeHostsSpecs(connectionString, hosts, props);
        this.liveConnections = new HashMap<String, ConnectionImpl>(numHosts);
        this.hostsToListIndexMap = new HashMap<String, Integer>(numHosts);
        for (int i2 = 0; i2 < numHosts; ++i2) {
            this.hostsToListIndexMap.put((String)this.hostList.get(i2), i2);
        }
        this.connectionsToHostsMap = new HashMap<ConnectionImpl, String>(numHosts);
        this.responseTimes = new long[numHosts];
        String retriesAllDownAsString = this.localProps.getProperty("retriesAllDown", "120");
        try {
            this.retriesAllDown = Integer.parseInt(retriesAllDownAsString);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForRetriesAllDown", new Object[]{retriesAllDownAsString}), "S1009", null);
        }
        String blacklistTimeoutAsString = this.localProps.getProperty("loadBalanceBlacklistTimeout", "0");
        try {
            this.globalBlacklistTimeout = Integer.parseInt(blacklistTimeoutAsString);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForLoadBalanceBlacklistTimeout", new Object[]{retriesAllDownAsString}), "S1009", null);
        }
        String strategy = this.localProps.getProperty("ha.loadBalanceStrategy", "random");
        try {
            this.balancer = "random".equals(strategy) ? (BalanceStrategy)Util.loadExtensions(null, props, RandomBalanceStrategy.class.getName(), "InvalidLoadBalanceStrategy", null, this.log).get(0) : ("bestResponseTime".equals(strategy) ? (BalanceStrategy)Util.loadExtensions(null, props, BestResponseTimeBalanceStrategy.class.getName(), "InvalidLoadBalanceStrategy", null, this.log).get(0) : (BalanceStrategy)Util.loadExtensions(null, props, strategy, "InvalidLoadBalanceStrategy", null, this.log).get(0));
        }
        catch (CJException e3) {
            throw SQLExceptionsMapping.translateException(e3);
        }
        String autoCommitSwapThresholdAsString = props.getProperty("loadBalanceAutoCommitStatementThreshold", "0");
        try {
            this.autoCommitSwapThreshold = Integer.parseInt(autoCommitSwapThresholdAsString);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForLoadBalanceAutoCommitStatementThreshold", new Object[]{autoCommitSwapThresholdAsString}), "S1009", null);
        }
        String autoCommitSwapRegex = props.getProperty("loadBalanceAutoCommitStatementRegex", "");
        if (!"".equals(autoCommitSwapRegex)) {
            try {
                "".matches(autoCommitSwapRegex);
            }
            catch (Exception e4) {
                throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForLoadBalanceAutoCommitStatementRegex", new Object[]{autoCommitSwapRegex}), "S1009", null);
            }
        }
        if (this.autoCommitSwapThreshold > 0) {
            String statementInterceptors = this.localProps.getProperty("statementInterceptors");
            if (statementInterceptors == null) {
                this.localProps.setProperty("statementInterceptors", LoadBalancedAutoCommitInterceptor.class.getName());
            } else if (statementInterceptors.length() > 0) {
                this.localProps.setProperty("statementInterceptors", statementInterceptors + "," + LoadBalancedAutoCommitInterceptor.class.getName());
            }
            props.setProperty("statementInterceptors", this.localProps.getProperty("statementInterceptors"));
        }
        try {
            this.balancer.init(null, props, this.log);
            String lbExceptionChecker = this.localProps.getProperty("loadBalanceExceptionChecker", StandardLoadBalanceExceptionChecker.class.getName());
            this.exceptionChecker = (LoadBalanceExceptionChecker)Util.loadExtensions(null, props, lbExceptionChecker, "InvalidLoadBalanceExceptionChecker", null, this.log).get(0);
        }
        catch (CJException e5) {
            throw SQLExceptionsMapping.translateException(e5, null);
        }
        this.pickNewConnection();
    }

    @Override
    JdbcConnection getNewWrapperForThisAsConnection() throws SQLException {
        return new LoadBalancedMySQLConnection(this);
    }

    @Override
    protected void propagateProxyDown(JdbcConnection proxyConn) {
        for (JdbcConnection jdbcConnection : this.liveConnections.values()) {
            jdbcConnection.setProxy(proxyConn);
        }
    }

    @Deprecated
    public boolean shouldExceptionTriggerFailover(Throwable t) {
        return this.shouldExceptionTriggerConnectionSwitch(t);
    }

    @Override
    boolean shouldExceptionTriggerConnectionSwitch(Throwable t) {
        return t instanceof SQLException && this.exceptionChecker.shouldExceptionTriggerFailover(t);
    }

    @Override
    boolean isMasterConnection() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    synchronized void invalidateConnection(JdbcConnection conn) throws SQLException {
        super.invalidateConnection(conn);
        if (this.isGlobalBlacklistEnabled()) {
            this.addToGlobalBlacklist(this.connectionsToHostsMap.get(conn));
        }
        this.liveConnections.remove(this.connectionsToHostsMap.get(conn));
        String mappedHost = this.connectionsToHostsMap.remove(conn);
        if (mappedHost == null || !this.hostsToListIndexMap.containsKey(mappedHost)) return;
        int hostIndex = this.hostsToListIndexMap.get(mappedHost);
        long[] lArray = this.responseTimes;
        synchronized (this.responseTimes) {
            this.responseTimes[hostIndex] = 0L;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    public synchronized void pickNewConnection() throws SQLException {
        if (this.isClosed && this.closedExplicitly) {
            return;
        }
        if (this.currentConnection == null) {
            this.currentConnection = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
            return;
        }
        if (this.currentConnection.isClosed()) {
            this.invalidateCurrentConnection();
        }
        int pingTimeout = this.currentConnection.getPropertySet().getIntegerReadableProperty("loadBalancePingTimeout").getValue();
        boolean pingBeforeReturn = this.currentConnection.getPropertySet().getBooleanReadableProperty("loadBalanceValidateConnectionOnSwapServer").getValue();
        int hostsToTry = this.hostList.size();
        for (int hostsTried = 0; hostsTried < hostsToTry; ++hostsTried) {
            ConnectionImpl newConn = null;
            try {
                newConn = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
                if (this.currentConnection != null) {
                    if (pingBeforeReturn) {
                        if (pingTimeout == 0) {
                            newConn.ping();
                        } else {
                            newConn.pingInternal(true, pingTimeout);
                        }
                    }
                    LoadBalancedConnectionProxy.syncSessionState(this.currentConnection, newConn);
                }
                this.currentConnection = newConn;
                return;
            }
            catch (SQLException e2) {
                if (!this.shouldExceptionTriggerConnectionSwitch(e2) || newConn == null) continue;
                this.invalidateConnection(newConn);
                continue;
            }
        }
        this.isClosed = true;
        this.closedReason = "Connection closed after inability to pick valid new connection during load-balance.";
    }

    @Override
    public synchronized ConnectionImpl createConnectionForHost(String hostPortSpec) throws SQLException {
        ConnectionImpl conn = super.createConnectionForHost(hostPortSpec);
        this.liveConnections.put(hostPortSpec, conn);
        this.connectionsToHostsMap.put(conn, hostPortSpec);
        ++this.activePhysicalConnections;
        ++this.totalPhysicalConnections;
        return conn;
    }

    private synchronized void closeAllConnections() {
        for (Connection connection : this.liveConnections.values()) {
            try {
                --this.activePhysicalConnections;
                connection.close();
            }
            catch (SQLException sQLException) {}
        }
        if (!this.isClosed) {
            this.balancer.destroy();
            if (this.connectionGroup != null) {
                this.connectionGroup.closeConnectionProxy(this);
            }
        }
        this.liveConnections.clear();
        this.connectionsToHostsMap.clear();
    }

    @Override
    synchronized void doClose() {
        this.closeAllConnections();
    }

    @Override
    synchronized void doAbortInternal() {
        for (JdbcConnection jdbcConnection : this.liveConnections.values()) {
            try {
                --this.activePhysicalConnections;
                jdbcConnection.abortInternal();
            }
            catch (SQLException sQLException) {}
        }
        if (!this.isClosed) {
            this.balancer.destroy();
            if (this.connectionGroup != null) {
                this.connectionGroup.closeConnectionProxy(this);
            }
        }
        this.liveConnections.clear();
        this.connectionsToHostsMap.clear();
    }

    @Override
    synchronized void doAbort(Executor executor) {
        for (Connection connection : this.liveConnections.values()) {
            try {
                --this.activePhysicalConnections;
                connection.abort(executor);
            }
            catch (SQLException sQLException) {}
        }
        if (!this.isClosed) {
            this.balancer.destroy();
            if (this.connectionGroup != null) {
                this.connectionGroup.closeConnectionProxy(this);
            }
        }
        this.liveConnections.clear();
        this.connectionsToHostsMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public synchronized Object invokeMore(Object proxy, Method method, Object[] args) throws Throwable {
        methodName = method.getName();
        if (!this.isClosed || this.allowedOnClosedConnection(method) || method.getExceptionTypes().length <= 0) ** GOTO lbl12
        if (!this.autoReconnect || this.closedExplicitly) {
            reason = "No operations allowed after connection closed.";
            if (this.closedReason != null) {
                reason = reason + "  " + this.closedReason;
            }
        } else {
            block25: {
                this.currentConnection = null;
                this.pickNewConnection();
                this.isClosed = false;
                this.closedReason = null;
lbl12:
                // 2 sources

                if (!this.inTransaction) {
                    this.inTransaction = true;
                    this.transactionStartTime = System.nanoTime();
                    ++this.transactionCount;
                }
                result = null;
                try {
                    result = method.invoke((Object)this.thisAsConnection, args);
                    if (result != null) {
                        if (result instanceof Statement) {
                            ((Statement)result).setPingTarget(this);
                        }
                        result = this.proxyIfReturnTypeIsJdbcInterface(method.getReturnType(), result);
                    }
                    if (!"commit".equals(methodName)) {
                        if ("rollback".equals(methodName) == false) return result;
                    }
                    this.inTransaction = false;
                    host = this.connectionsToHostsMap.get(this.currentConnection);
                    if (host == null) break block25;
                    var7_12 = this.responseTimes;
                }
                catch (InvocationTargetException e) {
                    block26: {
                        try {
                            this.dealWithInvocationException(e);
                            if (!"commit".equals(methodName)) {
                                if ("rollback".equals(methodName) == false) return result;
                            }
                            this.inTransaction = false;
                            host = this.connectionsToHostsMap.get(this.currentConnection);
                            if (host == null) break block26;
                            var7_13 = this.responseTimes;
                        }
                        catch (Throwable var12_18) {
                            if (!"commit".equals(methodName)) {
                                if ("rollback".equals(methodName) == false) throw var12_18;
                            }
                            this.inTransaction = false;
                            host = this.connectionsToHostsMap.get(this.currentConnection);
                            if (host != null) {
                                var14_20 = this.responseTimes;
                                // MONITORENTER : this.responseTimes
                                hostIndex = this.hostsToListIndexMap.get(host);
                                if (hostIndex != null && hostIndex < this.responseTimes.length) {
                                    this.responseTimes[hostIndex.intValue()] = System.nanoTime() - this.transactionStartTime;
                                }
                                // MONITOREXIT : var14_20
                            }
                            this.pickNewConnection();
                            throw var12_18;
                        }
                        hostIndex = this.hostsToListIndexMap.get(host);
                        if (hostIndex != null && hostIndex < this.responseTimes.length) {
                            this.responseTimes[hostIndex.intValue()] = System.nanoTime() - this.transactionStartTime;
                        }
                        // MONITOREXIT : var7_13
                    }
                    this.pickNewConnection();
                    return result;
                }
                // MONITORENTER : this.responseTimes
                hostIndex = this.hostsToListIndexMap.get(host);
                if (hostIndex != null && hostIndex < this.responseTimes.length) {
                    this.responseTimes[hostIndex.intValue()] = System.nanoTime() - this.transactionStartTime;
                }
                // MONITOREXIT : var7_12
            }
            this.pickNewConnection();
            return result;
        }
        var6_7 = method.getExceptionTypes();
        var7_11 = var6_7.length;
        var8_14 = 0;
        while (var8_14 < var7_11) {
            excls = var6_7[var8_14];
            if (SQLException.class.isAssignableFrom(excls)) {
                throw SQLError.createSQLException(reason, "08003", null);
            }
            ++var8_14;
        }
        throw ExceptionFactory.createException(CJCommunicationsException.class, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void doPing() throws SQLException {
        SQLException se = null;
        boolean foundHost = false;
        int pingTimeout = this.currentConnection.getPropertySet().getIntegerReadableProperty("loadBalancePingTimeout").getValue();
        LoadBalancedConnectionProxy loadBalancedConnectionProxy = this;
        synchronized (loadBalancedConnectionProxy) {
            for (String host : this.hostList) {
                ConnectionImpl conn = this.liveConnections.get(host);
                if (conn == null) continue;
                try {
                    if (pingTimeout == 0) {
                        conn.ping();
                    } else {
                        conn.pingInternal(true, pingTimeout);
                    }
                    foundHost = true;
                }
                catch (SQLException e2) {
                    --this.activePhysicalConnections;
                    if (host.equals(this.connectionsToHostsMap.get(this.currentConnection))) {
                        this.closeAllConnections();
                        this.isClosed = true;
                        this.closedReason = "Connection closed because ping of current connection failed.";
                        throw e2;
                    }
                    if (e2.getMessage().equals(Messages.getString("Connection.exceededConnectionLifetime"))) {
                        if (se == null) {
                            se = e2;
                        }
                    } else {
                        se = e2;
                        if (this.isGlobalBlacklistEnabled()) {
                            this.addToGlobalBlacklist(host);
                        }
                    }
                    this.liveConnections.remove(this.connectionsToHostsMap.get(conn));
                }
            }
        }
        if (!foundHost) {
            this.closeAllConnections();
            this.isClosed = true;
            this.closedReason = "Connection closed due to inability to ping any active connections.";
            if (se != null) {
                throw se;
            }
            ((ConnectionImpl)this.currentConnection).throwConnectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToGlobalBlacklist(String host, long timeout) {
        if (this.isGlobalBlacklistEnabled()) {
            Map<String, Long> map = globalBlacklist;
            synchronized (map) {
                globalBlacklist.put(host, timeout);
            }
        }
    }

    public void addToGlobalBlacklist(String host) {
        this.addToGlobalBlacklist(host, System.currentTimeMillis() + (long)this.globalBlacklistTimeout);
    }

    public boolean isGlobalBlacklistEnabled() {
        return this.globalBlacklistTimeout > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, Long> getGlobalBlacklist() {
        if (!this.isGlobalBlacklistEnabled()) {
            String localHostToRemove = this.hostToRemove;
            if (this.hostToRemove != null) {
                HashMap<String, Long> fakedBlacklist = new HashMap<String, Long>();
                fakedBlacklist.put(localHostToRemove, System.currentTimeMillis() + 5000L);
                return fakedBlacklist;
            }
            return new HashMap<String, Long>(1);
        }
        HashMap<String, Long> blacklistClone = new HashMap<String, Long>(globalBlacklist.size());
        Map<String, Long> fakedBlacklist = globalBlacklist;
        synchronized (fakedBlacklist) {
            blacklistClone.putAll(globalBlacklist);
        }
        Set keys = blacklistClone.keySet();
        keys.retainAll(this.hostList);
        Iterator i2 = keys.iterator();
        while (i2.hasNext()) {
            String host = (String)i2.next();
            Long timeout = globalBlacklist.get(host);
            if (timeout == null || timeout >= System.currentTimeMillis()) continue;
            Map<String, Long> map = globalBlacklist;
            synchronized (map) {
                globalBlacklist.remove(host);
            }
            i2.remove();
        }
        if (keys.size() == this.hostList.size()) {
            return new HashMap<String, Long>(1);
        }
        return blacklistClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHostWhenNotInUse(String host) throws SQLException {
        int timeBetweenChecks = 1000;
        long timeBeforeHardFail = 15000L;
        LoadBalancedConnectionProxy loadBalancedConnectionProxy = this;
        synchronized (loadBalancedConnectionProxy) {
            this.addToGlobalBlacklist(host, System.currentTimeMillis() + timeBeforeHardFail + 1000L);
            long cur = System.currentTimeMillis();
            while (System.currentTimeMillis() < cur + timeBeforeHardFail) {
                this.hostToRemove = host;
                if (!host.equals(this.currentConnection.getHost())) {
                    this.removeHost(host);
                    return;
                }
                try {
                    Thread.sleep(timeBetweenChecks);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.removeHost(host);
    }

    public synchronized void removeHost(String host) throws SQLException {
        if (this.connectionGroup != null) {
            if (this.connectionGroup.getInitialHosts().size() == 1 && this.connectionGroup.getInitialHosts().contains(host)) {
                throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.0"), null);
            }
            this.hostToRemove = host;
            if (host.equals(this.currentConnection.getHost())) {
                this.closeAllConnections();
            } else {
                this.connectionsToHostsMap.remove(this.liveConnections.remove(host));
                Integer idx = this.hostsToListIndexMap.remove(host);
                long[] newResponseTimes = new long[this.responseTimes.length - 1];
                int newIdx = 0;
                for (String copyHost : this.hostList) {
                    if (idx != null && idx < this.responseTimes.length) {
                        newResponseTimes[newIdx] = this.responseTimes[idx];
                        this.hostsToListIndexMap.put(copyHost, newIdx);
                    }
                    ++newIdx;
                }
                this.responseTimes = newResponseTimes;
            }
        }
    }

    public synchronized boolean addHost(String host) {
        if (this.hostsToListIndexMap.containsKey(host)) {
            return false;
        }
        long[] newResponseTimes = new long[this.responseTimes.length + 1];
        System.arraycopy(this.responseTimes, 0, newResponseTimes, 0, this.responseTimes.length);
        this.responseTimes = newResponseTimes;
        this.hostList.add(host);
        this.hostsToListIndexMap.put(host, this.responseTimes.length - 1);
        return true;
    }

    public synchronized boolean inTransaction() {
        return this.inTransaction;
    }

    public synchronized long getTransactionCount() {
        return this.transactionCount;
    }

    public synchronized long getActivePhysicalConnectionCount() {
        return this.activePhysicalConnections;
    }

    public synchronized long getTotalPhysicalConnectionCount() {
        return this.totalPhysicalConnections;
    }

    public synchronized long getConnectionGroupProxyID() {
        return this.connectionGroupProxyID;
    }

    public synchronized String getCurrentActiveHost() {
        String o2;
        JdbcConnection c2 = this.currentConnection;
        if (c2 != null && (o2 = this.connectionsToHostsMap.get(c2)) != null) {
            return o2.toString();
        }
        return null;
    }

    public synchronized long getCurrentTransactionDuration() {
        if (this.inTransaction && this.transactionStartTime > 0L) {
            return System.nanoTime() - this.transactionStartTime;
        }
        return 0L;
    }
}

