/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.bson.util.Assertions;
import org.bson.util.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class TagSet
implements Iterable<Tag> {
    private final List<Tag> wrapped;

    public TagSet() {
        this.wrapped = Collections.emptyList();
    }

    public TagSet(Tag tag) {
        Assertions.notNull("tag", tag);
        this.wrapped = Collections.singletonList(tag);
    }

    public TagSet(List<Tag> tagList) {
        Assertions.notNull("tagList", tagList);
        HashSet<String> tagNames = new HashSet<String>();
        for (Tag tag : tagList) {
            if (tag == null) {
                throw new IllegalArgumentException("Null tags are not allowed");
            }
            if (tagNames.add(tag.getName())) continue;
            throw new IllegalArgumentException("Duplicate tag names not allowed in a tag set: " + tag.getName());
        }
        this.wrapped = Collections.unmodifiableList(new ArrayList<Tag>(tagList));
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.wrapped.iterator();
    }

    public boolean containsAll(TagSet tagSet) {
        return this.wrapped.containsAll(tagSet.wrapped);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagSet tags = (TagSet)o;
        return this.wrapped.equals(tags.wrapped);
    }

    public int hashCode() {
        return this.wrapped.hashCode();
    }

    public String toString() {
        return "TagSet{" + this.wrapped + '}';
    }
}

