/* wc_mldsa_asm.S */
/*
 * Copyright (C) 2006-2025 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */

#ifdef WOLFSSL_USER_SETTINGS
#ifdef WOLFSSL_USER_SETTINGS_ASM
/*
 * user_settings_asm.h is a file generated by the script user_settings_asm.sh.
 * The script takes in a user_settings.h and produces user_settings_asm.h, which
 * is a stripped down version of user_settings.h containing only preprocessor
 * directives. This makes the header safe to include in assembly (.S) files.
 */
#include "user_settings_asm.h"
#else
/*
 * Note: if user_settings.h contains any C code (e.g. a typedef or function
 * prototype), including it here in an assembly (.S) file will cause an
 * assembler failure. See user_settings_asm.h above.
 */
#include "user_settings.h"
#endif /* WOLFSSL_USER_SETTINGS_ASM */
#endif /* WOLFSSL_USER_SETTINGS */

#ifndef HAVE_INTEL_AVX1
#define HAVE_INTEL_AVX1
#endif /* HAVE_INTEL_AVX1 */
#ifndef NO_AVX2_SUPPORT
#ifndef HAVE_INTEL_AVX2
#define HAVE_INTEL_AVX2
#endif /* HAVE_INTEL_AVX2 */
#endif /* NO_AVX2_SUPPORT */

#ifdef WOLFSSL_WC_DILITHIUM
#ifdef HAVE_INTEL_AVX2
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
mldsa_q:
.long	0x007fe001,0x007fe001,0x007fe001,0x007fe001
.long	0x007fe001,0x007fe001,0x007fe001,0x007fe001
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
mldsa_qinv:
.long	0x03802001,0x03802001,0x03802001,0x03802001
.long	0x03802001,0x03802001,0x03802001,0x03802001
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
mldsa_v:
.long	0x00400000,0x00400000,0x00400000,0x00400000
.long	0x00400000,0x00400000,0x00400000,0x00400000
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_avx2_zetas:
.long	0x000064f7,0x000064f7,0x000064f7,0x000064f7
.long	0x000064f7,0x000064f7,0x000064f7,0x000064f7
.long	0x6d1f44f7,0x6d1f44f7,0x6d1f44f7,0x6d1f44f7
.long	0x6d1f44f7,0x6d1f44f7,0x6d1f44f7,0x6d1f44f7
.long	0xffd83102,0xffd83102,0xffd83102,0xffd83102
.long	0xffd83102,0xffd83102,0xffd83102,0xffd83102
.long	0x8cf87102,0x8cf87102,0x8cf87102,0x8cf87102
.long	0x8cf87102,0x8cf87102,0x8cf87102,0x8cf87102
.long	0xfff81503,0xfff81503,0xfff81503,0xfff81503
.long	0xfff81503,0xfff81503,0xfff81503,0xfff81503
.long	0x8d187503,0x8d187503,0x8d187503,0x8d187503
.long	0x8d187503,0x8d187503,0x8d187503,0x8d187503
.long	0x00039e44,0x00039e44,0x00039e44,0x00039e44
.long	0x00039e44,0x00039e44,0x00039e44,0x00039e44
.long	0x61cc1e44,0x61cc1e44,0x61cc1e44,0x61cc1e44
.long	0x61cc1e44,0x61cc1e44,0x61cc1e44,0x61cc1e44
.long	0x001bde2b,0x001bde2b,0x001bde2b,0x001bde2b
.long	0x001bde2b,0x001bde2b,0x001bde2b,0x001bde2b
.long	0x12613e2b,0x12613e2b,0x12613e2b,0x12613e2b
.long	0x12613e2b,0x12613e2b,0x12613e2b,0x12613e2b
.long	0x0023e92b,0x0023e92b,0x0023e92b,0x0023e92b
.long	0x0023e92b,0x0023e92b,0x0023e92b,0x0023e92b
.long	0x93c9492b,0x93c9492b,0x93c9492b,0x93c9492b
.long	0x93c9492b,0x93c9492b,0x93c9492b,0x93c9492b
.long	0x00299658,0x00299658,0x00299658,0x00299658
.long	0x00299658,0x00299658,0x00299658,0x00299658
.long	0x66f49658,0x66f49658,0x66f49658,0x66f49658
.long	0x66f49658,0x66f49658,0x66f49658,0x66f49658
.long	0x000fa070,0x000fa070,0x000fa070,0x000fa070
.long	0x000fa070,0x000fa070,0x000fa070,0x000fa070
.long	0x7c1da070,0x7c1da070,0x7c1da070,0x7c1da070
.long	0x7c1da070,0x7c1da070,0x7c1da070,0x7c1da070
.long	0xffef85a4,0xffef85a4,0xffef85a4,0xffef85a4
.long	0xffef85a4,0xffef85a4,0xffef85a4,0xffef85a4
.long	0xaea405a4,0xaea405a4,0xaea405a4,0xaea405a4
.long	0xaea405a4,0xaea405a4,0xaea405a4,0xaea405a4
.long	0x0036b788,0x0036b788,0x0036b788,0x0036b788
.long	0x0036b788,0x0036b788,0x0036b788,0x0036b788
.long	0x3327b788,0x3327b788,0x3327b788,0x3327b788
.long	0x3327b788,0x3327b788,0x3327b788,0x3327b788
.long	0x00294a67,0x00294a67,0x00294a67,0x00294a67
.long	0x00017620,0x00017620,0x00017620,0x00017620
.long	0x91f62a67,0x91f62a67,0x91f62a67,0x91f62a67
.long	0x9ec57620,0x9ec57620,0x9ec57620,0x9ec57620
.long	0x002ef4cd,0x002ef4cd,0x002ef4cd,0x002ef4cd
.long	0x0035dec5,0x0035dec5,0x0035dec5,0x0035dec5
.long	0xac4894cd,0xac4894cd,0xac4894cd,0xac4894cd
.long	0x6d8e7ec5,0x6d8e7ec5,0x6d8e7ec5,0x6d8e7ec5
.long	0xffc406e5,0xffc406e5,0xffe8ac81,0xffe8ac81
.long	0xffc7e1cf,0xffc7e1cf,0xffd19819,0xffd19819
.long	0xa220a6e5,0xa220a6e5,0xd8f8cc81,0xd8f8cc81
.long	0x5081c1cf,0x5081c1cf,0x8a54b819,0x8a54b819
.long	0xffe9d65d,0xffe9d65d,0x003509ee,0x003509ee
.long	0x002135c7,0x002135c7,0xffe7cfbb,0xffe7cfbb
.long	0x8035765d,0x8035765d,0x6272c9ee,0x6272c9ee
.long	0x5f5a15c7,0x5f5a15c7,0x085f2fbb,0x085f2fbb
.long	0xffe6a503,0xffe6a503,0xffe6a503,0xffe6a503
.long	0xffc9302c,0xffc9302c,0xffc9302c,0xffc9302c
.long	0x5f070503,0x5f070503,0x5f070503,0x5f070503
.long	0xbfceb02c,0xbfceb02c,0xbfceb02c,0xbfceb02c
.long	0xffd947d4,0xffd947d4,0xffd947d4,0xffd947d4
.long	0x003bbeaf,0x003bbeaf,0x003bbeaf,0x003bbeaf
.long	0x8ed3c7d4,0x8ed3c7d4,0x8ed3c7d4,0x8ed3c7d4
.long	0xdc919eaf,0xdc919eaf,0xdc919eaf,0xdc919eaf
.long	0xffeccf75,0xffeccf75,0x001d9772,0x001d9772
.long	0xffc1b072,0xffc1b072,0xfff0bcf6,0xfff0bcf6
.long	0xb35b6f75,0xb35b6f75,0xc20bd772,0xc20bd772
.long	0xc4cff072,0xc4cff072,0x748f7cf6,0x748f7cf6
.long	0xffcf5280,0xffcf5280,0xffcfd2ae,0xffcfd2ae
.long	0xffc890e0,0xffc890e0,0x0001efca,0x0001efca
.long	0xaa1f5280,0xaa1f5280,0x5b2592ae,0x5b2592ae
.long	0x21e490e0,0x21e490e0,0x80fb2fca,0x80fb2fca
.long	0x001fea93,0x0033ff5a,0x002358d4,0x003a41f8
.long	0xffccff72,0x00223dfb,0xffdaab9f,0xffc9a422
.long	0xfff24a93,0x3b1f3f5a,0x513dd8d4,0x2c7941f8
.long	0xaebb3f72,0x36619dfb,0x01ce8b9f,0xab4de422
.long	0x000412f5,0x00252587,0xffed24f0,0x00359b5d
.long	0xffca48a0,0xffc6a2fc,0xffedbb56,0xffcf45de
.long	0xdbe2b2f5,0xfd560587,0xec8b24f0,0x79213b5d
.long	0x78de48a0,0x462622fc,0x64587b56,0x718b05de
.long	0x000dbe5e,0x001c5e1a,0x000de0e6,0x000c7f5a
.long	0x00078f83,0xffe7628a,0xffff5704,0xfff806fc
.long	0x00d97e5e,0xe6df9e1a,0xe12aa0e6,0x4af7bf5a
.long	0x3c77ef83,0xcf38a28a,0x78dfd704,0x72d786fc
.long	0xfff60021,0xffd05af6,0x001f0084,0x0030ef86
.long	0xffc9b97d,0xfff7fcd6,0xfff44592,0xffc921c2
.long	0x337a2021,0x682f1af6,0xae2f8084,0x7321af86
.long	0x6c79597d,0xec92bcd6,0x07a68592,0x4b0161c2
.long	0xfff42118,0xfff42118,0xfff42118,0xfff42118
.long	0xfff42118,0xfff42118,0xfff42118,0xfff42118
.long	0x58172118,0x58172118,0x58172118,0x58172118
.long	0x58172118,0x58172118,0x58172118,0x58172118
.long	0xfffa84ad,0xfffa84ad,0xfffa84ad,0xfffa84ad
.long	0xfffa84ad,0xfffa84ad,0xfffa84ad,0xfffa84ad
.long	0xae1024ad,0xae1024ad,0xae1024ad,0xae1024ad
.long	0xae1024ad,0xae1024ad,0xae1024ad,0xae1024ad
.long	0xffe0147f,0xffe0147f,0xffe0147f,0xffe0147f
.long	0xffe0147f,0xffe0147f,0xffe0147f,0xffe0147f
.long	0xbeeff47f,0xbeeff47f,0xbeeff47f,0xbeeff47f
.long	0xbeeff47f,0xbeeff47f,0xbeeff47f,0xbeeff47f
.long	0xfff79d90,0xfff79d90,0xfff79d90,0xfff79d90
.long	0xfff79d90,0xfff79d90,0xfff79d90,0xfff79d90
.long	0x6ba99d90,0x6ba99d90,0x6ba99d90,0x6ba99d90
.long	0x6ba99d90,0x6ba99d90,0x6ba99d90,0x6ba99d90
.long	0xffeeeaa0,0xffeeeaa0,0xffeeeaa0,0xffeeeaa0
.long	0xffeeeaa0,0xffeeeaa0,0xffeeeaa0,0xffeeeaa0
.long	0x0d42eaa0,0x0d42eaa0,0x0d42eaa0,0x0d42eaa0
.long	0x0d42eaa0,0x0d42eaa0,0x0d42eaa0,0x0d42eaa0
.long	0x0027f968,0x0027f968,0x0027f968,0x0027f968
.long	0x0027f968,0x0027f968,0x0027f968,0x0027f968
.long	0xeb54f968,0xeb54f968,0xeb54f968,0xeb54f968
.long	0xeb54f968,0xeb54f968,0xeb54f968,0xeb54f968
.long	0xffdfd37b,0xffdfd37b,0xffdfd37b,0xffdfd37b
.long	0xffdfd37b,0xffdfd37b,0xffdfd37b,0xffdfd37b
.long	0x28cf337b,0x28cf337b,0x28cf337b,0x28cf337b
.long	0x28cf337b,0x28cf337b,0x28cf337b,0x28cf337b
.long	0xffc51585,0xffc51585,0xffc51585,0xffc51585
.long	0xffd18e7c,0xffd18e7c,0xffd18e7c,0xffd18e7c
.long	0xf3f5b585,0xf3f5b585,0xf3f5b585,0xf3f5b585
.long	0xe3a10e7c,0xe3a10e7c,0xe3a10e7c,0xe3a10e7c
.long	0x00368a96,0x00368a96,0x00368a96,0x00368a96
.long	0xffd43e41,0xffd43e41,0xffd43e41,0xffd43e41
.long	0xde894a96,0xde894a96,0xde894a96,0xde894a96
.long	0x6b1c5e41,0x6b1c5e41,0x6b1c5e41,0x6b1c5e41
.long	0x003410f2,0x003410f2,0xfff0fe85,0xfff0fe85
.long	0x0020c638,0x0020c638,0x00296e9f,0x00296e9f
.long	0xd15250f2,0xd15250f2,0xf1419e85,0xf1419e85
.long	0xdce7c638,0xdce7c638,0x5a7d4e9f,0x5a7d4e9f
.long	0xffd2b7a3,0xffd2b7a3,0xffc7a44b,0xffc7a44b
.long	0xfff9ba6d,0xfff9ba6d,0xffda3409,0xffda3409
.long	0x114717a3,0x114717a3,0xfad1044b,0xfad1044b
.long	0xb4c75a6d,0xb4c75a6d,0x65db5409,0x65db5409
.long	0x00360400,0x00360400,0x00360400,0x00360400
.long	0xfffb6a4d,0xfffb6a4d,0xfffb6a4d,0xfffb6a4d
.long	0xc0b60400,0xc0b60400,0xc0b60400,0xc0b60400
.long	0x7ac50a4d,0x7ac50a4d,0x7ac50a4d,0x7ac50a4d
.long	0x0023d69c,0x0023d69c,0x0023d69c,0x0023d69c
.long	0xfff7c55d,0xfff7c55d,0xfff7c55d,0xfff7c55d
.long	0x9cf7569c,0x9cf7569c,0x9cf7569c,0x9cf7569c
.long	0xbe23655d,0xbe23655d,0xbe23655d,0xbe23655d
.long	0xfff5c282,0xfff5c282,0xffed4113,0xffed4113
.long	0xffffa63b,0xffffa63b,0xffec09f7,0xffec09f7
.long	0x7f460282,0x7f460282,0x6a8fa113,0x6a8fa113
.long	0xc347063b,0xc347063b,0x61aae9f7,0x61aae9f7
.long	0xfffa2bdd,0xfffa2bdd,0x001495d4,0x001495d4
.long	0x001c4563,0x001c4563,0xffea2c62,0xffea2c62
.long	0xcaf5cbdd,0xcaf5cbdd,0xf8cf15d4,0xf8cf15d4
.long	0x6348a563,0x6348a563,0x9c766c62,0x9c766c62
.long	0x00053919,0x0004610c,0xffdacd41,0x003eb01b
.long	0x003472e7,0xffcd003b,0x001a7cc7,0x00031924
.long	0x7ea85919,0x3625e10c,0xbd02ed41,0x34c2101b
.long	0xb71152e7,0x6e54603b,0x08335cc7,0x61279924
.long	0x002b5ee5,0x00291199,0xffd87a3a,0x00134d71
.long	0x003de11c,0x00130984,0x0025f051,0x00185a46
.long	0x8d87fee5,0xb9dc3199,0xda1fba3a,0x75416d71
.long	0x9e61611c,0xaf438984,0xd9b01051,0x00611a46
.long	0xffc68518,0x001314be,0x00283891,0xffc9db90
.long	0xffd25089,0x001c853f,0x001d0b4b,0xffeff6a6
.long	0xa4698518,0xfbaad4be,0x02ba5891,0xb33bdb90
.long	0x29637089,0xed44653f,0x28066b4b,0x43c4b6a6
.long	0xffeba8be,0x0012e11b,0xffcd5e3e,0xffea2d2f
.long	0xfff91de4,0x001406c7,0x00327283,0xffe20d6e
.long	0x0e0368be,0x3ab6411b,0x84951e3e,0x6a100d2f
.long	0xc1b59de4,0x396ce6c7,0x1902d283,0x428fcd6e
.long	0xfff2a128,0xfff2a128,0xfff2a128,0xfff2a128
.long	0xfff2a128,0xfff2a128,0xfff2a128,0xfff2a128
.long	0x6017a128,0x6017a128,0x6017a128,0x6017a128
.long	0x6017a128,0x6017a128,0x6017a128,0x6017a128
.long	0x002f9a75,0x002f9a75,0x002f9a75,0x002f9a75
.long	0x002f9a75,0x002f9a75,0x002f9a75,0x002f9a75
.long	0x8cfe3a75,0x8cfe3a75,0x8cfe3a75,0x8cfe3a75
.long	0x8cfe3a75,0x8cfe3a75,0x8cfe3a75,0x8cfe3a75
.long	0xffd3fb09,0xffd3fb09,0xffd3fb09,0xffd3fb09
.long	0xffd3fb09,0xffd3fb09,0xffd3fb09,0xffd3fb09
.long	0x1eb51b09,0x1eb51b09,0x1eb51b09,0x1eb51b09
.long	0x1eb51b09,0x1eb51b09,0x1eb51b09,0x1eb51b09
.long	0xffdfadd6,0xffdfadd6,0xffdfadd6,0xffdfadd6
.long	0xffdfadd6,0xffdfadd6,0xffdfadd6,0xffdfadd6
.long	0x629a6dd6,0x629a6dd6,0x629a6dd6,0x629a6dd6
.long	0x629a6dd6,0x629a6dd6,0x629a6dd6,0x629a6dd6
.long	0xffc51ae7,0xffc51ae7,0xffc51ae7,0xffc51ae7
.long	0xffc51ae7,0xffc51ae7,0xffc51ae7,0xffc51ae7
.long	0xcba1fae7,0xcba1fae7,0xcba1fae7,0xcba1fae7
.long	0xcba1fae7,0xcba1fae7,0xcba1fae7,0xcba1fae7
.long	0xffeaa4f7,0xffeaa4f7,0xffeaa4f7,0xffeaa4f7
.long	0xffeaa4f7,0xffeaa4f7,0xffeaa4f7,0xffeaa4f7
.long	0xb50984f7,0xb50984f7,0xb50984f7,0xb50984f7
.long	0xb50984f7,0xb50984f7,0xb50984f7,0xb50984f7
.long	0xffcdfc98,0xffcdfc98,0xffcdfc98,0xffcdfc98
.long	0xffcdfc98,0xffcdfc98,0xffcdfc98,0xffcdfc98
.long	0xd360fc98,0xd360fc98,0xd360fc98,0xd360fc98
.long	0xd360fc98,0xd360fc98,0xd360fc98,0xd360fc98
.long	0xffe6123d,0xffe6123d,0xffe6123d,0xffe6123d
.long	0xffe6ead6,0xffe6ead6,0xffe6ead6,0xffe6ead6
.long	0x97adb23d,0x97adb23d,0x97adb23d,0x97adb23d
.long	0xca41aad6,0xca41aad6,0xca41aad6,0xca41aad6
.long	0x00357e1e,0x00357e1e,0x00357e1e,0x00357e1e
.long	0xffc5af59,0xffc5af59,0xffc5af59,0xffc5af59
.long	0x18f93e1e,0x18f93e1e,0x18f93e1e,0x18f93e1e
.long	0x6d30cf59,0x6d30cf59,0x6d30cf59,0x6d30cf59
.long	0xffccfbe9,0xffccfbe9,0x00040af0,0x00040af0
.long	0x0007c417,0x0007c417,0x002f4588,0x002f4588
.long	0x4eca1be9,0x4eca1be9,0xc9620af0,0xc9620af0
.long	0x490aa417,0x490aa417,0x44e04588,0x44e04588
.long	0x0000ad00,0x0000ad00,0xffef36be,0xffef36be
.long	0x000dcd44,0x000dcd44,0x003c675a,0x003c675a
.long	0x95a0ad00,0x95a0ad00,0x7fc6f6be,0x7fc6f6be
.long	0x27b64d44,0x27b64d44,0x4827a75a,0x4827a75a
.long	0x0035843f,0x0035843f,0x0035843f,0x0035843f
.long	0xffdf5617,0xffdf5617,0xffdf5617,0xffdf5617
.long	0x8d3d643f,0x8d3d643f,0x8d3d643f,0x8d3d643f
.long	0x3b223617,0x3b223617,0x3b223617,0x3b223617
.long	0xffe7945c,0xffe7945c,0xffe7945c,0xffe7945c
.long	0x0038738c,0x0038738c,0x0038738c,0x0038738c
.long	0x3473145c,0x3473145c,0x3473145c,0x3473145c
.long	0x78a9f38c,0x78a9f38c,0x78a9f38c,0x78a9f38c
.long	0xffc72bca,0xffc72bca,0xffffde7e,0xffffde7e
.long	0x00193948,0x00193948,0xffce69c0,0xffce69c0
.long	0x28406bca,0x28406bca,0xb4cf9e7e,0xb4cf9e7e
.long	0xa3423948,0xa3423948,0xed0669c0,0xed0669c0
.long	0x0024756c,0x0024756c,0xfffcc7df,0xfffcc7df
.long	0x000b98a1,0x000b98a1,0xffebe808,0xffebe808
.long	0x88d1f56c,0x88d1f56c,0x2578a7df,0x2578a7df
.long	0xa69fb8a1,0xa69fb8a1,0x98ece808,0x98ece808
.long	0xffec7953,0x001d4099,0xffd92578,0xffeb05ad
.long	0x0016e405,0x000bdbe7,0x00221de8,0x0033f8cf
.long	0x3196d953,0xbfb06099,0x48882578,0x3e20a5ad
.long	0xee178405,0x2408bbe7,0xefdf1de8,0x53cdd8cf
.long	0xfff7b934,0xffd4ca0c,0xffe67ff8,0xffe3d157
.long	0xffd8911b,0xffc72c12,0x000910d8,0xffc65e1f
.long	0x2d1e3934,0xc3164a0c,0xb3e57ff8,0x2a8eb157
.long	0xf07bf11b,0x24496c12,0x162410d8,0x380a3e1f
.long	0xffe14658,0x00251d8b,0x002573b7,0xfffd7c8f
.long	0x001ddd98,0x00336898,0x0002d4bb,0xffed93a7
.long	0x5cac4658,0x0a567d8b,0xaf1c53b7,0xa40f5c8f
.long	0x4fd0dd98,0x81466898,0xe91a34bb,0x7ae273a7
.long	0xffcf6cbe,0x00027c1c,0x0018aa08,0x002dfd71
.long	0x000c5ca5,0x0019379a,0xffc7a167,0xffe48c3d
.long	0x86672cbe,0xb185fc1c,0x3159aa08,0xcb5c1d71
.long	0xcd20fca5,0xc20c779a,0xdc748167,0x66ec2c3d
.long	0x00071e24,0x00071e24,0x00071e24,0x00071e24
.long	0x00071e24,0x00071e24,0x00071e24,0x00071e24
.long	0x61cb9e24,0x61cb9e24,0x61cb9e24,0x61cb9e24
.long	0x61cb9e24,0x61cb9e24,0x61cb9e24,0x61cb9e24
.long	0x002f7a49,0x002f7a49,0x002f7a49,0x002f7a49
.long	0x002f7a49,0x002f7a49,0x002f7a49,0x002f7a49
.long	0xeef89a49,0xeef89a49,0xeef89a49,0xeef89a49
.long	0xeef89a49,0xeef89a49,0xeef89a49,0xeef89a49
.long	0x0028e527,0x0028e527,0x0028e527,0x0028e527
.long	0x0028e527,0x0028e527,0x0028e527,0x0028e527
.long	0x254dc527,0x254dc527,0x254dc527,0x254dc527
.long	0x254dc527,0x254dc527,0x254dc527,0x254dc527
.long	0x001ad035,0x001ad035,0x001ad035,0x001ad035
.long	0x001ad035,0x001ad035,0x001ad035,0x001ad035
.long	0x13a17035,0x13a17035,0x13a17035,0x13a17035
.long	0x13a17035,0x13a17035,0x13a17035,0x13a17035
.long	0xffffb422,0xffffb422,0xffffb422,0xffffb422
.long	0xffffb422,0xffffb422,0xffffb422,0xffffb422
.long	0x6d83f422,0x6d83f422,0x6d83f422,0x6d83f422
.long	0x6d83f422,0x6d83f422,0x6d83f422,0x6d83f422
.long	0x003d3201,0x003d3201,0x003d3201,0x003d3201
.long	0x003d3201,0x003d3201,0x003d3201,0x003d3201
.long	0xa9fd5201,0xa9fd5201,0xa9fd5201,0xa9fd5201
.long	0xa9fd5201,0xa9fd5201,0xa9fd5201,0xa9fd5201
.long	0x000445c5,0x000445c5,0x000445c5,0x000445c5
.long	0x000445c5,0x000445c5,0x000445c5,0x000445c5
.long	0xba3ce5c5,0xba3ce5c5,0xba3ce5c5,0xba3ce5c5
.long	0xba3ce5c5,0xba3ce5c5,0xba3ce5c5,0xba3ce5c5
.long	0x000c63a8,0x000c63a8,0x000c63a8,0x000c63a8
.long	0x00081b9a,0x00081b9a,0x00081b9a,0x00081b9a
.long	0x588163a8,0x588163a8,0x588163a8,0x588163a8
.long	0x9e7b5b9a,0x9e7b5b9a,0x9e7b5b9a,0x9e7b5b9a
.long	0x000e8f76,0x000e8f76,0x000e8f76,0x000e8f76
.long	0x003b3853,0x003b3853,0x003b3853,0x003b3853
.long	0xeefd4f76,0xeefd4f76,0xeefd4f76,0xeefd4f76
.long	0x89c59853,0x89c59853,0x89c59853,0x89c59853
.long	0x0002e46c,0x0002e46c,0xffc9c808,0xffc9c808
.long	0x003036c2,0x003036c2,0xffe3bff6,0xffe3bff6
.long	0xd690646c,0xd690646c,0x54cac808,0x54cac808
.long	0xae0876c2,0xae0876c2,0x54e27ff6,0x54e27ff6
.long	0xffdb3c93,0xffdb3c93,0xfffd4ae0,0xfffd4ae0
.long	0x00141305,0x00141305,0x00147792,0x00147792
.long	0x69ed9c93,0x69ed9c93,0xb9594ae0,0xb9594ae0
.long	0x13f4b305,0x13f4b305,0x0e06b792,0x0e06b792
.long	0x003b8534,0x003b8534,0x003b8534,0x003b8534
.long	0xffd8fc30,0xffd8fc30,0xffd8fc30,0xffd8fc30
.long	0xa6e20534,0xa6e20534,0xa6e20534,0xa6e20534
.long	0xc75efc30,0xc75efc30,0xc75efc30,0xc75efc30
.long	0x001f9d54,0x001f9d54,0x001f9d54,0x001f9d54
.long	0xffd54f2d,0xffd54f2d,0xffd54f2d,0xffd54f2d
.long	0x99ca1d54,0x99ca1d54,0x99ca1d54,0x99ca1d54
.long	0xc73aef2d,0xc73aef2d,0xc73aef2d,0xc73aef2d
.long	0x00139e25,0x00139e25,0xffe7d0e0,0xffe7d0e0
.long	0xfff39944,0xfff39944,0xffea0802,0xffea0802
.long	0xf5583e25,0xf5583e25,0x0a03d0e0,0x0a03d0e0
.long	0xe11c1944,0xe11c1944,0x47ea4802,0x47ea4802
.long	0xffd1eea2,0xffd1eea2,0xffc4c79c,0xffc4c79c
.long	0xffc8a057,0xffc8a057,0x003a97d9,0x003a97d9
.long	0x74a62ea2,0x74a62ea2,0x3ab8479c,0x3ab8479c
.long	0x44538057,0x44538057,0xcab5b7d9,0xcab5b7d9
.long	0xffd1a13c,0x0035c539,0x003b0115,0x00041dc0
.long	0x0021c4f7,0xfff11bf4,0x001a35e7,0x0007340e
.long	0x85f9213c,0x005ce539,0x29dda115,0xa3bc1dc0
.long	0x9940a4f7,0xf96f9bf4,0xef5715e7,0x1788f40e
.long	0xfff97d45,0x001a4cd0,0xffe47cae,0x001d2668
.long	0xffe68e98,0xffef2633,0xfffc05da,0xffc57fdb
.long	0xa1221d45,0x21b44cd0,0xf07a3cae,0x10ea2668
.long	0xe5b98e98,0x97358633,0xfbb745da,0x2e40dfdb
.long	0xffd32764,0xffdde1af,0xfff993dd,0xffdd1d09
.long	0x0002cc93,0xfff11805,0x00189c2a,0xffc9e5a9
.long	0x42bfa764,0xa093c1af,0xb7f533dd,0x42fe3d09
.long	0x5c152c93,0x3471b805,0xa69ddc2a,0x0bff05a9
.long	0xfff78a50,0x003bcf2c,0xffff434e,0xffeb36df
.long	0x003c15ca,0x00155e68,0xfff316b6,0x001e29ce
.long	0x09418a50,0x94214f2c,0x7969034e,0x734716df
.long	0xc5f555ca,0x17e25e68,0xdfc9d6b6,0x1657e9ce
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_avx2_zetas_basemul:
.long	0xffc406e5,0xffe9d65d,0x003cf91b,0x001729a3
.long	0xffe8ac81,0x003509ee,0x0018537f,0xffcbf612
.long	0xffc7e1cf,0x002135c7,0x00391e31,0xffdfca39
.long	0xffd19819,0xffe7cfbb,0x002f67e7,0x00193045
.long	0x0000a6e5,0x0000765d,0x0000591b,0x000089a3
.long	0x0000cc81,0x0000c9ee,0x0000337f,0x00003612
.long	0x0000c1cf,0x000015c7,0x00003e31,0x0000ea39
.long	0x0000b819,0x00002fbb,0x000047e7,0x0000d045
.long	0xffeccf75,0xffcf5280,0x0014308b,0x0031ad80
.long	0x001d9772,0xffcfd2ae,0xffe3688e,0x00312d52
.long	0xffc1b072,0xffc890e0,0x003f4f8e,0x00386f20
.long	0xfff0bcf6,0x0001efca,0x0010430a,0xffff1036
.long	0x00006f75,0x00005280,0x0000908b,0x0000ad80
.long	0x0000d772,0x000092ae,0x0000288e,0x00006d52
.long	0x0000f072,0x000090e0,0x00000f8e,0x00006f20
.long	0x00007cf6,0x00002fca,0x0000830a,0x0000d036
.long	0x003410f2,0xffd2b7a3,0xffccef0e,0x002e485d
.long	0xfff0fe85,0xffc7a44b,0x0010017b,0x00395bb5
.long	0x0020c638,0xfff9ba6d,0xffe039c8,0x00074593
.long	0x00296e9f,0xffda3409,0xffd79161,0x0026cbf7
.long	0x000050f2,0x000017a3,0x0000af0e,0x0000e85d
.long	0x00009e85,0x0000044b,0x0000617b,0x0000fbb5
.long	0x0000c638,0x00005a6d,0x000039c8,0x0000a593
.long	0x00004e9f,0x00005409,0x0000b161,0x0000abf7
.long	0xfff5c282,0xfffa2bdd,0x000b3d7e,0x0006d423
.long	0xffed4113,0x001495d4,0x0013beed,0xffec6a2c
.long	0xffffa63b,0x001c4563,0x000159c5,0xffe4ba9d
.long	0xffec09f7,0xffea2c62,0x0014f609,0x0016d39e
.long	0x00000282,0x0000cbdd,0x0000fd7e,0x00003423
.long	0x0000a113,0x000015d4,0x00005eed,0x0000ea2c
.long	0x0000063b,0x0000a563,0x0000f9c5,0x00005a9d
.long	0x0000e9f7,0x00006c62,0x00001609,0x0000939e
.long	0xffccfbe9,0x0000ad00,0x00340417,0x00005300
.long	0x00040af0,0xffef36be,0xfffcf510,0x0011c942
.long	0x0007c417,0x000dcd44,0xfff93be9,0xfff332bc
.long	0x002f4588,0x003c675a,0xffd1ba78,0xffc498a6
.long	0x00001be9,0x0000ad00,0x0000e417,0x00005300
.long	0x00000af0,0x0000f6be,0x0000f510,0x00000942
.long	0x0000a417,0x00004d44,0x00005be9,0x0000b2bc
.long	0x00004588,0x0000a75a,0x0000ba78,0x000058a6
.long	0xffc72bca,0x0024756c,0x0039d436,0xffdc8a94
.long	0xffffde7e,0xfffcc7df,0x00012182,0x00043821
.long	0x00193948,0x000b98a1,0xffe7c6b8,0xfff5675f
.long	0xffce69c0,0xffebe808,0x00329640,0x001517f8
.long	0x00006bca,0x0000f56c,0x00009436,0x00000a94
.long	0x00009e7e,0x0000a7df,0x00006182,0x00005821
.long	0x00003948,0x0000b8a1,0x0000c6b8,0x0000475f
.long	0x000069c0,0x0000e808,0x00009640,0x000017f8
.long	0x0002e46c,0xffdb3c93,0xfffe1b94,0x0025c36d
.long	0xffc9c808,0xfffd4ae0,0x003737f8,0x0003b520
.long	0x003036c2,0x00141305,0xffd0c93e,0xffececfb
.long	0xffe3bff6,0x00147792,0x001d400a,0xffec886e
.long	0x0000646c,0x00009c93,0x00009b94,0x0000636d
.long	0x0000c808,0x00004ae0,0x000037f8,0x0000b520
.long	0x000076c2,0x0000b305,0x0000893e,0x00004cfb
.long	0x00007ff6,0x0000b792,0x0000800a,0x0000486e
.long	0x00139e25,0xffd1eea2,0xffed61db,0x002f115e
.long	0xffe7d0e0,0xffc4c79c,0x00192f20,0x003c3864
.long	0xfff39944,0xffc8a057,0x000d66bc,0x00385fa9
.long	0xffea0802,0x003a97d9,0x0016f7fe,0xffc66827
.long	0x00003e25,0x00002ea2,0x0000c1db,0x0000d15e
.long	0x0000d0e0,0x0000479c,0x00002f20,0x0000b864
.long	0x00001944,0x00008057,0x0000e6bc,0x00007fa9
.long	0x00004802,0x0000b7d9,0x0000b7fe,0x00004827
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_avx2_zetas_1:
.long	0xffc97e01,0xffc97e01,0xffc97e01,0xffc97e01
.long	0xffc97e01,0xffc97e01,0xffc97e01,0xffc97e01
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_avx2_zetas_inv:
.long	0xffe1d632,0x000ce94a,0xffeaa198,0xffc3ea36
.long	0x0014c921,0x0000bcb2,0xffc430d4,0x000875b0
.long	0xe9a81632,0x2036294a,0xe81da198,0x3a0aaa36
.long	0x8cb8e921,0x8696fcb2,0x6bdeb0d4,0xf6be75b0
.long	0x00361a57,0xffe763d6,0x000ee7fb,0xfffd336d
.long	0x0022e2f7,0x00066c23,0x00221e51,0x002cd89c
.long	0xf400fa57,0x596223d6,0xcb8e47fb,0xa3ead36d
.long	0xbd01c2f7,0x480acc23,0x5f6c3e51,0xbd40589c
.long	0xffc56827,0xffc56827,0x00375fa9,0x00375fa9
.long	0x003b3864,0x003b3864,0x002e115e,0x002e115e
.long	0x354a4827,0x354a4827,0xbbac7fa9,0xbbac7fa9
.long	0xc547b864,0xc547b864,0x8b59d15e,0x8b59d15e
.long	0x0015f7fe,0x0015f7fe,0x000c66bc,0x000c66bc
.long	0x00182f20,0x00182f20,0xffec61db,0xffec61db
.long	0xb815b7fe,0xb815b7fe,0x1ee3e6bc,0x1ee3e6bc
.long	0xf5fc2f20,0xf5fc2f20,0x0aa7c1db,0x0aa7c1db
.long	0x002ab0d3,0x002ab0d3,0x002ab0d3,0x002ab0d3
.long	0xffe062ac,0xffe062ac,0xffe062ac,0xffe062ac
.long	0x38c510d3,0x38c510d3,0x38c510d3,0x38c510d3
.long	0x6635e2ac,0x6635e2ac,0x6635e2ac,0x6635e2ac
.long	0x002703d0,0x002703d0,0x002703d0,0x002703d0
.long	0xffc47acc,0xffc47acc,0xffc47acc,0xffc47acc
.long	0x38a103d0,0x38a103d0,0x38a103d0,0x38a103d0
.long	0x591dfacc,0x591dfacc,0x591dfacc,0x591dfacc
.long	0xfffbba3b,0xfffbba3b,0xfffbba3b,0xfffbba3b
.long	0xfffbba3b,0xfffbba3b,0xfffbba3b,0xfffbba3b
.long	0x45c31a3b,0x45c31a3b,0x45c31a3b,0x45c31a3b
.long	0x45c31a3b,0x45c31a3b,0x45c31a3b,0x45c31a3b
.long	0xffc2cdff,0xffc2cdff,0xffc2cdff,0xffc2cdff
.long	0xffc2cdff,0xffc2cdff,0xffc2cdff,0xffc2cdff
.long	0x5602adff,0x5602adff,0x5602adff,0x5602adff
.long	0x5602adff,0x5602adff,0x5602adff,0x5602adff
.long	0xffd71ad9,0xffd71ad9,0xffd71ad9,0xffd71ad9
.long	0xffd71ad9,0xffd71ad9,0xffd71ad9,0xffd71ad9
.long	0xdab23ad9,0xdab23ad9,0xdab23ad9,0xdab23ad9
.long	0xdab23ad9,0xdab23ad9,0xdab23ad9,0xdab23ad9
.long	0x003a8025,0x0003fa26,0x0010d9cd,0x00197168
.long	0xffe2d998,0x001b8352,0xffe5b330,0x000682bb
.long	0xd1bf2025,0x0448ba26,0x68ca79cd,0x1a467168
.long	0xef15d998,0x0f85c352,0xde4bb330,0x5edde2bb
.long	0xfff8cbf2,0xffe5ca19,0x000ee40c,0xffde3b09
.long	0xfffbe240,0xffc4feeb,0xffca3ac7,0x002e5ec4
.long	0xe8770bf2,0x10a8ea19,0x0690640c,0x66bf5b09
.long	0x5c43e240,0xd6225eeb,0xffa31ac7,0x7a06dec4
.long	0xffeb886e,0xffeb886e,0xffebecfb,0xffebecfb
.long	0x0002b520,0x0002b520,0x0024c36d,0x0024c36d
.long	0xf1f9486e,0xf1f9486e,0xec0b4cfb,0xec0b4cfb
.long	0x46a6b520,0x46a6b520,0x9612636d,0x9612636d
.long	0x001c400a,0x001c400a,0xffcfc93e,0xffcfc93e
.long	0x003637f8,0x003637f8,0xfffd1b94,0xfffd1b94
.long	0xab1d800a,0xab1d800a,0x51f7893e,0x51f7893e
.long	0xab3537f8,0xab3537f8,0x296f9b94,0x296f9b94
.long	0xffc4c7ad,0xffc4c7ad,0xffc4c7ad,0xffc4c7ad
.long	0xfff1708a,0xfff1708a,0xfff1708a,0xfff1708a
.long	0x763a67ad,0x763a67ad,0x763a67ad,0x763a67ad
.long	0x1102b08a,0x1102b08a,0x1102b08a,0x1102b08a
.long	0xfff7e466,0xfff7e466,0xfff7e466,0xfff7e466
.long	0xfff39c58,0xfff39c58,0xfff39c58,0xfff39c58
.long	0x6184a466,0x6184a466,0x6184a466,0x6184a466
.long	0xa77e9c58,0xa77e9c58,0xa77e9c58,0xa77e9c58
.long	0x00004bde,0x00004bde,0x00004bde,0x00004bde
.long	0x00004bde,0x00004bde,0x00004bde,0x00004bde
.long	0x927c0bde,0x927c0bde,0x927c0bde,0x927c0bde
.long	0x927c0bde,0x927c0bde,0x927c0bde,0x927c0bde
.long	0xffe52fcb,0xffe52fcb,0xffe52fcb,0xffe52fcb
.long	0xffe52fcb,0xffe52fcb,0xffe52fcb,0xffe52fcb
.long	0xec5e8fcb,0xec5e8fcb,0xec5e8fcb,0xec5e8fcb
.long	0xec5e8fcb,0xec5e8fcb,0xec5e8fcb,0xec5e8fcb
.long	0xffd085b7,0xffd085b7,0xffd085b7,0xffd085b7
.long	0xffd085b7,0xffd085b7,0xffd085b7,0xffd085b7
.long	0x110765b7,0x110765b7,0x110765b7,0x110765b7
.long	0x110765b7,0x110765b7,0x110765b7,0x110765b7
.long	0xfff8e1dc,0xfff8e1dc,0xfff8e1dc,0xfff8e1dc
.long	0xfff8e1dc,0xfff8e1dc,0xfff8e1dc,0xfff8e1dc
.long	0x9e3461dc,0x9e3461dc,0x9e3461dc,0x9e3461dc
.long	0x9e3461dc,0x9e3461dc,0x9e3461dc,0x9e3461dc
.long	0x001b73c3,0x00385e99,0xffe6c866,0xfff3a35b
.long	0xffd2028f,0xffe755f8,0xfffd83e4,0x00309342
.long	0x9913d3c3,0x238b7e99,0x3df38866,0x32df035b
.long	0x34a3e28f,0xcea655f8,0x4e7a03e4,0x7998d342
.long	0x00126c59,0xfffd2b45,0xffcc9768,0xffe22268
.long	0x00028371,0xffda8c49,0xffdae275,0x001eb9a8
.long	0x851d8c59,0x16e5cb45,0x7eb99768,0xb02f2268
.long	0x5bf0a371,0x50e3ac49,0xf5a98275,0xa353b9a8
.long	0x001417f8,0x001417f8,0xfff4675f,0xfff4675f
.long	0x00033821,0x00033821,0xffdb8a94,0xffdb8a94
.long	0x671317f8,0x671317f8,0x5960475f,0x5960475f
.long	0xda875821,0xda875821,0x772e0a94,0x772e0a94
.long	0x00319640,0x00319640,0xffe6c6b8,0xffe6c6b8
.long	0x00002182,0x00002182,0x0038d436,0x0038d436
.long	0x12f99640,0x12f99640,0x5cbdc6b8,0x5cbdc6b8
.long	0x4b306182,0x4b306182,0xd7bf9436,0xd7bf9436
.long	0xffc78c74,0xffc78c74,0xffc78c74,0xffc78c74
.long	0x00186ba4,0x00186ba4,0x00186ba4,0x00186ba4
.long	0x87560c74,0x87560c74,0x87560c74,0x87560c74
.long	0xcb8ceba4,0xcb8ceba4,0xcb8ceba4,0xcb8ceba4
.long	0x0020a9e9,0x0020a9e9,0x0020a9e9,0x0020a9e9
.long	0xffca7bc1,0xffca7bc1,0xffca7bc1,0xffca7bc1
.long	0xc4ddc9e9,0xc4ddc9e9,0xc4ddc9e9,0xc4ddc9e9
.long	0x72c29bc1,0x72c29bc1,0x72c29bc1,0x72c29bc1
.long	0x00320368,0x00320368,0x00320368,0x00320368
.long	0x00320368,0x00320368,0x00320368,0x00320368
.long	0x2c9f0368,0x2c9f0368,0x2c9f0368,0x2c9f0368
.long	0x2c9f0368,0x2c9f0368,0x2c9f0368,0x2c9f0368
.long	0x00155b09,0x00155b09,0x00155b09,0x00155b09
.long	0x00155b09,0x00155b09,0x00155b09,0x00155b09
.long	0x4af67b09,0x4af67b09,0x4af67b09,0x4af67b09
.long	0x4af67b09,0x4af67b09,0x4af67b09,0x4af67b09
.long	0x002c04f7,0x002c04f7,0x002c04f7,0x002c04f7
.long	0x002c04f7,0x002c04f7,0x002c04f7,0x002c04f7
.long	0xe14ae4f7,0xe14ae4f7,0xe14ae4f7,0xe14ae4f7
.long	0xe14ae4f7,0xe14ae4f7,0xe14ae4f7,0xe14ae4f7
.long	0x0039a1e1,0xfff6ef28,0x0038d3ee,0x00276ee5
.long	0x001c2ea9,0x00198008,0x002b35f4,0x000846cc
.long	0xc7f5c1e1,0xe9dbef28,0xdbb693ee,0x0f840ee5
.long	0xd5714ea9,0x4c1a8008,0x3ce9b5f4,0xd2e1c6cc
.long	0xffcc0731,0xffdde218,0xfff42419,0xffe91bfb
.long	0x0014fa53,0x0026da88,0xffe2bf67,0x001386ad
.long	0xac322731,0x1020e218,0xdbf74419,0x11e87bfb
.long	0xc1df5a53,0xb777da88,0x404f9f67,0xce6926ad
.long	0xffc398a6,0xffc398a6,0xfff232bc,0xfff232bc
.long	0x0010c942,0x0010c942,0xffff5300,0xffff5300
.long	0xb7d858a6,0xb7d858a6,0xd849b2bc,0xd849b2bc
.long	0x80390942,0x80390942,0x6a5f5300,0x6a5f5300
.long	0xffd0ba78,0xffd0ba78,0xfff83be9,0xfff83be9
.long	0xfffbf510,0xfffbf510,0x00330417,0x00330417
.long	0xbb1fba78,0xbb1fba78,0xb6f55be9,0xb6f55be9
.long	0x369df510,0x369df510,0xb135e417,0xb135e417
.long	0x003a50a7,0x003a50a7,0x003a50a7,0x003a50a7
.long	0xffca81e2,0xffca81e2,0xffca81e2,0xffca81e2
.long	0x92cf30a7,0x92cf30a7,0x92cf30a7,0x92cf30a7
.long	0xe706c1e2,0xe706c1e2,0xe706c1e2,0xe706c1e2
.long	0x0019152a,0x0019152a,0x0019152a,0x0019152a
.long	0x0019edc3,0x0019edc3,0x0019edc3,0x0019edc3
.long	0x35be552a,0x35be552a,0x35be552a,0x35be552a
.long	0x68524dc3,0x68524dc3,0x68524dc3,0x68524dc3
.long	0x003ae519,0x003ae519,0x003ae519,0x003ae519
.long	0x003ae519,0x003ae519,0x003ae519,0x003ae519
.long	0x345e0519,0x345e0519,0x345e0519,0x345e0519
.long	0x345e0519,0x345e0519,0x345e0519,0x345e0519
.long	0x0020522a,0x0020522a,0x0020522a,0x0020522a
.long	0x0020522a,0x0020522a,0x0020522a,0x0020522a
.long	0x9d65922a,0x9d65922a,0x9d65922a,0x9d65922a
.long	0x9d65922a,0x9d65922a,0x9d65922a,0x9d65922a
.long	0xffd0658b,0xffd0658b,0xffd0658b,0xffd0658b
.long	0xffd0658b,0xffd0658b,0xffd0658b,0xffd0658b
.long	0x7301c58b,0x7301c58b,0x7301c58b,0x7301c58b
.long	0x7301c58b,0x7301c58b,0x7301c58b,0x7301c58b
.long	0x000d5ed8,0x000d5ed8,0x000d5ed8,0x000d5ed8
.long	0x000d5ed8,0x000d5ed8,0x000d5ed8,0x000d5ed8
.long	0x9fe85ed8,0x9fe85ed8,0x9fe85ed8,0x9fe85ed8
.long	0x9fe85ed8,0x9fe85ed8,0x9fe85ed8,0x9fe85ed8
.long	0x001df292,0xffcd8d7d,0xffebf939,0x0006e21c
.long	0x0015d2d1,0x0032a1c2,0xffed1ee5,0x00145742
.long	0xbd703292,0xe6fd2d7d,0xc6931939,0x3e4a621c
.long	0x95eff2d1,0x7b6ae1c2,0xc549bee5,0xf1fc9742
.long	0x0010095a,0xffe2f4b5,0xffe37ac1,0x002daf77
.long	0x00362470,0xffd7c76f,0xffeceb42,0x00397ae8
.long	0xbc3b495a,0xd7f994b5,0x12bb9ac1,0xd69c8f77
.long	0x4cc42470,0xfd45a76f,0x04552b42,0x5b967ae8
.long	0x0015d39e,0x0015d39e,0xffe3ba9d,0xffe3ba9d
.long	0xffeb6a2c,0xffeb6a2c,0x0005d423,0x0005d423
.long	0x6389939e,0x6389939e,0x9cb75a9d,0x9cb75a9d
.long	0x0730ea2c,0x0730ea2c,0x350a3423,0x350a3423
.long	0x0013f609,0x0013f609,0x000059c5,0x000059c5
.long	0x0012beed,0x0012beed,0x000a3d7e,0x000a3d7e
.long	0x9e551609,0x9e551609,0x3cb8f9c5,0x3cb8f9c5
.long	0x95705eed,0x95705eed,0x80b9fd7e,0x80b9fd7e
.long	0x00083aa3,0x00083aa3,0x00083aa3,0x00083aa3
.long	0xffdc2964,0xffdc2964,0xffdc2964,0xffdc2964
.long	0x41dc9aa3,0x41dc9aa3,0x41dc9aa3,0x41dc9aa3
.long	0x6308a964,0x6308a964,0x6308a964,0x6308a964
.long	0x000495b3,0x000495b3,0x000495b3,0x000495b3
.long	0xffc9fc00,0xffc9fc00,0xffc9fc00,0xffc9fc00
.long	0x853af5b3,0x853af5b3,0x853af5b3,0x853af5b3
.long	0x3f49fc00,0x3f49fc00,0x3f49fc00,0x3f49fc00
.long	0x00202c85,0x00202c85,0x00202c85,0x00202c85
.long	0x00202c85,0x00202c85,0x00202c85,0x00202c85
.long	0xd730cc85,0xd730cc85,0xd730cc85,0xd730cc85
.long	0xd730cc85,0xd730cc85,0xd730cc85,0xd730cc85
.long	0xffd80698,0xffd80698,0xffd80698,0xffd80698
.long	0xffd80698,0xffd80698,0xffd80698,0xffd80698
.long	0x14ab0698,0x14ab0698,0x14ab0698,0x14ab0698
.long	0x14ab0698,0x14ab0698,0x14ab0698,0x14ab0698
.long	0x001feb81,0x001feb81,0x001feb81,0x001feb81
.long	0x001feb81,0x001feb81,0x001feb81,0x001feb81
.long	0x41100b81,0x41100b81,0x41100b81,0x41100b81
.long	0x41100b81,0x41100b81,0x41100b81,0x41100b81
.long	0xffe7a5ba,0xffda0faf,0xffecf67c,0xffc21ee4
.long	0xffecb28f,0x002785c6,0xffd6ee67,0xffd4a11b
.long	0xff9ee5ba,0x264fefaf,0x50bc767c,0x619e9ee4
.long	0x8abe928f,0x25e045c6,0x4623ce67,0x7278011b
.long	0xfffce6dc,0xffe58339,0x0032ffc5,0xffcb8d19
.long	0xffc14fe5,0x002532bf,0xfffb9ef4,0xfffac6e7
.long	0x9ed866dc,0xf7cca339,0x91ab9fc5,0x48eead19
.long	0xcb3defe5,0x42fd12bf,0xc9da1ef4,0x8157a6e7
.long	0x0025cbf7,0x0025cbf7,0x00064593,0x00064593
.long	0x00385bb5,0x00385bb5,0x002d485d,0x002d485d
.long	0x9a24abf7,0x9a24abf7,0x4b38a593,0x4b38a593
.long	0x052efbb5,0x052efbb5,0xeeb8e85d,0xeeb8e85d
.long	0xffd69161,0xffd69161,0xffdf39c8,0xffdf39c8
.long	0x000f017b,0x000f017b,0xffcbef0e,0xffcbef0e
.long	0xa582b161,0xa582b161,0x231839c8,0x231839c8
.long	0x0ebe617b,0x0ebe617b,0x2eadaf0e,0x2eadaf0e
.long	0x002bc1bf,0x002bc1bf,0x002bc1bf,0x002bc1bf
.long	0xffc9756a,0xffc9756a,0xffc9756a,0xffc9756a
.long	0x94e3a1bf,0x94e3a1bf,0x94e3a1bf,0x94e3a1bf
.long	0x2176b56a,0x2176b56a,0x2176b56a,0x2176b56a
.long	0x002e7184,0x002e7184,0x002e7184,0x002e7184
.long	0x003aea7b,0x003aea7b,0x003aea7b,0x003aea7b
.long	0x1c5ef184,0x1c5ef184,0x1c5ef184,0x1c5ef184
.long	0x0c0a4a7b,0x0c0a4a7b,0x0c0a4a7b,0x0c0a4a7b
.long	0x00111560,0x00111560,0x00111560,0x00111560
.long	0x00111560,0x00111560,0x00111560,0x00111560
.long	0xf2bd1560,0xf2bd1560,0xf2bd1560,0xf2bd1560
.long	0xf2bd1560,0xf2bd1560,0xf2bd1560,0xf2bd1560
.long	0x00086270,0x00086270,0x00086270,0x00086270
.long	0x00086270,0x00086270,0x00086270,0x00086270
.long	0x94566270,0x94566270,0x94566270,0x94566270
.long	0x94566270,0x94566270,0x94566270,0x94566270
.long	0x00057b53,0x00057b53,0x00057b53,0x00057b53
.long	0x00057b53,0x00057b53,0x00057b53,0x00057b53
.long	0x51efdb53,0x51efdb53,0x51efdb53,0x51efdb53
.long	0x51efdb53,0x51efdb53,0x51efdb53,0x51efdb53
.long	0x000bdee8,0x000bdee8,0x000bdee8,0x000bdee8
.long	0x000bdee8,0x000bdee8,0x000bdee8,0x000bdee8
.long	0xa7e8dee8,0xa7e8dee8,0xa7e8dee8,0xa7e8dee8
.long	0xa7e8dee8,0xa7e8dee8,0xa7e8dee8,0xa7e8dee8
.long	0x0036de3e,0x000bba6e,0x0008032a,0x00364683
.long	0xffcf107a,0xffe0ff7c,0x002fa50a,0x0009ffdf
.long	0xb4fe9e3e,0xf8597a6e,0x136d432a,0x9386a683
.long	0x8cde507a,0x51d07f7c,0x97d0e50a,0xcc85dfdf
.long	0x0007f904,0x0000a8fc,0x00189d76,0xfff8707d
.long	0xfff380a6,0xfff21f1a,0xffe3a1e6,0xfff241a2
.long	0x8d287904,0x872028fc,0x30c75d76,0xc388107d
.long	0xb50840a6,0x1ed55f1a,0x192061e6,0xff2681a2
.long	0xfffe1036,0xfffe1036,0x00376f20,0x00376f20
.long	0x00302d52,0x00302d52,0x0030ad80,0x0030ad80
.long	0x7f04d036,0x7f04d036,0xde1b6f20,0xde1b6f20
.long	0xa4da6d52,0xa4da6d52,0x55e0ad80,0x55e0ad80
.long	0x000f430a,0x000f430a,0x003e4f8e,0x003e4f8e
.long	0xffe2688e,0xffe2688e,0x0013308b,0x0013308b
.long	0x8b70830a,0x8b70830a,0x3b300f8e,0x3b300f8e
.long	0x3df4288e,0x3df4288e,0x4ca4908b,0x4ca4908b
.long	0xffc44151,0xffc44151,0xffc44151,0xffc44151
.long	0x0026b82c,0x0026b82c,0x0026b82c,0x0026b82c
.long	0x236e6151,0x236e6151,0x236e6151,0x236e6151
.long	0x712c382c,0x712c382c,0x712c382c,0x712c382c
.long	0x0036cfd4,0x0036cfd4,0x0036cfd4,0x0036cfd4
.long	0x00195afd,0x00195afd,0x00195afd,0x00195afd
.long	0x40314fd4,0x40314fd4,0x40314fd4,0x40314fd4
.long	0xa0f8fafd,0xa0f8fafd,0xa0f8fafd,0xa0f8fafd
.long	0xffc94878,0xffc94878,0xffc94878,0xffc94878
.long	0xffc94878,0xffc94878,0xffc94878,0xffc94878
.long	0xccd84878,0xccd84878,0xccd84878,0xccd84878
.long	0xccd84878,0xccd84878,0xccd84878,0xccd84878
.long	0x00107a5c,0x00107a5c,0x00107a5c,0x00107a5c
.long	0x00107a5c,0x00107a5c,0x00107a5c,0x00107a5c
.long	0x515bfa5c,0x515bfa5c,0x515bfa5c,0x515bfa5c
.long	0x515bfa5c,0x515bfa5c,0x515bfa5c,0x515bfa5c
.long	0xffdc16d5,0xffdc16d5,0xffdc16d5,0xffdc16d5
.long	0xffdc16d5,0xffdc16d5,0xffdc16d5,0xffdc16d5
.long	0x6c36b6d5,0x6c36b6d5,0x6c36b6d5,0x6c36b6d5
.long	0x6c36b6d5,0x6c36b6d5,0x6c36b6d5,0x6c36b6d5
.long	0x0030ba22,0x001244aa,0x00395d04,0x0035b760
.long	0xffca64a3,0x0012db10,0xffdada79,0xfffbed0b
.long	0x8e74fa22,0x9ba784aa,0xb9d9dd04,0x8721b760
.long	0x86dec4a3,0x1374db10,0x02a9fa79,0x241d4d0b
.long	0x00365bde,0x00255461,0xffddc205,0x0033008e
.long	0xffc5be08,0xffdca72c,0xffcc00a6,0xffe0156d
.long	0x54b21bde,0xfe317461,0xc99e6205,0x5144c08e
.long	0xd386be08,0xaec2272c,0xc4e0c0a6,0x000db56d
.long	0x00183045,0x00183045,0xffdeca39,0xffdeca39
.long	0xffcaf612,0xffcaf612,0x001629a3,0x001629a3
.long	0xf7a0d045,0xf7a0d045,0xa0a5ea39,0xa0a5ea39
.long	0x9d8d3612,0x9d8d3612,0x7fca89a3,0x7fca89a3
.long	0x002e67e7,0x002e67e7,0x00381e31,0x00381e31
.long	0x0017537f,0x0017537f,0x003bf91b,0x003bf91b
.long	0x75ab47e7,0x75ab47e7,0xaf7e3e31,0xaf7e3e31
.long	0x2707337f,0x2707337f,0x5ddf591b,0x5ddf591b
.long	0xffca213b,0xffca213b,0xffca213b,0xffca213b
.long	0xffd10b33,0xffd10b33,0xffd10b33,0xffd10b33
.long	0x9271813b,0x9271813b,0x9271813b,0x9271813b
.long	0x53b76b33,0x53b76b33,0x53b76b33,0x53b76b33
.long	0xfffe89e0,0xfffe89e0,0xfffe89e0,0xfffe89e0
.long	0xffd6b599,0xffd6b599,0xffd6b599,0xffd6b599
.long	0x613a89e0,0x613a89e0,0x613a89e0,0x613a89e0
.long	0x6e09d599,0x6e09d599,0x6e09d599,0x6e09d599
.long	0xfff05f90,0xfff05f90,0xfff05f90,0xfff05f90
.long	0xfff05f90,0xfff05f90,0xfff05f90,0xfff05f90
.long	0x83e25f90,0x83e25f90,0x83e25f90,0x83e25f90
.long	0x83e25f90,0x83e25f90,0x83e25f90,0x83e25f90
.long	0xffd669a8,0xffd669a8,0xffd669a8,0xffd669a8
.long	0xffd669a8,0xffd669a8,0xffd669a8,0xffd669a8
.long	0x990b69a8,0x990b69a8,0x990b69a8,0x990b69a8
.long	0x990b69a8,0x990b69a8,0x990b69a8,0x990b69a8
.long	0xffe421d5,0xffe421d5,0xffe421d5,0xffe421d5
.long	0xffe421d5,0xffe421d5,0xffe421d5,0xffe421d5
.long	0xed9ec1d5,0xed9ec1d5,0xed9ec1d5,0xed9ec1d5
.long	0xed9ec1d5,0xed9ec1d5,0xed9ec1d5,0xed9ec1d5
.long	0xfffc61bc,0xfffc61bc,0xfffc61bc,0xfffc61bc
.long	0xfffc61bc,0xfffc61bc,0xfffc61bc,0xfffc61bc
.long	0x9e33e1bc,0x9e33e1bc,0x9e33e1bc,0x9e33e1bc
.long	0x9e33e1bc,0x9e33e1bc,0x9e33e1bc,0x9e33e1bc
.long	0x0007eafd,0x0007eafd,0x0007eafd,0x0007eafd
.long	0x0007eafd,0x0007eafd,0x0007eafd,0x0007eafd
.long	0x72e78afd,0x72e78afd,0x72e78afd,0x72e78afd
.long	0x72e78afd,0x72e78afd,0x72e78afd,0x72e78afd
.long	0x0027cefe,0x0027cefe,0x0027cefe,0x0027cefe
.long	0x0027cefe,0x0027cefe,0x0027cefe,0x0027cefe
.long	0x73078efe,0x73078efe,0x73078efe,0x73078efe
.long	0x73078efe,0x73078efe,0x73078efe,0x73078efe
.long	0xffff9b09,0xffff9b09,0xffff9b09,0xffff9b09
.long	0xffff9b09,0xffff9b09,0xffff9b09,0xffff9b09
.long	0x92e0bb09,0x92e0bb09,0x92e0bb09,0x92e0bb09
.long	0x92e0bb09,0x92e0bb09,0x92e0bb09,0x92e0bb09
.long	0x0000a3fa,0x0000a3fa,0x0000a3fa,0x0000a3fa
.long	0x0000a3fa,0x0000a3fa,0x0000a3fa,0x0000a3fa
.long	0xff7fe3fa,0xff7fe3fa,0xff7fe3fa,0xff7fe3fa
.long	0xff7fe3fa,0xff7fe3fa,0xff7fe3fa,0xff7fe3fa
#ifndef __APPLE__
.text
.globl	wc_mldsa_poly_red_avx2
.type	wc_mldsa_poly_red_avx2,@function
.align	16
wc_mldsa_poly_red_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_poly_red_avx2
.p2align	4
_wc_mldsa_poly_red_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm10, %ymm10, %ymm10
        vmovdqu	mldsa_q(%rip), %ymm10
        vmovdqu	mldsa_v(%rip), %ymm11
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        vpaddd	%ymm11, %ymm0, %ymm8
        vpaddd	%ymm11, %ymm1, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm0, %ymm0
        vpsubd	%ymm9, %ymm1, %ymm1
        vpaddd	%ymm11, %ymm2, %ymm8
        vpaddd	%ymm11, %ymm3, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm2, %ymm2
        vpsubd	%ymm9, %ymm3, %ymm3
        vpaddd	%ymm11, %ymm4, %ymm8
        vpaddd	%ymm11, %ymm5, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm4, %ymm4
        vpsubd	%ymm9, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm6, %ymm8
        vpaddd	%ymm11, %ymm7, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm6, %ymm6
        vpsubd	%ymm9, %ymm7, %ymm7
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, 128(%rdi)
        vmovdqu	%ymm5, 160(%rdi)
        vmovdqu	%ymm6, 192(%rdi)
        vmovdqu	%ymm7, 224(%rdi)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vmovdqu	448(%rdi), %ymm6
        vmovdqu	480(%rdi), %ymm7
        vpaddd	%ymm11, %ymm0, %ymm8
        vpaddd	%ymm11, %ymm1, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm0, %ymm0
        vpsubd	%ymm9, %ymm1, %ymm1
        vpaddd	%ymm11, %ymm2, %ymm8
        vpaddd	%ymm11, %ymm3, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm2, %ymm2
        vpsubd	%ymm9, %ymm3, %ymm3
        vpaddd	%ymm11, %ymm4, %ymm8
        vpaddd	%ymm11, %ymm5, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm4, %ymm4
        vpsubd	%ymm9, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm6, %ymm8
        vpaddd	%ymm11, %ymm7, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm6, %ymm6
        vpsubd	%ymm9, %ymm7, %ymm7
        vmovdqu	%ymm0, 256(%rdi)
        vmovdqu	%ymm1, 288(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 352(%rdi)
        vmovdqu	%ymm4, 384(%rdi)
        vmovdqu	%ymm5, 416(%rdi)
        vmovdqu	%ymm6, 448(%rdi)
        vmovdqu	%ymm7, 480(%rdi)
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vmovdqu	576(%rdi), %ymm2
        vmovdqu	608(%rdi), %ymm3
        vmovdqu	640(%rdi), %ymm4
        vmovdqu	672(%rdi), %ymm5
        vmovdqu	704(%rdi), %ymm6
        vmovdqu	736(%rdi), %ymm7
        vpaddd	%ymm11, %ymm0, %ymm8
        vpaddd	%ymm11, %ymm1, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm0, %ymm0
        vpsubd	%ymm9, %ymm1, %ymm1
        vpaddd	%ymm11, %ymm2, %ymm8
        vpaddd	%ymm11, %ymm3, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm2, %ymm2
        vpsubd	%ymm9, %ymm3, %ymm3
        vpaddd	%ymm11, %ymm4, %ymm8
        vpaddd	%ymm11, %ymm5, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm4, %ymm4
        vpsubd	%ymm9, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm6, %ymm8
        vpaddd	%ymm11, %ymm7, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm6, %ymm6
        vpsubd	%ymm9, %ymm7, %ymm7
        vmovdqu	%ymm0, 512(%rdi)
        vmovdqu	%ymm1, 544(%rdi)
        vmovdqu	%ymm2, 576(%rdi)
        vmovdqu	%ymm3, 608(%rdi)
        vmovdqu	%ymm4, 640(%rdi)
        vmovdqu	%ymm5, 672(%rdi)
        vmovdqu	%ymm6, 704(%rdi)
        vmovdqu	%ymm7, 736(%rdi)
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vmovdqu	832(%rdi), %ymm2
        vmovdqu	864(%rdi), %ymm3
        vmovdqu	896(%rdi), %ymm4
        vmovdqu	928(%rdi), %ymm5
        vmovdqu	960(%rdi), %ymm6
        vmovdqu	992(%rdi), %ymm7
        vpaddd	%ymm11, %ymm0, %ymm8
        vpaddd	%ymm11, %ymm1, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm0, %ymm0
        vpsubd	%ymm9, %ymm1, %ymm1
        vpaddd	%ymm11, %ymm2, %ymm8
        vpaddd	%ymm11, %ymm3, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm2, %ymm2
        vpsubd	%ymm9, %ymm3, %ymm3
        vpaddd	%ymm11, %ymm4, %ymm8
        vpaddd	%ymm11, %ymm5, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm4, %ymm4
        vpsubd	%ymm9, %ymm5, %ymm5
        vpaddd	%ymm11, %ymm6, %ymm8
        vpaddd	%ymm11, %ymm7, %ymm9
        vpsrad	$23, %ymm8, %ymm8
        vpsrad	$23, %ymm9, %ymm9
        vpmulld	%ymm10, %ymm8, %ymm8
        vpmulld	%ymm10, %ymm9, %ymm9
        vpsubd	%ymm8, %ymm6, %ymm6
        vpsubd	%ymm9, %ymm7, %ymm7
        vmovdqu	%ymm0, 768(%rdi)
        vmovdqu	%ymm1, 800(%rdi)
        vmovdqu	%ymm2, 832(%rdi)
        vmovdqu	%ymm3, 864(%rdi)
        vmovdqu	%ymm4, 896(%rdi)
        vmovdqu	%ymm5, 928(%rdi)
        vmovdqu	%ymm6, 960(%rdi)
        vmovdqu	%ymm7, 992(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_poly_red_avx2,.-wc_mldsa_poly_red_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	wc_mldsa_ntt_avx2
.type	wc_mldsa_ntt_avx2,@function
.align	16
wc_mldsa_ntt_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_ntt_avx2
.p2align	4
_wc_mldsa_ntt_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm14, %ymm14, %ymm14
        vmovdqu	mldsa_q(%rip), %ymm14
        # ntt
        leaq	L_mldsa_avx2_zetas(%rip), %rdx
        vmovdqu	64(%rdx), %ymm11
        vmovdqu	96(%rdx), %ymm13
        # 128: 4/4
        vmovdqu	(%rdx), %ymm10
        vmovdqu	32(%rdx), %ymm12
        vmovdqu	96(%rdi), %ymm0
        vmovdqu	224(%rdi), %ymm1
        vmovdqu	352(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vmovdqu	608(%rdi), %ymm4
        vmovdqu	736(%rdi), %ymm5
        vmovdqu	864(%rdi), %ymm6
        vmovdqu	992(%rdi), %ymm7
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 64: 4/4
        vmovdqu	128(%rdx), %ymm10
        vmovdqu	160(%rdx), %ymm12
        vpmulld	%ymm13, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, 224(%rdi)
        vmovdqu	%ymm2, 352(%rdi)
        vmovdqu	%ymm3, 480(%rdi)
        vmovdqu	%ymm4, 608(%rdi)
        vmovdqu	%ymm5, 736(%rdi)
        vmovdqu	%ymm6, 864(%rdi)
        vmovdqu	%ymm7, 992(%rdi)
        # 128: 3/4
        vmovdqu	(%rdx), %ymm10
        vmovdqu	32(%rdx), %ymm12
        vmovdqu	64(%rdi), %ymm0
        vmovdqu	192(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	448(%rdi), %ymm3
        vmovdqu	576(%rdi), %ymm4
        vmovdqu	704(%rdi), %ymm5
        vmovdqu	832(%rdi), %ymm6
        vmovdqu	960(%rdi), %ymm7
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 64: 3/4
        vmovdqu	128(%rdx), %ymm10
        vmovdqu	160(%rdx), %ymm12
        vpmulld	%ymm13, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, 192(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 448(%rdi)
        vmovdqu	%ymm4, 576(%rdi)
        vmovdqu	%ymm5, 704(%rdi)
        vmovdqu	%ymm6, 832(%rdi)
        vmovdqu	%ymm7, 960(%rdi)
        # 128: 2/4
        vmovdqu	(%rdx), %ymm10
        vmovdqu	32(%rdx), %ymm12
        vmovdqu	32(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vmovdqu	288(%rdi), %ymm2
        vmovdqu	416(%rdi), %ymm3
        vmovdqu	544(%rdi), %ymm4
        vmovdqu	672(%rdi), %ymm5
        vmovdqu	800(%rdi), %ymm6
        vmovdqu	928(%rdi), %ymm7
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 64: 2/4
        vmovdqu	128(%rdx), %ymm10
        vmovdqu	160(%rdx), %ymm12
        vpmulld	%ymm13, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, 160(%rdi)
        vmovdqu	%ymm2, 288(%rdi)
        vmovdqu	%ymm3, 416(%rdi)
        vmovdqu	%ymm4, 544(%rdi)
        vmovdqu	%ymm5, 672(%rdi)
        vmovdqu	%ymm6, 800(%rdi)
        vmovdqu	%ymm7, 928(%rdi)
        # 128: 1/4
        vmovdqu	(%rdx), %ymm10
        vmovdqu	32(%rdx), %ymm12
        vmovdqu	(%rdi), %ymm0
        vmovdqu	128(%rdi), %ymm1
        vmovdqu	256(%rdi), %ymm2
        vmovdqu	384(%rdi), %ymm3
        vmovdqu	512(%rdi), %ymm4
        vmovdqu	640(%rdi), %ymm5
        vmovdqu	768(%rdi), %ymm6
        vmovdqu	896(%rdi), %ymm7
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 64: 1/4
        vmovdqu	128(%rdx), %ymm10
        vmovdqu	160(%rdx), %ymm12
        vpmulld	%ymm13, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        vmovdqu	%ymm2, 256(%rdi)
        vmovdqu	%ymm3, 384(%rdi)
        vmovdqu	%ymm4, 512(%rdi)
        vmovdqu	%ymm5, 640(%rdi)
        vmovdqu	%ymm6, 768(%rdi)
        vmovdqu	%ymm7, 896(%rdi)
        vmovdqu	%ymm1, %ymm4
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        # 32: 1/4
        vmovdqu	192(%rdx), %ymm10
        vmovdqu	224(%rdx), %ymm12
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 16: 1/4
        vmovdqu	256(%rdx), %ymm10
        vmovdqu	288(%rdx), %ymm12
        vmovdqu	320(%rdx), %ymm11
        vmovdqu	352(%rdx), %ymm13
        vpmulld	%ymm12, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm10, %ymm2, %ymm2
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm10, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm13, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        # 8: 1/4
        vmovdqu	384(%rdx), %ymm10
        vmovdqu	416(%rdx), %ymm12
        vmovdqu	448(%rdx), %ymm11
        vmovdqu	480(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        vmovdqu	512(%rdx), %ymm10
        vmovdqu	544(%rdx), %ymm12
        vmovdqu	576(%rdx), %ymm11
        vmovdqu	608(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 4: 1/4
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	640(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	672(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	704(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	736(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm0
        vmovshdup	%ymm1, %ymm2
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm1, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm8, %ymm1
        vpaddd	%ymm0, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm0
        vmovshdup	%ymm3, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm3, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm9, %ymm3
        vpaddd	%ymm0, %ymm9, %ymm9
        # 2: 1/4
        vmovdqu	768(%rdx), %ymm10
        vmovdqu	800(%rdx), %ymm12
        vmovdqu	832(%rdx), %ymm11
        vmovdqu	864(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 4: 1/4
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	896(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	928(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	960(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	992(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm4
        vmovshdup	%ymm5, %ymm6
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm5, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm8, %ymm5
        vpaddd	%ymm4, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm4
        vmovshdup	%ymm7, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm7, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm9, %ymm7
        vpaddd	%ymm4, %ymm9, %ymm9
        # 2: 1/4
        vmovdqu	1024(%rdx), %ymm10
        vmovdqu	1056(%rdx), %ymm12
        vmovdqu	1088(%rdx), %ymm11
        vmovdqu	1120(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 1: 1/4
        vmovdqu	1152(%rdx), %ymm10
        vmovdqu	1184(%rdx), %ymm12
        vmovdqu	1216(%rdx), %ymm11
        vmovdqu	1248(%rdx), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 1: 1/4
        vmovdqu	1280(%rdx), %ymm10
        vmovdqu	1312(%rdx), %ymm12
        vmovdqu	1344(%rdx), %ymm11
        vmovdqu	1376(%rdx), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, 128(%rdi)
        vmovdqu	%ymm5, 160(%rdi)
        vmovdqu	%ymm6, 192(%rdi)
        vmovdqu	%ymm7, 224(%rdi)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vmovdqu	448(%rdi), %ymm6
        vmovdqu	480(%rdi), %ymm7
        # 32: 2/4
        vmovdqu	1408(%rdx), %ymm10
        vmovdqu	1440(%rdx), %ymm12
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 16: 2/4
        vmovdqu	1472(%rdx), %ymm10
        vmovdqu	1504(%rdx), %ymm12
        vmovdqu	1536(%rdx), %ymm11
        vmovdqu	1568(%rdx), %ymm13
        vpmulld	%ymm12, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm10, %ymm2, %ymm2
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm10, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm13, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        # 8: 2/4
        vmovdqu	1600(%rdx), %ymm10
        vmovdqu	1632(%rdx), %ymm12
        vmovdqu	1664(%rdx), %ymm11
        vmovdqu	1696(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        vmovdqu	1728(%rdx), %ymm10
        vmovdqu	1760(%rdx), %ymm12
        vmovdqu	1792(%rdx), %ymm11
        vmovdqu	1824(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 4: 2/4
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	1856(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	1888(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	1920(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	1952(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm0
        vmovshdup	%ymm1, %ymm2
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm1, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm8, %ymm1
        vpaddd	%ymm0, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm0
        vmovshdup	%ymm3, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm3, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm9, %ymm3
        vpaddd	%ymm0, %ymm9, %ymm9
        # 2: 2/4
        vmovdqu	1984(%rdx), %ymm10
        vmovdqu	2016(%rdx), %ymm12
        vmovdqu	2048(%rdx), %ymm11
        vmovdqu	2080(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 4: 2/4
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	2112(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	2144(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	2176(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	2208(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm4
        vmovshdup	%ymm5, %ymm6
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm5, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm8, %ymm5
        vpaddd	%ymm4, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm4
        vmovshdup	%ymm7, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm7, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm9, %ymm7
        vpaddd	%ymm4, %ymm9, %ymm9
        # 2: 2/4
        vmovdqu	2240(%rdx), %ymm10
        vmovdqu	2272(%rdx), %ymm12
        vmovdqu	2304(%rdx), %ymm11
        vmovdqu	2336(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 1: 2/4
        vmovdqu	2368(%rdx), %ymm10
        vmovdqu	2400(%rdx), %ymm12
        vmovdqu	2432(%rdx), %ymm11
        vmovdqu	2464(%rdx), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 1: 2/4
        vmovdqu	2496(%rdx), %ymm10
        vmovdqu	2528(%rdx), %ymm12
        vmovdqu	2560(%rdx), %ymm11
        vmovdqu	2592(%rdx), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        vmovdqu	%ymm0, 256(%rdi)
        vmovdqu	%ymm1, 288(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 352(%rdi)
        vmovdqu	%ymm4, 384(%rdi)
        vmovdqu	%ymm5, 416(%rdi)
        vmovdqu	%ymm6, 448(%rdi)
        vmovdqu	%ymm7, 480(%rdi)
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vmovdqu	576(%rdi), %ymm2
        vmovdqu	608(%rdi), %ymm3
        vmovdqu	640(%rdi), %ymm4
        vmovdqu	672(%rdi), %ymm5
        vmovdqu	704(%rdi), %ymm6
        vmovdqu	736(%rdi), %ymm7
        # 32: 3/4
        vmovdqu	2624(%rdx), %ymm10
        vmovdqu	2656(%rdx), %ymm12
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 16: 3/4
        vmovdqu	2688(%rdx), %ymm10
        vmovdqu	2720(%rdx), %ymm12
        vmovdqu	2752(%rdx), %ymm11
        vmovdqu	2784(%rdx), %ymm13
        vpmulld	%ymm12, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm10, %ymm2, %ymm2
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm10, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm13, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        # 8: 3/4
        vmovdqu	2816(%rdx), %ymm10
        vmovdqu	2848(%rdx), %ymm12
        vmovdqu	2880(%rdx), %ymm11
        vmovdqu	2912(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        vmovdqu	2944(%rdx), %ymm10
        vmovdqu	2976(%rdx), %ymm12
        vmovdqu	3008(%rdx), %ymm11
        vmovdqu	3040(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 4: 3/4
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	3072(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	3104(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	3136(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	3168(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm0
        vmovshdup	%ymm1, %ymm2
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm1, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm8, %ymm1
        vpaddd	%ymm0, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm0
        vmovshdup	%ymm3, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm3, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm9, %ymm3
        vpaddd	%ymm0, %ymm9, %ymm9
        # 2: 3/4
        vmovdqu	3200(%rdx), %ymm10
        vmovdqu	3232(%rdx), %ymm12
        vmovdqu	3264(%rdx), %ymm11
        vmovdqu	3296(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 4: 3/4
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	3328(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	3360(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	3392(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	3424(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm4
        vmovshdup	%ymm5, %ymm6
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm5, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm8, %ymm5
        vpaddd	%ymm4, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm4
        vmovshdup	%ymm7, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm7, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm9, %ymm7
        vpaddd	%ymm4, %ymm9, %ymm9
        # 2: 3/4
        vmovdqu	3456(%rdx), %ymm10
        vmovdqu	3488(%rdx), %ymm12
        vmovdqu	3520(%rdx), %ymm11
        vmovdqu	3552(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 1: 3/4
        vmovdqu	3584(%rdx), %ymm10
        vmovdqu	3616(%rdx), %ymm12
        vmovdqu	3648(%rdx), %ymm11
        vmovdqu	3680(%rdx), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 1: 3/4
        vmovdqu	3712(%rdx), %ymm10
        vmovdqu	3744(%rdx), %ymm12
        vmovdqu	3776(%rdx), %ymm11
        vmovdqu	3808(%rdx), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        vmovdqu	%ymm0, 512(%rdi)
        vmovdqu	%ymm1, 544(%rdi)
        vmovdqu	%ymm2, 576(%rdi)
        vmovdqu	%ymm3, 608(%rdi)
        vmovdqu	%ymm4, 640(%rdi)
        vmovdqu	%ymm5, 672(%rdi)
        vmovdqu	%ymm6, 704(%rdi)
        vmovdqu	%ymm7, 736(%rdi)
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vmovdqu	832(%rdi), %ymm2
        vmovdqu	864(%rdi), %ymm3
        vmovdqu	896(%rdi), %ymm4
        vmovdqu	928(%rdi), %ymm5
        vmovdqu	960(%rdi), %ymm6
        vmovdqu	992(%rdi), %ymm7
        # 32: 4/4
        vmovdqu	3840(%rdx), %ymm10
        vmovdqu	3872(%rdx), %ymm12
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 16: 4/4
        vmovdqu	3904(%rdx), %ymm10
        vmovdqu	3936(%rdx), %ymm12
        vmovdqu	3968(%rdx), %ymm11
        vmovdqu	4000(%rdx), %ymm13
        vpmulld	%ymm12, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm10, %ymm2, %ymm2
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm10, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm13, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        # 8: 4/4
        vmovdqu	4032(%rdx), %ymm10
        vmovdqu	4064(%rdx), %ymm12
        vmovdqu	4096(%rdx), %ymm11
        vmovdqu	4128(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        vmovdqu	4160(%rdx), %ymm10
        vmovdqu	4192(%rdx), %ymm12
        vmovdqu	4224(%rdx), %ymm11
        vmovdqu	4256(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 4: 4/4
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	4288(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	4320(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	4352(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	4384(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm0
        vmovshdup	%ymm1, %ymm2
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm1, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm8, %ymm1
        vpaddd	%ymm0, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm0
        vmovshdup	%ymm3, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm3, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm9, %ymm3
        vpaddd	%ymm0, %ymm9, %ymm9
        # 2: 4/4
        vmovdqu	4416(%rdx), %ymm10
        vmovdqu	4448(%rdx), %ymm12
        vmovdqu	4480(%rdx), %ymm11
        vmovdqu	4512(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 4: 4/4
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	4544(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	4576(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	4608(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	4640(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm4
        vmovshdup	%ymm5, %ymm6
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm5, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm8, %ymm5
        vpaddd	%ymm4, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm4
        vmovshdup	%ymm7, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm7, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm9, %ymm7
        vpaddd	%ymm4, %ymm9, %ymm9
        # 2: 4/4
        vmovdqu	4672(%rdx), %ymm10
        vmovdqu	4704(%rdx), %ymm12
        vmovdqu	4736(%rdx), %ymm11
        vmovdqu	4768(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 1: 4/4
        vmovdqu	4800(%rdx), %ymm10
        vmovdqu	4832(%rdx), %ymm12
        vmovdqu	4864(%rdx), %ymm11
        vmovdqu	4896(%rdx), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 1: 4/4
        vmovdqu	4928(%rdx), %ymm10
        vmovdqu	4960(%rdx), %ymm12
        vmovdqu	4992(%rdx), %ymm11
        vmovdqu	5024(%rdx), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        vmovdqu	%ymm0, 768(%rdi)
        vmovdqu	%ymm1, 800(%rdi)
        vmovdqu	%ymm2, 832(%rdi)
        vmovdqu	%ymm3, 864(%rdi)
        vmovdqu	%ymm4, 896(%rdi)
        vmovdqu	%ymm5, 928(%rdi)
        vmovdqu	%ymm6, 960(%rdi)
        vmovdqu	%ymm7, 992(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_ntt_avx2,.-wc_mldsa_ntt_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	wc_mldsa_ntt_full_avx2
.type	wc_mldsa_ntt_full_avx2,@function
.align	16
wc_mldsa_ntt_full_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_ntt_full_avx2
.p2align	4
_wc_mldsa_ntt_full_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm14, %ymm14, %ymm14
        vmovdqu	mldsa_q(%rip), %ymm14
        # ntt
        leaq	L_mldsa_avx2_zetas(%rip), %rdx
        vmovdqu	64(%rdx), %ymm11
        vmovdqu	96(%rdx), %ymm13
        # 128: 4/4
        vmovdqu	(%rdx), %ymm10
        vmovdqu	32(%rdx), %ymm12
        vmovdqu	96(%rdi), %ymm0
        vmovdqu	224(%rdi), %ymm1
        vmovdqu	352(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vmovdqu	608(%rdi), %ymm4
        vmovdqu	736(%rdi), %ymm5
        vmovdqu	864(%rdi), %ymm6
        vmovdqu	992(%rdi), %ymm7
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 64: 4/4
        vmovdqu	128(%rdx), %ymm10
        vmovdqu	160(%rdx), %ymm12
        vpmulld	%ymm13, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, 224(%rdi)
        vmovdqu	%ymm2, 352(%rdi)
        vmovdqu	%ymm3, 480(%rdi)
        vmovdqu	%ymm4, 608(%rdi)
        vmovdqu	%ymm5, 736(%rdi)
        vmovdqu	%ymm6, 864(%rdi)
        vmovdqu	%ymm7, 992(%rdi)
        # 128: 3/4
        vmovdqu	(%rdx), %ymm10
        vmovdqu	32(%rdx), %ymm12
        vmovdqu	64(%rdi), %ymm0
        vmovdqu	192(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	448(%rdi), %ymm3
        vmovdqu	576(%rdi), %ymm4
        vmovdqu	704(%rdi), %ymm5
        vmovdqu	832(%rdi), %ymm6
        vmovdqu	960(%rdi), %ymm7
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 64: 3/4
        vmovdqu	128(%rdx), %ymm10
        vmovdqu	160(%rdx), %ymm12
        vpmulld	%ymm13, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, 192(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 448(%rdi)
        vmovdqu	%ymm4, 576(%rdi)
        vmovdqu	%ymm5, 704(%rdi)
        vmovdqu	%ymm6, 832(%rdi)
        vmovdqu	%ymm7, 960(%rdi)
        # 128: 2/4
        vmovdqu	(%rdx), %ymm10
        vmovdqu	32(%rdx), %ymm12
        vmovdqu	32(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vmovdqu	288(%rdi), %ymm2
        vmovdqu	416(%rdi), %ymm3
        vmovdqu	544(%rdi), %ymm4
        vmovdqu	672(%rdi), %ymm5
        vmovdqu	800(%rdi), %ymm6
        vmovdqu	928(%rdi), %ymm7
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 64: 2/4
        vmovdqu	128(%rdx), %ymm10
        vmovdqu	160(%rdx), %ymm12
        vpmulld	%ymm13, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, 160(%rdi)
        vmovdqu	%ymm2, 288(%rdi)
        vmovdqu	%ymm3, 416(%rdi)
        vmovdqu	%ymm4, 544(%rdi)
        vmovdqu	%ymm5, 672(%rdi)
        vmovdqu	%ymm6, 800(%rdi)
        vmovdqu	%ymm7, 928(%rdi)
        # 128: 1/4
        vmovdqu	(%rdx), %ymm10
        vmovdqu	32(%rdx), %ymm12
        vmovdqu	(%rdi), %ymm0
        vmovdqu	128(%rdi), %ymm1
        vmovdqu	256(%rdi), %ymm2
        vmovdqu	384(%rdi), %ymm3
        vmovdqu	512(%rdi), %ymm4
        vmovdqu	640(%rdi), %ymm5
        vmovdqu	768(%rdi), %ymm6
        vmovdqu	896(%rdi), %ymm7
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 64: 1/4
        vmovdqu	128(%rdx), %ymm10
        vmovdqu	160(%rdx), %ymm12
        vpmulld	%ymm13, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        vmovdqu	%ymm2, 256(%rdi)
        vmovdqu	%ymm3, 384(%rdi)
        vmovdqu	%ymm4, 512(%rdi)
        vmovdqu	%ymm5, 640(%rdi)
        vmovdqu	%ymm6, 768(%rdi)
        vmovdqu	%ymm7, 896(%rdi)
        vmovdqu	%ymm1, %ymm4
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        # 32: 1/4
        vmovdqu	192(%rdx), %ymm10
        vmovdqu	224(%rdx), %ymm12
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 16: 1/4
        vmovdqu	256(%rdx), %ymm10
        vmovdqu	288(%rdx), %ymm12
        vmovdqu	320(%rdx), %ymm11
        vmovdqu	352(%rdx), %ymm13
        vpmulld	%ymm12, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm10, %ymm2, %ymm2
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm10, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm13, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        # 8: 1/4
        vmovdqu	384(%rdx), %ymm10
        vmovdqu	416(%rdx), %ymm12
        vmovdqu	448(%rdx), %ymm11
        vmovdqu	480(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        vmovdqu	512(%rdx), %ymm10
        vmovdqu	544(%rdx), %ymm12
        vmovdqu	576(%rdx), %ymm11
        vmovdqu	608(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 4: 1/4
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	640(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	672(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	704(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	736(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm0
        vmovshdup	%ymm1, %ymm2
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm1, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm8, %ymm1
        vpaddd	%ymm0, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm0
        vmovshdup	%ymm3, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm3, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm9, %ymm3
        vpaddd	%ymm0, %ymm9, %ymm9
        # 2: 1/4
        vmovdqu	768(%rdx), %ymm10
        vmovdqu	800(%rdx), %ymm12
        vmovdqu	832(%rdx), %ymm11
        vmovdqu	864(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 4: 1/4
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	896(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	928(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	960(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	992(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm4
        vmovshdup	%ymm5, %ymm6
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm5, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm8, %ymm5
        vpaddd	%ymm4, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm4
        vmovshdup	%ymm7, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm7, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm9, %ymm7
        vpaddd	%ymm4, %ymm9, %ymm9
        # 2: 1/4
        vmovdqu	1024(%rdx), %ymm10
        vmovdqu	1056(%rdx), %ymm12
        vmovdqu	1088(%rdx), %ymm11
        vmovdqu	1120(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 1: 1/4
        vmovdqu	1152(%rdx), %ymm10
        vmovdqu	1184(%rdx), %ymm12
        vmovdqu	1216(%rdx), %ymm11
        vmovdqu	1248(%rdx), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 1: 1/4
        vmovdqu	1280(%rdx), %ymm10
        vmovdqu	1312(%rdx), %ymm12
        vmovdqu	1344(%rdx), %ymm11
        vmovdqu	1376(%rdx), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm0
        vperm2i128	$49, %ymm9, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm2
        vperm2i128	$49, %ymm9, %ymm8, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm4
        vperm2i128	$49, %ymm9, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm6
        vperm2i128	$49, %ymm9, %ymm8, %ymm7
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, 128(%rdi)
        vmovdqu	%ymm5, 160(%rdi)
        vmovdqu	%ymm6, 192(%rdi)
        vmovdqu	%ymm7, 224(%rdi)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vmovdqu	448(%rdi), %ymm6
        vmovdqu	480(%rdi), %ymm7
        # 32: 2/4
        vmovdqu	1408(%rdx), %ymm10
        vmovdqu	1440(%rdx), %ymm12
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 16: 2/4
        vmovdqu	1472(%rdx), %ymm10
        vmovdqu	1504(%rdx), %ymm12
        vmovdqu	1536(%rdx), %ymm11
        vmovdqu	1568(%rdx), %ymm13
        vpmulld	%ymm12, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm10, %ymm2, %ymm2
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm10, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm13, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        # 8: 2/4
        vmovdqu	1600(%rdx), %ymm10
        vmovdqu	1632(%rdx), %ymm12
        vmovdqu	1664(%rdx), %ymm11
        vmovdqu	1696(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        vmovdqu	1728(%rdx), %ymm10
        vmovdqu	1760(%rdx), %ymm12
        vmovdqu	1792(%rdx), %ymm11
        vmovdqu	1824(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 4: 2/4
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	1856(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	1888(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	1920(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	1952(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm0
        vmovshdup	%ymm1, %ymm2
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm1, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm8, %ymm1
        vpaddd	%ymm0, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm0
        vmovshdup	%ymm3, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm3, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm9, %ymm3
        vpaddd	%ymm0, %ymm9, %ymm9
        # 2: 2/4
        vmovdqu	1984(%rdx), %ymm10
        vmovdqu	2016(%rdx), %ymm12
        vmovdqu	2048(%rdx), %ymm11
        vmovdqu	2080(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 4: 2/4
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	2112(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	2144(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	2176(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	2208(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm4
        vmovshdup	%ymm5, %ymm6
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm5, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm8, %ymm5
        vpaddd	%ymm4, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm4
        vmovshdup	%ymm7, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm7, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm9, %ymm7
        vpaddd	%ymm4, %ymm9, %ymm9
        # 2: 2/4
        vmovdqu	2240(%rdx), %ymm10
        vmovdqu	2272(%rdx), %ymm12
        vmovdqu	2304(%rdx), %ymm11
        vmovdqu	2336(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 1: 2/4
        vmovdqu	2368(%rdx), %ymm10
        vmovdqu	2400(%rdx), %ymm12
        vmovdqu	2432(%rdx), %ymm11
        vmovdqu	2464(%rdx), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 1: 2/4
        vmovdqu	2496(%rdx), %ymm10
        vmovdqu	2528(%rdx), %ymm12
        vmovdqu	2560(%rdx), %ymm11
        vmovdqu	2592(%rdx), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm0
        vperm2i128	$49, %ymm9, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm2
        vperm2i128	$49, %ymm9, %ymm8, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm4
        vperm2i128	$49, %ymm9, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm6
        vperm2i128	$49, %ymm9, %ymm8, %ymm7
        vmovdqu	%ymm0, 256(%rdi)
        vmovdqu	%ymm1, 288(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 352(%rdi)
        vmovdqu	%ymm4, 384(%rdi)
        vmovdqu	%ymm5, 416(%rdi)
        vmovdqu	%ymm6, 448(%rdi)
        vmovdqu	%ymm7, 480(%rdi)
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vmovdqu	576(%rdi), %ymm2
        vmovdqu	608(%rdi), %ymm3
        vmovdqu	640(%rdi), %ymm4
        vmovdqu	672(%rdi), %ymm5
        vmovdqu	704(%rdi), %ymm6
        vmovdqu	736(%rdi), %ymm7
        # 32: 3/4
        vmovdqu	2624(%rdx), %ymm10
        vmovdqu	2656(%rdx), %ymm12
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 16: 3/4
        vmovdqu	2688(%rdx), %ymm10
        vmovdqu	2720(%rdx), %ymm12
        vmovdqu	2752(%rdx), %ymm11
        vmovdqu	2784(%rdx), %ymm13
        vpmulld	%ymm12, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm10, %ymm2, %ymm2
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm10, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm13, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        # 8: 3/4
        vmovdqu	2816(%rdx), %ymm10
        vmovdqu	2848(%rdx), %ymm12
        vmovdqu	2880(%rdx), %ymm11
        vmovdqu	2912(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        vmovdqu	2944(%rdx), %ymm10
        vmovdqu	2976(%rdx), %ymm12
        vmovdqu	3008(%rdx), %ymm11
        vmovdqu	3040(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 4: 3/4
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	3072(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	3104(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	3136(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	3168(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm0
        vmovshdup	%ymm1, %ymm2
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm1, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm8, %ymm1
        vpaddd	%ymm0, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm0
        vmovshdup	%ymm3, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm3, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm9, %ymm3
        vpaddd	%ymm0, %ymm9, %ymm9
        # 2: 3/4
        vmovdqu	3200(%rdx), %ymm10
        vmovdqu	3232(%rdx), %ymm12
        vmovdqu	3264(%rdx), %ymm11
        vmovdqu	3296(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 4: 3/4
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	3328(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	3360(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	3392(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	3424(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm4
        vmovshdup	%ymm5, %ymm6
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm5, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm8, %ymm5
        vpaddd	%ymm4, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm4
        vmovshdup	%ymm7, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm7, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm9, %ymm7
        vpaddd	%ymm4, %ymm9, %ymm9
        # 2: 3/4
        vmovdqu	3456(%rdx), %ymm10
        vmovdqu	3488(%rdx), %ymm12
        vmovdqu	3520(%rdx), %ymm11
        vmovdqu	3552(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 1: 3/4
        vmovdqu	3584(%rdx), %ymm10
        vmovdqu	3616(%rdx), %ymm12
        vmovdqu	3648(%rdx), %ymm11
        vmovdqu	3680(%rdx), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 1: 3/4
        vmovdqu	3712(%rdx), %ymm10
        vmovdqu	3744(%rdx), %ymm12
        vmovdqu	3776(%rdx), %ymm11
        vmovdqu	3808(%rdx), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm0
        vperm2i128	$49, %ymm9, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm2
        vperm2i128	$49, %ymm9, %ymm8, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm4
        vperm2i128	$49, %ymm9, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm6
        vperm2i128	$49, %ymm9, %ymm8, %ymm7
        vmovdqu	%ymm0, 512(%rdi)
        vmovdqu	%ymm1, 544(%rdi)
        vmovdqu	%ymm2, 576(%rdi)
        vmovdqu	%ymm3, 608(%rdi)
        vmovdqu	%ymm4, 640(%rdi)
        vmovdqu	%ymm5, 672(%rdi)
        vmovdqu	%ymm6, 704(%rdi)
        vmovdqu	%ymm7, 736(%rdi)
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vmovdqu	832(%rdi), %ymm2
        vmovdqu	864(%rdi), %ymm3
        vmovdqu	896(%rdi), %ymm4
        vmovdqu	928(%rdi), %ymm5
        vmovdqu	960(%rdi), %ymm6
        vmovdqu	992(%rdi), %ymm7
        # 32: 4/4
        vmovdqu	3840(%rdx), %ymm10
        vmovdqu	3872(%rdx), %ymm12
        vpmulld	%ymm12, %ymm4, %ymm8
        vmovshdup	%ymm4, %ymm9
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm4
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm5
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm10, %ymm6, %ymm6
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm6
        vpaddd	%ymm8, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm10, %ymm7, %ymm7
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm3, %ymm7
        vpaddd	%ymm8, %ymm3, %ymm3
        # 16: 4/4
        vmovdqu	3904(%rdx), %ymm10
        vmovdqu	3936(%rdx), %ymm12
        vmovdqu	3968(%rdx), %ymm11
        vmovdqu	4000(%rdx), %ymm13
        vpmulld	%ymm12, %ymm2, %ymm8
        vmovshdup	%ymm2, %ymm9
        vpmuldq	%ymm10, %ymm2, %ymm2
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm2
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm10, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm1, %ymm3
        vpaddd	%ymm8, %ymm1, %ymm1
        vpmulld	%ymm13, %ymm6, %ymm8
        vmovshdup	%ymm6, %ymm9
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm6
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm5, %ymm7
        vpaddd	%ymm8, %ymm5, %ymm5
        # 8: 4/4
        vmovdqu	4032(%rdx), %ymm10
        vmovdqu	4064(%rdx), %ymm12
        vmovdqu	4096(%rdx), %ymm11
        vmovdqu	4128(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        vmovdqu	4160(%rdx), %ymm10
        vmovdqu	4192(%rdx), %ymm12
        vmovdqu	4224(%rdx), %ymm11
        vmovdqu	4256(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 4: 4/4
        vperm2i128	$32, %ymm1, %ymm0, %ymm8
        vmovdqu	4288(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm0, %ymm1
        vmovdqu	4320(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm2, %ymm9
        vmovdqu	4352(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm2, %ymm3
        vmovdqu	4384(%rdx), %ymm13
        vpmulld	%ymm12, %ymm1, %ymm0
        vmovshdup	%ymm1, %ymm2
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm1, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm8, %ymm1
        vpaddd	%ymm0, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm0
        vmovshdup	%ymm3, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm0, %ymm15
        vpmuldq	%ymm14, %ymm0, %ymm0
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm0, %ymm3, %ymm0
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm0, %ymm0
        vpblendd	$0xaa, %ymm15, %ymm0, %ymm0
        vpsubd	%ymm0, %ymm9, %ymm3
        vpaddd	%ymm0, %ymm9, %ymm9
        # 2: 4/4
        vmovdqu	4416(%rdx), %ymm10
        vmovdqu	4448(%rdx), %ymm12
        vmovdqu	4480(%rdx), %ymm11
        vmovdqu	4512(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm8, %ymm0
        vpunpckhqdq	%ymm1, %ymm8, %ymm1
        vpunpcklqdq	%ymm3, %ymm9, %ymm2
        vpunpckhqdq	%ymm3, %ymm9, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 4: 4/4
        vperm2i128	$32, %ymm5, %ymm4, %ymm8
        vmovdqu	4544(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm4, %ymm5
        vmovdqu	4576(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm6, %ymm9
        vmovdqu	4608(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm6, %ymm7
        vmovdqu	4640(%rdx), %ymm13
        vpmulld	%ymm12, %ymm5, %ymm4
        vmovshdup	%ymm5, %ymm6
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm5, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm8, %ymm5
        vpaddd	%ymm4, %ymm8, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm4
        vmovshdup	%ymm7, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm7, %ymm4
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm9, %ymm7
        vpaddd	%ymm4, %ymm9, %ymm9
        # 2: 4/4
        vmovdqu	4672(%rdx), %ymm10
        vmovdqu	4704(%rdx), %ymm12
        vmovdqu	4736(%rdx), %ymm11
        vmovdqu	4768(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm8, %ymm4
        vpunpckhqdq	%ymm5, %ymm8, %ymm5
        vpunpcklqdq	%ymm7, %ymm9, %ymm6
        vpunpckhqdq	%ymm7, %ymm9, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        # 1: 4/4
        vmovdqu	4800(%rdx), %ymm10
        vmovdqu	4832(%rdx), %ymm12
        vmovdqu	4864(%rdx), %ymm11
        vmovdqu	4896(%rdx), %ymm13
        vpsllq	$32, %ymm1, %ymm8
        vpsrlq	$32, %ymm0, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm0, %ymm0
        vpblendd	$0x55, %ymm9, %ymm1, %ymm1
        vpsllq	$32, %ymm3, %ymm8
        vpsrlq	$32, %ymm2, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm2, %ymm2
        vpblendd	$0x55, %ymm9, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm1, %ymm8
        vmovshdup	%ymm1, %ymm9
        vpmuldq	%ymm10, %ymm1, %ymm1
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm1, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm0, %ymm1
        vpaddd	%ymm8, %ymm0, %ymm0
        vpmulld	%ymm13, %ymm3, %ymm8
        vmovshdup	%ymm3, %ymm9
        vpmuldq	%ymm11, %ymm3, %ymm3
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm3, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm2, %ymm3
        vpaddd	%ymm8, %ymm2, %ymm2
        # 1: 4/4
        vmovdqu	4928(%rdx), %ymm10
        vmovdqu	4960(%rdx), %ymm12
        vmovdqu	4992(%rdx), %ymm11
        vmovdqu	5024(%rdx), %ymm13
        vpsllq	$32, %ymm5, %ymm8
        vpsrlq	$32, %ymm4, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm4, %ymm4
        vpblendd	$0x55, %ymm9, %ymm5, %ymm5
        vpsllq	$32, %ymm7, %ymm8
        vpsrlq	$32, %ymm6, %ymm9
        vpblendd	$0xaa, %ymm8, %ymm6, %ymm6
        vpblendd	$0x55, %ymm9, %ymm7, %ymm7
        vpmulld	%ymm12, %ymm5, %ymm8
        vmovshdup	%ymm5, %ymm9
        vpmuldq	%ymm10, %ymm5, %ymm5
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm5, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm4, %ymm5
        vpaddd	%ymm8, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm7, %ymm8
        vmovshdup	%ymm7, %ymm9
        vpmuldq	%ymm11, %ymm7, %ymm7
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm7, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm8, %ymm8
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm8
        vpsubd	%ymm8, %ymm6, %ymm7
        vpaddd	%ymm8, %ymm6, %ymm6
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm0
        vperm2i128	$49, %ymm9, %ymm8, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm2
        vperm2i128	$49, %ymm9, %ymm8, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm4
        vperm2i128	$49, %ymm9, %ymm8, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vperm2i128	$32, %ymm9, %ymm8, %ymm6
        vperm2i128	$49, %ymm9, %ymm8, %ymm7
        vmovdqu	%ymm0, 768(%rdi)
        vmovdqu	%ymm1, 800(%rdi)
        vmovdqu	%ymm2, 832(%rdi)
        vmovdqu	%ymm3, 864(%rdi)
        vmovdqu	%ymm4, 896(%rdi)
        vmovdqu	%ymm5, 928(%rdi)
        vmovdqu	%ymm6, 960(%rdi)
        vmovdqu	%ymm7, 992(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_ntt_full_avx2,.-wc_mldsa_ntt_full_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	wc_mldsa_invntt_avx2
.type	wc_mldsa_invntt_avx2,@function
.align	16
wc_mldsa_invntt_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_invntt_avx2
.p2align	4
_wc_mldsa_invntt_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm14, %ymm14, %ymm14
        vmovdqu	mldsa_q(%rip), %ymm14
        # invntt
        leaq	L_mldsa_avx2_zetas_inv(%rip), %rdx
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        # 1: 1/4
        vmovdqu	(%rdx), %ymm10
        vmovdqu	32(%rdx), %ymm12
        vmovdqu	64(%rdx), %ymm11
        vmovdqu	96(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 2: 1/4
        vmovdqu	128(%rdx), %ymm10
        vmovdqu	160(%rdx), %ymm12
        vmovdqu	192(%rdx), %ymm11
        vmovdqu	224(%rdx), %ymm13
        vpshufd	$0xd8, %ymm0, %ymm8
        vpshufd	$0xd8, %ymm1, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm0
        vpunpckhdq	%ymm9, %ymm8, %ymm1
        vpshufd	$0xd8, %ymm2, %ymm8
        vpshufd	$0xd8, %ymm3, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm2
        vpunpckhdq	%ymm9, %ymm8, %ymm3
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 4: 1/4
        vmovdqu	256(%rdx), %ymm10
        vmovdqu	288(%rdx), %ymm12
        vmovdqu	320(%rdx), %ymm11
        vmovdqu	352(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm1
        vpunpcklqdq	%ymm3, %ymm2, %ymm9
        vpunpckhqdq	%ymm3, %ymm2, %ymm3
        vpsubd	%ymm1, %ymm8, %ymm0
        vpaddd	%ymm1, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm0, %ymm1
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm10, %ymm0, %ymm0
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm0, %ymm1
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm9, %ymm0
        vpaddd	%ymm3, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm0, %ymm3
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm0, %ymm3
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 8: 1/4
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	384(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	416(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	448(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	480(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 16: 1/4
        vmovdqu	512(%rdx), %ymm10
        vmovdqu	544(%rdx), %ymm12
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 1: 1/4
        vmovdqu	576(%rdx), %ymm10
        vmovdqu	608(%rdx), %ymm12
        vmovdqu	640(%rdx), %ymm11
        vmovdqu	672(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 2: 1/4
        vmovdqu	704(%rdx), %ymm10
        vmovdqu	736(%rdx), %ymm12
        vmovdqu	768(%rdx), %ymm11
        vmovdqu	800(%rdx), %ymm13
        vpshufd	$0xd8, %ymm4, %ymm8
        vpshufd	$0xd8, %ymm5, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm4
        vpunpckhdq	%ymm9, %ymm8, %ymm5
        vpshufd	$0xd8, %ymm6, %ymm8
        vpshufd	$0xd8, %ymm7, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm6
        vpunpckhdq	%ymm9, %ymm8, %ymm7
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 4: 1/4
        vmovdqu	832(%rdx), %ymm10
        vmovdqu	864(%rdx), %ymm12
        vmovdqu	896(%rdx), %ymm11
        vmovdqu	928(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm5
        vpunpcklqdq	%ymm7, %ymm6, %ymm9
        vpunpckhqdq	%ymm7, %ymm6, %ymm7
        vpsubd	%ymm5, %ymm8, %ymm4
        vpaddd	%ymm5, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm4, %ymm5
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm4, %ymm5
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm9, %ymm4
        vpaddd	%ymm7, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm4, %ymm7
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm4, %ymm7
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 8: 1/4
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	960(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	992(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	1024(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	1056(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 16: 1/4
        vmovdqu	1088(%rdx), %ymm10
        vmovdqu	1120(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 32: 1/4
        vmovdqu	1152(%rdx), %ymm10
        vmovdqu	1184(%rdx), %ymm12
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, 128(%rdi)
        vmovdqu	%ymm5, 160(%rdi)
        vmovdqu	%ymm6, 192(%rdi)
        vmovdqu	%ymm7, 224(%rdi)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vmovdqu	448(%rdi), %ymm6
        vmovdqu	480(%rdi), %ymm7
        # 1: 2/4
        vmovdqu	1216(%rdx), %ymm10
        vmovdqu	1248(%rdx), %ymm12
        vmovdqu	1280(%rdx), %ymm11
        vmovdqu	1312(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 2: 2/4
        vmovdqu	1344(%rdx), %ymm10
        vmovdqu	1376(%rdx), %ymm12
        vmovdqu	1408(%rdx), %ymm11
        vmovdqu	1440(%rdx), %ymm13
        vpshufd	$0xd8, %ymm0, %ymm8
        vpshufd	$0xd8, %ymm1, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm0
        vpunpckhdq	%ymm9, %ymm8, %ymm1
        vpshufd	$0xd8, %ymm2, %ymm8
        vpshufd	$0xd8, %ymm3, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm2
        vpunpckhdq	%ymm9, %ymm8, %ymm3
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 4: 2/4
        vmovdqu	1472(%rdx), %ymm10
        vmovdqu	1504(%rdx), %ymm12
        vmovdqu	1536(%rdx), %ymm11
        vmovdqu	1568(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm1
        vpunpcklqdq	%ymm3, %ymm2, %ymm9
        vpunpckhqdq	%ymm3, %ymm2, %ymm3
        vpsubd	%ymm1, %ymm8, %ymm0
        vpaddd	%ymm1, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm0, %ymm1
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm10, %ymm0, %ymm0
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm0, %ymm1
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm9, %ymm0
        vpaddd	%ymm3, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm0, %ymm3
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm0, %ymm3
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 8: 2/4
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	1600(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	1632(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	1664(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	1696(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 16: 2/4
        vmovdqu	1728(%rdx), %ymm10
        vmovdqu	1760(%rdx), %ymm12
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 1: 2/4
        vmovdqu	1792(%rdx), %ymm10
        vmovdqu	1824(%rdx), %ymm12
        vmovdqu	1856(%rdx), %ymm11
        vmovdqu	1888(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 2: 2/4
        vmovdqu	1920(%rdx), %ymm10
        vmovdqu	1952(%rdx), %ymm12
        vmovdqu	1984(%rdx), %ymm11
        vmovdqu	2016(%rdx), %ymm13
        vpshufd	$0xd8, %ymm4, %ymm8
        vpshufd	$0xd8, %ymm5, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm4
        vpunpckhdq	%ymm9, %ymm8, %ymm5
        vpshufd	$0xd8, %ymm6, %ymm8
        vpshufd	$0xd8, %ymm7, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm6
        vpunpckhdq	%ymm9, %ymm8, %ymm7
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 4: 2/4
        vmovdqu	2048(%rdx), %ymm10
        vmovdqu	2080(%rdx), %ymm12
        vmovdqu	2112(%rdx), %ymm11
        vmovdqu	2144(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm5
        vpunpcklqdq	%ymm7, %ymm6, %ymm9
        vpunpckhqdq	%ymm7, %ymm6, %ymm7
        vpsubd	%ymm5, %ymm8, %ymm4
        vpaddd	%ymm5, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm4, %ymm5
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm4, %ymm5
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm9, %ymm4
        vpaddd	%ymm7, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm4, %ymm7
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm4, %ymm7
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 8: 2/4
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	2176(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	2208(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	2240(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	2272(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 16: 2/4
        vmovdqu	2304(%rdx), %ymm10
        vmovdqu	2336(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 32: 2/4
        vmovdqu	2368(%rdx), %ymm10
        vmovdqu	2400(%rdx), %ymm12
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vmovdqu	%ymm0, 256(%rdi)
        vmovdqu	%ymm1, 288(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 352(%rdi)
        vmovdqu	%ymm4, 384(%rdi)
        vmovdqu	%ymm5, 416(%rdi)
        vmovdqu	%ymm6, 448(%rdi)
        vmovdqu	%ymm7, 480(%rdi)
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vmovdqu	576(%rdi), %ymm2
        vmovdqu	608(%rdi), %ymm3
        vmovdqu	640(%rdi), %ymm4
        vmovdqu	672(%rdi), %ymm5
        vmovdqu	704(%rdi), %ymm6
        vmovdqu	736(%rdi), %ymm7
        # 1: 3/4
        vmovdqu	2432(%rdx), %ymm10
        vmovdqu	2464(%rdx), %ymm12
        vmovdqu	2496(%rdx), %ymm11
        vmovdqu	2528(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 2: 3/4
        vmovdqu	2560(%rdx), %ymm10
        vmovdqu	2592(%rdx), %ymm12
        vmovdqu	2624(%rdx), %ymm11
        vmovdqu	2656(%rdx), %ymm13
        vpshufd	$0xd8, %ymm0, %ymm8
        vpshufd	$0xd8, %ymm1, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm0
        vpunpckhdq	%ymm9, %ymm8, %ymm1
        vpshufd	$0xd8, %ymm2, %ymm8
        vpshufd	$0xd8, %ymm3, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm2
        vpunpckhdq	%ymm9, %ymm8, %ymm3
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 4: 3/4
        vmovdqu	2688(%rdx), %ymm10
        vmovdqu	2720(%rdx), %ymm12
        vmovdqu	2752(%rdx), %ymm11
        vmovdqu	2784(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm1
        vpunpcklqdq	%ymm3, %ymm2, %ymm9
        vpunpckhqdq	%ymm3, %ymm2, %ymm3
        vpsubd	%ymm1, %ymm8, %ymm0
        vpaddd	%ymm1, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm0, %ymm1
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm10, %ymm0, %ymm0
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm0, %ymm1
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm9, %ymm0
        vpaddd	%ymm3, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm0, %ymm3
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm0, %ymm3
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 8: 3/4
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	2816(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	2848(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	2880(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	2912(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 16: 3/4
        vmovdqu	2944(%rdx), %ymm10
        vmovdqu	2976(%rdx), %ymm12
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 1: 3/4
        vmovdqu	3008(%rdx), %ymm10
        vmovdqu	3040(%rdx), %ymm12
        vmovdqu	3072(%rdx), %ymm11
        vmovdqu	3104(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 2: 3/4
        vmovdqu	3136(%rdx), %ymm10
        vmovdqu	3168(%rdx), %ymm12
        vmovdqu	3200(%rdx), %ymm11
        vmovdqu	3232(%rdx), %ymm13
        vpshufd	$0xd8, %ymm4, %ymm8
        vpshufd	$0xd8, %ymm5, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm4
        vpunpckhdq	%ymm9, %ymm8, %ymm5
        vpshufd	$0xd8, %ymm6, %ymm8
        vpshufd	$0xd8, %ymm7, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm6
        vpunpckhdq	%ymm9, %ymm8, %ymm7
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 4: 3/4
        vmovdqu	3264(%rdx), %ymm10
        vmovdqu	3296(%rdx), %ymm12
        vmovdqu	3328(%rdx), %ymm11
        vmovdqu	3360(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm5
        vpunpcklqdq	%ymm7, %ymm6, %ymm9
        vpunpckhqdq	%ymm7, %ymm6, %ymm7
        vpsubd	%ymm5, %ymm8, %ymm4
        vpaddd	%ymm5, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm4, %ymm5
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm4, %ymm5
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm9, %ymm4
        vpaddd	%ymm7, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm4, %ymm7
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm4, %ymm7
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 8: 3/4
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	3392(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	3424(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	3456(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	3488(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 16: 3/4
        vmovdqu	3520(%rdx), %ymm10
        vmovdqu	3552(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 32: 3/4
        vmovdqu	3584(%rdx), %ymm10
        vmovdqu	3616(%rdx), %ymm12
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vmovdqu	%ymm0, 512(%rdi)
        vmovdqu	%ymm1, 544(%rdi)
        vmovdqu	%ymm2, 576(%rdi)
        vmovdqu	%ymm3, 608(%rdi)
        vmovdqu	%ymm4, 640(%rdi)
        vmovdqu	%ymm5, 672(%rdi)
        vmovdqu	%ymm6, 704(%rdi)
        vmovdqu	%ymm7, 736(%rdi)
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vmovdqu	832(%rdi), %ymm2
        vmovdqu	864(%rdi), %ymm3
        vmovdqu	896(%rdi), %ymm4
        vmovdqu	928(%rdi), %ymm5
        vmovdqu	960(%rdi), %ymm6
        vmovdqu	992(%rdi), %ymm7
        # 1: 4/4
        vmovdqu	3648(%rdx), %ymm10
        vmovdqu	3680(%rdx), %ymm12
        vmovdqu	3712(%rdx), %ymm11
        vmovdqu	3744(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 2: 4/4
        vmovdqu	3776(%rdx), %ymm10
        vmovdqu	3808(%rdx), %ymm12
        vmovdqu	3840(%rdx), %ymm11
        vmovdqu	3872(%rdx), %ymm13
        vpshufd	$0xd8, %ymm0, %ymm8
        vpshufd	$0xd8, %ymm1, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm0
        vpunpckhdq	%ymm9, %ymm8, %ymm1
        vpshufd	$0xd8, %ymm2, %ymm8
        vpshufd	$0xd8, %ymm3, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm2
        vpunpckhdq	%ymm9, %ymm8, %ymm3
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 4: 4/4
        vmovdqu	3904(%rdx), %ymm10
        vmovdqu	3936(%rdx), %ymm12
        vmovdqu	3968(%rdx), %ymm11
        vmovdqu	4000(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm1
        vpunpcklqdq	%ymm3, %ymm2, %ymm9
        vpunpckhqdq	%ymm3, %ymm2, %ymm3
        vpsubd	%ymm1, %ymm8, %ymm0
        vpaddd	%ymm1, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm0, %ymm1
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm10, %ymm0, %ymm0
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm0, %ymm1
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm9, %ymm0
        vpaddd	%ymm3, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm0, %ymm3
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm0, %ymm3
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 8: 4/4
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	4032(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	4064(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	4096(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	4128(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 16: 4/4
        vmovdqu	4160(%rdx), %ymm10
        vmovdqu	4192(%rdx), %ymm12
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 1: 4/4
        vmovdqu	4224(%rdx), %ymm10
        vmovdqu	4256(%rdx), %ymm12
        vmovdqu	4288(%rdx), %ymm11
        vmovdqu	4320(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 2: 4/4
        vmovdqu	4352(%rdx), %ymm10
        vmovdqu	4384(%rdx), %ymm12
        vmovdqu	4416(%rdx), %ymm11
        vmovdqu	4448(%rdx), %ymm13
        vpshufd	$0xd8, %ymm4, %ymm8
        vpshufd	$0xd8, %ymm5, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm4
        vpunpckhdq	%ymm9, %ymm8, %ymm5
        vpshufd	$0xd8, %ymm6, %ymm8
        vpshufd	$0xd8, %ymm7, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm6
        vpunpckhdq	%ymm9, %ymm8, %ymm7
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 4: 4/4
        vmovdqu	4480(%rdx), %ymm10
        vmovdqu	4512(%rdx), %ymm12
        vmovdqu	4544(%rdx), %ymm11
        vmovdqu	4576(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm5
        vpunpcklqdq	%ymm7, %ymm6, %ymm9
        vpunpckhqdq	%ymm7, %ymm6, %ymm7
        vpsubd	%ymm5, %ymm8, %ymm4
        vpaddd	%ymm5, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm4, %ymm5
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm4, %ymm5
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm9, %ymm4
        vpaddd	%ymm7, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm4, %ymm7
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm4, %ymm7
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 8: 4/4
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	4608(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	4640(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	4672(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	4704(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 16: 4/4
        vmovdqu	4736(%rdx), %ymm10
        vmovdqu	4768(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 32: 4/4
        vmovdqu	4800(%rdx), %ymm10
        vmovdqu	4832(%rdx), %ymm12
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vmovdqu	%ymm0, 768(%rdi)
        vmovdqu	%ymm1, 800(%rdi)
        vmovdqu	%ymm2, 832(%rdi)
        vmovdqu	%ymm4, 896(%rdi)
        vmovdqu	%ymm5, 928(%rdi)
        vmovdqu	%ymm6, 960(%rdi)
        vmovdqu	4864(%rdx), %ymm10
        vmovdqu	4896(%rdx), %ymm12
        vmovdqu	4928(%rdx), %ymm11
        vmovdqu	4960(%rdx), %ymm13
        vmovdqu	%ymm3, %ymm6
        vmovdqu	96(%rdi), %ymm0
        vmovdqu	224(%rdi), %ymm1
        vmovdqu	352(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vmovdqu	608(%rdi), %ymm4
        vmovdqu	736(%rdi), %ymm5
        # 64: 4/4
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        vmovdqu	4992(%rdx), %ymm10
        vmovdqu	5024(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 128: 4/4
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vmovdqu	5056(%rdx), %ymm11
        vmovdqu	5088(%rdx), %ymm13
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vpmulld	%ymm13, %ymm0, %ymm8
        vpmulld	%ymm13, %ymm1, %ymm10
        vmovshdup	%ymm0, %ymm9
        vmovshdup	%ymm1, %ymm12
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm1, %ymm1
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm0, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm1, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm0
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm1
        vpmulld	%ymm13, %ymm2, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm10
        vmovshdup	%ymm2, %ymm9
        vmovshdup	%ymm3, %ymm12
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm3, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm2
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm3
        vpmulld	%ymm13, %ymm4, %ymm8
        vpmulld	%ymm13, %ymm5, %ymm10
        vmovshdup	%ymm4, %ymm9
        vmovshdup	%ymm5, %ymm12
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm5, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm4
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm5
        vpmulld	%ymm13, %ymm6, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm10
        vmovshdup	%ymm6, %ymm9
        vmovshdup	%ymm7, %ymm12
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm7, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm6
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm7
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, 224(%rdi)
        vmovdqu	%ymm2, 352(%rdi)
        vmovdqu	%ymm3, 480(%rdi)
        vmovdqu	%ymm4, 608(%rdi)
        vmovdqu	%ymm5, 736(%rdi)
        vmovdqu	%ymm6, 864(%rdi)
        vmovdqu	%ymm7, 992(%rdi)
        vmovdqu	4864(%rdx), %ymm10
        vmovdqu	4896(%rdx), %ymm12
        vmovdqu	4928(%rdx), %ymm11
        vmovdqu	4960(%rdx), %ymm13
        vmovdqu	64(%rdi), %ymm0
        vmovdqu	192(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	448(%rdi), %ymm3
        vmovdqu	576(%rdi), %ymm4
        vmovdqu	704(%rdi), %ymm5
        vmovdqu	832(%rdi), %ymm6
        vmovdqu	960(%rdi), %ymm7
        # 64: 3/4
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        vmovdqu	4992(%rdx), %ymm10
        vmovdqu	5024(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 128: 3/4
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vmovdqu	5056(%rdx), %ymm11
        vmovdqu	5088(%rdx), %ymm13
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vpmulld	%ymm13, %ymm0, %ymm8
        vpmulld	%ymm13, %ymm1, %ymm10
        vmovshdup	%ymm0, %ymm9
        vmovshdup	%ymm1, %ymm12
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm1, %ymm1
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm0, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm1, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm0
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm1
        vpmulld	%ymm13, %ymm2, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm10
        vmovshdup	%ymm2, %ymm9
        vmovshdup	%ymm3, %ymm12
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm3, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm2
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm3
        vpmulld	%ymm13, %ymm4, %ymm8
        vpmulld	%ymm13, %ymm5, %ymm10
        vmovshdup	%ymm4, %ymm9
        vmovshdup	%ymm5, %ymm12
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm5, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm4
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm5
        vpmulld	%ymm13, %ymm6, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm10
        vmovshdup	%ymm6, %ymm9
        vmovshdup	%ymm7, %ymm12
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm7, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm6
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm7
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, 192(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 448(%rdi)
        vmovdqu	%ymm4, 576(%rdi)
        vmovdqu	%ymm5, 704(%rdi)
        vmovdqu	%ymm6, 832(%rdi)
        vmovdqu	%ymm7, 960(%rdi)
        vmovdqu	4864(%rdx), %ymm10
        vmovdqu	4896(%rdx), %ymm12
        vmovdqu	4928(%rdx), %ymm11
        vmovdqu	4960(%rdx), %ymm13
        vmovdqu	32(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vmovdqu	288(%rdi), %ymm2
        vmovdqu	416(%rdi), %ymm3
        vmovdqu	544(%rdi), %ymm4
        vmovdqu	672(%rdi), %ymm5
        vmovdqu	800(%rdi), %ymm6
        vmovdqu	928(%rdi), %ymm7
        # 64: 2/4
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        vmovdqu	4992(%rdx), %ymm10
        vmovdqu	5024(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 128: 2/4
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vmovdqu	5056(%rdx), %ymm11
        vmovdqu	5088(%rdx), %ymm13
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vpmulld	%ymm13, %ymm0, %ymm8
        vpmulld	%ymm13, %ymm1, %ymm10
        vmovshdup	%ymm0, %ymm9
        vmovshdup	%ymm1, %ymm12
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm1, %ymm1
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm0, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm1, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm0
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm1
        vpmulld	%ymm13, %ymm2, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm10
        vmovshdup	%ymm2, %ymm9
        vmovshdup	%ymm3, %ymm12
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm3, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm2
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm3
        vpmulld	%ymm13, %ymm4, %ymm8
        vpmulld	%ymm13, %ymm5, %ymm10
        vmovshdup	%ymm4, %ymm9
        vmovshdup	%ymm5, %ymm12
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm5, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm4
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm5
        vpmulld	%ymm13, %ymm6, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm10
        vmovshdup	%ymm6, %ymm9
        vmovshdup	%ymm7, %ymm12
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm7, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm6
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm7
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, 160(%rdi)
        vmovdqu	%ymm2, 288(%rdi)
        vmovdqu	%ymm3, 416(%rdi)
        vmovdqu	%ymm4, 544(%rdi)
        vmovdqu	%ymm5, 672(%rdi)
        vmovdqu	%ymm6, 800(%rdi)
        vmovdqu	%ymm7, 928(%rdi)
        vmovdqu	4864(%rdx), %ymm10
        vmovdqu	4896(%rdx), %ymm12
        vmovdqu	4928(%rdx), %ymm11
        vmovdqu	4960(%rdx), %ymm13
        vmovdqu	(%rdi), %ymm0
        vmovdqu	128(%rdi), %ymm1
        vmovdqu	256(%rdi), %ymm2
        vmovdqu	384(%rdi), %ymm3
        vmovdqu	512(%rdi), %ymm4
        vmovdqu	640(%rdi), %ymm5
        vmovdqu	768(%rdi), %ymm6
        vmovdqu	896(%rdi), %ymm7
        # 64: 1/4
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        vmovdqu	4992(%rdx), %ymm10
        vmovdqu	5024(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 128: 1/4
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vmovdqu	5056(%rdx), %ymm11
        vmovdqu	5088(%rdx), %ymm13
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vpmulld	%ymm13, %ymm0, %ymm8
        vpmulld	%ymm13, %ymm1, %ymm10
        vmovshdup	%ymm0, %ymm9
        vmovshdup	%ymm1, %ymm12
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm1, %ymm1
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm0, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm1, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm0
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm1
        vpmulld	%ymm13, %ymm2, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm10
        vmovshdup	%ymm2, %ymm9
        vmovshdup	%ymm3, %ymm12
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm3, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm2
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm3
        vpmulld	%ymm13, %ymm4, %ymm8
        vpmulld	%ymm13, %ymm5, %ymm10
        vmovshdup	%ymm4, %ymm9
        vmovshdup	%ymm5, %ymm12
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm5, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm4
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm5
        vpmulld	%ymm13, %ymm6, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm10
        vmovshdup	%ymm6, %ymm9
        vmovshdup	%ymm7, %ymm12
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm7, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm6
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm7
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, 256(%rdi)
        vmovdqu	%ymm3, 384(%rdi)
        vmovdqu	%ymm4, 512(%rdi)
        vmovdqu	%ymm5, 640(%rdi)
        vmovdqu	%ymm6, 768(%rdi)
        vmovdqu	%ymm7, 896(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_invntt_avx2,.-wc_mldsa_invntt_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	wc_mldsa_invntt_full_avx2
.type	wc_mldsa_invntt_full_avx2,@function
.align	16
wc_mldsa_invntt_full_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_invntt_full_avx2
.p2align	4
_wc_mldsa_invntt_full_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm14, %ymm14, %ymm14
        vmovdqu	mldsa_q(%rip), %ymm14
        # invntt
        leaq	L_mldsa_avx2_zetas_inv(%rip), %rdx
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm0
        vpunpckhdq	%ymm9, %ymm8, %ymm1
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm2
        vpunpckhdq	%ymm9, %ymm8, %ymm3
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        # 1: 1/4
        vmovdqu	(%rdx), %ymm10
        vmovdqu	32(%rdx), %ymm12
        vmovdqu	64(%rdx), %ymm11
        vmovdqu	96(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 2: 1/4
        vmovdqu	128(%rdx), %ymm10
        vmovdqu	160(%rdx), %ymm12
        vmovdqu	192(%rdx), %ymm11
        vmovdqu	224(%rdx), %ymm13
        vpshufd	$0xd8, %ymm0, %ymm8
        vpshufd	$0xd8, %ymm1, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm0
        vpunpckhdq	%ymm9, %ymm8, %ymm1
        vpshufd	$0xd8, %ymm2, %ymm8
        vpshufd	$0xd8, %ymm3, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm2
        vpunpckhdq	%ymm9, %ymm8, %ymm3
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 4: 1/4
        vmovdqu	256(%rdx), %ymm10
        vmovdqu	288(%rdx), %ymm12
        vmovdqu	320(%rdx), %ymm11
        vmovdqu	352(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm1
        vpunpcklqdq	%ymm3, %ymm2, %ymm9
        vpunpckhqdq	%ymm3, %ymm2, %ymm3
        vpsubd	%ymm1, %ymm8, %ymm0
        vpaddd	%ymm1, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm0, %ymm1
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm10, %ymm0, %ymm0
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm0, %ymm1
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm9, %ymm0
        vpaddd	%ymm3, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm0, %ymm3
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm0, %ymm3
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 8: 1/4
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	384(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	416(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	448(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	480(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 16: 1/4
        vmovdqu	512(%rdx), %ymm10
        vmovdqu	544(%rdx), %ymm12
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm4
        vpunpckhdq	%ymm9, %ymm8, %ymm5
        vpermq	$0xd8, %ymm4, %ymm4
        vpermq	$0xd8, %ymm5, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm6
        vpunpckhdq	%ymm9, %ymm8, %ymm7
        vpermq	$0xd8, %ymm6, %ymm6
        vpermq	$0xd8, %ymm7, %ymm7
        # 1: 1/4
        vmovdqu	576(%rdx), %ymm10
        vmovdqu	608(%rdx), %ymm12
        vmovdqu	640(%rdx), %ymm11
        vmovdqu	672(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 2: 1/4
        vmovdqu	704(%rdx), %ymm10
        vmovdqu	736(%rdx), %ymm12
        vmovdqu	768(%rdx), %ymm11
        vmovdqu	800(%rdx), %ymm13
        vpshufd	$0xd8, %ymm4, %ymm8
        vpshufd	$0xd8, %ymm5, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm4
        vpunpckhdq	%ymm9, %ymm8, %ymm5
        vpshufd	$0xd8, %ymm6, %ymm8
        vpshufd	$0xd8, %ymm7, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm6
        vpunpckhdq	%ymm9, %ymm8, %ymm7
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 4: 1/4
        vmovdqu	832(%rdx), %ymm10
        vmovdqu	864(%rdx), %ymm12
        vmovdqu	896(%rdx), %ymm11
        vmovdqu	928(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm5
        vpunpcklqdq	%ymm7, %ymm6, %ymm9
        vpunpckhqdq	%ymm7, %ymm6, %ymm7
        vpsubd	%ymm5, %ymm8, %ymm4
        vpaddd	%ymm5, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm4, %ymm5
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm4, %ymm5
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm9, %ymm4
        vpaddd	%ymm7, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm4, %ymm7
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm4, %ymm7
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 8: 1/4
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	960(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	992(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	1024(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	1056(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 16: 1/4
        vmovdqu	1088(%rdx), %ymm10
        vmovdqu	1120(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 32: 1/4
        vmovdqu	1152(%rdx), %ymm10
        vmovdqu	1184(%rdx), %ymm12
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, 128(%rdi)
        vmovdqu	%ymm5, 160(%rdi)
        vmovdqu	%ymm6, 192(%rdi)
        vmovdqu	%ymm7, 224(%rdi)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vmovdqu	448(%rdi), %ymm6
        vmovdqu	480(%rdi), %ymm7
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm0
        vpunpckhdq	%ymm9, %ymm8, %ymm1
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm2
        vpunpckhdq	%ymm9, %ymm8, %ymm3
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        # 1: 2/4
        vmovdqu	1216(%rdx), %ymm10
        vmovdqu	1248(%rdx), %ymm12
        vmovdqu	1280(%rdx), %ymm11
        vmovdqu	1312(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 2: 2/4
        vmovdqu	1344(%rdx), %ymm10
        vmovdqu	1376(%rdx), %ymm12
        vmovdqu	1408(%rdx), %ymm11
        vmovdqu	1440(%rdx), %ymm13
        vpshufd	$0xd8, %ymm0, %ymm8
        vpshufd	$0xd8, %ymm1, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm0
        vpunpckhdq	%ymm9, %ymm8, %ymm1
        vpshufd	$0xd8, %ymm2, %ymm8
        vpshufd	$0xd8, %ymm3, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm2
        vpunpckhdq	%ymm9, %ymm8, %ymm3
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 4: 2/4
        vmovdqu	1472(%rdx), %ymm10
        vmovdqu	1504(%rdx), %ymm12
        vmovdqu	1536(%rdx), %ymm11
        vmovdqu	1568(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm1
        vpunpcklqdq	%ymm3, %ymm2, %ymm9
        vpunpckhqdq	%ymm3, %ymm2, %ymm3
        vpsubd	%ymm1, %ymm8, %ymm0
        vpaddd	%ymm1, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm0, %ymm1
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm10, %ymm0, %ymm0
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm0, %ymm1
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm9, %ymm0
        vpaddd	%ymm3, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm0, %ymm3
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm0, %ymm3
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 8: 2/4
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	1600(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	1632(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	1664(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	1696(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 16: 2/4
        vmovdqu	1728(%rdx), %ymm10
        vmovdqu	1760(%rdx), %ymm12
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm4
        vpunpckhdq	%ymm9, %ymm8, %ymm5
        vpermq	$0xd8, %ymm4, %ymm4
        vpermq	$0xd8, %ymm5, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm6
        vpunpckhdq	%ymm9, %ymm8, %ymm7
        vpermq	$0xd8, %ymm6, %ymm6
        vpermq	$0xd8, %ymm7, %ymm7
        # 1: 2/4
        vmovdqu	1792(%rdx), %ymm10
        vmovdqu	1824(%rdx), %ymm12
        vmovdqu	1856(%rdx), %ymm11
        vmovdqu	1888(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 2: 2/4
        vmovdqu	1920(%rdx), %ymm10
        vmovdqu	1952(%rdx), %ymm12
        vmovdqu	1984(%rdx), %ymm11
        vmovdqu	2016(%rdx), %ymm13
        vpshufd	$0xd8, %ymm4, %ymm8
        vpshufd	$0xd8, %ymm5, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm4
        vpunpckhdq	%ymm9, %ymm8, %ymm5
        vpshufd	$0xd8, %ymm6, %ymm8
        vpshufd	$0xd8, %ymm7, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm6
        vpunpckhdq	%ymm9, %ymm8, %ymm7
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 4: 2/4
        vmovdqu	2048(%rdx), %ymm10
        vmovdqu	2080(%rdx), %ymm12
        vmovdqu	2112(%rdx), %ymm11
        vmovdqu	2144(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm5
        vpunpcklqdq	%ymm7, %ymm6, %ymm9
        vpunpckhqdq	%ymm7, %ymm6, %ymm7
        vpsubd	%ymm5, %ymm8, %ymm4
        vpaddd	%ymm5, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm4, %ymm5
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm4, %ymm5
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm9, %ymm4
        vpaddd	%ymm7, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm4, %ymm7
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm4, %ymm7
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 8: 2/4
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	2176(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	2208(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	2240(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	2272(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 16: 2/4
        vmovdqu	2304(%rdx), %ymm10
        vmovdqu	2336(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 32: 2/4
        vmovdqu	2368(%rdx), %ymm10
        vmovdqu	2400(%rdx), %ymm12
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vmovdqu	%ymm0, 256(%rdi)
        vmovdqu	%ymm1, 288(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 352(%rdi)
        vmovdqu	%ymm4, 384(%rdi)
        vmovdqu	%ymm5, 416(%rdi)
        vmovdqu	%ymm6, 448(%rdi)
        vmovdqu	%ymm7, 480(%rdi)
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vmovdqu	576(%rdi), %ymm2
        vmovdqu	608(%rdi), %ymm3
        vmovdqu	640(%rdi), %ymm4
        vmovdqu	672(%rdi), %ymm5
        vmovdqu	704(%rdi), %ymm6
        vmovdqu	736(%rdi), %ymm7
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm0
        vpunpckhdq	%ymm9, %ymm8, %ymm1
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm2
        vpunpckhdq	%ymm9, %ymm8, %ymm3
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        # 1: 3/4
        vmovdqu	2432(%rdx), %ymm10
        vmovdqu	2464(%rdx), %ymm12
        vmovdqu	2496(%rdx), %ymm11
        vmovdqu	2528(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 2: 3/4
        vmovdqu	2560(%rdx), %ymm10
        vmovdqu	2592(%rdx), %ymm12
        vmovdqu	2624(%rdx), %ymm11
        vmovdqu	2656(%rdx), %ymm13
        vpshufd	$0xd8, %ymm0, %ymm8
        vpshufd	$0xd8, %ymm1, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm0
        vpunpckhdq	%ymm9, %ymm8, %ymm1
        vpshufd	$0xd8, %ymm2, %ymm8
        vpshufd	$0xd8, %ymm3, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm2
        vpunpckhdq	%ymm9, %ymm8, %ymm3
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 4: 3/4
        vmovdqu	2688(%rdx), %ymm10
        vmovdqu	2720(%rdx), %ymm12
        vmovdqu	2752(%rdx), %ymm11
        vmovdqu	2784(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm1
        vpunpcklqdq	%ymm3, %ymm2, %ymm9
        vpunpckhqdq	%ymm3, %ymm2, %ymm3
        vpsubd	%ymm1, %ymm8, %ymm0
        vpaddd	%ymm1, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm0, %ymm1
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm10, %ymm0, %ymm0
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm0, %ymm1
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm9, %ymm0
        vpaddd	%ymm3, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm0, %ymm3
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm0, %ymm3
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 8: 3/4
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	2816(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	2848(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	2880(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	2912(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 16: 3/4
        vmovdqu	2944(%rdx), %ymm10
        vmovdqu	2976(%rdx), %ymm12
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm4
        vpunpckhdq	%ymm9, %ymm8, %ymm5
        vpermq	$0xd8, %ymm4, %ymm4
        vpermq	$0xd8, %ymm5, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm6
        vpunpckhdq	%ymm9, %ymm8, %ymm7
        vpermq	$0xd8, %ymm6, %ymm6
        vpermq	$0xd8, %ymm7, %ymm7
        # 1: 3/4
        vmovdqu	3008(%rdx), %ymm10
        vmovdqu	3040(%rdx), %ymm12
        vmovdqu	3072(%rdx), %ymm11
        vmovdqu	3104(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 2: 3/4
        vmovdqu	3136(%rdx), %ymm10
        vmovdqu	3168(%rdx), %ymm12
        vmovdqu	3200(%rdx), %ymm11
        vmovdqu	3232(%rdx), %ymm13
        vpshufd	$0xd8, %ymm4, %ymm8
        vpshufd	$0xd8, %ymm5, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm4
        vpunpckhdq	%ymm9, %ymm8, %ymm5
        vpshufd	$0xd8, %ymm6, %ymm8
        vpshufd	$0xd8, %ymm7, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm6
        vpunpckhdq	%ymm9, %ymm8, %ymm7
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 4: 3/4
        vmovdqu	3264(%rdx), %ymm10
        vmovdqu	3296(%rdx), %ymm12
        vmovdqu	3328(%rdx), %ymm11
        vmovdqu	3360(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm5
        vpunpcklqdq	%ymm7, %ymm6, %ymm9
        vpunpckhqdq	%ymm7, %ymm6, %ymm7
        vpsubd	%ymm5, %ymm8, %ymm4
        vpaddd	%ymm5, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm4, %ymm5
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm4, %ymm5
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm9, %ymm4
        vpaddd	%ymm7, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm4, %ymm7
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm4, %ymm7
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 8: 3/4
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	3392(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	3424(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	3456(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	3488(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 16: 3/4
        vmovdqu	3520(%rdx), %ymm10
        vmovdqu	3552(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 32: 3/4
        vmovdqu	3584(%rdx), %ymm10
        vmovdqu	3616(%rdx), %ymm12
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vmovdqu	%ymm0, 512(%rdi)
        vmovdqu	%ymm1, 544(%rdi)
        vmovdqu	%ymm2, 576(%rdi)
        vmovdqu	%ymm3, 608(%rdi)
        vmovdqu	%ymm4, 640(%rdi)
        vmovdqu	%ymm5, 672(%rdi)
        vmovdqu	%ymm6, 704(%rdi)
        vmovdqu	%ymm7, 736(%rdi)
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vmovdqu	832(%rdi), %ymm2
        vmovdqu	864(%rdi), %ymm3
        vmovdqu	896(%rdi), %ymm4
        vmovdqu	928(%rdi), %ymm5
        vmovdqu	960(%rdi), %ymm6
        vmovdqu	992(%rdi), %ymm7
        vpunpckldq	%ymm1, %ymm0, %ymm8
        vpunpckhdq	%ymm1, %ymm0, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm0
        vpunpckhdq	%ymm9, %ymm8, %ymm1
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpunpckldq	%ymm3, %ymm2, %ymm8
        vpunpckhdq	%ymm3, %ymm2, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm2
        vpunpckhdq	%ymm9, %ymm8, %ymm3
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        # 1: 4/4
        vmovdqu	3648(%rdx), %ymm10
        vmovdqu	3680(%rdx), %ymm12
        vmovdqu	3712(%rdx), %ymm11
        vmovdqu	3744(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 2: 4/4
        vmovdqu	3776(%rdx), %ymm10
        vmovdqu	3808(%rdx), %ymm12
        vmovdqu	3840(%rdx), %ymm11
        vmovdqu	3872(%rdx), %ymm13
        vpshufd	$0xd8, %ymm0, %ymm8
        vpshufd	$0xd8, %ymm1, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm0
        vpunpckhdq	%ymm9, %ymm8, %ymm1
        vpshufd	$0xd8, %ymm2, %ymm8
        vpshufd	$0xd8, %ymm3, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm2
        vpunpckhdq	%ymm9, %ymm8, %ymm3
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 4: 4/4
        vmovdqu	3904(%rdx), %ymm10
        vmovdqu	3936(%rdx), %ymm12
        vmovdqu	3968(%rdx), %ymm11
        vmovdqu	4000(%rdx), %ymm13
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm1
        vpunpcklqdq	%ymm3, %ymm2, %ymm9
        vpunpckhqdq	%ymm3, %ymm2, %ymm3
        vpsubd	%ymm1, %ymm8, %ymm0
        vpaddd	%ymm1, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm0, %ymm1
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm10, %ymm0, %ymm0
        vpmuldq	%ymm10, %ymm2, %ymm2
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm0, %ymm1
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm9, %ymm0
        vpaddd	%ymm3, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm0, %ymm3
        vmovshdup	%ymm0, %ymm2
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm2, %ymm2
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm0, %ymm3
        vpsubq	%ymm15, %ymm2, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 8: 4/4
        vperm2i128	$32, %ymm1, %ymm8, %ymm0
        vmovdqu	4032(%rdx), %ymm10
        vperm2i128	$49, %ymm1, %ymm8, %ymm1
        vmovdqu	4064(%rdx), %ymm12
        vperm2i128	$32, %ymm3, %ymm9, %ymm2
        vmovdqu	4096(%rdx), %ymm11
        vperm2i128	$49, %ymm3, %ymm9, %ymm3
        vmovdqu	4128(%rdx), %ymm13
        vpsubd	%ymm1, %ymm0, %ymm8
        vpaddd	%ymm1, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm1
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm1, %ymm15
        vpmuldq	%ymm14, %ymm1, %ymm1
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm1, %ymm8, %ymm1
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm1, %ymm1
        vpblendd	$0xaa, %ymm15, %ymm1, %ymm1
        vpsubd	%ymm3, %ymm2, %ymm8
        vpaddd	%ymm3, %ymm2, %ymm2
        vpmulld	%ymm13, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        # 16: 4/4
        vmovdqu	4160(%rdx), %ymm10
        vmovdqu	4192(%rdx), %ymm12
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        vpunpckldq	%ymm5, %ymm4, %ymm8
        vpunpckhdq	%ymm5, %ymm4, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm4
        vpunpckhdq	%ymm9, %ymm8, %ymm5
        vpermq	$0xd8, %ymm4, %ymm4
        vpermq	$0xd8, %ymm5, %ymm5
        vpunpckldq	%ymm7, %ymm6, %ymm8
        vpunpckhdq	%ymm7, %ymm6, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm6
        vpunpckhdq	%ymm9, %ymm8, %ymm7
        vpermq	$0xd8, %ymm6, %ymm6
        vpermq	$0xd8, %ymm7, %ymm7
        # 1: 4/4
        vmovdqu	4224(%rdx), %ymm10
        vmovdqu	4256(%rdx), %ymm12
        vmovdqu	4288(%rdx), %ymm11
        vmovdqu	4320(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vmovshdup	%ymm11, %ymm11
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 2: 4/4
        vmovdqu	4352(%rdx), %ymm10
        vmovdqu	4384(%rdx), %ymm12
        vmovdqu	4416(%rdx), %ymm11
        vmovdqu	4448(%rdx), %ymm13
        vpshufd	$0xd8, %ymm4, %ymm8
        vpshufd	$0xd8, %ymm5, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm4
        vpunpckhdq	%ymm9, %ymm8, %ymm5
        vpshufd	$0xd8, %ymm6, %ymm8
        vpshufd	$0xd8, %ymm7, %ymm9
        vpunpckldq	%ymm9, %ymm8, %ymm6
        vpunpckhdq	%ymm9, %ymm8, %ymm7
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 4: 4/4
        vmovdqu	4480(%rdx), %ymm10
        vmovdqu	4512(%rdx), %ymm12
        vmovdqu	4544(%rdx), %ymm11
        vmovdqu	4576(%rdx), %ymm13
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm5
        vpunpcklqdq	%ymm7, %ymm6, %ymm9
        vpunpckhqdq	%ymm7, %ymm6, %ymm7
        vpsubd	%ymm5, %ymm8, %ymm4
        vpaddd	%ymm5, %ymm8, %ymm8
        vpmulld	%ymm12, %ymm4, %ymm5
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm10, %ymm6, %ymm6
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm4, %ymm5
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm9, %ymm4
        vpaddd	%ymm7, %ymm9, %ymm9
        vpmulld	%ymm13, %ymm4, %ymm7
        vmovshdup	%ymm4, %ymm6
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm6, %ymm6
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm4, %ymm7
        vpsubq	%ymm15, %ymm6, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 8: 4/4
        vperm2i128	$32, %ymm5, %ymm8, %ymm4
        vmovdqu	4608(%rdx), %ymm10
        vperm2i128	$49, %ymm5, %ymm8, %ymm5
        vmovdqu	4640(%rdx), %ymm12
        vperm2i128	$32, %ymm7, %ymm9, %ymm6
        vmovdqu	4672(%rdx), %ymm11
        vperm2i128	$49, %ymm7, %ymm9, %ymm7
        vmovdqu	4704(%rdx), %ymm13
        vpsubd	%ymm5, %ymm4, %ymm8
        vpaddd	%ymm5, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm7, %ymm6, %ymm8
        vpaddd	%ymm7, %ymm6, %ymm6
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 16: 4/4
        vmovdqu	4736(%rdx), %ymm10
        vmovdqu	4768(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 32: 4/4
        vmovdqu	4800(%rdx), %ymm10
        vmovdqu	4832(%rdx), %ymm12
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vmovdqu	%ymm0, 768(%rdi)
        vmovdqu	%ymm1, 800(%rdi)
        vmovdqu	%ymm2, 832(%rdi)
        vmovdqu	%ymm4, 896(%rdi)
        vmovdqu	%ymm5, 928(%rdi)
        vmovdqu	%ymm6, 960(%rdi)
        vmovdqu	4864(%rdx), %ymm10
        vmovdqu	4896(%rdx), %ymm12
        vmovdqu	4928(%rdx), %ymm11
        vmovdqu	4960(%rdx), %ymm13
        vmovdqu	%ymm3, %ymm6
        vmovdqu	96(%rdi), %ymm0
        vmovdqu	224(%rdi), %ymm1
        vmovdqu	352(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vmovdqu	608(%rdi), %ymm4
        vmovdqu	736(%rdi), %ymm5
        # 64: 4/4
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        vmovdqu	4992(%rdx), %ymm10
        vmovdqu	5024(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 128: 4/4
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vmovdqu	5056(%rdx), %ymm11
        vmovdqu	5088(%rdx), %ymm13
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vpmulld	%ymm13, %ymm0, %ymm8
        vpmulld	%ymm13, %ymm1, %ymm10
        vmovshdup	%ymm0, %ymm9
        vmovshdup	%ymm1, %ymm12
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm1, %ymm1
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm0, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm1, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm0
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm1
        vpmulld	%ymm13, %ymm2, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm10
        vmovshdup	%ymm2, %ymm9
        vmovshdup	%ymm3, %ymm12
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm3, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm2
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm3
        vpmulld	%ymm13, %ymm4, %ymm8
        vpmulld	%ymm13, %ymm5, %ymm10
        vmovshdup	%ymm4, %ymm9
        vmovshdup	%ymm5, %ymm12
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm5, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm4
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm5
        vpmulld	%ymm13, %ymm6, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm10
        vmovshdup	%ymm6, %ymm9
        vmovshdup	%ymm7, %ymm12
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm7, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm6
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm7
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, 224(%rdi)
        vmovdqu	%ymm2, 352(%rdi)
        vmovdqu	%ymm3, 480(%rdi)
        vmovdqu	%ymm4, 608(%rdi)
        vmovdqu	%ymm5, 736(%rdi)
        vmovdqu	%ymm6, 864(%rdi)
        vmovdqu	%ymm7, 992(%rdi)
        vmovdqu	4864(%rdx), %ymm10
        vmovdqu	4896(%rdx), %ymm12
        vmovdqu	4928(%rdx), %ymm11
        vmovdqu	4960(%rdx), %ymm13
        vmovdqu	64(%rdi), %ymm0
        vmovdqu	192(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	448(%rdi), %ymm3
        vmovdqu	576(%rdi), %ymm4
        vmovdqu	704(%rdi), %ymm5
        vmovdqu	832(%rdi), %ymm6
        vmovdqu	960(%rdi), %ymm7
        # 64: 3/4
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        vmovdqu	4992(%rdx), %ymm10
        vmovdqu	5024(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 128: 3/4
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vmovdqu	5056(%rdx), %ymm11
        vmovdqu	5088(%rdx), %ymm13
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vpmulld	%ymm13, %ymm0, %ymm8
        vpmulld	%ymm13, %ymm1, %ymm10
        vmovshdup	%ymm0, %ymm9
        vmovshdup	%ymm1, %ymm12
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm1, %ymm1
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm0, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm1, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm0
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm1
        vpmulld	%ymm13, %ymm2, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm10
        vmovshdup	%ymm2, %ymm9
        vmovshdup	%ymm3, %ymm12
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm3, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm2
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm3
        vpmulld	%ymm13, %ymm4, %ymm8
        vpmulld	%ymm13, %ymm5, %ymm10
        vmovshdup	%ymm4, %ymm9
        vmovshdup	%ymm5, %ymm12
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm5, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm4
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm5
        vpmulld	%ymm13, %ymm6, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm10
        vmovshdup	%ymm6, %ymm9
        vmovshdup	%ymm7, %ymm12
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm7, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm6
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm7
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, 192(%rdi)
        vmovdqu	%ymm2, 320(%rdi)
        vmovdqu	%ymm3, 448(%rdi)
        vmovdqu	%ymm4, 576(%rdi)
        vmovdqu	%ymm5, 704(%rdi)
        vmovdqu	%ymm6, 832(%rdi)
        vmovdqu	%ymm7, 960(%rdi)
        vmovdqu	4864(%rdx), %ymm10
        vmovdqu	4896(%rdx), %ymm12
        vmovdqu	4928(%rdx), %ymm11
        vmovdqu	4960(%rdx), %ymm13
        vmovdqu	32(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vmovdqu	288(%rdi), %ymm2
        vmovdqu	416(%rdi), %ymm3
        vmovdqu	544(%rdi), %ymm4
        vmovdqu	672(%rdi), %ymm5
        vmovdqu	800(%rdi), %ymm6
        vmovdqu	928(%rdi), %ymm7
        # 64: 2/4
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        vmovdqu	4992(%rdx), %ymm10
        vmovdqu	5024(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 128: 2/4
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vmovdqu	5056(%rdx), %ymm11
        vmovdqu	5088(%rdx), %ymm13
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vpmulld	%ymm13, %ymm0, %ymm8
        vpmulld	%ymm13, %ymm1, %ymm10
        vmovshdup	%ymm0, %ymm9
        vmovshdup	%ymm1, %ymm12
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm1, %ymm1
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm0, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm1, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm0
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm1
        vpmulld	%ymm13, %ymm2, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm10
        vmovshdup	%ymm2, %ymm9
        vmovshdup	%ymm3, %ymm12
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm3, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm2
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm3
        vpmulld	%ymm13, %ymm4, %ymm8
        vpmulld	%ymm13, %ymm5, %ymm10
        vmovshdup	%ymm4, %ymm9
        vmovshdup	%ymm5, %ymm12
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm5, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm4
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm5
        vpmulld	%ymm13, %ymm6, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm10
        vmovshdup	%ymm6, %ymm9
        vmovshdup	%ymm7, %ymm12
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm7, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm6
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm7
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, 160(%rdi)
        vmovdqu	%ymm2, 288(%rdi)
        vmovdqu	%ymm3, 416(%rdi)
        vmovdqu	%ymm4, 544(%rdi)
        vmovdqu	%ymm5, 672(%rdi)
        vmovdqu	%ymm6, 800(%rdi)
        vmovdqu	%ymm7, 928(%rdi)
        vmovdqu	4864(%rdx), %ymm10
        vmovdqu	4896(%rdx), %ymm12
        vmovdqu	4928(%rdx), %ymm11
        vmovdqu	4960(%rdx), %ymm13
        vmovdqu	(%rdi), %ymm0
        vmovdqu	128(%rdi), %ymm1
        vmovdqu	256(%rdi), %ymm2
        vmovdqu	384(%rdi), %ymm3
        vmovdqu	512(%rdi), %ymm4
        vmovdqu	640(%rdi), %ymm5
        vmovdqu	768(%rdi), %ymm6
        vmovdqu	896(%rdi), %ymm7
        # 64: 1/4
        vpsubd	%ymm2, %ymm0, %ymm8
        vpaddd	%ymm2, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm2
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm2, %ymm15
        vpmuldq	%ymm14, %ymm2, %ymm2
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm2, %ymm8, %ymm2
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm2, %ymm2
        vpblendd	$0xaa, %ymm15, %ymm2, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm8
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm3
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm3, %ymm15
        vpmuldq	%ymm14, %ymm3, %ymm3
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm3, %ymm8, %ymm3
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm3, %ymm3
        vpblendd	$0xaa, %ymm15, %ymm3, %ymm3
        vmovdqu	4992(%rdx), %ymm10
        vmovdqu	5024(%rdx), %ymm12
        vpsubd	%ymm6, %ymm4, %ymm8
        vpaddd	%ymm6, %ymm4, %ymm4
        vpmulld	%ymm13, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm5, %ymm8
        vpaddd	%ymm7, %ymm5, %ymm5
        vpmulld	%ymm13, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm11, %ymm8, %ymm8
        vpmuldq	%ymm11, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        # 128: 1/4
        vpsubd	%ymm4, %ymm0, %ymm8
        vpaddd	%ymm4, %ymm0, %ymm0
        vpmulld	%ymm12, %ymm8, %ymm4
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm4, %ymm15
        vpmuldq	%ymm14, %ymm4, %ymm4
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm4, %ymm8, %ymm4
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm4, %ymm4
        vpblendd	$0xaa, %ymm15, %ymm4, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm8
        vpaddd	%ymm5, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm8, %ymm5
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm5, %ymm15
        vpmuldq	%ymm14, %ymm5, %ymm5
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm5, %ymm8, %ymm5
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm5, %ymm5
        vpblendd	$0xaa, %ymm15, %ymm5, %ymm5
        vmovdqu	5056(%rdx), %ymm11
        vmovdqu	5088(%rdx), %ymm13
        vpsubd	%ymm6, %ymm2, %ymm8
        vpaddd	%ymm6, %ymm2, %ymm2
        vpmulld	%ymm12, %ymm8, %ymm6
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm6, %ymm15
        vpmuldq	%ymm14, %ymm6, %ymm6
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm6, %ymm8, %ymm6
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm6, %ymm6
        vpblendd	$0xaa, %ymm15, %ymm6, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm8
        vpaddd	%ymm7, %ymm3, %ymm3
        vpmulld	%ymm12, %ymm8, %ymm7
        vmovshdup	%ymm8, %ymm9
        vpmuldq	%ymm10, %ymm8, %ymm8
        vpmuldq	%ymm10, %ymm9, %ymm9
        vmovshdup	%ymm7, %ymm15
        vpmuldq	%ymm14, %ymm7, %ymm7
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm7, %ymm8, %ymm7
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm7, %ymm7
        vpblendd	$0xaa, %ymm15, %ymm7, %ymm7
        vpmulld	%ymm13, %ymm0, %ymm8
        vpmulld	%ymm13, %ymm1, %ymm10
        vmovshdup	%ymm0, %ymm9
        vmovshdup	%ymm1, %ymm12
        vpmuldq	%ymm11, %ymm0, %ymm0
        vpmuldq	%ymm11, %ymm1, %ymm1
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm0, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm1, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm0
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm1
        vpmulld	%ymm13, %ymm2, %ymm8
        vpmulld	%ymm13, %ymm3, %ymm10
        vmovshdup	%ymm2, %ymm9
        vmovshdup	%ymm3, %ymm12
        vpmuldq	%ymm11, %ymm2, %ymm2
        vpmuldq	%ymm11, %ymm3, %ymm3
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm2, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm3, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm2
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm3
        vpmulld	%ymm13, %ymm4, %ymm8
        vpmulld	%ymm13, %ymm5, %ymm10
        vmovshdup	%ymm4, %ymm9
        vmovshdup	%ymm5, %ymm12
        vpmuldq	%ymm11, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm4, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm5, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm4
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm5
        vpmulld	%ymm13, %ymm6, %ymm8
        vpmulld	%ymm13, %ymm7, %ymm10
        vmovshdup	%ymm6, %ymm9
        vmovshdup	%ymm7, %ymm12
        vpmuldq	%ymm11, %ymm6, %ymm6
        vpmuldq	%ymm11, %ymm7, %ymm7
        vpmuldq	%ymm11, %ymm9, %ymm9
        vpmuldq	%ymm11, %ymm12, %ymm12
        vmovshdup	%ymm8, %ymm15
        vpmuldq	%ymm14, %ymm8, %ymm8
        vpmuldq	%ymm14, %ymm15, %ymm15
        vpsubq	%ymm8, %ymm6, %ymm8
        vpsubq	%ymm15, %ymm9, %ymm15
        vmovshdup	%ymm10, %ymm9
        vpmuldq	%ymm14, %ymm10, %ymm10
        vpmuldq	%ymm14, %ymm9, %ymm9
        vpsubq	%ymm10, %ymm7, %ymm10
        vpsubq	%ymm9, %ymm12, %ymm9
        vmovshdup	%ymm8, %ymm8
        vmovshdup	%ymm10, %ymm10
        vpblendd	$0xaa, %ymm15, %ymm8, %ymm6
        vpblendd	$0xaa, %ymm9, %ymm10, %ymm7
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, 256(%rdi)
        vmovdqu	%ymm3, 384(%rdi)
        vmovdqu	%ymm4, 512(%rdi)
        vmovdqu	%ymm5, 640(%rdi)
        vmovdqu	%ymm6, 768(%rdi)
        vmovdqu	%ymm7, 896(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_invntt_full_avx2,.-wc_mldsa_invntt_full_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	wc_mldsa_mul_avx2
.type	wc_mldsa_mul_avx2,@function
.align	16
wc_mldsa_mul_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_mul_avx2
.p2align	4
_wc_mldsa_mul_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm8, %ymm8, %ymm8
        vmovdqu	mldsa_q(%rip), %ymm8
        vmovdqu	mldsa_qinv(%rip), %ymm9
        # 0..15
        vmovdqu	(%rsi), %ymm0
        vmovdqu	32(%rsi), %ymm2
        vmovdqu	(%rdx), %ymm4
        vmovdqu	32(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm2, 32(%rdi)
        # 16..31
        vmovdqu	64(%rsi), %ymm0
        vmovdqu	96(%rsi), %ymm2
        vmovdqu	64(%rdx), %ymm4
        vmovdqu	96(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm2, 96(%rdi)
        # 32..47
        vmovdqu	128(%rsi), %ymm0
        vmovdqu	160(%rsi), %ymm2
        vmovdqu	128(%rdx), %ymm4
        vmovdqu	160(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm2, 160(%rdi)
        # 48..63
        vmovdqu	192(%rsi), %ymm0
        vmovdqu	224(%rsi), %ymm2
        vmovdqu	192(%rdx), %ymm4
        vmovdqu	224(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 192(%rdi)
        vmovdqu	%ymm2, 224(%rdi)
        # 64..79
        vmovdqu	256(%rsi), %ymm0
        vmovdqu	288(%rsi), %ymm2
        vmovdqu	256(%rdx), %ymm4
        vmovdqu	288(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 256(%rdi)
        vmovdqu	%ymm2, 288(%rdi)
        # 80..95
        vmovdqu	320(%rsi), %ymm0
        vmovdqu	352(%rsi), %ymm2
        vmovdqu	320(%rdx), %ymm4
        vmovdqu	352(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 320(%rdi)
        vmovdqu	%ymm2, 352(%rdi)
        # 96..111
        vmovdqu	384(%rsi), %ymm0
        vmovdqu	416(%rsi), %ymm2
        vmovdqu	384(%rdx), %ymm4
        vmovdqu	416(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 384(%rdi)
        vmovdqu	%ymm2, 416(%rdi)
        # 112..127
        vmovdqu	448(%rsi), %ymm0
        vmovdqu	480(%rsi), %ymm2
        vmovdqu	448(%rdx), %ymm4
        vmovdqu	480(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 448(%rdi)
        vmovdqu	%ymm2, 480(%rdi)
        # 128..143
        vmovdqu	512(%rsi), %ymm0
        vmovdqu	544(%rsi), %ymm2
        vmovdqu	512(%rdx), %ymm4
        vmovdqu	544(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 512(%rdi)
        vmovdqu	%ymm2, 544(%rdi)
        # 144..159
        vmovdqu	576(%rsi), %ymm0
        vmovdqu	608(%rsi), %ymm2
        vmovdqu	576(%rdx), %ymm4
        vmovdqu	608(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 576(%rdi)
        vmovdqu	%ymm2, 608(%rdi)
        # 160..175
        vmovdqu	640(%rsi), %ymm0
        vmovdqu	672(%rsi), %ymm2
        vmovdqu	640(%rdx), %ymm4
        vmovdqu	672(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 640(%rdi)
        vmovdqu	%ymm2, 672(%rdi)
        # 176..191
        vmovdqu	704(%rsi), %ymm0
        vmovdqu	736(%rsi), %ymm2
        vmovdqu	704(%rdx), %ymm4
        vmovdqu	736(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 704(%rdi)
        vmovdqu	%ymm2, 736(%rdi)
        # 192..207
        vmovdqu	768(%rsi), %ymm0
        vmovdqu	800(%rsi), %ymm2
        vmovdqu	768(%rdx), %ymm4
        vmovdqu	800(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 768(%rdi)
        vmovdqu	%ymm2, 800(%rdi)
        # 208..223
        vmovdqu	832(%rsi), %ymm0
        vmovdqu	864(%rsi), %ymm2
        vmovdqu	832(%rdx), %ymm4
        vmovdqu	864(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 832(%rdi)
        vmovdqu	%ymm2, 864(%rdi)
        # 224..239
        vmovdqu	896(%rsi), %ymm0
        vmovdqu	928(%rsi), %ymm2
        vmovdqu	896(%rdx), %ymm4
        vmovdqu	928(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 896(%rdi)
        vmovdqu	%ymm2, 928(%rdi)
        # 240..255
        vmovdqu	960(%rsi), %ymm0
        vmovdqu	992(%rsi), %ymm2
        vmovdqu	960(%rdx), %ymm4
        vmovdqu	992(%rdx), %ymm6
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpmuldq	%ymm4, %ymm0, %ymm0
        vpmuldq	%ymm5, %ymm1, %ymm1
        vpmuldq	%ymm6, %ymm2, %ymm2
        vpmuldq	%ymm7, %ymm3, %ymm3
        # Mont Reduce 2
        vpmulld	%ymm9, %ymm0, %ymm4
        vpmulld	%ymm9, %ymm1, %ymm5
        vpmulld	%ymm9, %ymm2, %ymm6
        vpmulld	%ymm9, %ymm3, %ymm7
        vpmuldq	%ymm8, %ymm4, %ymm4
        vpmuldq	%ymm8, %ymm5, %ymm5
        vpmuldq	%ymm8, %ymm6, %ymm6
        vpmuldq	%ymm8, %ymm7, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm0
        vpsubd	%ymm5, %ymm1, %ymm1
        vpsubd	%ymm6, %ymm2, %ymm2
        vpsubd	%ymm7, %ymm3, %ymm3
        vpsrlq	$32, %ymm0, %ymm0
        vpsrlq	$32, %ymm2, %ymm2
        vpor	%ymm1, %ymm0, %ymm0
        vpor	%ymm3, %ymm2, %ymm2
        vmovdqu	%ymm0, 960(%rdi)
        vmovdqu	%ymm2, 992(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_mul_avx2,.-wc_mldsa_mul_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	wc_mldsa_mul_vec_4_avx2
.type	wc_mldsa_mul_vec_4_avx2,@function
.align	16
wc_mldsa_mul_vec_4_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_mul_vec_4_avx2
.p2align	4
_wc_mldsa_mul_vec_4_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm12, %ymm12, %ymm12
        vmovdqu	mldsa_q(%rip), %ymm12
        vmovdqu	mldsa_qinv(%rip), %ymm13
        # 0..7
        vmovdqu	(%rsi), %ymm0
        vmovdqu	1024(%rsi), %ymm2
        vmovdqu	(%rdx), %ymm6
        vmovdqu	1024(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2048(%rsi), %ymm2
        vmovdqu	3072(%rsi), %ymm4
        vmovdqu	2048(%rdx), %ymm8
        vmovdqu	3072(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, (%rdi)
        # 8..15
        vmovdqu	32(%rsi), %ymm0
        vmovdqu	1056(%rsi), %ymm2
        vmovdqu	32(%rdx), %ymm6
        vmovdqu	1056(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2080(%rsi), %ymm2
        vmovdqu	3104(%rsi), %ymm4
        vmovdqu	2080(%rdx), %ymm8
        vmovdqu	3104(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 32(%rdi)
        # 16..23
        vmovdqu	64(%rsi), %ymm0
        vmovdqu	1088(%rsi), %ymm2
        vmovdqu	64(%rdx), %ymm6
        vmovdqu	1088(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2112(%rsi), %ymm2
        vmovdqu	3136(%rsi), %ymm4
        vmovdqu	2112(%rdx), %ymm8
        vmovdqu	3136(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 64(%rdi)
        # 24..31
        vmovdqu	96(%rsi), %ymm0
        vmovdqu	1120(%rsi), %ymm2
        vmovdqu	96(%rdx), %ymm6
        vmovdqu	1120(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2144(%rsi), %ymm2
        vmovdqu	3168(%rsi), %ymm4
        vmovdqu	2144(%rdx), %ymm8
        vmovdqu	3168(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 96(%rdi)
        # 32..39
        vmovdqu	128(%rsi), %ymm0
        vmovdqu	1152(%rsi), %ymm2
        vmovdqu	128(%rdx), %ymm6
        vmovdqu	1152(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2176(%rsi), %ymm2
        vmovdqu	3200(%rsi), %ymm4
        vmovdqu	2176(%rdx), %ymm8
        vmovdqu	3200(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 128(%rdi)
        # 40..47
        vmovdqu	160(%rsi), %ymm0
        vmovdqu	1184(%rsi), %ymm2
        vmovdqu	160(%rdx), %ymm6
        vmovdqu	1184(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2208(%rsi), %ymm2
        vmovdqu	3232(%rsi), %ymm4
        vmovdqu	2208(%rdx), %ymm8
        vmovdqu	3232(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 160(%rdi)
        # 48..55
        vmovdqu	192(%rsi), %ymm0
        vmovdqu	1216(%rsi), %ymm2
        vmovdqu	192(%rdx), %ymm6
        vmovdqu	1216(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2240(%rsi), %ymm2
        vmovdqu	3264(%rsi), %ymm4
        vmovdqu	2240(%rdx), %ymm8
        vmovdqu	3264(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 192(%rdi)
        # 56..63
        vmovdqu	224(%rsi), %ymm0
        vmovdqu	1248(%rsi), %ymm2
        vmovdqu	224(%rdx), %ymm6
        vmovdqu	1248(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2272(%rsi), %ymm2
        vmovdqu	3296(%rsi), %ymm4
        vmovdqu	2272(%rdx), %ymm8
        vmovdqu	3296(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 224(%rdi)
        # 64..71
        vmovdqu	256(%rsi), %ymm0
        vmovdqu	1280(%rsi), %ymm2
        vmovdqu	256(%rdx), %ymm6
        vmovdqu	1280(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2304(%rsi), %ymm2
        vmovdqu	3328(%rsi), %ymm4
        vmovdqu	2304(%rdx), %ymm8
        vmovdqu	3328(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 256(%rdi)
        # 72..79
        vmovdqu	288(%rsi), %ymm0
        vmovdqu	1312(%rsi), %ymm2
        vmovdqu	288(%rdx), %ymm6
        vmovdqu	1312(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2336(%rsi), %ymm2
        vmovdqu	3360(%rsi), %ymm4
        vmovdqu	2336(%rdx), %ymm8
        vmovdqu	3360(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 288(%rdi)
        # 80..87
        vmovdqu	320(%rsi), %ymm0
        vmovdqu	1344(%rsi), %ymm2
        vmovdqu	320(%rdx), %ymm6
        vmovdqu	1344(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2368(%rsi), %ymm2
        vmovdqu	3392(%rsi), %ymm4
        vmovdqu	2368(%rdx), %ymm8
        vmovdqu	3392(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 320(%rdi)
        # 88..95
        vmovdqu	352(%rsi), %ymm0
        vmovdqu	1376(%rsi), %ymm2
        vmovdqu	352(%rdx), %ymm6
        vmovdqu	1376(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2400(%rsi), %ymm2
        vmovdqu	3424(%rsi), %ymm4
        vmovdqu	2400(%rdx), %ymm8
        vmovdqu	3424(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 352(%rdi)
        # 96..103
        vmovdqu	384(%rsi), %ymm0
        vmovdqu	1408(%rsi), %ymm2
        vmovdqu	384(%rdx), %ymm6
        vmovdqu	1408(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2432(%rsi), %ymm2
        vmovdqu	3456(%rsi), %ymm4
        vmovdqu	2432(%rdx), %ymm8
        vmovdqu	3456(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 384(%rdi)
        # 104..111
        vmovdqu	416(%rsi), %ymm0
        vmovdqu	1440(%rsi), %ymm2
        vmovdqu	416(%rdx), %ymm6
        vmovdqu	1440(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2464(%rsi), %ymm2
        vmovdqu	3488(%rsi), %ymm4
        vmovdqu	2464(%rdx), %ymm8
        vmovdqu	3488(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 416(%rdi)
        # 112..119
        vmovdqu	448(%rsi), %ymm0
        vmovdqu	1472(%rsi), %ymm2
        vmovdqu	448(%rdx), %ymm6
        vmovdqu	1472(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2496(%rsi), %ymm2
        vmovdqu	3520(%rsi), %ymm4
        vmovdqu	2496(%rdx), %ymm8
        vmovdqu	3520(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 448(%rdi)
        # 120..127
        vmovdqu	480(%rsi), %ymm0
        vmovdqu	1504(%rsi), %ymm2
        vmovdqu	480(%rdx), %ymm6
        vmovdqu	1504(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2528(%rsi), %ymm2
        vmovdqu	3552(%rsi), %ymm4
        vmovdqu	2528(%rdx), %ymm8
        vmovdqu	3552(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 480(%rdi)
        # 128..135
        vmovdqu	512(%rsi), %ymm0
        vmovdqu	1536(%rsi), %ymm2
        vmovdqu	512(%rdx), %ymm6
        vmovdqu	1536(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2560(%rsi), %ymm2
        vmovdqu	3584(%rsi), %ymm4
        vmovdqu	2560(%rdx), %ymm8
        vmovdqu	3584(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 512(%rdi)
        # 136..143
        vmovdqu	544(%rsi), %ymm0
        vmovdqu	1568(%rsi), %ymm2
        vmovdqu	544(%rdx), %ymm6
        vmovdqu	1568(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2592(%rsi), %ymm2
        vmovdqu	3616(%rsi), %ymm4
        vmovdqu	2592(%rdx), %ymm8
        vmovdqu	3616(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 544(%rdi)
        # 144..151
        vmovdqu	576(%rsi), %ymm0
        vmovdqu	1600(%rsi), %ymm2
        vmovdqu	576(%rdx), %ymm6
        vmovdqu	1600(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2624(%rsi), %ymm2
        vmovdqu	3648(%rsi), %ymm4
        vmovdqu	2624(%rdx), %ymm8
        vmovdqu	3648(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 576(%rdi)
        # 152..159
        vmovdqu	608(%rsi), %ymm0
        vmovdqu	1632(%rsi), %ymm2
        vmovdqu	608(%rdx), %ymm6
        vmovdqu	1632(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2656(%rsi), %ymm2
        vmovdqu	3680(%rsi), %ymm4
        vmovdqu	2656(%rdx), %ymm8
        vmovdqu	3680(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 608(%rdi)
        # 160..167
        vmovdqu	640(%rsi), %ymm0
        vmovdqu	1664(%rsi), %ymm2
        vmovdqu	640(%rdx), %ymm6
        vmovdqu	1664(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2688(%rsi), %ymm2
        vmovdqu	3712(%rsi), %ymm4
        vmovdqu	2688(%rdx), %ymm8
        vmovdqu	3712(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 640(%rdi)
        # 168..175
        vmovdqu	672(%rsi), %ymm0
        vmovdqu	1696(%rsi), %ymm2
        vmovdqu	672(%rdx), %ymm6
        vmovdqu	1696(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2720(%rsi), %ymm2
        vmovdqu	3744(%rsi), %ymm4
        vmovdqu	2720(%rdx), %ymm8
        vmovdqu	3744(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 672(%rdi)
        # 176..183
        vmovdqu	704(%rsi), %ymm0
        vmovdqu	1728(%rsi), %ymm2
        vmovdqu	704(%rdx), %ymm6
        vmovdqu	1728(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2752(%rsi), %ymm2
        vmovdqu	3776(%rsi), %ymm4
        vmovdqu	2752(%rdx), %ymm8
        vmovdqu	3776(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 704(%rdi)
        # 184..191
        vmovdqu	736(%rsi), %ymm0
        vmovdqu	1760(%rsi), %ymm2
        vmovdqu	736(%rdx), %ymm6
        vmovdqu	1760(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2784(%rsi), %ymm2
        vmovdqu	3808(%rsi), %ymm4
        vmovdqu	2784(%rdx), %ymm8
        vmovdqu	3808(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 736(%rdi)
        # 192..199
        vmovdqu	768(%rsi), %ymm0
        vmovdqu	1792(%rsi), %ymm2
        vmovdqu	768(%rdx), %ymm6
        vmovdqu	1792(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2816(%rsi), %ymm2
        vmovdqu	3840(%rsi), %ymm4
        vmovdqu	2816(%rdx), %ymm8
        vmovdqu	3840(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 768(%rdi)
        # 200..207
        vmovdqu	800(%rsi), %ymm0
        vmovdqu	1824(%rsi), %ymm2
        vmovdqu	800(%rdx), %ymm6
        vmovdqu	1824(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2848(%rsi), %ymm2
        vmovdqu	3872(%rsi), %ymm4
        vmovdqu	2848(%rdx), %ymm8
        vmovdqu	3872(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 800(%rdi)
        # 208..215
        vmovdqu	832(%rsi), %ymm0
        vmovdqu	1856(%rsi), %ymm2
        vmovdqu	832(%rdx), %ymm6
        vmovdqu	1856(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2880(%rsi), %ymm2
        vmovdqu	3904(%rsi), %ymm4
        vmovdqu	2880(%rdx), %ymm8
        vmovdqu	3904(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 832(%rdi)
        # 216..223
        vmovdqu	864(%rsi), %ymm0
        vmovdqu	1888(%rsi), %ymm2
        vmovdqu	864(%rdx), %ymm6
        vmovdqu	1888(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2912(%rsi), %ymm2
        vmovdqu	3936(%rsi), %ymm4
        vmovdqu	2912(%rdx), %ymm8
        vmovdqu	3936(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 864(%rdi)
        # 224..231
        vmovdqu	896(%rsi), %ymm0
        vmovdqu	1920(%rsi), %ymm2
        vmovdqu	896(%rdx), %ymm6
        vmovdqu	1920(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2944(%rsi), %ymm2
        vmovdqu	3968(%rsi), %ymm4
        vmovdqu	2944(%rdx), %ymm8
        vmovdqu	3968(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 896(%rdi)
        # 232..239
        vmovdqu	928(%rsi), %ymm0
        vmovdqu	1952(%rsi), %ymm2
        vmovdqu	928(%rdx), %ymm6
        vmovdqu	1952(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	2976(%rsi), %ymm2
        vmovdqu	4000(%rsi), %ymm4
        vmovdqu	2976(%rdx), %ymm8
        vmovdqu	4000(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 928(%rdi)
        # 240..247
        vmovdqu	960(%rsi), %ymm0
        vmovdqu	1984(%rsi), %ymm2
        vmovdqu	960(%rdx), %ymm6
        vmovdqu	1984(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	3008(%rsi), %ymm2
        vmovdqu	4032(%rsi), %ymm4
        vmovdqu	3008(%rdx), %ymm8
        vmovdqu	4032(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 960(%rdi)
        # 248..255
        vmovdqu	992(%rsi), %ymm0
        vmovdqu	2016(%rsi), %ymm2
        vmovdqu	992(%rdx), %ymm6
        vmovdqu	2016(%rdx), %ymm8
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vmovdqu	3040(%rsi), %ymm2
        vmovdqu	4064(%rsi), %ymm4
        vmovdqu	3040(%rdx), %ymm8
        vmovdqu	4064(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 992(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_mul_vec_4_avx2,.-wc_mldsa_mul_vec_4_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	wc_mldsa_mul_vec_5_avx2
.type	wc_mldsa_mul_vec_5_avx2,@function
.align	16
wc_mldsa_mul_vec_5_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_mul_vec_5_avx2
.p2align	4
_wc_mldsa_mul_vec_5_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm12, %ymm12, %ymm12
        vmovdqu	mldsa_q(%rip), %ymm12
        vmovdqu	mldsa_qinv(%rip), %ymm13
        # 0..7
        vmovdqu	(%rsi), %ymm0
        vmovdqu	1024(%rsi), %ymm2
        vmovdqu	2048(%rsi), %ymm4
        vmovdqu	(%rdx), %ymm6
        vmovdqu	1024(%rdx), %ymm8
        vmovdqu	2048(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3072(%rsi), %ymm2
        vmovdqu	4096(%rsi), %ymm4
        vmovdqu	3072(%rdx), %ymm8
        vmovdqu	4096(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, (%rdi)
        # 8..15
        vmovdqu	32(%rsi), %ymm0
        vmovdqu	1056(%rsi), %ymm2
        vmovdqu	2080(%rsi), %ymm4
        vmovdqu	32(%rdx), %ymm6
        vmovdqu	1056(%rdx), %ymm8
        vmovdqu	2080(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3104(%rsi), %ymm2
        vmovdqu	4128(%rsi), %ymm4
        vmovdqu	3104(%rdx), %ymm8
        vmovdqu	4128(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 32(%rdi)
        # 16..23
        vmovdqu	64(%rsi), %ymm0
        vmovdqu	1088(%rsi), %ymm2
        vmovdqu	2112(%rsi), %ymm4
        vmovdqu	64(%rdx), %ymm6
        vmovdqu	1088(%rdx), %ymm8
        vmovdqu	2112(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3136(%rsi), %ymm2
        vmovdqu	4160(%rsi), %ymm4
        vmovdqu	3136(%rdx), %ymm8
        vmovdqu	4160(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 64(%rdi)
        # 24..31
        vmovdqu	96(%rsi), %ymm0
        vmovdqu	1120(%rsi), %ymm2
        vmovdqu	2144(%rsi), %ymm4
        vmovdqu	96(%rdx), %ymm6
        vmovdqu	1120(%rdx), %ymm8
        vmovdqu	2144(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3168(%rsi), %ymm2
        vmovdqu	4192(%rsi), %ymm4
        vmovdqu	3168(%rdx), %ymm8
        vmovdqu	4192(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 96(%rdi)
        # 32..39
        vmovdqu	128(%rsi), %ymm0
        vmovdqu	1152(%rsi), %ymm2
        vmovdqu	2176(%rsi), %ymm4
        vmovdqu	128(%rdx), %ymm6
        vmovdqu	1152(%rdx), %ymm8
        vmovdqu	2176(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3200(%rsi), %ymm2
        vmovdqu	4224(%rsi), %ymm4
        vmovdqu	3200(%rdx), %ymm8
        vmovdqu	4224(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 128(%rdi)
        # 40..47
        vmovdqu	160(%rsi), %ymm0
        vmovdqu	1184(%rsi), %ymm2
        vmovdqu	2208(%rsi), %ymm4
        vmovdqu	160(%rdx), %ymm6
        vmovdqu	1184(%rdx), %ymm8
        vmovdqu	2208(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3232(%rsi), %ymm2
        vmovdqu	4256(%rsi), %ymm4
        vmovdqu	3232(%rdx), %ymm8
        vmovdqu	4256(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 160(%rdi)
        # 48..55
        vmovdqu	192(%rsi), %ymm0
        vmovdqu	1216(%rsi), %ymm2
        vmovdqu	2240(%rsi), %ymm4
        vmovdqu	192(%rdx), %ymm6
        vmovdqu	1216(%rdx), %ymm8
        vmovdqu	2240(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3264(%rsi), %ymm2
        vmovdqu	4288(%rsi), %ymm4
        vmovdqu	3264(%rdx), %ymm8
        vmovdqu	4288(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 192(%rdi)
        # 56..63
        vmovdqu	224(%rsi), %ymm0
        vmovdqu	1248(%rsi), %ymm2
        vmovdqu	2272(%rsi), %ymm4
        vmovdqu	224(%rdx), %ymm6
        vmovdqu	1248(%rdx), %ymm8
        vmovdqu	2272(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3296(%rsi), %ymm2
        vmovdqu	4320(%rsi), %ymm4
        vmovdqu	3296(%rdx), %ymm8
        vmovdqu	4320(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 224(%rdi)
        # 64..71
        vmovdqu	256(%rsi), %ymm0
        vmovdqu	1280(%rsi), %ymm2
        vmovdqu	2304(%rsi), %ymm4
        vmovdqu	256(%rdx), %ymm6
        vmovdqu	1280(%rdx), %ymm8
        vmovdqu	2304(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3328(%rsi), %ymm2
        vmovdqu	4352(%rsi), %ymm4
        vmovdqu	3328(%rdx), %ymm8
        vmovdqu	4352(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 256(%rdi)
        # 72..79
        vmovdqu	288(%rsi), %ymm0
        vmovdqu	1312(%rsi), %ymm2
        vmovdqu	2336(%rsi), %ymm4
        vmovdqu	288(%rdx), %ymm6
        vmovdqu	1312(%rdx), %ymm8
        vmovdqu	2336(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3360(%rsi), %ymm2
        vmovdqu	4384(%rsi), %ymm4
        vmovdqu	3360(%rdx), %ymm8
        vmovdqu	4384(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 288(%rdi)
        # 80..87
        vmovdqu	320(%rsi), %ymm0
        vmovdqu	1344(%rsi), %ymm2
        vmovdqu	2368(%rsi), %ymm4
        vmovdqu	320(%rdx), %ymm6
        vmovdqu	1344(%rdx), %ymm8
        vmovdqu	2368(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3392(%rsi), %ymm2
        vmovdqu	4416(%rsi), %ymm4
        vmovdqu	3392(%rdx), %ymm8
        vmovdqu	4416(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 320(%rdi)
        # 88..95
        vmovdqu	352(%rsi), %ymm0
        vmovdqu	1376(%rsi), %ymm2
        vmovdqu	2400(%rsi), %ymm4
        vmovdqu	352(%rdx), %ymm6
        vmovdqu	1376(%rdx), %ymm8
        vmovdqu	2400(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3424(%rsi), %ymm2
        vmovdqu	4448(%rsi), %ymm4
        vmovdqu	3424(%rdx), %ymm8
        vmovdqu	4448(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 352(%rdi)
        # 96..103
        vmovdqu	384(%rsi), %ymm0
        vmovdqu	1408(%rsi), %ymm2
        vmovdqu	2432(%rsi), %ymm4
        vmovdqu	384(%rdx), %ymm6
        vmovdqu	1408(%rdx), %ymm8
        vmovdqu	2432(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3456(%rsi), %ymm2
        vmovdqu	4480(%rsi), %ymm4
        vmovdqu	3456(%rdx), %ymm8
        vmovdqu	4480(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 384(%rdi)
        # 104..111
        vmovdqu	416(%rsi), %ymm0
        vmovdqu	1440(%rsi), %ymm2
        vmovdqu	2464(%rsi), %ymm4
        vmovdqu	416(%rdx), %ymm6
        vmovdqu	1440(%rdx), %ymm8
        vmovdqu	2464(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3488(%rsi), %ymm2
        vmovdqu	4512(%rsi), %ymm4
        vmovdqu	3488(%rdx), %ymm8
        vmovdqu	4512(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 416(%rdi)
        # 112..119
        vmovdqu	448(%rsi), %ymm0
        vmovdqu	1472(%rsi), %ymm2
        vmovdqu	2496(%rsi), %ymm4
        vmovdqu	448(%rdx), %ymm6
        vmovdqu	1472(%rdx), %ymm8
        vmovdqu	2496(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3520(%rsi), %ymm2
        vmovdqu	4544(%rsi), %ymm4
        vmovdqu	3520(%rdx), %ymm8
        vmovdqu	4544(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 448(%rdi)
        # 120..127
        vmovdqu	480(%rsi), %ymm0
        vmovdqu	1504(%rsi), %ymm2
        vmovdqu	2528(%rsi), %ymm4
        vmovdqu	480(%rdx), %ymm6
        vmovdqu	1504(%rdx), %ymm8
        vmovdqu	2528(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3552(%rsi), %ymm2
        vmovdqu	4576(%rsi), %ymm4
        vmovdqu	3552(%rdx), %ymm8
        vmovdqu	4576(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 480(%rdi)
        # 128..135
        vmovdqu	512(%rsi), %ymm0
        vmovdqu	1536(%rsi), %ymm2
        vmovdqu	2560(%rsi), %ymm4
        vmovdqu	512(%rdx), %ymm6
        vmovdqu	1536(%rdx), %ymm8
        vmovdqu	2560(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3584(%rsi), %ymm2
        vmovdqu	4608(%rsi), %ymm4
        vmovdqu	3584(%rdx), %ymm8
        vmovdqu	4608(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 512(%rdi)
        # 136..143
        vmovdqu	544(%rsi), %ymm0
        vmovdqu	1568(%rsi), %ymm2
        vmovdqu	2592(%rsi), %ymm4
        vmovdqu	544(%rdx), %ymm6
        vmovdqu	1568(%rdx), %ymm8
        vmovdqu	2592(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3616(%rsi), %ymm2
        vmovdqu	4640(%rsi), %ymm4
        vmovdqu	3616(%rdx), %ymm8
        vmovdqu	4640(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 544(%rdi)
        # 144..151
        vmovdqu	576(%rsi), %ymm0
        vmovdqu	1600(%rsi), %ymm2
        vmovdqu	2624(%rsi), %ymm4
        vmovdqu	576(%rdx), %ymm6
        vmovdqu	1600(%rdx), %ymm8
        vmovdqu	2624(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3648(%rsi), %ymm2
        vmovdqu	4672(%rsi), %ymm4
        vmovdqu	3648(%rdx), %ymm8
        vmovdqu	4672(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 576(%rdi)
        # 152..159
        vmovdqu	608(%rsi), %ymm0
        vmovdqu	1632(%rsi), %ymm2
        vmovdqu	2656(%rsi), %ymm4
        vmovdqu	608(%rdx), %ymm6
        vmovdqu	1632(%rdx), %ymm8
        vmovdqu	2656(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3680(%rsi), %ymm2
        vmovdqu	4704(%rsi), %ymm4
        vmovdqu	3680(%rdx), %ymm8
        vmovdqu	4704(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 608(%rdi)
        # 160..167
        vmovdqu	640(%rsi), %ymm0
        vmovdqu	1664(%rsi), %ymm2
        vmovdqu	2688(%rsi), %ymm4
        vmovdqu	640(%rdx), %ymm6
        vmovdqu	1664(%rdx), %ymm8
        vmovdqu	2688(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3712(%rsi), %ymm2
        vmovdqu	4736(%rsi), %ymm4
        vmovdqu	3712(%rdx), %ymm8
        vmovdqu	4736(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 640(%rdi)
        # 168..175
        vmovdqu	672(%rsi), %ymm0
        vmovdqu	1696(%rsi), %ymm2
        vmovdqu	2720(%rsi), %ymm4
        vmovdqu	672(%rdx), %ymm6
        vmovdqu	1696(%rdx), %ymm8
        vmovdqu	2720(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3744(%rsi), %ymm2
        vmovdqu	4768(%rsi), %ymm4
        vmovdqu	3744(%rdx), %ymm8
        vmovdqu	4768(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 672(%rdi)
        # 176..183
        vmovdqu	704(%rsi), %ymm0
        vmovdqu	1728(%rsi), %ymm2
        vmovdqu	2752(%rsi), %ymm4
        vmovdqu	704(%rdx), %ymm6
        vmovdqu	1728(%rdx), %ymm8
        vmovdqu	2752(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3776(%rsi), %ymm2
        vmovdqu	4800(%rsi), %ymm4
        vmovdqu	3776(%rdx), %ymm8
        vmovdqu	4800(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 704(%rdi)
        # 184..191
        vmovdqu	736(%rsi), %ymm0
        vmovdqu	1760(%rsi), %ymm2
        vmovdqu	2784(%rsi), %ymm4
        vmovdqu	736(%rdx), %ymm6
        vmovdqu	1760(%rdx), %ymm8
        vmovdqu	2784(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3808(%rsi), %ymm2
        vmovdqu	4832(%rsi), %ymm4
        vmovdqu	3808(%rdx), %ymm8
        vmovdqu	4832(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 736(%rdi)
        # 192..199
        vmovdqu	768(%rsi), %ymm0
        vmovdqu	1792(%rsi), %ymm2
        vmovdqu	2816(%rsi), %ymm4
        vmovdqu	768(%rdx), %ymm6
        vmovdqu	1792(%rdx), %ymm8
        vmovdqu	2816(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3840(%rsi), %ymm2
        vmovdqu	4864(%rsi), %ymm4
        vmovdqu	3840(%rdx), %ymm8
        vmovdqu	4864(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 768(%rdi)
        # 200..207
        vmovdqu	800(%rsi), %ymm0
        vmovdqu	1824(%rsi), %ymm2
        vmovdqu	2848(%rsi), %ymm4
        vmovdqu	800(%rdx), %ymm6
        vmovdqu	1824(%rdx), %ymm8
        vmovdqu	2848(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3872(%rsi), %ymm2
        vmovdqu	4896(%rsi), %ymm4
        vmovdqu	3872(%rdx), %ymm8
        vmovdqu	4896(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 800(%rdi)
        # 208..215
        vmovdqu	832(%rsi), %ymm0
        vmovdqu	1856(%rsi), %ymm2
        vmovdqu	2880(%rsi), %ymm4
        vmovdqu	832(%rdx), %ymm6
        vmovdqu	1856(%rdx), %ymm8
        vmovdqu	2880(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3904(%rsi), %ymm2
        vmovdqu	4928(%rsi), %ymm4
        vmovdqu	3904(%rdx), %ymm8
        vmovdqu	4928(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 832(%rdi)
        # 216..223
        vmovdqu	864(%rsi), %ymm0
        vmovdqu	1888(%rsi), %ymm2
        vmovdqu	2912(%rsi), %ymm4
        vmovdqu	864(%rdx), %ymm6
        vmovdqu	1888(%rdx), %ymm8
        vmovdqu	2912(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3936(%rsi), %ymm2
        vmovdqu	4960(%rsi), %ymm4
        vmovdqu	3936(%rdx), %ymm8
        vmovdqu	4960(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 864(%rdi)
        # 224..231
        vmovdqu	896(%rsi), %ymm0
        vmovdqu	1920(%rsi), %ymm2
        vmovdqu	2944(%rsi), %ymm4
        vmovdqu	896(%rdx), %ymm6
        vmovdqu	1920(%rdx), %ymm8
        vmovdqu	2944(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3968(%rsi), %ymm2
        vmovdqu	4992(%rsi), %ymm4
        vmovdqu	3968(%rdx), %ymm8
        vmovdqu	4992(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 896(%rdi)
        # 232..239
        vmovdqu	928(%rsi), %ymm0
        vmovdqu	1952(%rsi), %ymm2
        vmovdqu	2976(%rsi), %ymm4
        vmovdqu	928(%rdx), %ymm6
        vmovdqu	1952(%rdx), %ymm8
        vmovdqu	2976(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	4000(%rsi), %ymm2
        vmovdqu	5024(%rsi), %ymm4
        vmovdqu	4000(%rdx), %ymm8
        vmovdqu	5024(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 928(%rdi)
        # 240..247
        vmovdqu	960(%rsi), %ymm0
        vmovdqu	1984(%rsi), %ymm2
        vmovdqu	3008(%rsi), %ymm4
        vmovdqu	960(%rdx), %ymm6
        vmovdqu	1984(%rdx), %ymm8
        vmovdqu	3008(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	4032(%rsi), %ymm2
        vmovdqu	5056(%rsi), %ymm4
        vmovdqu	4032(%rdx), %ymm8
        vmovdqu	5056(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 960(%rdi)
        # 248..255
        vmovdqu	992(%rsi), %ymm0
        vmovdqu	2016(%rsi), %ymm2
        vmovdqu	3040(%rsi), %ymm4
        vmovdqu	992(%rdx), %ymm6
        vmovdqu	2016(%rdx), %ymm8
        vmovdqu	3040(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	4064(%rsi), %ymm2
        vmovdqu	5088(%rsi), %ymm4
        vmovdqu	4064(%rdx), %ymm8
        vmovdqu	5088(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 992(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_mul_vec_5_avx2,.-wc_mldsa_mul_vec_5_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	wc_mldsa_mul_vec_7_avx2
.type	wc_mldsa_mul_vec_7_avx2,@function
.align	16
wc_mldsa_mul_vec_7_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_mul_vec_7_avx2
.p2align	4
_wc_mldsa_mul_vec_7_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm12, %ymm12, %ymm12
        vmovdqu	mldsa_q(%rip), %ymm12
        vmovdqu	mldsa_qinv(%rip), %ymm13
        # 0..7
        vmovdqu	(%rsi), %ymm0
        vmovdqu	1024(%rsi), %ymm2
        vmovdqu	2048(%rsi), %ymm4
        vmovdqu	(%rdx), %ymm6
        vmovdqu	1024(%rdx), %ymm8
        vmovdqu	2048(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3072(%rsi), %ymm2
        vmovdqu	4096(%rsi), %ymm4
        vmovdqu	3072(%rdx), %ymm8
        vmovdqu	4096(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5120(%rsi), %ymm2
        vmovdqu	6144(%rsi), %ymm4
        vmovdqu	5120(%rdx), %ymm8
        vmovdqu	6144(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, (%rdi)
        # 8..15
        vmovdqu	32(%rsi), %ymm0
        vmovdqu	1056(%rsi), %ymm2
        vmovdqu	2080(%rsi), %ymm4
        vmovdqu	32(%rdx), %ymm6
        vmovdqu	1056(%rdx), %ymm8
        vmovdqu	2080(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3104(%rsi), %ymm2
        vmovdqu	4128(%rsi), %ymm4
        vmovdqu	3104(%rdx), %ymm8
        vmovdqu	4128(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5152(%rsi), %ymm2
        vmovdqu	6176(%rsi), %ymm4
        vmovdqu	5152(%rdx), %ymm8
        vmovdqu	6176(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 32(%rdi)
        # 16..23
        vmovdqu	64(%rsi), %ymm0
        vmovdqu	1088(%rsi), %ymm2
        vmovdqu	2112(%rsi), %ymm4
        vmovdqu	64(%rdx), %ymm6
        vmovdqu	1088(%rdx), %ymm8
        vmovdqu	2112(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3136(%rsi), %ymm2
        vmovdqu	4160(%rsi), %ymm4
        vmovdqu	3136(%rdx), %ymm8
        vmovdqu	4160(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5184(%rsi), %ymm2
        vmovdqu	6208(%rsi), %ymm4
        vmovdqu	5184(%rdx), %ymm8
        vmovdqu	6208(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 64(%rdi)
        # 24..31
        vmovdqu	96(%rsi), %ymm0
        vmovdqu	1120(%rsi), %ymm2
        vmovdqu	2144(%rsi), %ymm4
        vmovdqu	96(%rdx), %ymm6
        vmovdqu	1120(%rdx), %ymm8
        vmovdqu	2144(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3168(%rsi), %ymm2
        vmovdqu	4192(%rsi), %ymm4
        vmovdqu	3168(%rdx), %ymm8
        vmovdqu	4192(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5216(%rsi), %ymm2
        vmovdqu	6240(%rsi), %ymm4
        vmovdqu	5216(%rdx), %ymm8
        vmovdqu	6240(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 96(%rdi)
        # 32..39
        vmovdqu	128(%rsi), %ymm0
        vmovdqu	1152(%rsi), %ymm2
        vmovdqu	2176(%rsi), %ymm4
        vmovdqu	128(%rdx), %ymm6
        vmovdqu	1152(%rdx), %ymm8
        vmovdqu	2176(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3200(%rsi), %ymm2
        vmovdqu	4224(%rsi), %ymm4
        vmovdqu	3200(%rdx), %ymm8
        vmovdqu	4224(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5248(%rsi), %ymm2
        vmovdqu	6272(%rsi), %ymm4
        vmovdqu	5248(%rdx), %ymm8
        vmovdqu	6272(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 128(%rdi)
        # 40..47
        vmovdqu	160(%rsi), %ymm0
        vmovdqu	1184(%rsi), %ymm2
        vmovdqu	2208(%rsi), %ymm4
        vmovdqu	160(%rdx), %ymm6
        vmovdqu	1184(%rdx), %ymm8
        vmovdqu	2208(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3232(%rsi), %ymm2
        vmovdqu	4256(%rsi), %ymm4
        vmovdqu	3232(%rdx), %ymm8
        vmovdqu	4256(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5280(%rsi), %ymm2
        vmovdqu	6304(%rsi), %ymm4
        vmovdqu	5280(%rdx), %ymm8
        vmovdqu	6304(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 160(%rdi)
        # 48..55
        vmovdqu	192(%rsi), %ymm0
        vmovdqu	1216(%rsi), %ymm2
        vmovdqu	2240(%rsi), %ymm4
        vmovdqu	192(%rdx), %ymm6
        vmovdqu	1216(%rdx), %ymm8
        vmovdqu	2240(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3264(%rsi), %ymm2
        vmovdqu	4288(%rsi), %ymm4
        vmovdqu	3264(%rdx), %ymm8
        vmovdqu	4288(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5312(%rsi), %ymm2
        vmovdqu	6336(%rsi), %ymm4
        vmovdqu	5312(%rdx), %ymm8
        vmovdqu	6336(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 192(%rdi)
        # 56..63
        vmovdqu	224(%rsi), %ymm0
        vmovdqu	1248(%rsi), %ymm2
        vmovdqu	2272(%rsi), %ymm4
        vmovdqu	224(%rdx), %ymm6
        vmovdqu	1248(%rdx), %ymm8
        vmovdqu	2272(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3296(%rsi), %ymm2
        vmovdqu	4320(%rsi), %ymm4
        vmovdqu	3296(%rdx), %ymm8
        vmovdqu	4320(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5344(%rsi), %ymm2
        vmovdqu	6368(%rsi), %ymm4
        vmovdqu	5344(%rdx), %ymm8
        vmovdqu	6368(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 224(%rdi)
        # 64..71
        vmovdqu	256(%rsi), %ymm0
        vmovdqu	1280(%rsi), %ymm2
        vmovdqu	2304(%rsi), %ymm4
        vmovdqu	256(%rdx), %ymm6
        vmovdqu	1280(%rdx), %ymm8
        vmovdqu	2304(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3328(%rsi), %ymm2
        vmovdqu	4352(%rsi), %ymm4
        vmovdqu	3328(%rdx), %ymm8
        vmovdqu	4352(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5376(%rsi), %ymm2
        vmovdqu	6400(%rsi), %ymm4
        vmovdqu	5376(%rdx), %ymm8
        vmovdqu	6400(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 256(%rdi)
        # 72..79
        vmovdqu	288(%rsi), %ymm0
        vmovdqu	1312(%rsi), %ymm2
        vmovdqu	2336(%rsi), %ymm4
        vmovdqu	288(%rdx), %ymm6
        vmovdqu	1312(%rdx), %ymm8
        vmovdqu	2336(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3360(%rsi), %ymm2
        vmovdqu	4384(%rsi), %ymm4
        vmovdqu	3360(%rdx), %ymm8
        vmovdqu	4384(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5408(%rsi), %ymm2
        vmovdqu	6432(%rsi), %ymm4
        vmovdqu	5408(%rdx), %ymm8
        vmovdqu	6432(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 288(%rdi)
        # 80..87
        vmovdqu	320(%rsi), %ymm0
        vmovdqu	1344(%rsi), %ymm2
        vmovdqu	2368(%rsi), %ymm4
        vmovdqu	320(%rdx), %ymm6
        vmovdqu	1344(%rdx), %ymm8
        vmovdqu	2368(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3392(%rsi), %ymm2
        vmovdqu	4416(%rsi), %ymm4
        vmovdqu	3392(%rdx), %ymm8
        vmovdqu	4416(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5440(%rsi), %ymm2
        vmovdqu	6464(%rsi), %ymm4
        vmovdqu	5440(%rdx), %ymm8
        vmovdqu	6464(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 320(%rdi)
        # 88..95
        vmovdqu	352(%rsi), %ymm0
        vmovdqu	1376(%rsi), %ymm2
        vmovdqu	2400(%rsi), %ymm4
        vmovdqu	352(%rdx), %ymm6
        vmovdqu	1376(%rdx), %ymm8
        vmovdqu	2400(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3424(%rsi), %ymm2
        vmovdqu	4448(%rsi), %ymm4
        vmovdqu	3424(%rdx), %ymm8
        vmovdqu	4448(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5472(%rsi), %ymm2
        vmovdqu	6496(%rsi), %ymm4
        vmovdqu	5472(%rdx), %ymm8
        vmovdqu	6496(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 352(%rdi)
        # 96..103
        vmovdqu	384(%rsi), %ymm0
        vmovdqu	1408(%rsi), %ymm2
        vmovdqu	2432(%rsi), %ymm4
        vmovdqu	384(%rdx), %ymm6
        vmovdqu	1408(%rdx), %ymm8
        vmovdqu	2432(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3456(%rsi), %ymm2
        vmovdqu	4480(%rsi), %ymm4
        vmovdqu	3456(%rdx), %ymm8
        vmovdqu	4480(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5504(%rsi), %ymm2
        vmovdqu	6528(%rsi), %ymm4
        vmovdqu	5504(%rdx), %ymm8
        vmovdqu	6528(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 384(%rdi)
        # 104..111
        vmovdqu	416(%rsi), %ymm0
        vmovdqu	1440(%rsi), %ymm2
        vmovdqu	2464(%rsi), %ymm4
        vmovdqu	416(%rdx), %ymm6
        vmovdqu	1440(%rdx), %ymm8
        vmovdqu	2464(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3488(%rsi), %ymm2
        vmovdqu	4512(%rsi), %ymm4
        vmovdqu	3488(%rdx), %ymm8
        vmovdqu	4512(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5536(%rsi), %ymm2
        vmovdqu	6560(%rsi), %ymm4
        vmovdqu	5536(%rdx), %ymm8
        vmovdqu	6560(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 416(%rdi)
        # 112..119
        vmovdqu	448(%rsi), %ymm0
        vmovdqu	1472(%rsi), %ymm2
        vmovdqu	2496(%rsi), %ymm4
        vmovdqu	448(%rdx), %ymm6
        vmovdqu	1472(%rdx), %ymm8
        vmovdqu	2496(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3520(%rsi), %ymm2
        vmovdqu	4544(%rsi), %ymm4
        vmovdqu	3520(%rdx), %ymm8
        vmovdqu	4544(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5568(%rsi), %ymm2
        vmovdqu	6592(%rsi), %ymm4
        vmovdqu	5568(%rdx), %ymm8
        vmovdqu	6592(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 448(%rdi)
        # 120..127
        vmovdqu	480(%rsi), %ymm0
        vmovdqu	1504(%rsi), %ymm2
        vmovdqu	2528(%rsi), %ymm4
        vmovdqu	480(%rdx), %ymm6
        vmovdqu	1504(%rdx), %ymm8
        vmovdqu	2528(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3552(%rsi), %ymm2
        vmovdqu	4576(%rsi), %ymm4
        vmovdqu	3552(%rdx), %ymm8
        vmovdqu	4576(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5600(%rsi), %ymm2
        vmovdqu	6624(%rsi), %ymm4
        vmovdqu	5600(%rdx), %ymm8
        vmovdqu	6624(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 480(%rdi)
        # 128..135
        vmovdqu	512(%rsi), %ymm0
        vmovdqu	1536(%rsi), %ymm2
        vmovdqu	2560(%rsi), %ymm4
        vmovdqu	512(%rdx), %ymm6
        vmovdqu	1536(%rdx), %ymm8
        vmovdqu	2560(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3584(%rsi), %ymm2
        vmovdqu	4608(%rsi), %ymm4
        vmovdqu	3584(%rdx), %ymm8
        vmovdqu	4608(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5632(%rsi), %ymm2
        vmovdqu	6656(%rsi), %ymm4
        vmovdqu	5632(%rdx), %ymm8
        vmovdqu	6656(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 512(%rdi)
        # 136..143
        vmovdqu	544(%rsi), %ymm0
        vmovdqu	1568(%rsi), %ymm2
        vmovdqu	2592(%rsi), %ymm4
        vmovdqu	544(%rdx), %ymm6
        vmovdqu	1568(%rdx), %ymm8
        vmovdqu	2592(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3616(%rsi), %ymm2
        vmovdqu	4640(%rsi), %ymm4
        vmovdqu	3616(%rdx), %ymm8
        vmovdqu	4640(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5664(%rsi), %ymm2
        vmovdqu	6688(%rsi), %ymm4
        vmovdqu	5664(%rdx), %ymm8
        vmovdqu	6688(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 544(%rdi)
        # 144..151
        vmovdqu	576(%rsi), %ymm0
        vmovdqu	1600(%rsi), %ymm2
        vmovdqu	2624(%rsi), %ymm4
        vmovdqu	576(%rdx), %ymm6
        vmovdqu	1600(%rdx), %ymm8
        vmovdqu	2624(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3648(%rsi), %ymm2
        vmovdqu	4672(%rsi), %ymm4
        vmovdqu	3648(%rdx), %ymm8
        vmovdqu	4672(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5696(%rsi), %ymm2
        vmovdqu	6720(%rsi), %ymm4
        vmovdqu	5696(%rdx), %ymm8
        vmovdqu	6720(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 576(%rdi)
        # 152..159
        vmovdqu	608(%rsi), %ymm0
        vmovdqu	1632(%rsi), %ymm2
        vmovdqu	2656(%rsi), %ymm4
        vmovdqu	608(%rdx), %ymm6
        vmovdqu	1632(%rdx), %ymm8
        vmovdqu	2656(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3680(%rsi), %ymm2
        vmovdqu	4704(%rsi), %ymm4
        vmovdqu	3680(%rdx), %ymm8
        vmovdqu	4704(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5728(%rsi), %ymm2
        vmovdqu	6752(%rsi), %ymm4
        vmovdqu	5728(%rdx), %ymm8
        vmovdqu	6752(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 608(%rdi)
        # 160..167
        vmovdqu	640(%rsi), %ymm0
        vmovdqu	1664(%rsi), %ymm2
        vmovdqu	2688(%rsi), %ymm4
        vmovdqu	640(%rdx), %ymm6
        vmovdqu	1664(%rdx), %ymm8
        vmovdqu	2688(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3712(%rsi), %ymm2
        vmovdqu	4736(%rsi), %ymm4
        vmovdqu	3712(%rdx), %ymm8
        vmovdqu	4736(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5760(%rsi), %ymm2
        vmovdqu	6784(%rsi), %ymm4
        vmovdqu	5760(%rdx), %ymm8
        vmovdqu	6784(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 640(%rdi)
        # 168..175
        vmovdqu	672(%rsi), %ymm0
        vmovdqu	1696(%rsi), %ymm2
        vmovdqu	2720(%rsi), %ymm4
        vmovdqu	672(%rdx), %ymm6
        vmovdqu	1696(%rdx), %ymm8
        vmovdqu	2720(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3744(%rsi), %ymm2
        vmovdqu	4768(%rsi), %ymm4
        vmovdqu	3744(%rdx), %ymm8
        vmovdqu	4768(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5792(%rsi), %ymm2
        vmovdqu	6816(%rsi), %ymm4
        vmovdqu	5792(%rdx), %ymm8
        vmovdqu	6816(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 672(%rdi)
        # 176..183
        vmovdqu	704(%rsi), %ymm0
        vmovdqu	1728(%rsi), %ymm2
        vmovdqu	2752(%rsi), %ymm4
        vmovdqu	704(%rdx), %ymm6
        vmovdqu	1728(%rdx), %ymm8
        vmovdqu	2752(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3776(%rsi), %ymm2
        vmovdqu	4800(%rsi), %ymm4
        vmovdqu	3776(%rdx), %ymm8
        vmovdqu	4800(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5824(%rsi), %ymm2
        vmovdqu	6848(%rsi), %ymm4
        vmovdqu	5824(%rdx), %ymm8
        vmovdqu	6848(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 704(%rdi)
        # 184..191
        vmovdqu	736(%rsi), %ymm0
        vmovdqu	1760(%rsi), %ymm2
        vmovdqu	2784(%rsi), %ymm4
        vmovdqu	736(%rdx), %ymm6
        vmovdqu	1760(%rdx), %ymm8
        vmovdqu	2784(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3808(%rsi), %ymm2
        vmovdqu	4832(%rsi), %ymm4
        vmovdqu	3808(%rdx), %ymm8
        vmovdqu	4832(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5856(%rsi), %ymm2
        vmovdqu	6880(%rsi), %ymm4
        vmovdqu	5856(%rdx), %ymm8
        vmovdqu	6880(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 736(%rdi)
        # 192..199
        vmovdqu	768(%rsi), %ymm0
        vmovdqu	1792(%rsi), %ymm2
        vmovdqu	2816(%rsi), %ymm4
        vmovdqu	768(%rdx), %ymm6
        vmovdqu	1792(%rdx), %ymm8
        vmovdqu	2816(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3840(%rsi), %ymm2
        vmovdqu	4864(%rsi), %ymm4
        vmovdqu	3840(%rdx), %ymm8
        vmovdqu	4864(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5888(%rsi), %ymm2
        vmovdqu	6912(%rsi), %ymm4
        vmovdqu	5888(%rdx), %ymm8
        vmovdqu	6912(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 768(%rdi)
        # 200..207
        vmovdqu	800(%rsi), %ymm0
        vmovdqu	1824(%rsi), %ymm2
        vmovdqu	2848(%rsi), %ymm4
        vmovdqu	800(%rdx), %ymm6
        vmovdqu	1824(%rdx), %ymm8
        vmovdqu	2848(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3872(%rsi), %ymm2
        vmovdqu	4896(%rsi), %ymm4
        vmovdqu	3872(%rdx), %ymm8
        vmovdqu	4896(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5920(%rsi), %ymm2
        vmovdqu	6944(%rsi), %ymm4
        vmovdqu	5920(%rdx), %ymm8
        vmovdqu	6944(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 800(%rdi)
        # 208..215
        vmovdqu	832(%rsi), %ymm0
        vmovdqu	1856(%rsi), %ymm2
        vmovdqu	2880(%rsi), %ymm4
        vmovdqu	832(%rdx), %ymm6
        vmovdqu	1856(%rdx), %ymm8
        vmovdqu	2880(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3904(%rsi), %ymm2
        vmovdqu	4928(%rsi), %ymm4
        vmovdqu	3904(%rdx), %ymm8
        vmovdqu	4928(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5952(%rsi), %ymm2
        vmovdqu	6976(%rsi), %ymm4
        vmovdqu	5952(%rdx), %ymm8
        vmovdqu	6976(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 832(%rdi)
        # 216..223
        vmovdqu	864(%rsi), %ymm0
        vmovdqu	1888(%rsi), %ymm2
        vmovdqu	2912(%rsi), %ymm4
        vmovdqu	864(%rdx), %ymm6
        vmovdqu	1888(%rdx), %ymm8
        vmovdqu	2912(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3936(%rsi), %ymm2
        vmovdqu	4960(%rsi), %ymm4
        vmovdqu	3936(%rdx), %ymm8
        vmovdqu	4960(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	5984(%rsi), %ymm2
        vmovdqu	7008(%rsi), %ymm4
        vmovdqu	5984(%rdx), %ymm8
        vmovdqu	7008(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 864(%rdi)
        # 224..231
        vmovdqu	896(%rsi), %ymm0
        vmovdqu	1920(%rsi), %ymm2
        vmovdqu	2944(%rsi), %ymm4
        vmovdqu	896(%rdx), %ymm6
        vmovdqu	1920(%rdx), %ymm8
        vmovdqu	2944(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	3968(%rsi), %ymm2
        vmovdqu	4992(%rsi), %ymm4
        vmovdqu	3968(%rdx), %ymm8
        vmovdqu	4992(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	6016(%rsi), %ymm2
        vmovdqu	7040(%rsi), %ymm4
        vmovdqu	6016(%rdx), %ymm8
        vmovdqu	7040(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 896(%rdi)
        # 232..239
        vmovdqu	928(%rsi), %ymm0
        vmovdqu	1952(%rsi), %ymm2
        vmovdqu	2976(%rsi), %ymm4
        vmovdqu	928(%rdx), %ymm6
        vmovdqu	1952(%rdx), %ymm8
        vmovdqu	2976(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	4000(%rsi), %ymm2
        vmovdqu	5024(%rsi), %ymm4
        vmovdqu	4000(%rdx), %ymm8
        vmovdqu	5024(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	6048(%rsi), %ymm2
        vmovdqu	7072(%rsi), %ymm4
        vmovdqu	6048(%rdx), %ymm8
        vmovdqu	7072(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 928(%rdi)
        # 240..247
        vmovdqu	960(%rsi), %ymm0
        vmovdqu	1984(%rsi), %ymm2
        vmovdqu	3008(%rsi), %ymm4
        vmovdqu	960(%rdx), %ymm6
        vmovdqu	1984(%rdx), %ymm8
        vmovdqu	3008(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	4032(%rsi), %ymm2
        vmovdqu	5056(%rsi), %ymm4
        vmovdqu	4032(%rdx), %ymm8
        vmovdqu	5056(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	6080(%rsi), %ymm2
        vmovdqu	7104(%rsi), %ymm4
        vmovdqu	6080(%rdx), %ymm8
        vmovdqu	7104(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 960(%rdi)
        # 248..255
        vmovdqu	992(%rsi), %ymm0
        vmovdqu	2016(%rsi), %ymm2
        vmovdqu	3040(%rsi), %ymm4
        vmovdqu	992(%rdx), %ymm6
        vmovdqu	2016(%rdx), %ymm8
        vmovdqu	3040(%rdx), %ymm10
        vpshufd	$0xf5, %ymm0, %ymm1
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm6, %ymm7
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm6, %ymm0, %ymm0
        vpmuldq	%ymm7, %ymm1, %ymm1
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	4064(%rsi), %ymm2
        vmovdqu	5088(%rsi), %ymm4
        vmovdqu	4064(%rdx), %ymm8
        vmovdqu	5088(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        vmovdqu	6112(%rsi), %ymm2
        vmovdqu	7136(%rsi), %ymm4
        vmovdqu	6112(%rdx), %ymm8
        vmovdqu	7136(%rdx), %ymm10
        vpshufd	$0xf5, %ymm2, %ymm3
        vpshufd	$0xf5, %ymm4, %ymm5
        vpshufd	$0xf5, %ymm8, %ymm9
        vpshufd	$0xf5, %ymm10, %ymm11
        vpmuldq	%ymm8, %ymm2, %ymm2
        vpmuldq	%ymm9, %ymm3, %ymm3
        vpmuldq	%ymm10, %ymm4, %ymm4
        vpmuldq	%ymm11, %ymm5, %ymm5
        vpaddq	%ymm2, %ymm0, %ymm0
        vpaddq	%ymm3, %ymm1, %ymm1
        vpaddq	%ymm4, %ymm0, %ymm0
        vpaddq	%ymm5, %ymm1, %ymm1
        # Mont Reduce 2
        vpmulld	%ymm13, %ymm0, %ymm6
        vpmulld	%ymm13, %ymm1, %ymm7
        vpmuldq	%ymm12, %ymm6, %ymm6
        vpmuldq	%ymm12, %ymm7, %ymm7
        vpsubd	%ymm6, %ymm0, %ymm0
        vpsubd	%ymm7, %ymm1, %ymm1
        vpsrlq	$32, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vmovdqu	%ymm0, 992(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_mul_vec_7_avx2,.-wc_mldsa_mul_vec_7_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_rej_idx:
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000000000001,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000000000002,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000000000002
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000000000003,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000001,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000000000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000002,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000000000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000000000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000000000004,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000000,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000001,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000000000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000002,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000000000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000000000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000002
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000003,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000000000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000001,0x0000000000000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000002,0x0000000000000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000400000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000400000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000000000004,0x0000000000000000
.quad	0x0000000000000005,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000500000000,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000500000001,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000000000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000500000002,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000000000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000000000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000500000002
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000500000003,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000000000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000001,0x0000000000000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000500000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000002,0x0000000000000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000500000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000500000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000000000005,0x0000000000000000
.quad	0x0000000500000004,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000000,0x0000000000000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000001,0x0000000000000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000500000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000002,0x0000000000000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000500000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000500000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000002
.quad	0x0000000000000005,0x0000000000000000
.quad	0x0000000400000003,0x0000000000000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000500000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000001,0x0000000500000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000003
.quad	0x0000000000000005,0x0000000000000000
.quad	0x0000000300000002,0x0000000500000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000400000003
.quad	0x0000000000000005,0x0000000000000000
.quad	0x0000000200000001,0x0000000400000003
.quad	0x0000000000000005,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000500000004,0x0000000000000000
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000600000000,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000600000001,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000600000002,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000600000002
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000600000003,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000001,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000600000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000002,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000600000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000600000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000600000004,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000000,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000001,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000600000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000002,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000600000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000600000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000002
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000400000003,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000600000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000001,0x0000000600000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000003
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000300000002,0x0000000600000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000400000003
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000200000001,0x0000000400000003
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000600000004,0x0000000000000000
.quad	0x0000000600000005,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000500000000,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000500000001,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000600000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000500000002,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000600000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000600000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000500000002
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000500000003,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000600000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000001,0x0000000600000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000500000003
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000300000002,0x0000000600000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000500000003
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000200000001,0x0000000500000003
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000600000005,0x0000000000000000
.quad	0x0000000500000004,0x0000000000000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000000,0x0000000600000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000001,0x0000000600000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000500000004
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000400000002,0x0000000600000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000500000004
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000200000001,0x0000000500000004
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000002
.quad	0x0000000600000005,0x0000000000000000
.quad	0x0000000400000003,0x0000000600000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000500000004
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000300000001,0x0000000500000004
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000003
.quad	0x0000000600000005,0x0000000000000000
.quad	0x0000000300000002,0x0000000500000004
.quad	0x0000000000000006,0x0000000000000000
.quad	0x0000000200000000,0x0000000400000003
.quad	0x0000000600000005,0x0000000000000000
.quad	0x0000000200000001,0x0000000400000003
.quad	0x0000000600000005,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000500000004,0x0000000000000006
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000700000000,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000700000001,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000700000002,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000700000002
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000700000003,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000001,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000700000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000002,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000700000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000700000003
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000700000004,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000000,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000001,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000700000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000002,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000700000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000700000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000002
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000400000003,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000700000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000001,0x0000000700000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000003
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000300000002,0x0000000700000004
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000400000003
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000200000001,0x0000000400000003
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000700000004,0x0000000000000000
.quad	0x0000000700000005,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000500000000,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000500000001,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000700000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000500000002,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000700000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000700000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000500000002
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000500000003,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000700000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000001,0x0000000700000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000500000003
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000300000002,0x0000000700000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000500000003
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000200000001,0x0000000500000003
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000700000005,0x0000000000000000
.quad	0x0000000500000004,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000000,0x0000000700000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000001,0x0000000700000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000500000004
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000400000002,0x0000000700000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000500000004
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000200000001,0x0000000500000004
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000002
.quad	0x0000000700000005,0x0000000000000000
.quad	0x0000000400000003,0x0000000700000005
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000500000004
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000300000001,0x0000000500000004
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000003
.quad	0x0000000700000005,0x0000000000000000
.quad	0x0000000300000002,0x0000000500000004
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000200000000,0x0000000400000003
.quad	0x0000000700000005,0x0000000000000000
.quad	0x0000000200000001,0x0000000400000003
.quad	0x0000000700000005,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000500000004,0x0000000000000007
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000600000000,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000600000001,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000600000002,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000001,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000600000002
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000600000003,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000001,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000600000003
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000300000002,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000600000003
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000200000001,0x0000000600000003
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000600000004,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000000,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000001,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000600000004
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000400000002,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000600000004
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000200000001,0x0000000600000004
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000002
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000400000003,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000600000004
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000300000001,0x0000000600000004
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000003
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000300000002,0x0000000600000004
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000200000000,0x0000000400000003
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000200000001,0x0000000400000003
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000600000004,0x0000000000000007
.quad	0x0000000600000005,0x0000000000000007
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000500000000,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000500000001,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000100000000,0x0000000600000005
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000500000002,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000200000000,0x0000000600000005
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000200000001,0x0000000600000005
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000100000000,0x0000000500000002
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000500000003,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000300000000,0x0000000600000005
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000300000001,0x0000000600000005
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000100000000,0x0000000500000003
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000300000002,0x0000000600000005
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000200000000,0x0000000500000003
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000200000001,0x0000000500000003
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000600000005,0x0000000000000007
.quad	0x0000000500000004,0x0000000700000006
.quad	0x0000000000000000,0x0000000000000000
.quad	0x0000000400000000,0x0000000600000005
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000400000001,0x0000000600000005
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000100000000,0x0000000500000004
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000400000002,0x0000000600000005
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000200000000,0x0000000500000004
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000200000001,0x0000000500000004
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000002
.quad	0x0000000600000005,0x0000000000000007
.quad	0x0000000400000003,0x0000000600000005
.quad	0x0000000000000007,0x0000000000000000
.quad	0x0000000300000000,0x0000000500000004
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000300000001,0x0000000500000004
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000100000000,0x0000000400000003
.quad	0x0000000600000005,0x0000000000000007
.quad	0x0000000300000002,0x0000000500000004
.quad	0x0000000700000006,0x0000000000000000
.quad	0x0000000200000000,0x0000000400000003
.quad	0x0000000600000005,0x0000000000000007
.quad	0x0000000200000001,0x0000000400000003
.quad	0x0000000600000005,0x0000000000000007
.quad	0x0000000100000000,0x0000000300000002
.quad	0x0000000500000004,0x0000000700000006
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_rej_q:
.long	0x007fe001,0x007fe001,0x007fe001,0x007fe001
.long	0x007fe001,0x007fe001,0x007fe001,0x007fe001
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_mldsa_rej_mask:
.quad	0x7fffff007fffff, 0x7fffff007fffff
.quad	0x7fffff007fffff, 0x7fffff007fffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_mldsa_rej_shuffle:
.quad	0x5040300020100, 0xb0a0900080706
.quad	0x9080700060504, 0xf0e0d000c0b0a
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	32
#else
.p2align	5
#endif /* __APPLE__ */
L_mldsa_rej_ones:
.quad	0x101010101010101, 0x101010101010101
.quad	0x101010101010101, 0x101010101010101
#ifndef __APPLE__
.text
.globl	wc_mldsa_rej_uniform_n_avx2
.type	wc_mldsa_rej_uniform_n_avx2,@function
.align	16
wc_mldsa_rej_uniform_n_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_rej_uniform_n_avx2
.p2align	4
_wc_mldsa_rej_uniform_n_avx2:
#endif /* __APPLE__ */
        pushq	%rbx
        pushq	%r12
        pushq	%r13
        pushq	%r14
        movq	%rcx, %r8
        movl	%esi, %eax
        vmovdqu	L_mldsa_rej_q(%rip), %ymm6
        vmovdqu	L_mldsa_rej_mask(%rip), %ymm7
        vmovdqu	L_mldsa_rej_shuffle(%rip), %ymm8
        vmovdqu	L_mldsa_rej_ones(%rip), %ymm9
        leaq	L_mldsa_rej_idx(%rip), %r9
        vpermq	$0x94, (%rdx), %ymm0
        vpermq	$0x94, 24(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 48(%rdx), %ymm0
        vpermq	$0x94, 72(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 96(%rdx), %ymm0
        vpermq	$0x94, 120(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 144(%rdx), %ymm0
        vpermq	$0x94, 168(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 192(%rdx), %ymm0
        vpermq	$0x94, 216(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 240(%rdx), %ymm0
        vpermq	$0x94, 264(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 288(%rdx), %ymm0
        vpermq	$0x94, 312(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 336(%rdx), %ymm0
        vpermq	$0x94, 360(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 384(%rdx), %ymm0
        vpermq	$0x94, 408(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 432(%rdx), %ymm0
        vpermq	$0x94, 456(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 480(%rdx), %ymm0
        vpermq	$0x94, 504(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 528(%rdx), %ymm0
        vpermq	$0x94, 552(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 576(%rdx), %ymm0
        vpermq	$0x94, 600(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 624(%rdx), %ymm0
        vpermq	$0x94, 648(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        vpermq	$0x94, 672(%rdx), %ymm0
        vpermq	$0x94, 696(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        addq	$0x2d0, %rdx
        subl	$0x2d0, %r8d
L_mldsa_rej_uniform_n_avx2_start_256:
        vpermq	$0x94, (%rdx), %ymm0
        vpermq	$0x94, 24(%rdx), %ymm1
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpand	%ymm7, %ymm0, %ymm0
        vpand	%ymm7, %ymm1, %ymm1
        vpcmpgtd	%ymm0, %ymm6, %ymm2
        vpcmpgtd	%ymm1, %ymm6, %ymm3
        vpackssdw	%ymm3, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpermq	$0xd8, %ymm2, %ymm2
        vpmovmskb	%ymm2, %rbx
        movzbl	%bl, %r10d
        movzbl	%bh, %ecx
        shll	$5, %r10d
        shll	$5, %ecx
        vmovdqu	(%r9,%r10,1), %ymm2
        vmovdqu	(%r9,%rcx,1), %ymm3
        vpermd	%ymm0, %ymm2, %ymm0
        vpermd	%ymm1, %ymm3, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ecx, %ecx
        vmovdqu	%ymm0, (%rdi)
        leaq	(%rdi,%r10,4), %rdi
        subl	%r10d, %esi
        vmovdqu	%ymm1, (%rdi)
        leaq	(%rdi,%rcx,4), %rdi
        subl	%ecx, %esi
        addq	$48, %rdx
        subl	$48, %r8d
        cmpl	$48, %r8d
        jl	L_mldsa_rej_uniform_n_avx2_done_256
        cmpl	$16, %esi
        jge	L_mldsa_rej_uniform_n_avx2_start_256
L_mldsa_rej_uniform_n_avx2_done_256:
        cmpl	$0x00, %esi
        je	L_mldsa_rej_uniform_n_avx2_done_64
        movq	$0xffffff00ffffff, %r14
        movq	$0x7fffff007fffff, %r13
L_mldsa_rej_uniform_n_avx2_start_64:
        movq	(%rdx), %rcx
        pdepq	%r14, %rcx, %rcx
        andq	%r13, %rcx
        cmpl	$0x7fe001, %ecx
        jge	L_mldsa_rej_uniform_0_avx2_rej_large_0
        movl	%ecx, (%rdi)
        addq	$4, %rdi
        subl	$0x01, %esi
        je	L_mldsa_rej_uniform_n_avx2_done_64
L_mldsa_rej_uniform_0_avx2_rej_large_0:
        shrq	$32, %rcx
        cmpl	$0x7fe001, %ecx
        jge	L_mldsa_rej_uniform_0_avx2_rej_large_1
        movl	%ecx, (%rdi)
        addq	$4, %rdi
        subl	$0x01, %esi
        je	L_mldsa_rej_uniform_n_avx2_done_64
L_mldsa_rej_uniform_0_avx2_rej_large_1:
        addq	$6, %rdx
        subl	$6, %r8d
        jle	L_mldsa_rej_uniform_n_avx2_done_64
        cmpl	$0x00, %esi
        jg	L_mldsa_rej_uniform_n_avx2_start_64
L_mldsa_rej_uniform_n_avx2_done_64:
        vzeroupper
        subl	%esi, %eax
        popq	%r14
        popq	%r13
        popq	%r12
        popq	%rbx
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_rej_uniform_n_avx2,.-wc_mldsa_rej_uniform_n_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	wc_mldsa_rej_uniform_avx2
.type	wc_mldsa_rej_uniform_avx2,@function
.align	16
wc_mldsa_rej_uniform_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_rej_uniform_avx2
.p2align	4
_wc_mldsa_rej_uniform_avx2:
#endif /* __APPLE__ */
        pushq	%rbx
        pushq	%r12
        pushq	%r13
        pushq	%r14
        movq	%rcx, %r8
        movl	%esi, %eax
        movq	$0xffffff00ffffff, %r14
        movq	$0x7fffff007fffff, %r13
L_mldsa_rej_uniform_avx2_start_64:
        movq	(%rdx), %rcx
        pdepq	%r14, %rcx, %rcx
        andq	%r13, %rcx
        cmpl	$0x7fe001, %ecx
        jge	L_mldsa_rej_uniform_avx2_rej_large_0
        movl	%ecx, (%rdi)
        addq	$4, %rdi
        subl	$0x01, %esi
        je	L_mldsa_rej_uniform_avx2_done_64
L_mldsa_rej_uniform_avx2_rej_large_0:
        shrq	$32, %rcx
        cmpl	$0x7fe001, %ecx
        jge	L_mldsa_rej_uniform_avx2_rej_large_1
        movl	%ecx, (%rdi)
        addq	$4, %rdi
        subl	$0x01, %esi
        je	L_mldsa_rej_uniform_avx2_done_64
L_mldsa_rej_uniform_avx2_rej_large_1:
        addq	$6, %rdx
        subl	$6, %r8d
        jle	L_mldsa_rej_uniform_avx2_done_64
L_mldsa_rej_uniform_avx2_done_64:
        subl	%esi, %eax
        popq	%r14
        popq	%r13
        popq	%r12
        popq	%rbx
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_rej_uniform_avx2,.-wc_mldsa_rej_uniform_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_shufb_rej_idx:
.quad	0xffffffffffffffff,0xffffffffffffffff
.quad	0xffffffffffff0100,0xffffffffffffffff
.quad	0xffffffffffff0302,0xffffffffffffffff
.quad	0xffffffff03020100,0xffffffffffffffff
.quad	0xffffffffffff0504,0xffffffffffffffff
.quad	0xffffffff05040100,0xffffffffffffffff
.quad	0xffffffff05040302,0xffffffffffffffff
.quad	0xffff050403020100,0xffffffffffffffff
.quad	0xffffffffffff0706,0xffffffffffffffff
.quad	0xffffffff07060100,0xffffffffffffffff
.quad	0xffffffff07060302,0xffffffffffffffff
.quad	0xffff070603020100,0xffffffffffffffff
.quad	0xffffffff07060504,0xffffffffffffffff
.quad	0xffff070605040100,0xffffffffffffffff
.quad	0xffff070605040302,0xffffffffffffffff
.quad	0x0706050403020100,0xffffffffffffffff
.quad	0xffffffffffff0908,0xffffffffffffffff
.quad	0xffffffff09080100,0xffffffffffffffff
.quad	0xffffffff09080302,0xffffffffffffffff
.quad	0xffff090803020100,0xffffffffffffffff
.quad	0xffffffff09080504,0xffffffffffffffff
.quad	0xffff090805040100,0xffffffffffffffff
.quad	0xffff090805040302,0xffffffffffffffff
.quad	0x0908050403020100,0xffffffffffffffff
.quad	0xffffffff09080706,0xffffffffffffffff
.quad	0xffff090807060100,0xffffffffffffffff
.quad	0xffff090807060302,0xffffffffffffffff
.quad	0x0908070603020100,0xffffffffffffffff
.quad	0xffff090807060504,0xffffffffffffffff
.quad	0x0908070605040100,0xffffffffffffffff
.quad	0x0908070605040302,0xffffffffffffffff
.quad	0x0706050403020100,0xffffffffffff0908
.quad	0xffffffffffff0b0a,0xffffffffffffffff
.quad	0xffffffff0b0a0100,0xffffffffffffffff
.quad	0xffffffff0b0a0302,0xffffffffffffffff
.quad	0xffff0b0a03020100,0xffffffffffffffff
.quad	0xffffffff0b0a0504,0xffffffffffffffff
.quad	0xffff0b0a05040100,0xffffffffffffffff
.quad	0xffff0b0a05040302,0xffffffffffffffff
.quad	0x0b0a050403020100,0xffffffffffffffff
.quad	0xffffffff0b0a0706,0xffffffffffffffff
.quad	0xffff0b0a07060100,0xffffffffffffffff
.quad	0xffff0b0a07060302,0xffffffffffffffff
.quad	0x0b0a070603020100,0xffffffffffffffff
.quad	0xffff0b0a07060504,0xffffffffffffffff
.quad	0x0b0a070605040100,0xffffffffffffffff
.quad	0x0b0a070605040302,0xffffffffffffffff
.quad	0x0706050403020100,0xffffffffffff0b0a
.quad	0xffffffff0b0a0908,0xffffffffffffffff
.quad	0xffff0b0a09080100,0xffffffffffffffff
.quad	0xffff0b0a09080302,0xffffffffffffffff
.quad	0x0b0a090803020100,0xffffffffffffffff
.quad	0xffff0b0a09080504,0xffffffffffffffff
.quad	0x0b0a090805040100,0xffffffffffffffff
.quad	0x0b0a090805040302,0xffffffffffffffff
.quad	0x0908050403020100,0xffffffffffff0b0a
.quad	0xffff0b0a09080706,0xffffffffffffffff
.quad	0x0b0a090807060100,0xffffffffffffffff
.quad	0x0b0a090807060302,0xffffffffffffffff
.quad	0x0908070603020100,0xffffffffffff0b0a
.quad	0x0b0a090807060504,0xffffffffffffffff
.quad	0x0908070605040100,0xffffffffffff0b0a
.quad	0x0908070605040302,0xffffffffffff0b0a
.quad	0x0706050403020100,0xffffffff0b0a0908
.quad	0xffffffffffff0d0c,0xffffffffffffffff
.quad	0xffffffff0d0c0100,0xffffffffffffffff
.quad	0xffffffff0d0c0302,0xffffffffffffffff
.quad	0xffff0d0c03020100,0xffffffffffffffff
.quad	0xffffffff0d0c0504,0xffffffffffffffff
.quad	0xffff0d0c05040100,0xffffffffffffffff
.quad	0xffff0d0c05040302,0xffffffffffffffff
.quad	0x0d0c050403020100,0xffffffffffffffff
.quad	0xffffffff0d0c0706,0xffffffffffffffff
.quad	0xffff0d0c07060100,0xffffffffffffffff
.quad	0xffff0d0c07060302,0xffffffffffffffff
.quad	0x0d0c070603020100,0xffffffffffffffff
.quad	0xffff0d0c07060504,0xffffffffffffffff
.quad	0x0d0c070605040100,0xffffffffffffffff
.quad	0x0d0c070605040302,0xffffffffffffffff
.quad	0x0706050403020100,0xffffffffffff0d0c
.quad	0xffffffff0d0c0908,0xffffffffffffffff
.quad	0xffff0d0c09080100,0xffffffffffffffff
.quad	0xffff0d0c09080302,0xffffffffffffffff
.quad	0x0d0c090803020100,0xffffffffffffffff
.quad	0xffff0d0c09080504,0xffffffffffffffff
.quad	0x0d0c090805040100,0xffffffffffffffff
.quad	0x0d0c090805040302,0xffffffffffffffff
.quad	0x0908050403020100,0xffffffffffff0d0c
.quad	0xffff0d0c09080706,0xffffffffffffffff
.quad	0x0d0c090807060100,0xffffffffffffffff
.quad	0x0d0c090807060302,0xffffffffffffffff
.quad	0x0908070603020100,0xffffffffffff0d0c
.quad	0x0d0c090807060504,0xffffffffffffffff
.quad	0x0908070605040100,0xffffffffffff0d0c
.quad	0x0908070605040302,0xffffffffffff0d0c
.quad	0x0706050403020100,0xffffffff0d0c0908
.quad	0xffffffff0d0c0b0a,0xffffffffffffffff
.quad	0xffff0d0c0b0a0100,0xffffffffffffffff
.quad	0xffff0d0c0b0a0302,0xffffffffffffffff
.quad	0x0d0c0b0a03020100,0xffffffffffffffff
.quad	0xffff0d0c0b0a0504,0xffffffffffffffff
.quad	0x0d0c0b0a05040100,0xffffffffffffffff
.quad	0x0d0c0b0a05040302,0xffffffffffffffff
.quad	0x0b0a050403020100,0xffffffffffff0d0c
.quad	0xffff0d0c0b0a0706,0xffffffffffffffff
.quad	0x0d0c0b0a07060100,0xffffffffffffffff
.quad	0x0d0c0b0a07060302,0xffffffffffffffff
.quad	0x0b0a070603020100,0xffffffffffff0d0c
.quad	0x0d0c0b0a07060504,0xffffffffffffffff
.quad	0x0b0a070605040100,0xffffffffffff0d0c
.quad	0x0b0a070605040302,0xffffffffffff0d0c
.quad	0x0706050403020100,0xffffffff0d0c0b0a
.quad	0xffff0d0c0b0a0908,0xffffffffffffffff
.quad	0x0d0c0b0a09080100,0xffffffffffffffff
.quad	0x0d0c0b0a09080302,0xffffffffffffffff
.quad	0x0b0a090803020100,0xffffffffffff0d0c
.quad	0x0d0c0b0a09080504,0xffffffffffffffff
.quad	0x0b0a090805040100,0xffffffffffff0d0c
.quad	0x0b0a090805040302,0xffffffffffff0d0c
.quad	0x0908050403020100,0xffffffff0d0c0b0a
.quad	0x0d0c0b0a09080706,0xffffffffffffffff
.quad	0x0b0a090807060100,0xffffffffffff0d0c
.quad	0x0b0a090807060302,0xffffffffffff0d0c
.quad	0x0908070603020100,0xffffffff0d0c0b0a
.quad	0x0b0a090807060504,0xffffffffffff0d0c
.quad	0x0908070605040100,0xffffffff0d0c0b0a
.quad	0x0908070605040302,0xffffffff0d0c0b0a
.quad	0x0706050403020100,0xffff0d0c0b0a0908
.quad	0xffffffffffff0f0e,0xffffffffffffffff
.quad	0xffffffff0f0e0100,0xffffffffffffffff
.quad	0xffffffff0f0e0302,0xffffffffffffffff
.quad	0xffff0f0e03020100,0xffffffffffffffff
.quad	0xffffffff0f0e0504,0xffffffffffffffff
.quad	0xffff0f0e05040100,0xffffffffffffffff
.quad	0xffff0f0e05040302,0xffffffffffffffff
.quad	0x0f0e050403020100,0xffffffffffffffff
.quad	0xffffffff0f0e0706,0xffffffffffffffff
.quad	0xffff0f0e07060100,0xffffffffffffffff
.quad	0xffff0f0e07060302,0xffffffffffffffff
.quad	0x0f0e070603020100,0xffffffffffffffff
.quad	0xffff0f0e07060504,0xffffffffffffffff
.quad	0x0f0e070605040100,0xffffffffffffffff
.quad	0x0f0e070605040302,0xffffffffffffffff
.quad	0x0706050403020100,0xffffffffffff0f0e
.quad	0xffffffff0f0e0908,0xffffffffffffffff
.quad	0xffff0f0e09080100,0xffffffffffffffff
.quad	0xffff0f0e09080302,0xffffffffffffffff
.quad	0x0f0e090803020100,0xffffffffffffffff
.quad	0xffff0f0e09080504,0xffffffffffffffff
.quad	0x0f0e090805040100,0xffffffffffffffff
.quad	0x0f0e090805040302,0xffffffffffffffff
.quad	0x0908050403020100,0xffffffffffff0f0e
.quad	0xffff0f0e09080706,0xffffffffffffffff
.quad	0x0f0e090807060100,0xffffffffffffffff
.quad	0x0f0e090807060302,0xffffffffffffffff
.quad	0x0908070603020100,0xffffffffffff0f0e
.quad	0x0f0e090807060504,0xffffffffffffffff
.quad	0x0908070605040100,0xffffffffffff0f0e
.quad	0x0908070605040302,0xffffffffffff0f0e
.quad	0x0706050403020100,0xffffffff0f0e0908
.quad	0xffffffff0f0e0b0a,0xffffffffffffffff
.quad	0xffff0f0e0b0a0100,0xffffffffffffffff
.quad	0xffff0f0e0b0a0302,0xffffffffffffffff
.quad	0x0f0e0b0a03020100,0xffffffffffffffff
.quad	0xffff0f0e0b0a0504,0xffffffffffffffff
.quad	0x0f0e0b0a05040100,0xffffffffffffffff
.quad	0x0f0e0b0a05040302,0xffffffffffffffff
.quad	0x0b0a050403020100,0xffffffffffff0f0e
.quad	0xffff0f0e0b0a0706,0xffffffffffffffff
.quad	0x0f0e0b0a07060100,0xffffffffffffffff
.quad	0x0f0e0b0a07060302,0xffffffffffffffff
.quad	0x0b0a070603020100,0xffffffffffff0f0e
.quad	0x0f0e0b0a07060504,0xffffffffffffffff
.quad	0x0b0a070605040100,0xffffffffffff0f0e
.quad	0x0b0a070605040302,0xffffffffffff0f0e
.quad	0x0706050403020100,0xffffffff0f0e0b0a
.quad	0xffff0f0e0b0a0908,0xffffffffffffffff
.quad	0x0f0e0b0a09080100,0xffffffffffffffff
.quad	0x0f0e0b0a09080302,0xffffffffffffffff
.quad	0x0b0a090803020100,0xffffffffffff0f0e
.quad	0x0f0e0b0a09080504,0xffffffffffffffff
.quad	0x0b0a090805040100,0xffffffffffff0f0e
.quad	0x0b0a090805040302,0xffffffffffff0f0e
.quad	0x0908050403020100,0xffffffff0f0e0b0a
.quad	0x0f0e0b0a09080706,0xffffffffffffffff
.quad	0x0b0a090807060100,0xffffffffffff0f0e
.quad	0x0b0a090807060302,0xffffffffffff0f0e
.quad	0x0908070603020100,0xffffffff0f0e0b0a
.quad	0x0b0a090807060504,0xffffffffffff0f0e
.quad	0x0908070605040100,0xffffffff0f0e0b0a
.quad	0x0908070605040302,0xffffffff0f0e0b0a
.quad	0x0706050403020100,0xffff0f0e0b0a0908
.quad	0xffffffff0f0e0d0c,0xffffffffffffffff
.quad	0xffff0f0e0d0c0100,0xffffffffffffffff
.quad	0xffff0f0e0d0c0302,0xffffffffffffffff
.quad	0x0f0e0d0c03020100,0xffffffffffffffff
.quad	0xffff0f0e0d0c0504,0xffffffffffffffff
.quad	0x0f0e0d0c05040100,0xffffffffffffffff
.quad	0x0f0e0d0c05040302,0xffffffffffffffff
.quad	0x0d0c050403020100,0xffffffffffff0f0e
.quad	0xffff0f0e0d0c0706,0xffffffffffffffff
.quad	0x0f0e0d0c07060100,0xffffffffffffffff
.quad	0x0f0e0d0c07060302,0xffffffffffffffff
.quad	0x0d0c070603020100,0xffffffffffff0f0e
.quad	0x0f0e0d0c07060504,0xffffffffffffffff
.quad	0x0d0c070605040100,0xffffffffffff0f0e
.quad	0x0d0c070605040302,0xffffffffffff0f0e
.quad	0x0706050403020100,0xffffffff0f0e0d0c
.quad	0xffff0f0e0d0c0908,0xffffffffffffffff
.quad	0x0f0e0d0c09080100,0xffffffffffffffff
.quad	0x0f0e0d0c09080302,0xffffffffffffffff
.quad	0x0d0c090803020100,0xffffffffffff0f0e
.quad	0x0f0e0d0c09080504,0xffffffffffffffff
.quad	0x0d0c090805040100,0xffffffffffff0f0e
.quad	0x0d0c090805040302,0xffffffffffff0f0e
.quad	0x0908050403020100,0xffffffff0f0e0d0c
.quad	0x0f0e0d0c09080706,0xffffffffffffffff
.quad	0x0d0c090807060100,0xffffffffffff0f0e
.quad	0x0d0c090807060302,0xffffffffffff0f0e
.quad	0x0908070603020100,0xffffffff0f0e0d0c
.quad	0x0d0c090807060504,0xffffffffffff0f0e
.quad	0x0908070605040100,0xffffffff0f0e0d0c
.quad	0x0908070605040302,0xffffffff0f0e0d0c
.quad	0x0706050403020100,0xffff0f0e0d0c0908
.quad	0xffff0f0e0d0c0b0a,0xffffffffffffffff
.quad	0x0f0e0d0c0b0a0100,0xffffffffffffffff
.quad	0x0f0e0d0c0b0a0302,0xffffffffffffffff
.quad	0x0d0c0b0a03020100,0xffffffffffff0f0e
.quad	0x0f0e0d0c0b0a0504,0xffffffffffffffff
.quad	0x0d0c0b0a05040100,0xffffffffffff0f0e
.quad	0x0d0c0b0a05040302,0xffffffffffff0f0e
.quad	0x0b0a050403020100,0xffffffff0f0e0d0c
.quad	0x0f0e0d0c0b0a0706,0xffffffffffffffff
.quad	0x0d0c0b0a07060100,0xffffffffffff0f0e
.quad	0x0d0c0b0a07060302,0xffffffffffff0f0e
.quad	0x0b0a070603020100,0xffffffff0f0e0d0c
.quad	0x0d0c0b0a07060504,0xffffffffffff0f0e
.quad	0x0b0a070605040100,0xffffffff0f0e0d0c
.quad	0x0b0a070605040302,0xffffffff0f0e0d0c
.quad	0x0706050403020100,0xffff0f0e0d0c0b0a
.quad	0x0f0e0d0c0b0a0908,0xffffffffffffffff
.quad	0x0d0c0b0a09080100,0xffffffffffff0f0e
.quad	0x0d0c0b0a09080302,0xffffffffffff0f0e
.quad	0x0b0a090803020100,0xffffffff0f0e0d0c
.quad	0x0d0c0b0a09080504,0xffffffffffff0f0e
.quad	0x0b0a090805040100,0xffffffff0f0e0d0c
.quad	0x0b0a090805040302,0xffffffff0f0e0d0c
.quad	0x0908050403020100,0xffff0f0e0d0c0b0a
.quad	0x0d0c0b0a09080706,0xffffffffffff0f0e
.quad	0x0b0a090807060100,0xffffffff0f0e0d0c
.quad	0x0b0a090807060302,0xffffffff0f0e0d0c
.quad	0x0908070603020100,0xffff0f0e0d0c0b0a
.quad	0x0b0a090807060504,0xffffffff0f0e0d0c
.quad	0x0908070605040100,0xffff0f0e0d0c0b0a
.quad	0x0908070605040302,0xffff0f0e0d0c0b0a
.quad	0x0706050403020100,0x0f0e0d0c0b0a0908
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_extract_coeffs_eta2_mask_nibbles:
.value	0x000f,0x000f
.value	0x000f,0x000f
.value	0x000f,0x000f
.value	0x000f,0x000f
.value	0x000f,0x000f
.value	0x000f,0x000f
.value	0x000f,0x000f
.value	0x000f,0x000f
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_extract_coeffs_eta2_mul:
.value	0x3340,0x3340
.value	0x3340,0x3340
.value	0x3340,0x3340
.value	0x3340,0x3340
.value	0x3340,0x3340
.value	0x3340,0x3340
.value	0x3340,0x3340
.value	0x3340,0x3340
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_extract_coeffs_eta2_five:
.value	0x0005,0x0005
.value	0x0005,0x0005
.value	0x0005,0x0005
.value	0x0005,0x0005
.value	0x0005,0x0005
.value	0x0005,0x0005
.value	0x0005,0x0005
.value	0x0005,0x0005
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_extract_coeffs_eta2_two:
.value	0x0002,0x0002
.value	0x0002,0x0002
.value	0x0002,0x0002
.value	0x0002,0x0002
.value	0x0002,0x0002
.value	0x0002,0x0002
.value	0x0002,0x0002
.value	0x0002,0x0002
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_extract_coeffs_eta2_nibble_table:
.long	0x00000002,0x00000001,0x00000000,0xffffffff
.long	0xfffffffe,0x00000002,0x00000001,0x00000000
.long	0xffffffff,0xfffffffe,0x00000002,0x00000001
.long	0x00000000,0xffffffff,0xfffffffe,0x00000000
#ifndef __APPLE__
.text
.globl	wc_mldsa_extract_coeffs_eta2_avx2
.type	wc_mldsa_extract_coeffs_eta2_avx2,@function
.align	16
wc_mldsa_extract_coeffs_eta2_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_extract_coeffs_eta2_avx2
.p2align	4
_wc_mldsa_extract_coeffs_eta2_avx2:
#endif /* __APPLE__ */
        pushq	%rbx
        pushq	%r12
        pushq	%r13
        vmovdqu	L_mldsa_extract_coeffs_eta2_mask_nibbles(%rip), %ymm6
        vmovdqu	L_mldsa_extract_coeffs_eta2_mul(%rip), %ymm7
        vmovdqu	L_mldsa_extract_coeffs_eta2_five(%rip), %ymm8
        vmovdqu	L_mldsa_extract_coeffs_eta2_two(%rip), %ymm9
        leaq	L_mldsa_shufb_rej_idx(%rip), %r13
        movl	(%rcx), %r8d
        cmpl	$0x00, %r8d
        jne	L_mldsa_extract_coeffs_eta2_less_than_256
        vpmovzxbd	(%rdi), %ymm0
        vpmovzxbd	8(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %ymm2
        vmovdqu	(%r13,%rbx,1), %ymm3
        vmovdqu	(%r13,%r11,1), %ymm4
        vmovdqu	(%r13,%r12,1), %ymm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpmulhw	%ymm7, %ymm0, %ymm2
        vpmulhw	%ymm7, %ymm1, %ymm3
        vpmullw	%ymm8, %ymm2, %ymm2
        vpmullw	%ymm8, %ymm3, %ymm3
        vpsubw	%ymm0, %ymm9, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpaddw	%ymm2, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm1, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	16(%rdi), %ymm0
        vpmovzxbd	24(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %ymm2
        vmovdqu	(%r13,%rbx,1), %ymm3
        vmovdqu	(%r13,%r11,1), %ymm4
        vmovdqu	(%r13,%r12,1), %ymm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpmulhw	%ymm7, %ymm0, %ymm2
        vpmulhw	%ymm7, %ymm1, %ymm3
        vpmullw	%ymm8, %ymm2, %ymm2
        vpmullw	%ymm8, %ymm3, %ymm3
        vpsubw	%ymm0, %ymm9, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpaddw	%ymm2, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm1, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	32(%rdi), %ymm0
        vpmovzxbd	40(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %ymm2
        vmovdqu	(%r13,%rbx,1), %ymm3
        vmovdqu	(%r13,%r11,1), %ymm4
        vmovdqu	(%r13,%r12,1), %ymm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpmulhw	%ymm7, %ymm0, %ymm2
        vpmulhw	%ymm7, %ymm1, %ymm3
        vpmullw	%ymm8, %ymm2, %ymm2
        vpmullw	%ymm8, %ymm3, %ymm3
        vpsubw	%ymm0, %ymm9, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpaddw	%ymm2, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm1, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	48(%rdi), %ymm0
        vpmovzxbd	56(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %ymm2
        vmovdqu	(%r13,%rbx,1), %ymm3
        vmovdqu	(%r13,%r11,1), %ymm4
        vmovdqu	(%r13,%r12,1), %ymm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpmulhw	%ymm7, %ymm0, %ymm2
        vpmulhw	%ymm7, %ymm1, %ymm3
        vpmullw	%ymm8, %ymm2, %ymm2
        vpmullw	%ymm8, %ymm3, %ymm3
        vpsubw	%ymm0, %ymm9, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpaddw	%ymm2, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm1, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	64(%rdi), %ymm0
        vpmovzxbd	72(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %ymm2
        vmovdqu	(%r13,%rbx,1), %ymm3
        vmovdqu	(%r13,%r11,1), %ymm4
        vmovdqu	(%r13,%r12,1), %ymm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpmulhw	%ymm7, %ymm0, %ymm2
        vpmulhw	%ymm7, %ymm1, %ymm3
        vpmullw	%ymm8, %ymm2, %ymm2
        vpmullw	%ymm8, %ymm3, %ymm3
        vpsubw	%ymm0, %ymm9, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpaddw	%ymm2, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm1, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	80(%rdi), %ymm0
        vpmovzxbd	88(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %ymm2
        vmovdqu	(%r13,%rbx,1), %ymm3
        vmovdqu	(%r13,%r11,1), %ymm4
        vmovdqu	(%r13,%r12,1), %ymm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpmulhw	%ymm7, %ymm0, %ymm2
        vpmulhw	%ymm7, %ymm1, %ymm3
        vpmullw	%ymm8, %ymm2, %ymm2
        vpmullw	%ymm8, %ymm3, %ymm3
        vpsubw	%ymm0, %ymm9, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpaddw	%ymm2, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm1, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	96(%rdi), %ymm0
        vpmovzxbd	104(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %ymm2
        vmovdqu	(%r13,%rbx,1), %ymm3
        vmovdqu	(%r13,%r11,1), %ymm4
        vmovdqu	(%r13,%r12,1), %ymm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpmulhw	%ymm7, %ymm0, %ymm2
        vpmulhw	%ymm7, %ymm1, %ymm3
        vpmullw	%ymm8, %ymm2, %ymm2
        vpmullw	%ymm8, %ymm3, %ymm3
        vpsubw	%ymm0, %ymm9, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpaddw	%ymm2, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm1, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	112(%rdi), %ymm0
        vpmovzxbd	120(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpcmpgtw	%ymm1, %ymm6, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %ymm2
        vmovdqu	(%r13,%rbx,1), %ymm3
        vmovdqu	(%r13,%r11,1), %ymm4
        vmovdqu	(%r13,%r12,1), %ymm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpmulhw	%ymm7, %ymm0, %ymm2
        vpmulhw	%ymm7, %ymm1, %ymm3
        vpmullw	%ymm8, %ymm2, %ymm2
        vpmullw	%ymm8, %ymm3, %ymm3
        vpsubw	%ymm0, %ymm9, %ymm0
        vpsubw	%ymm1, %ymm9, %ymm1
        vpaddw	%ymm2, %ymm0, %ymm0
        vpaddw	%ymm3, %ymm1, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        subl	$0x80, %esi
        addq	$0x80, %rdi
L_mldsa_extract_coeffs_eta2_less_than_256:
        cmpl	$0xf0, %r8d
        jg	L_mldsa_extract_coeffs_eta2_less_than_ymm
L_mldsa_extract_coeffs_eta2_start_one_ymm:
        vpmovzxbd	(%rdi), %ymm0
        vpslld	$12, %ymm0, %ymm2
        vpor	%ymm2, %ymm0, %ymm0
        vpand	%ymm6, %ymm0, %ymm0
        vpcmpgtw	%ymm0, %ymm6, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movzbl	%al, %r10d
        shr	$16, %r11
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %r11d
        vmovdqu	(%r13,%r10,1), %ymm2
        vmovdqu	(%r13,%r11,1), %ymm4
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vpshufb	%ymm2, %ymm0, %ymm0
        popcntl	%r10d, %r10d
        popcntl	%r11d, %r11d
        vpmulhw	%ymm7, %ymm0, %ymm2
        vpmullw	%ymm8, %ymm2, %ymm2
        vpsubw	%ymm0, %ymm9, %ymm0
        vpaddw	%ymm2, %ymm0, %ymm0
        vpmovsxwd	%xmm0, %ymm2
        vextracti128	$0x01, %ymm0, %xmm0
        vpmovsxwd	%xmm0, %ymm0
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        subl	$8, %esi
        addq	$8, %rdi
        cmpl	$8, %esi
        jl	L_mldsa_extract_coeffs_eta2_less_than_ymm
        cmpl	$0xf0, %r8d
        jle	L_mldsa_extract_coeffs_eta2_start_one_ymm
L_mldsa_extract_coeffs_eta2_less_than_ymm:
        cmpl	$0x100, %r8d
        je	L_mldsa_extract_coeffs_eta2_done
L_mldsa_extract_coeffs_eta2_start_byte:
        leaq	L_mldsa_extract_coeffs_eta2_nibble_table(%rip), %r13
        cmpl	$0x00, %esi
        je	L_mldsa_extract_coeffs_eta2_done
        movzbl	(%rdi), %ebx
        addq	$0x01, %rdi
        subl	$0x01, %esi
        movl	%ebx, %eax
        shrl	$4, %eax
        andb	$15, %bl
        xorq	%r11, %r11
        cmpb	$15, %bl
        adcl	$0x00, %r11d
        movl	(%r13,%rbx,4), %r12d
        movl	%r12d, (%rdx)
        addl	%r11d, %r8d
        shl	$2, %r11d
        addq	%r11, %rdx
        cmpl	$0x100, %r8d
        je	L_mldsa_extract_coeffs_eta2_done
        xorq	%r11, %r11
        cmpb	$15, %al
        adcl	$0x00, %r11d
        movl	(%r13,%rax,4), %r12d
        movl	%r12d, (%rdx)
        addl	%r11d, %r8d
        shl	$2, %r11d
        addq	%r11, %rdx
        cmpl	$0x100, %r8d
        je	L_mldsa_extract_coeffs_eta2_done
        jmp	L_mldsa_extract_coeffs_eta2_start_byte
L_mldsa_extract_coeffs_eta2_done:
        movl	%r8d, (%rcx)
        vzeroupper
        popq	%r13
        popq	%r12
        popq	%rbx
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_extract_coeffs_eta2_avx2,.-wc_mldsa_extract_coeffs_eta2_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_extract_coeffs_eta4_mask_nibbles:
.value	0x000f,0x000f
.value	0x000f,0x000f
.value	0x000f,0x000f
.value	0x000f,0x000f
.value	0x000f,0x000f
.value	0x000f,0x000f
.value	0x000f,0x000f
.value	0x000f,0x000f
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_extract_coeffs_eta4_nine:
.value	0x0009,0x0009
.value	0x0009,0x0009
.value	0x0009,0x0009
.value	0x0009,0x0009
.value	0x0009,0x0009
.value	0x0009,0x0009
.value	0x0009,0x0009
.value	0x0009,0x0009
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_extract_coeffs_eta4_four:
.value	0x0004,0x0004
.value	0x0004,0x0004
.value	0x0004,0x0004
.value	0x0004,0x0004
.value	0x0004,0x0004
.value	0x0004,0x0004
.value	0x0004,0x0004
.value	0x0004,0x0004
#ifndef __APPLE__
.text
.globl	wc_mldsa_extract_coeffs_eta4_avx2
.type	wc_mldsa_extract_coeffs_eta4_avx2,@function
.align	16
wc_mldsa_extract_coeffs_eta4_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_extract_coeffs_eta4_avx2
.p2align	4
_wc_mldsa_extract_coeffs_eta4_avx2:
#endif /* __APPLE__ */
        pushq	%rbx
        pushq	%r12
        pushq	%r13
        vmovdqu	L_mldsa_extract_coeffs_eta4_mask_nibbles(%rip), %ymm6
        vmovdqu	L_mldsa_extract_coeffs_eta4_nine(%rip), %ymm7
        vmovdqu	L_mldsa_extract_coeffs_eta4_four(%rip), %ymm8
        leaq	L_mldsa_shufb_rej_idx(%rip), %r13
        movl	(%rcx), %r8d
        cmpl	$0x00, %r8d
        jne	L_mldsa_extract_coeffs_eta4_less_than_256
        vpmovzxbd	(%rdi), %ymm0
        vpmovzxbd	8(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm7, %ymm2
        vpcmpgtw	%ymm1, %ymm7, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %xmm2
        vmovdqu	(%r13,%rbx,1), %xmm3
        vmovdqu	(%r13,%r11,1), %xmm4
        vmovdqu	(%r13,%r12,1), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm8, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	16(%rdi), %ymm0
        vpmovzxbd	24(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm7, %ymm2
        vpcmpgtw	%ymm1, %ymm7, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %xmm2
        vmovdqu	(%r13,%rbx,1), %xmm3
        vmovdqu	(%r13,%r11,1), %xmm4
        vmovdqu	(%r13,%r12,1), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm8, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	32(%rdi), %ymm0
        vpmovzxbd	40(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm7, %ymm2
        vpcmpgtw	%ymm1, %ymm7, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %xmm2
        vmovdqu	(%r13,%rbx,1), %xmm3
        vmovdqu	(%r13,%r11,1), %xmm4
        vmovdqu	(%r13,%r12,1), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm8, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	48(%rdi), %ymm0
        vpmovzxbd	56(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm7, %ymm2
        vpcmpgtw	%ymm1, %ymm7, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %xmm2
        vmovdqu	(%r13,%rbx,1), %xmm3
        vmovdqu	(%r13,%r11,1), %xmm4
        vmovdqu	(%r13,%r12,1), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm8, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	64(%rdi), %ymm0
        vpmovzxbd	72(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm7, %ymm2
        vpcmpgtw	%ymm1, %ymm7, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %xmm2
        vmovdqu	(%r13,%rbx,1), %xmm3
        vmovdqu	(%r13,%r11,1), %xmm4
        vmovdqu	(%r13,%r12,1), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm8, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	80(%rdi), %ymm0
        vpmovzxbd	88(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm7, %ymm2
        vpcmpgtw	%ymm1, %ymm7, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %xmm2
        vmovdqu	(%r13,%rbx,1), %xmm3
        vmovdqu	(%r13,%r11,1), %xmm4
        vmovdqu	(%r13,%r12,1), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm8, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	96(%rdi), %ymm0
        vpmovzxbd	104(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm7, %ymm2
        vpcmpgtw	%ymm1, %ymm7, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %xmm2
        vmovdqu	(%r13,%rbx,1), %xmm3
        vmovdqu	(%r13,%r11,1), %xmm4
        vmovdqu	(%r13,%r12,1), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm8, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        vpmovzxbd	112(%rdi), %ymm0
        vpmovzxbd	120(%rdi), %ymm1
        vpslld	$12, %ymm0, %ymm2
        vpslld	$12, %ymm1, %ymm3
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm1, %ymm1
        vpand	%ymm6, %ymm0, %ymm0
        vpand	%ymm6, %ymm1, %ymm1
        vpcmpgtw	%ymm0, %ymm7, %ymm2
        vpcmpgtw	%ymm1, %ymm7, %ymm3
        vpacksswb	%ymm3, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movl	%eax, %r12d
        movzbl	%al, %r10d
        movzbl	%ah, %ebx
        shr	$16, %r11
        shr	$24, %r12
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %ebx
        shll	$4, %r11d
        shll	$4, %r12d
        vmovdqu	(%r13,%r10,1), %xmm2
        vmovdqu	(%r13,%rbx,1), %xmm3
        vmovdqu	(%r13,%r11,1), %xmm4
        vmovdqu	(%r13,%r12,1), %xmm5
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vinserti128	$0x01, %xmm5, %ymm3, %ymm3
        vpshufb	%ymm2, %ymm0, %ymm0
        vpshufb	%ymm3, %ymm1, %ymm1
        popcntl	%r10d, %r10d
        popcntl	%ebx, %ebx
        popcntl	%r11d, %r11d
        popcntl	%r12d, %r12d
        vpsubw	%ymm0, %ymm8, %ymm0
        vpsubw	%ymm1, %ymm8, %ymm1
        vpmovsxwd	%xmm0, %ymm2
        vpmovsxwd	%xmm1, %ymm3
        vextracti128	$0x01, %ymm0, %xmm0
        vextracti128	$0x01, %ymm1, %xmm1
        vpmovsxwd	%xmm0, %ymm0
        vpmovsxwd	%xmm1, %ymm1
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        vmovdqu	%ymm3, (%rdx)
        leaq	(%rdx,%rbx,4), %rdx
        addl	%ebx, %r8d
        vmovdqu	%ymm1, (%rdx)
        leaq	(%rdx,%r12,4), %rdx
        addl	%r12d, %r8d
        subl	$0x80, %esi
        addq	$0x80, %rdi
L_mldsa_extract_coeffs_eta4_less_than_256:
        cmpl	$0xf0, %r8d
        jg	L_mldsa_extract_coeffs_eta4_less_than_ymm
L_mldsa_extract_coeffs_eta4_start_one_ymm:
        vpmovzxbd	(%rdi), %ymm0
        vpslld	$12, %ymm0, %ymm2
        vpor	%ymm2, %ymm0, %ymm0
        vpand	%ymm6, %ymm0, %ymm0
        vpcmpgtw	%ymm0, %ymm7, %ymm2
        vpacksswb	%ymm2, %ymm2, %ymm2
        vpmovmskb	%ymm2, %eax
        movl	%eax, %r11d
        movzbl	%al, %r10d
        shr	$16, %r11
        andl	$0xff, %r11d
        shll	$4, %r10d
        shll	$4, %r11d
        vmovdqu	(%r13,%r10,1), %xmm2
        vmovdqu	(%r13,%r11,1), %xmm4
        vinserti128	$0x01, %xmm4, %ymm2, %ymm2
        vpshufb	%ymm2, %ymm0, %ymm0
        popcntl	%r10d, %r10d
        popcntl	%r11d, %r11d
        vpsubw	%ymm0, %ymm8, %ymm0
        vpmovsxwd	%xmm0, %ymm2
        vextracti128	$0x01, %ymm0, %xmm0
        vpmovsxwd	%xmm0, %ymm0
        vmovdqu	%ymm2, (%rdx)
        leaq	(%rdx,%r10,4), %rdx
        addl	%r10d, %r8d
        vmovdqu	%ymm0, (%rdx)
        leaq	(%rdx,%r11,4), %rdx
        addl	%r11d, %r8d
        subl	$8, %esi
        addq	$8, %rdi
        cmpl	$8, %esi
        jl	L_mldsa_extract_coeffs_eta4_less_than_ymm
        cmpl	$0xf0, %r8d
        jle	L_mldsa_extract_coeffs_eta4_start_one_ymm
L_mldsa_extract_coeffs_eta4_less_than_ymm:
        cmpl	$0x100, %r8d
        je	L_mldsa_extract_coeffs_eta4_done
L_mldsa_extract_coeffs_eta4_start_byte:
        cmpl	$0x00, %esi
        je	L_mldsa_extract_coeffs_eta4_done
        movzbl	(%rdi), %ebx
        addq	$0x01, %rdi
        subl	$0x01, %esi
        movl	%ebx, %eax
        shrl	$4, %eax
        andb	$15, %bl
        xorq	%r11, %r11
        movq	$4, %r12
        cmpb	$9, %bl
        adcl	$0x00, %r11d
        subl	%ebx, %r12d
        movl	%r12d, (%rdx)
        addl	%r11d, %r8d
        shl	$2, %r11d
        addq	%r11, %rdx
        cmpl	$0x100, %r8d
        je	L_mldsa_extract_coeffs_eta4_done
        xorq	%r11, %r11
        movq	$4, %r12
        cmpb	$9, %al
        adcl	$0x00, %r11d
        subl	%eax, %r12d
        movl	%r12d, (%rdx)
        addl	%r11d, %r8d
        shl	$2, %r11d
        addq	%r11, %rdx
        cmpl	$0x100, %r8d
        je	L_mldsa_extract_coeffs_eta4_done
        jmp	L_mldsa_extract_coeffs_eta4_start_byte
L_mldsa_extract_coeffs_eta4_done:
        movl	%r8d, (%rcx)
        vzeroupper
        popq	%r13
        popq	%r12
        popq	%rbx
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_extract_coeffs_eta4_avx2,.-wc_mldsa_extract_coeffs_eta4_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	wc_mldsa_redistribute_21_rand_avx2
.type	wc_mldsa_redistribute_21_rand_avx2,@function
.align	16
wc_mldsa_redistribute_21_rand_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_redistribute_21_rand_avx2
.p2align	4
_wc_mldsa_redistribute_21_rand_avx2:
#endif /* __APPLE__ */
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        vmovdqu	256(%rdi), %ymm8
        vmovdqu	288(%rdi), %ymm9
        vmovdqu	320(%rdi), %ymm10
        vmovdqu	352(%rdi), %ymm11
        vpunpcklqdq	%ymm1, %ymm0, %ymm12
        vpunpckhqdq	%ymm1, %ymm0, %ymm13
        vpunpcklqdq	%ymm3, %ymm2, %ymm14
        vpunpckhqdq	%ymm3, %ymm2, %ymm15
        vperm2i128	$32, %ymm14, %ymm12, %ymm0
        vperm2i128	$32, %ymm15, %ymm13, %ymm1
        vperm2i128	$49, %ymm14, %ymm12, %ymm2
        vperm2i128	$49, %ymm15, %ymm13, %ymm3
        vpunpcklqdq	%ymm5, %ymm4, %ymm12
        vpunpckhqdq	%ymm5, %ymm4, %ymm13
        vpunpcklqdq	%ymm7, %ymm6, %ymm14
        vpunpckhqdq	%ymm7, %ymm6, %ymm15
        vperm2i128	$32, %ymm14, %ymm12, %ymm4
        vperm2i128	$32, %ymm15, %ymm13, %ymm5
        vperm2i128	$49, %ymm14, %ymm12, %ymm6
        vperm2i128	$49, %ymm15, %ymm13, %ymm7
        vpunpcklqdq	%ymm9, %ymm8, %ymm12
        vpunpckhqdq	%ymm9, %ymm8, %ymm13
        vpunpcklqdq	%ymm11, %ymm10, %ymm14
        vpunpckhqdq	%ymm11, %ymm10, %ymm15
        vperm2i128	$32, %ymm14, %ymm12, %ymm8
        vperm2i128	$32, %ymm15, %ymm13, %ymm9
        vperm2i128	$49, %ymm14, %ymm12, %ymm10
        vperm2i128	$49, %ymm15, %ymm13, %ymm11
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm4, 32(%rsi)
        vmovdqu	%ymm8, 64(%rsi)
        vmovdqu	%ymm1, (%rdx)
        vmovdqu	%ymm5, 32(%rdx)
        vmovdqu	%ymm9, 64(%rdx)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm6, 32(%rcx)
        vmovdqu	%ymm10, 64(%rcx)
        vmovdqu	%ymm3, (%r8)
        vmovdqu	%ymm7, 32(%r8)
        vmovdqu	%ymm11, 64(%r8)
        vmovdqu	384(%rdi), %ymm0
        vmovdqu	416(%rdi), %ymm1
        vmovdqu	448(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vmovdqu	512(%rdi), %ymm4
        vmovdqu	544(%rdi), %ymm5
        vmovdqu	576(%rdi), %ymm6
        vmovdqu	608(%rdi), %ymm7
        movq	640(%rdi), %rax
        movq	648(%rdi), %r9
        movq	656(%rdi), %r10
        movq	664(%rdi), %r11
        vpunpcklqdq	%ymm1, %ymm0, %ymm12
        vpunpckhqdq	%ymm1, %ymm0, %ymm13
        vpunpcklqdq	%ymm3, %ymm2, %ymm14
        vpunpckhqdq	%ymm3, %ymm2, %ymm15
        vperm2i128	$32, %ymm14, %ymm12, %ymm0
        vperm2i128	$32, %ymm15, %ymm13, %ymm1
        vperm2i128	$49, %ymm14, %ymm12, %ymm2
        vperm2i128	$49, %ymm15, %ymm13, %ymm3
        vpunpcklqdq	%ymm5, %ymm4, %ymm12
        vpunpckhqdq	%ymm5, %ymm4, %ymm13
        vpunpcklqdq	%ymm7, %ymm6, %ymm14
        vpunpckhqdq	%ymm7, %ymm6, %ymm15
        vperm2i128	$32, %ymm14, %ymm12, %ymm4
        vperm2i128	$32, %ymm15, %ymm13, %ymm5
        vperm2i128	$49, %ymm14, %ymm12, %ymm6
        vperm2i128	$49, %ymm15, %ymm13, %ymm7
        vmovdqu	%ymm0, 96(%rsi)
        vmovdqu	%ymm4, 128(%rsi)
        movq	%rax, 160(%rsi)
        vmovdqu	%ymm1, 96(%rdx)
        vmovdqu	%ymm5, 128(%rdx)
        movq	%r9, 160(%rdx)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm6, 128(%rcx)
        movq	%r10, 160(%rcx)
        vmovdqu	%ymm3, 96(%r8)
        vmovdqu	%ymm7, 128(%r8)
        movq	%r11, 160(%r8)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_redistribute_21_rand_avx2,.-wc_mldsa_redistribute_21_rand_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	wc_mldsa_redistribute_17_rand_avx2
.type	wc_mldsa_redistribute_17_rand_avx2,@function
.align	16
wc_mldsa_redistribute_17_rand_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_redistribute_17_rand_avx2
.p2align	4
_wc_mldsa_redistribute_17_rand_avx2:
#endif /* __APPLE__ */
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm9
        vpunpcklqdq	%ymm3, %ymm2, %ymm10
        vpunpckhqdq	%ymm3, %ymm2, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm0
        vperm2i128	$32, %ymm11, %ymm9, %ymm1
        vperm2i128	$49, %ymm10, %ymm8, %ymm2
        vperm2i128	$49, %ymm11, %ymm9, %ymm3
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm9
        vpunpcklqdq	%ymm7, %ymm6, %ymm10
        vpunpckhqdq	%ymm7, %ymm6, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm4
        vperm2i128	$32, %ymm11, %ymm9, %ymm5
        vperm2i128	$49, %ymm10, %ymm8, %ymm6
        vperm2i128	$49, %ymm11, %ymm9, %ymm7
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm4, 32(%rsi)
        vmovdqu	%ymm1, (%rdx)
        vmovdqu	%ymm5, 32(%rdx)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm6, 32(%rcx)
        vmovdqu	%ymm3, (%r8)
        vmovdqu	%ymm7, 32(%r8)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vmovdqu	448(%rdi), %ymm6
        vmovdqu	480(%rdi), %ymm7
        movq	512(%rdi), %rax
        movq	520(%rdi), %r9
        movq	528(%rdi), %r10
        movq	536(%rdi), %r11
        vpunpcklqdq	%ymm1, %ymm0, %ymm8
        vpunpckhqdq	%ymm1, %ymm0, %ymm9
        vpunpcklqdq	%ymm3, %ymm2, %ymm10
        vpunpckhqdq	%ymm3, %ymm2, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm0
        vperm2i128	$32, %ymm11, %ymm9, %ymm1
        vperm2i128	$49, %ymm10, %ymm8, %ymm2
        vperm2i128	$49, %ymm11, %ymm9, %ymm3
        vpunpcklqdq	%ymm5, %ymm4, %ymm8
        vpunpckhqdq	%ymm5, %ymm4, %ymm9
        vpunpcklqdq	%ymm7, %ymm6, %ymm10
        vpunpckhqdq	%ymm7, %ymm6, %ymm11
        vperm2i128	$32, %ymm10, %ymm8, %ymm4
        vperm2i128	$32, %ymm11, %ymm9, %ymm5
        vperm2i128	$49, %ymm10, %ymm8, %ymm6
        vperm2i128	$49, %ymm11, %ymm9, %ymm7
        vmovdqu	%ymm0, 64(%rsi)
        vmovdqu	%ymm4, 96(%rsi)
        movq	%rax, 128(%rsi)
        vmovdqu	%ymm1, 64(%rdx)
        vmovdqu	%ymm5, 96(%rdx)
        movq	%r9, 128(%rdx)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm6, 96(%rcx)
        movq	%r10, 128(%rcx)
        vmovdqu	%ymm3, 64(%r8)
        vmovdqu	%ymm7, 96(%r8)
        movq	%r11, 128(%r8)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_redistribute_17_rand_avx2,.-wc_mldsa_redistribute_17_rand_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_eta_2_avx2_two:
.long	0x00000002,0x00000002,0x00000002,0x00000002
.long	0x00000002,0x00000002,0x00000002,0x00000002
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_eta_2_avx2_vs_3:
.long	0x00000000,0x00000003,0x00000006,0x00000009
.long	0x00000004,0x00000007,0x0000000a,0x0000000d
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_eta_2_avx2_shuff_3_even:
.value	0xff00,0x504
.value	0xff08,0xd0c
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xff00,0x504
.value	0xff08,0xd0c
.value	0xffff,0xffff
.value	0xffff,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_eta_2_avx2_shuff_3_odd:
.value	0xff02,0x7ff
.value	0xb0a,0xfff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xff02,0x7ff
.value	0xb0a,0xfff
.value	0xffff,0xffff
.value	0xffff,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_eta_2_avx2_shuff_6_even:
.value	0x400,0x805
.value	0xd0c,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0x400
.value	0x805,0xd0c
.value	0xffff,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_eta_2_avx2_shuff_6_odd:
.value	0x302,0xa07
.value	0xf0b,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0x302
.value	0xa07,0xf0b
.value	0xffff,0xffff
#ifndef __APPLE__
.text
.globl	wc_mldsa_vec_encode_eta_2_avx2
.type	wc_mldsa_vec_encode_eta_2_avx2,@function
.align	16
wc_mldsa_vec_encode_eta_2_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_vec_encode_eta_2_avx2
.p2align	4
_wc_mldsa_vec_encode_eta_2_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_mldsa_encode_eta_2_avx2_two(%rip), %ymm6
        vmovdqu	L_mldsa_encode_eta_2_avx2_vs_3(%rip), %ymm7
        vmovdqu	L_mldsa_encode_eta_2_avx2_shuff_3_even(%rip), %ymm8
        vmovdqu	L_mldsa_encode_eta_2_avx2_shuff_3_odd(%rip), %ymm9
        vmovdqu	L_mldsa_encode_eta_2_avx2_shuff_6_even(%rip), %ymm10
        vmovdqu	L_mldsa_encode_eta_2_avx2_shuff_6_odd(%rip), %ymm11
L_mldsa_encode_eta_2_avx2_loop:
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vpsubd	%ymm0, %ymm6, %ymm0
        vpsubd	%ymm1, %ymm6, %ymm1
        vpsubd	%ymm2, %ymm6, %ymm2
        vpsubd	%ymm3, %ymm6, %ymm3
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm1, %ymm1
        vpsllvd	%ymm7, %ymm2, %ymm2
        vpsllvd	%ymm7, %ymm3, %ymm3
        vpackusdw	%ymm2, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm1, %ymm1
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm0, %ymm4
        vpshufb	%ymm9, %ymm1, %ymm5
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpermq	$0xb1, %ymm1, %ymm1
        vpor	%ymm1, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm0, %ymm0
        vpor	%ymm4, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm4
        vpor	%ymm4, %ymm0, %ymm0
        vmovdqu	%xmm0, (%rdx)
        addq	$12, %rdx
        vmovdqu	128(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vmovdqu	192(%rdi), %ymm2
        vmovdqu	224(%rdi), %ymm3
        vpsubd	%ymm0, %ymm6, %ymm0
        vpsubd	%ymm1, %ymm6, %ymm1
        vpsubd	%ymm2, %ymm6, %ymm2
        vpsubd	%ymm3, %ymm6, %ymm3
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm1, %ymm1
        vpsllvd	%ymm7, %ymm2, %ymm2
        vpsllvd	%ymm7, %ymm3, %ymm3
        vpackusdw	%ymm2, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm1, %ymm1
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm0, %ymm4
        vpshufb	%ymm9, %ymm1, %ymm5
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpermq	$0xb1, %ymm1, %ymm1
        vpor	%ymm1, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm0, %ymm0
        vpor	%ymm4, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm4
        vpor	%ymm4, %ymm0, %ymm0
        vmovdqu	%xmm0, (%rdx)
        addq	$12, %rdx
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vpsubd	%ymm0, %ymm6, %ymm0
        vpsubd	%ymm1, %ymm6, %ymm1
        vpsubd	%ymm2, %ymm6, %ymm2
        vpsubd	%ymm3, %ymm6, %ymm3
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm1, %ymm1
        vpsllvd	%ymm7, %ymm2, %ymm2
        vpsllvd	%ymm7, %ymm3, %ymm3
        vpackusdw	%ymm2, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm1, %ymm1
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm0, %ymm4
        vpshufb	%ymm9, %ymm1, %ymm5
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpermq	$0xb1, %ymm1, %ymm1
        vpor	%ymm1, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm0, %ymm0
        vpor	%ymm4, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm4
        vpor	%ymm4, %ymm0, %ymm0
        vmovdqu	%xmm0, (%rdx)
        addq	$12, %rdx
        vmovdqu	384(%rdi), %ymm0
        vmovdqu	416(%rdi), %ymm1
        vmovdqu	448(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vpsubd	%ymm0, %ymm6, %ymm0
        vpsubd	%ymm1, %ymm6, %ymm1
        vpsubd	%ymm2, %ymm6, %ymm2
        vpsubd	%ymm3, %ymm6, %ymm3
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm1, %ymm1
        vpsllvd	%ymm7, %ymm2, %ymm2
        vpsllvd	%ymm7, %ymm3, %ymm3
        vpackusdw	%ymm2, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm1, %ymm1
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm0, %ymm4
        vpshufb	%ymm9, %ymm1, %ymm5
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpermq	$0xb1, %ymm1, %ymm1
        vpor	%ymm1, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm0, %ymm0
        vpor	%ymm4, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm4
        vpor	%ymm4, %ymm0, %ymm0
        vmovdqu	%xmm0, (%rdx)
        addq	$12, %rdx
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vmovdqu	576(%rdi), %ymm2
        vmovdqu	608(%rdi), %ymm3
        vpsubd	%ymm0, %ymm6, %ymm0
        vpsubd	%ymm1, %ymm6, %ymm1
        vpsubd	%ymm2, %ymm6, %ymm2
        vpsubd	%ymm3, %ymm6, %ymm3
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm1, %ymm1
        vpsllvd	%ymm7, %ymm2, %ymm2
        vpsllvd	%ymm7, %ymm3, %ymm3
        vpackusdw	%ymm2, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm1, %ymm1
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm0, %ymm4
        vpshufb	%ymm9, %ymm1, %ymm5
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpermq	$0xb1, %ymm1, %ymm1
        vpor	%ymm1, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm0, %ymm0
        vpor	%ymm4, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm4
        vpor	%ymm4, %ymm0, %ymm0
        vmovdqu	%xmm0, (%rdx)
        addq	$12, %rdx
        vmovdqu	640(%rdi), %ymm0
        vmovdqu	672(%rdi), %ymm1
        vmovdqu	704(%rdi), %ymm2
        vmovdqu	736(%rdi), %ymm3
        vpsubd	%ymm0, %ymm6, %ymm0
        vpsubd	%ymm1, %ymm6, %ymm1
        vpsubd	%ymm2, %ymm6, %ymm2
        vpsubd	%ymm3, %ymm6, %ymm3
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm1, %ymm1
        vpsllvd	%ymm7, %ymm2, %ymm2
        vpsllvd	%ymm7, %ymm3, %ymm3
        vpackusdw	%ymm2, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm1, %ymm1
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm0, %ymm4
        vpshufb	%ymm9, %ymm1, %ymm5
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpermq	$0xb1, %ymm1, %ymm1
        vpor	%ymm1, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm0, %ymm0
        vpor	%ymm4, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm4
        vpor	%ymm4, %ymm0, %ymm0
        vmovdqu	%xmm0, (%rdx)
        addq	$12, %rdx
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vmovdqu	832(%rdi), %ymm2
        vmovdqu	864(%rdi), %ymm3
        vpsubd	%ymm0, %ymm6, %ymm0
        vpsubd	%ymm1, %ymm6, %ymm1
        vpsubd	%ymm2, %ymm6, %ymm2
        vpsubd	%ymm3, %ymm6, %ymm3
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm1, %ymm1
        vpsllvd	%ymm7, %ymm2, %ymm2
        vpsllvd	%ymm7, %ymm3, %ymm3
        vpackusdw	%ymm2, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm1, %ymm1
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm0, %ymm4
        vpshufb	%ymm9, %ymm1, %ymm5
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpermq	$0xb1, %ymm1, %ymm1
        vpor	%ymm1, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm0, %ymm0
        vpor	%ymm4, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm4
        vpor	%ymm4, %ymm0, %ymm0
        vmovdqu	%xmm0, (%rdx)
        addq	$12, %rdx
        vmovdqu	896(%rdi), %ymm0
        vmovdqu	928(%rdi), %ymm1
        vmovdqu	960(%rdi), %ymm2
        vmovdqu	992(%rdi), %ymm3
        vpsubd	%ymm0, %ymm6, %ymm0
        vpsubd	%ymm1, %ymm6, %ymm1
        vpsubd	%ymm2, %ymm6, %ymm2
        vpsubd	%ymm3, %ymm6, %ymm3
        vpsllvd	%ymm7, %ymm0, %ymm0
        vpsllvd	%ymm7, %ymm1, %ymm1
        vpsllvd	%ymm7, %ymm2, %ymm2
        vpsllvd	%ymm7, %ymm3, %ymm3
        vpackusdw	%ymm2, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm1, %ymm1
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm0, %ymm4
        vpshufb	%ymm9, %ymm1, %ymm5
        vpshufb	%ymm8, %ymm0, %ymm0
        vpshufb	%ymm8, %ymm1, %ymm1
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpermq	$0xb1, %ymm1, %ymm1
        vpor	%ymm1, %ymm0, %ymm0
        vpshufb	%ymm11, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm0, %ymm0
        vpor	%ymm4, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm4
        vpor	%ymm4, %ymm0, %ymm0
        vmovdqu	%xmm0, (%rdx)
        addq	$12, %rdx
        addq	$0x400, %rdi
        decb	%sil
        jnz	L_mldsa_encode_eta_2_avx2_loop
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_vec_encode_eta_2_avx2,.-wc_mldsa_vec_encode_eta_2_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_eta_4_avx2_four:
.long	0x00000004,0x00000004,0x00000004,0x00000004
.long	0x00000004,0x00000004,0x00000004,0x00000004
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_eta_4_avx2_vs_4:
.long	0x00000000,0x00000004,0x00000000,0x00000004
.long	0x00000000,0x00000004,0x00000000,0x00000004
#ifndef __APPLE__
.text
.globl	wc_mldsa_vec_encode_eta_4_avx2
.type	wc_mldsa_vec_encode_eta_4_avx2,@function
.align	16
wc_mldsa_vec_encode_eta_4_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_vec_encode_eta_4_avx2
.p2align	4
_wc_mldsa_vec_encode_eta_4_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm8, %ymm8, %ymm8
        vmovdqu	L_mldsa_encode_eta_4_avx2_four(%rip), %ymm8
        vmovdqu	L_mldsa_encode_eta_4_avx2_vs_4(%rip), %ymm9
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vmovdqu	448(%rdi), %ymm6
        vmovdqu	480(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 32(%rsi)
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vmovdqu	576(%rdi), %ymm2
        vmovdqu	608(%rdi), %ymm3
        vmovdqu	640(%rdi), %ymm4
        vmovdqu	672(%rdi), %ymm5
        vmovdqu	704(%rdi), %ymm6
        vmovdqu	736(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 64(%rsi)
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vmovdqu	832(%rdi), %ymm2
        vmovdqu	864(%rdi), %ymm3
        vmovdqu	896(%rdi), %ymm4
        vmovdqu	928(%rdi), %ymm5
        vmovdqu	960(%rdi), %ymm6
        vmovdqu	992(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 96(%rsi)
        vmovdqu	1024(%rdi), %ymm0
        vmovdqu	1056(%rdi), %ymm1
        vmovdqu	1088(%rdi), %ymm2
        vmovdqu	1120(%rdi), %ymm3
        vmovdqu	1152(%rdi), %ymm4
        vmovdqu	1184(%rdi), %ymm5
        vmovdqu	1216(%rdi), %ymm6
        vmovdqu	1248(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 128(%rsi)
        vmovdqu	1280(%rdi), %ymm0
        vmovdqu	1312(%rdi), %ymm1
        vmovdqu	1344(%rdi), %ymm2
        vmovdqu	1376(%rdi), %ymm3
        vmovdqu	1408(%rdi), %ymm4
        vmovdqu	1440(%rdi), %ymm5
        vmovdqu	1472(%rdi), %ymm6
        vmovdqu	1504(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 160(%rsi)
        vmovdqu	1536(%rdi), %ymm0
        vmovdqu	1568(%rdi), %ymm1
        vmovdqu	1600(%rdi), %ymm2
        vmovdqu	1632(%rdi), %ymm3
        vmovdqu	1664(%rdi), %ymm4
        vmovdqu	1696(%rdi), %ymm5
        vmovdqu	1728(%rdi), %ymm6
        vmovdqu	1760(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 192(%rsi)
        vmovdqu	1792(%rdi), %ymm0
        vmovdqu	1824(%rdi), %ymm1
        vmovdqu	1856(%rdi), %ymm2
        vmovdqu	1888(%rdi), %ymm3
        vmovdqu	1920(%rdi), %ymm4
        vmovdqu	1952(%rdi), %ymm5
        vmovdqu	1984(%rdi), %ymm6
        vmovdqu	2016(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 224(%rsi)
        vmovdqu	2048(%rdi), %ymm0
        vmovdqu	2080(%rdi), %ymm1
        vmovdqu	2112(%rdi), %ymm2
        vmovdqu	2144(%rdi), %ymm3
        vmovdqu	2176(%rdi), %ymm4
        vmovdqu	2208(%rdi), %ymm5
        vmovdqu	2240(%rdi), %ymm6
        vmovdqu	2272(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 256(%rsi)
        vmovdqu	2304(%rdi), %ymm0
        vmovdqu	2336(%rdi), %ymm1
        vmovdqu	2368(%rdi), %ymm2
        vmovdqu	2400(%rdi), %ymm3
        vmovdqu	2432(%rdi), %ymm4
        vmovdqu	2464(%rdi), %ymm5
        vmovdqu	2496(%rdi), %ymm6
        vmovdqu	2528(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 288(%rsi)
        vmovdqu	2560(%rdi), %ymm0
        vmovdqu	2592(%rdi), %ymm1
        vmovdqu	2624(%rdi), %ymm2
        vmovdqu	2656(%rdi), %ymm3
        vmovdqu	2688(%rdi), %ymm4
        vmovdqu	2720(%rdi), %ymm5
        vmovdqu	2752(%rdi), %ymm6
        vmovdqu	2784(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 320(%rsi)
        vmovdqu	2816(%rdi), %ymm0
        vmovdqu	2848(%rdi), %ymm1
        vmovdqu	2880(%rdi), %ymm2
        vmovdqu	2912(%rdi), %ymm3
        vmovdqu	2944(%rdi), %ymm4
        vmovdqu	2976(%rdi), %ymm5
        vmovdqu	3008(%rdi), %ymm6
        vmovdqu	3040(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 352(%rsi)
        vmovdqu	3072(%rdi), %ymm0
        vmovdqu	3104(%rdi), %ymm1
        vmovdqu	3136(%rdi), %ymm2
        vmovdqu	3168(%rdi), %ymm3
        vmovdqu	3200(%rdi), %ymm4
        vmovdqu	3232(%rdi), %ymm5
        vmovdqu	3264(%rdi), %ymm6
        vmovdqu	3296(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 384(%rsi)
        vmovdqu	3328(%rdi), %ymm0
        vmovdqu	3360(%rdi), %ymm1
        vmovdqu	3392(%rdi), %ymm2
        vmovdqu	3424(%rdi), %ymm3
        vmovdqu	3456(%rdi), %ymm4
        vmovdqu	3488(%rdi), %ymm5
        vmovdqu	3520(%rdi), %ymm6
        vmovdqu	3552(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 416(%rsi)
        vmovdqu	3584(%rdi), %ymm0
        vmovdqu	3616(%rdi), %ymm1
        vmovdqu	3648(%rdi), %ymm2
        vmovdqu	3680(%rdi), %ymm3
        vmovdqu	3712(%rdi), %ymm4
        vmovdqu	3744(%rdi), %ymm5
        vmovdqu	3776(%rdi), %ymm6
        vmovdqu	3808(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 448(%rsi)
        vmovdqu	3840(%rdi), %ymm0
        vmovdqu	3872(%rdi), %ymm1
        vmovdqu	3904(%rdi), %ymm2
        vmovdqu	3936(%rdi), %ymm3
        vmovdqu	3968(%rdi), %ymm4
        vmovdqu	4000(%rdi), %ymm5
        vmovdqu	4032(%rdi), %ymm6
        vmovdqu	4064(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 480(%rsi)
        vmovdqu	4096(%rdi), %ymm0
        vmovdqu	4128(%rdi), %ymm1
        vmovdqu	4160(%rdi), %ymm2
        vmovdqu	4192(%rdi), %ymm3
        vmovdqu	4224(%rdi), %ymm4
        vmovdqu	4256(%rdi), %ymm5
        vmovdqu	4288(%rdi), %ymm6
        vmovdqu	4320(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 512(%rsi)
        vmovdqu	4352(%rdi), %ymm0
        vmovdqu	4384(%rdi), %ymm1
        vmovdqu	4416(%rdi), %ymm2
        vmovdqu	4448(%rdi), %ymm3
        vmovdqu	4480(%rdi), %ymm4
        vmovdqu	4512(%rdi), %ymm5
        vmovdqu	4544(%rdi), %ymm6
        vmovdqu	4576(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 544(%rsi)
        vmovdqu	4608(%rdi), %ymm0
        vmovdqu	4640(%rdi), %ymm1
        vmovdqu	4672(%rdi), %ymm2
        vmovdqu	4704(%rdi), %ymm3
        vmovdqu	4736(%rdi), %ymm4
        vmovdqu	4768(%rdi), %ymm5
        vmovdqu	4800(%rdi), %ymm6
        vmovdqu	4832(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 576(%rsi)
        vmovdqu	4864(%rdi), %ymm0
        vmovdqu	4896(%rdi), %ymm1
        vmovdqu	4928(%rdi), %ymm2
        vmovdqu	4960(%rdi), %ymm3
        vmovdqu	4992(%rdi), %ymm4
        vmovdqu	5024(%rdi), %ymm5
        vmovdqu	5056(%rdi), %ymm6
        vmovdqu	5088(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 608(%rsi)
        vmovdqu	5120(%rdi), %ymm0
        vmovdqu	5152(%rdi), %ymm1
        vmovdqu	5184(%rdi), %ymm2
        vmovdqu	5216(%rdi), %ymm3
        vmovdqu	5248(%rdi), %ymm4
        vmovdqu	5280(%rdi), %ymm5
        vmovdqu	5312(%rdi), %ymm6
        vmovdqu	5344(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 640(%rsi)
        vmovdqu	5376(%rdi), %ymm0
        vmovdqu	5408(%rdi), %ymm1
        vmovdqu	5440(%rdi), %ymm2
        vmovdqu	5472(%rdi), %ymm3
        vmovdqu	5504(%rdi), %ymm4
        vmovdqu	5536(%rdi), %ymm5
        vmovdqu	5568(%rdi), %ymm6
        vmovdqu	5600(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 672(%rsi)
        vmovdqu	5632(%rdi), %ymm0
        vmovdqu	5664(%rdi), %ymm1
        vmovdqu	5696(%rdi), %ymm2
        vmovdqu	5728(%rdi), %ymm3
        vmovdqu	5760(%rdi), %ymm4
        vmovdqu	5792(%rdi), %ymm5
        vmovdqu	5824(%rdi), %ymm6
        vmovdqu	5856(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 704(%rsi)
        vmovdqu	5888(%rdi), %ymm0
        vmovdqu	5920(%rdi), %ymm1
        vmovdqu	5952(%rdi), %ymm2
        vmovdqu	5984(%rdi), %ymm3
        vmovdqu	6016(%rdi), %ymm4
        vmovdqu	6048(%rdi), %ymm5
        vmovdqu	6080(%rdi), %ymm6
        vmovdqu	6112(%rdi), %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vpsllvd	%ymm9, %ymm0, %ymm0
        vpsllvd	%ymm9, %ymm1, %ymm1
        vpsllvd	%ymm9, %ymm2, %ymm2
        vpsllvd	%ymm9, %ymm3, %ymm3
        vpsllvd	%ymm9, %ymm4, %ymm4
        vpsllvd	%ymm9, %ymm5, %ymm5
        vpsllvd	%ymm9, %ymm6, %ymm6
        vpsllvd	%ymm9, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 736(%rsi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_vec_encode_eta_4_avx2,.-wc_mldsa_vec_encode_eta_4_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_2_avx2_shuff_0:
.value	0xff00,0xffff
.value	0xff00,0xffff
.value	0x100,0xffff
.value	0xff01,0xffff
.value	0xff01,0xffff
.value	0x201,0xffff
.value	0xff02,0xffff
.value	0xff02,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_2_avx2_shuff_1:
.value	0xff01,0xffff
.value	0xff01,0xffff
.value	0x201,0xffff
.value	0xff02,0xffff
.value	0xff02,0xffff
.value	0x302,0xffff
.value	0xff03,0xffff
.value	0xff03,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_2_avx2_shuff_2:
.value	0xff02,0xffff
.value	0xff02,0xffff
.value	0x302,0xffff
.value	0xff03,0xffff
.value	0xff03,0xffff
.value	0x403,0xffff
.value	0xff04,0xffff
.value	0xff04,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_2_avx2_shuff_3:
.value	0xff03,0xffff
.value	0xff03,0xffff
.value	0x403,0xffff
.value	0xff04,0xffff
.value	0xff04,0xffff
.value	0x504,0xffff
.value	0xff05,0xffff
.value	0xff05,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_2_avx2_shuff_4:
.value	0xff04,0xffff
.value	0xff04,0xffff
.value	0x504,0xffff
.value	0xff05,0xffff
.value	0xff05,0xffff
.value	0x605,0xffff
.value	0xff06,0xffff
.value	0xff06,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_2_avx2_shuff_5:
.value	0xff05,0xffff
.value	0xff05,0xffff
.value	0x605,0xffff
.value	0xff06,0xffff
.value	0xff06,0xffff
.value	0x706,0xffff
.value	0xff07,0xffff
.value	0xff07,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_2_avx2_shuff_6:
.value	0xff06,0xffff
.value	0xff06,0xffff
.value	0x706,0xffff
.value	0xff07,0xffff
.value	0xff07,0xffff
.value	0x807,0xffff
.value	0xff08,0xffff
.value	0xff08,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_2_avx2_shuff_7:
.value	0xff07,0xffff
.value	0xff07,0xffff
.value	0x807,0xffff
.value	0xff08,0xffff
.value	0xff08,0xffff
.value	0x908,0xffff
.value	0xff09,0xffff
.value	0xff09,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_eta_2_avx2_two:
.long	0x00000002,0x00000002,0x00000002,0x00000002
.long	0x00000002,0x00000002,0x00000002,0x00000002
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_eta_2_avx2_vs:
.long	0x00000000,0x00000003,0x00000006,0x00000001
.long	0x00000004,0x00000007,0x00000002,0x00000005
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_eta_2_avx2_mask:
.long	0x00000007,0x00000007,0x00000007,0x00000007
.long	0x00000007,0x00000007,0x00000007,0x00000007
#ifndef __APPLE__
.text
.globl	wc_mldsa_decode_eta_2_avx2
.type	wc_mldsa_decode_eta_2_avx2,@function
.align	16
wc_mldsa_decode_eta_2_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_decode_eta_2_avx2
.p2align	4
_wc_mldsa_decode_eta_2_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm4, %ymm4, %ymm4
        vmovdqu	L_mldsa_decode_eta_2_avx2_shuff_0(%rip), %ymm4
        vmovdqu	L_mldsa_decode_eta_2_avx2_shuff_1(%rip), %ymm5
        vmovdqu	L_mldsa_decode_eta_2_avx2_shuff_2(%rip), %ymm6
        vmovdqu	L_mldsa_decode_eta_2_avx2_shuff_3(%rip), %ymm7
        vmovdqu	L_mldsa_decode_eta_2_avx2_shuff_4(%rip), %ymm8
        vmovdqu	L_mldsa_decode_eta_2_avx2_shuff_5(%rip), %ymm9
        vmovdqu	L_mldsa_decode_eta_2_avx2_shuff_6(%rip), %ymm10
        vmovdqu	L_mldsa_decode_eta_2_avx2_shuff_7(%rip), %ymm11
        vmovdqu	L_mldsa_decode_eta_2_avx2_two(%rip), %ymm12
        vmovdqu	L_mldsa_decode_eta_2_avx2_vs(%rip), %ymm13
        vmovdqu	L_mldsa_decode_eta_2_avx2_mask(%rip), %ymm14
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vpermq	$0x44, %ymm0, %ymm3
        vpshufb	%ymm4, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, (%rsi)
        vpermq	$0x44, %ymm0, %ymm3
        vpshufb	%ymm7, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 32(%rsi)
        vpermq	$0x44, %ymm0, %ymm3
        vpshufb	%ymm10, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 64(%rsi)
        vpermq	$57, %ymm0, %ymm0
        vpermq	$0x44, %ymm0, %ymm3
        vpshufb	%ymm5, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 96(%rsi)
        vpermq	$0x44, %ymm0, %ymm3
        vpshufb	%ymm8, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 128(%rsi)
        vpermq	$0x44, %ymm0, %ymm3
        vpshufb	%ymm11, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 160(%rsi)
        vpermq	$57, %ymm0, %ymm0
        vpermq	$0x44, %ymm0, %ymm3
        vpshufb	%ymm6, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 192(%rsi)
        vpermq	$0x44, %ymm0, %ymm3
        vpshufb	%ymm9, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 224(%rsi)
        vpermq	$57, %ymm0, %ymm0
        vpermq	$0x44, %ymm0, %ymm3
        vpshufb	%ymm4, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 256(%rsi)
        vpermq	$0x44, %ymm0, %ymm3
        vpshufb	%ymm7, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 288(%rsi)
        vperm2i128	$32, %ymm1, %ymm0, %ymm0
        vpermq	$56, %ymm0, %ymm0
        vpermq	$0x44, %ymm0, %ymm3
        vpshufb	%ymm10, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 320(%rsi)
        vpermq	$0x44, %ymm1, %ymm3
        vpshufb	%ymm5, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 352(%rsi)
        vpermq	$0x44, %ymm1, %ymm3
        vpshufb	%ymm8, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 384(%rsi)
        vpermq	$0x44, %ymm1, %ymm3
        vpshufb	%ymm11, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 416(%rsi)
        vpermq	$57, %ymm1, %ymm1
        vpermq	$0x44, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 448(%rsi)
        vpermq	$0x44, %ymm1, %ymm3
        vpshufb	%ymm9, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 480(%rsi)
        vpermq	$57, %ymm1, %ymm1
        vpermq	$0x44, %ymm1, %ymm3
        vpshufb	%ymm4, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 512(%rsi)
        vpermq	$0x44, %ymm1, %ymm3
        vpshufb	%ymm7, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 544(%rsi)
        vpermq	$0x44, %ymm1, %ymm3
        vpshufb	%ymm10, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 576(%rsi)
        vpermq	$57, %ymm1, %ymm1
        vpermq	$0x44, %ymm1, %ymm3
        vpshufb	%ymm5, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 608(%rsi)
        vpermq	$0x44, %ymm1, %ymm3
        vpshufb	%ymm8, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 640(%rsi)
        vperm2i128	$32, %ymm2, %ymm1, %ymm1
        vpermq	$56, %ymm1, %ymm1
        vpermq	$0x44, %ymm1, %ymm3
        vpshufb	%ymm11, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 672(%rsi)
        vpermq	$0x44, %ymm2, %ymm3
        vpshufb	%ymm6, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 704(%rsi)
        vpermq	$0x44, %ymm2, %ymm3
        vpshufb	%ymm9, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 736(%rsi)
        vpermq	$57, %ymm2, %ymm2
        vpermq	$0x44, %ymm2, %ymm3
        vpshufb	%ymm4, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 768(%rsi)
        vpermq	$0x44, %ymm2, %ymm3
        vpshufb	%ymm7, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 800(%rsi)
        vpermq	$0x44, %ymm2, %ymm3
        vpshufb	%ymm10, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 832(%rsi)
        vpermq	$57, %ymm2, %ymm2
        vpermq	$0x44, %ymm2, %ymm3
        vpshufb	%ymm5, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 864(%rsi)
        vpermq	$0x44, %ymm2, %ymm3
        vpshufb	%ymm8, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 896(%rsi)
        vpermq	$0x44, %ymm2, %ymm3
        vpshufb	%ymm11, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 928(%rsi)
        vpermq	$57, %ymm2, %ymm2
        vpermq	$0x44, %ymm2, %ymm3
        vpshufb	%ymm6, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 960(%rsi)
        vpermq	$0x44, %ymm2, %ymm3
        vpshufb	%ymm9, %ymm3, %ymm3
        vpsrlvd	%ymm13, %ymm3, %ymm3
        vpand	%ymm14, %ymm3, %ymm3
        vpsubd	%ymm3, %ymm12, %ymm3
        vmovdqu	%ymm3, 992(%rsi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_decode_eta_2_avx2,.-wc_mldsa_decode_eta_2_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_4_avx2_shuff_0:
.value	0xff00,0xffff
.value	0xff00,0xffff
.value	0x100,0xffff
.value	0xff01,0xffff
.value	0xff01,0xffff
.value	0x201,0xffff
.value	0xff02,0xffff
.value	0xff02,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_4_avx2_shuff_1:
.value	0xff01,0xffff
.value	0xff01,0xffff
.value	0x201,0xffff
.value	0xff02,0xffff
.value	0xff02,0xffff
.value	0x302,0xffff
.value	0xff03,0xffff
.value	0xff03,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_4_avx2_shuff_2:
.value	0xff02,0xffff
.value	0xff02,0xffff
.value	0x302,0xffff
.value	0xff03,0xffff
.value	0xff03,0xffff
.value	0x403,0xffff
.value	0xff04,0xffff
.value	0xff04,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_4_avx2_shuff_3:
.value	0xff03,0xffff
.value	0xff03,0xffff
.value	0x403,0xffff
.value	0xff04,0xffff
.value	0xff04,0xffff
.value	0x504,0xffff
.value	0xff05,0xffff
.value	0xff05,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_4_avx2_shuff_4:
.value	0xff04,0xffff
.value	0xff04,0xffff
.value	0x504,0xffff
.value	0xff05,0xffff
.value	0xff05,0xffff
.value	0x605,0xffff
.value	0xff06,0xffff
.value	0xff06,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_4_avx2_shuff_5:
.value	0xff05,0xffff
.value	0xff05,0xffff
.value	0x605,0xffff
.value	0xff06,0xffff
.value	0xff06,0xffff
.value	0x706,0xffff
.value	0xff07,0xffff
.value	0xff07,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_4_avx2_shuff_6:
.value	0xff06,0xffff
.value	0xff06,0xffff
.value	0x706,0xffff
.value	0xff07,0xffff
.value	0xff07,0xffff
.value	0x807,0xffff
.value	0xff08,0xffff
.value	0xff08,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_eta_4_avx2_shuff_7:
.value	0xff07,0xffff
.value	0xff07,0xffff
.value	0x807,0xffff
.value	0xff08,0xffff
.value	0xff08,0xffff
.value	0x908,0xffff
.value	0xff09,0xffff
.value	0xff09,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_eta_4_avx2_four:
.long	0x00000004,0x00000004,0x00000004,0x00000004
.long	0x00000004,0x00000004,0x00000004,0x00000004
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_eta_4_avx2_vs:
.long	0x00000000,0x00000004,0x00000008,0x0000000c
.long	0x00000010,0x00000014,0x00000018,0x0000001c
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_eta_4_avx2_mask:
.long	0x0000000f,0x0000000f,0x0000000f,0x0000000f
.long	0x0000000f,0x0000000f,0x0000000f,0x0000000f
#ifndef __APPLE__
.text
.globl	wc_mldsa_decode_eta_4_avx2
.type	wc_mldsa_decode_eta_4_avx2,@function
.align	16
wc_mldsa_decode_eta_4_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_decode_eta_4_avx2
.p2align	4
_wc_mldsa_decode_eta_4_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm8, %ymm8, %ymm8
        vmovdqu	L_mldsa_decode_eta_4_avx2_four(%rip), %ymm8
        vmovdqu	L_mldsa_decode_eta_4_avx2_vs(%rip), %ymm9
        vmovdqu	L_mldsa_decode_eta_4_avx2_mask(%rip), %ymm10
        vpbroadcastd	(%rdi), %ymm0
        vpbroadcastd	4(%rdi), %ymm1
        vpbroadcastd	8(%rdi), %ymm2
        vpbroadcastd	12(%rdi), %ymm3
        vpbroadcastd	16(%rdi), %ymm4
        vpbroadcastd	20(%rdi), %ymm5
        vpbroadcastd	24(%rdi), %ymm6
        vpbroadcastd	28(%rdi), %ymm7
        vpsrlvd	%ymm9, %ymm0, %ymm0
        vpsrlvd	%ymm9, %ymm1, %ymm1
        vpsrlvd	%ymm9, %ymm2, %ymm2
        vpsrlvd	%ymm9, %ymm3, %ymm3
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm5, %ymm5
        vpsrlvd	%ymm9, %ymm6, %ymm6
        vpsrlvd	%ymm9, %ymm7, %ymm7
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm1, %ymm1
        vpand	%ymm10, %ymm2, %ymm2
        vpand	%ymm10, %ymm3, %ymm3
        vpand	%ymm10, %ymm4, %ymm4
        vpand	%ymm10, %ymm5, %ymm5
        vpand	%ymm10, %ymm6, %ymm6
        vpand	%ymm10, %ymm7, %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	%ymm1, 32(%rsi)
        vmovdqu	%ymm2, 64(%rsi)
        vmovdqu	%ymm3, 96(%rsi)
        vmovdqu	%ymm4, 128(%rsi)
        vmovdqu	%ymm5, 160(%rsi)
        vmovdqu	%ymm6, 192(%rsi)
        vmovdqu	%ymm7, 224(%rsi)
        vpbroadcastd	32(%rdi), %ymm0
        vpbroadcastd	36(%rdi), %ymm1
        vpbroadcastd	40(%rdi), %ymm2
        vpbroadcastd	44(%rdi), %ymm3
        vpbroadcastd	48(%rdi), %ymm4
        vpbroadcastd	52(%rdi), %ymm5
        vpbroadcastd	56(%rdi), %ymm6
        vpbroadcastd	60(%rdi), %ymm7
        vpsrlvd	%ymm9, %ymm0, %ymm0
        vpsrlvd	%ymm9, %ymm1, %ymm1
        vpsrlvd	%ymm9, %ymm2, %ymm2
        vpsrlvd	%ymm9, %ymm3, %ymm3
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm5, %ymm5
        vpsrlvd	%ymm9, %ymm6, %ymm6
        vpsrlvd	%ymm9, %ymm7, %ymm7
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm1, %ymm1
        vpand	%ymm10, %ymm2, %ymm2
        vpand	%ymm10, %ymm3, %ymm3
        vpand	%ymm10, %ymm4, %ymm4
        vpand	%ymm10, %ymm5, %ymm5
        vpand	%ymm10, %ymm6, %ymm6
        vpand	%ymm10, %ymm7, %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vmovdqu	%ymm0, 256(%rsi)
        vmovdqu	%ymm1, 288(%rsi)
        vmovdqu	%ymm2, 320(%rsi)
        vmovdqu	%ymm3, 352(%rsi)
        vmovdqu	%ymm4, 384(%rsi)
        vmovdqu	%ymm5, 416(%rsi)
        vmovdqu	%ymm6, 448(%rsi)
        vmovdqu	%ymm7, 480(%rsi)
        vpbroadcastd	64(%rdi), %ymm0
        vpbroadcastd	68(%rdi), %ymm1
        vpbroadcastd	72(%rdi), %ymm2
        vpbroadcastd	76(%rdi), %ymm3
        vpbroadcastd	80(%rdi), %ymm4
        vpbroadcastd	84(%rdi), %ymm5
        vpbroadcastd	88(%rdi), %ymm6
        vpbroadcastd	92(%rdi), %ymm7
        vpsrlvd	%ymm9, %ymm0, %ymm0
        vpsrlvd	%ymm9, %ymm1, %ymm1
        vpsrlvd	%ymm9, %ymm2, %ymm2
        vpsrlvd	%ymm9, %ymm3, %ymm3
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm5, %ymm5
        vpsrlvd	%ymm9, %ymm6, %ymm6
        vpsrlvd	%ymm9, %ymm7, %ymm7
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm1, %ymm1
        vpand	%ymm10, %ymm2, %ymm2
        vpand	%ymm10, %ymm3, %ymm3
        vpand	%ymm10, %ymm4, %ymm4
        vpand	%ymm10, %ymm5, %ymm5
        vpand	%ymm10, %ymm6, %ymm6
        vpand	%ymm10, %ymm7, %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vmovdqu	%ymm0, 512(%rsi)
        vmovdqu	%ymm1, 544(%rsi)
        vmovdqu	%ymm2, 576(%rsi)
        vmovdqu	%ymm3, 608(%rsi)
        vmovdqu	%ymm4, 640(%rsi)
        vmovdqu	%ymm5, 672(%rsi)
        vmovdqu	%ymm6, 704(%rsi)
        vmovdqu	%ymm7, 736(%rsi)
        vpbroadcastd	96(%rdi), %ymm0
        vpbroadcastd	100(%rdi), %ymm1
        vpbroadcastd	104(%rdi), %ymm2
        vpbroadcastd	108(%rdi), %ymm3
        vpbroadcastd	112(%rdi), %ymm4
        vpbroadcastd	116(%rdi), %ymm5
        vpbroadcastd	120(%rdi), %ymm6
        vpbroadcastd	124(%rdi), %ymm7
        vpsrlvd	%ymm9, %ymm0, %ymm0
        vpsrlvd	%ymm9, %ymm1, %ymm1
        vpsrlvd	%ymm9, %ymm2, %ymm2
        vpsrlvd	%ymm9, %ymm3, %ymm3
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm5, %ymm5
        vpsrlvd	%ymm9, %ymm6, %ymm6
        vpsrlvd	%ymm9, %ymm7, %ymm7
        vpand	%ymm10, %ymm0, %ymm0
        vpand	%ymm10, %ymm1, %ymm1
        vpand	%ymm10, %ymm2, %ymm2
        vpand	%ymm10, %ymm3, %ymm3
        vpand	%ymm10, %ymm4, %ymm4
        vpand	%ymm10, %ymm5, %ymm5
        vpand	%ymm10, %ymm6, %ymm6
        vpand	%ymm10, %ymm7, %ymm7
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsubd	%ymm4, %ymm8, %ymm4
        vpsubd	%ymm5, %ymm8, %ymm5
        vpsubd	%ymm6, %ymm8, %ymm6
        vpsubd	%ymm7, %ymm8, %ymm7
        vmovdqu	%ymm0, 768(%rsi)
        vmovdqu	%ymm1, 800(%rsi)
        vmovdqu	%ymm2, 832(%rsi)
        vmovdqu	%ymm3, 864(%rsi)
        vmovdqu	%ymm4, 896(%rsi)
        vmovdqu	%ymm5, 928(%rsi)
        vmovdqu	%ymm6, 960(%rsi)
        vmovdqu	%ymm7, 992(%rsi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_decode_eta_4_avx2,.-wc_mldsa_decode_eta_4_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_w1_88_avx2_shuff_0_even:
.value	0x900,0xff0a
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0xff
.value	0xa09,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_w1_88_avx2_shuff_0_odd:
.value	0x504,0xff0e
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0x4ff
.value	0xe05,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_w1_88_avx2_shuff_1_even:
.value	0xffff,0xffff
.value	0xffff,0x900
.value	0xff0a,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xff,0xa09
.value	0xffff,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_w1_88_avx2_shuff_1_odd:
.value	0xffff,0xffff
.value	0xffff,0x504
.value	0xff0e,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0x4ff,0xe05
.value	0xffff,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_w1_88_avx2_vs:
.long	0x00000000,0x00000006,0x0000000c,0x00000012
.long	0x00000000,0x00000006,0x0000000c,0x00000012
#ifndef __APPLE__
.text
.globl	wc_mldsa_encode_w1_88_avx2
.type	wc_mldsa_encode_w1_88_avx2,@function
.align	16
wc_mldsa_encode_w1_88_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_encode_w1_88_avx2
.p2align	4
_wc_mldsa_encode_w1_88_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm4, %ymm4, %ymm4
        vmovdqu	L_mldsa_encode_w1_88_avx2_shuff_0_even(%rip), %ymm4
        vmovdqu	L_mldsa_encode_w1_88_avx2_shuff_0_odd(%rip), %ymm5
        vmovdqu	L_mldsa_encode_w1_88_avx2_shuff_1_even(%rip), %ymm6
        vmovdqu	L_mldsa_encode_w1_88_avx2_shuff_1_odd(%rip), %ymm7
        vmovdqu	L_mldsa_encode_w1_88_avx2_vs(%rip), %ymm8
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	64(%rdi), %ymm0
        vmovdqu	96(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	128(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	192(%rdi), %ymm0
        vmovdqu	224(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	320(%rdi), %ymm0
        vmovdqu	352(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	384(%rdi), %ymm0
        vmovdqu	416(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	448(%rdi), %ymm0
        vmovdqu	480(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	576(%rdi), %ymm0
        vmovdqu	608(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	640(%rdi), %ymm0
        vmovdqu	672(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	704(%rdi), %ymm0
        vmovdqu	736(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	832(%rdi), %ymm0
        vmovdqu	864(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	896(%rdi), %ymm0
        vmovdqu	928(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vmovdqu	960(%rdi), %ymm0
        vmovdqu	992(%rdi), %ymm1
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpshufb	%ymm5, %ymm0, %ymm2
        vpshufb	%ymm4, %ymm0, %ymm0
        vpshufb	%ymm7, %ymm1, %ymm3
        vpshufb	%ymm6, %ymm1, %ymm1
        vpor	%ymm2, %ymm0, %ymm0
        vpor	%ymm3, %ymm0, %ymm0
        vpor	%ymm1, %ymm0, %ymm0
        vextracti128	$0x01, %ymm0, %xmm2
        vpor	%ymm2, %ymm0, %ymm0
        vmovq	%xmm0, (%rsi)
        vpextrd	$2, %xmm0, 8(%rsi)
        addq	$12, %rsi
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_encode_w1_88_avx2,.-wc_mldsa_encode_w1_88_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_w1_32_avx2_vs_4:
.long	0x00000000,0x00000004,0x00000000,0x00000004
.long	0x00000000,0x00000004,0x00000000,0x00000004
#ifndef __APPLE__
.text
.globl	wc_mldsa_encode_w1_32_avx2
.type	wc_mldsa_encode_w1_32_avx2,@function
.align	16
wc_mldsa_encode_w1_32_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_encode_w1_32_avx2
.p2align	4
_wc_mldsa_encode_w1_32_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm8, %ymm8, %ymm8
        vmovdqu	L_mldsa_encode_w1_32_avx2_vs_4(%rip), %ymm8
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        vmovdqu	192(%rdi), %ymm6
        vmovdqu	224(%rdi), %ymm7
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpsllvd	%ymm8, %ymm4, %ymm4
        vpsllvd	%ymm8, %ymm5, %ymm5
        vpsllvd	%ymm8, %ymm6, %ymm6
        vpsllvd	%ymm8, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, (%rsi)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vmovdqu	384(%rdi), %ymm4
        vmovdqu	416(%rdi), %ymm5
        vmovdqu	448(%rdi), %ymm6
        vmovdqu	480(%rdi), %ymm7
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpsllvd	%ymm8, %ymm4, %ymm4
        vpsllvd	%ymm8, %ymm5, %ymm5
        vpsllvd	%ymm8, %ymm6, %ymm6
        vpsllvd	%ymm8, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 32(%rsi)
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vmovdqu	576(%rdi), %ymm2
        vmovdqu	608(%rdi), %ymm3
        vmovdqu	640(%rdi), %ymm4
        vmovdqu	672(%rdi), %ymm5
        vmovdqu	704(%rdi), %ymm6
        vmovdqu	736(%rdi), %ymm7
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpsllvd	%ymm8, %ymm4, %ymm4
        vpsllvd	%ymm8, %ymm5, %ymm5
        vpsllvd	%ymm8, %ymm6, %ymm6
        vpsllvd	%ymm8, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 64(%rsi)
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vmovdqu	832(%rdi), %ymm2
        vmovdqu	864(%rdi), %ymm3
        vmovdqu	896(%rdi), %ymm4
        vmovdqu	928(%rdi), %ymm5
        vmovdqu	960(%rdi), %ymm6
        vmovdqu	992(%rdi), %ymm7
        vpsllvd	%ymm8, %ymm0, %ymm0
        vpsllvd	%ymm8, %ymm1, %ymm1
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpsllvd	%ymm8, %ymm4, %ymm4
        vpsllvd	%ymm8, %ymm5, %ymm5
        vpsllvd	%ymm8, %ymm6, %ymm6
        vpsllvd	%ymm8, %ymm7, %ymm7
        vpackusdw	%ymm1, %ymm0, %ymm0
        vpackusdw	%ymm3, %ymm2, %ymm1
        vpackusdw	%ymm5, %ymm4, %ymm2
        vpackusdw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpermq	$0xd8, %ymm2, %ymm2
        vpermq	$0xd8, %ymm3, %ymm3
        vphaddw	%ymm1, %ymm0, %ymm0
        vphaddw	%ymm3, %ymm2, %ymm1
        vphaddw	%ymm5, %ymm4, %ymm2
        vphaddw	%ymm7, %ymm6, %ymm3
        vpermq	$0xd8, %ymm0, %ymm0
        vpermq	$0xd8, %ymm1, %ymm1
        vpackuswb	%ymm1, %ymm0, %ymm0
        vpermq	$0xd8, %ymm0, %ymm0
        vmovdqu	%ymm0, 96(%rsi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_encode_w1_32_avx2,.-wc_mldsa_encode_w1_32_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_t0_t1_avx2_d_max_half_m1:
.long	0x00000fff,0x00000fff,0x00000fff,0x00000fff
.long	0x00000fff,0x00000fff,0x00000fff,0x00000fff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_t0_t1_avx2_d_max_half:
.long	0x00001000,0x00001000,0x00001000,0x00001000
.long	0x00001000,0x00001000,0x00001000,0x00001000
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_t0_t1_avx2_vs_13:
.long	0x00000000,0x0000000d,0x00000002,0x0000000f
.long	0x00000004,0x00000011,0x00000006,0x00000013
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_t0_t1_avx2_shuff_13_even:
.value	0x100,0x8ff
.value	0xff09,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0x100
.value	0x802,0xa09
.value	0xffff,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_t0_t1_avx2_shuff_13_odd:
.value	0x5ff,0x706
.value	0xe0d,0xff0f
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0x706,0xeff
.value	0xff0f,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_t0_t1_avx2_vs_10:
.long	0x00000000,0x0000000a,0x00000004,0x0000000e
.long	0x00000000,0x0000000a,0x00000004,0x0000000e
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_t0_t1_avx2_shuff_10_even:
.value	0x100,0x908
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xff,0x801
.value	0xff09,0xffff
.value	0xffff,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_t0_t1_avx2_shuff_10_odd:
.value	0x5ff,0xd06
.value	0xff0e,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0xffff,0x605
.value	0xe0d,0xffff
.value	0xffff,0xffff
#ifndef __APPLE__
.text
.globl	wc_mldsa_vec_encode_t0_t1_avx2
.type	wc_mldsa_vec_encode_t0_t1_avx2,@function
.align	16
wc_mldsa_vec_encode_t0_t1_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_vec_encode_t0_t1_avx2
.p2align	4
_wc_mldsa_vec_encode_t0_t1_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_mldsa_encode_t0_t1_avx2_d_max_half_m1(%rip), %ymm6
        vmovdqu	L_mldsa_encode_t0_t1_avx2_d_max_half(%rip), %ymm7
        vmovdqu	L_mldsa_encode_t0_t1_avx2_vs_13(%rip), %ymm8
        vmovdqu	L_mldsa_encode_t0_t1_avx2_shuff_13_even(%rip), %ymm9
        vmovdqu	L_mldsa_encode_t0_t1_avx2_shuff_13_odd(%rip), %ymm10
        vmovdqu	L_mldsa_encode_t0_t1_avx2_vs_10(%rip), %ymm11
        vmovdqu	L_mldsa_encode_t0_t1_avx2_shuff_10_even(%rip), %ymm12
        vmovdqu	L_mldsa_encode_t0_t1_avx2_shuff_10_odd(%rip), %ymm13
L_mldsa_encode_t0_t1_avx2_loop:
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	64(%rdi), %ymm0
        vmovdqu	96(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	128(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	192(%rdi), %ymm0
        vmovdqu	224(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	320(%rdi), %ymm0
        vmovdqu	352(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	384(%rdi), %ymm0
        vmovdqu	416(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	448(%rdi), %ymm0
        vmovdqu	480(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	576(%rdi), %ymm0
        vmovdqu	608(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	640(%rdi), %ymm0
        vmovdqu	672(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	704(%rdi), %ymm0
        vmovdqu	736(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	832(%rdi), %ymm0
        vmovdqu	864(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	896(%rdi), %ymm0
        vmovdqu	928(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        vmovdqu	960(%rdi), %ymm0
        vmovdqu	992(%rdi), %ymm1
        vpaddd	%ymm6, %ymm0, %ymm4
        vpaddd	%ymm6, %ymm1, %ymm5
        vpsrld	$13, %ymm4, %ymm4
        vpsrld	$13, %ymm5, %ymm5
        vpslld	$13, %ymm4, %ymm2
        vpslld	$13, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm7, %ymm2
        vpsubd	%ymm3, %ymm7, %ymm3
        vpsllvd	%ymm8, %ymm2, %ymm2
        vpsllvd	%ymm8, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm2, %ymm0
        vpshufb	%ymm10, %ymm3, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vextracti128	$0x01, %ymm2, %xmm0
        vextracti128	$0x01, %ymm3, %xmm1
        vpor	%ymm0, %ymm2, %ymm2
        vpor	%ymm1, %ymm3, %ymm3
        vmovdqu	%xmm2, (%rdx)
        addq	$13, %rdx
        vmovdqu	%xmm3, (%rdx)
        addq	$13, %rdx
        vpsllvd	%ymm11, %ymm4, %ymm4
        vpsllvd	%ymm11, %ymm5, %ymm5
        vpshufb	%ymm13, %ymm4, %ymm0
        vpshufb	%ymm13, %ymm5, %ymm1
        vpshufb	%ymm12, %ymm4, %ymm4
        vpshufb	%ymm12, %ymm5, %ymm5
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vextracti128	$0x01, %ymm4, %xmm0
        vextracti128	$0x01, %ymm5, %xmm1
        vpor	%ymm0, %ymm4, %ymm4
        vpor	%ymm1, %ymm5, %ymm5
        vmovdqu	%xmm4, (%rcx)
        addq	$10, %rcx
        vmovdqu	%xmm5, (%rcx)
        addq	$10, %rcx
        addq	$0x400, %rdi
        decb	%sil
        jnz	L_mldsa_encode_t0_t1_avx2_loop
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_vec_encode_t0_t1_avx2,.-wc_mldsa_vec_encode_t0_t1_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_t0_avx2_shuff_0:
.value	0x100,0xffff
.value	0x1ff,0x302
.value	0x403,0xff05
.value	0x504,0x706
.value	0x706,0xff08
.value	0x8ff,0xff09
.value	0xa09,0xff0b
.value	0xffff,0xc0b
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_t0_avx2_shuff_1:
.value	0x605,0xffff
.value	0x6ff,0x807
.value	0x908,0xffff
.value	0xa09,0xff0b
.value	0x403,0xff05
.value	0x5ff,0xff06
.value	0x706,0xff08
.value	0xffff,0x908
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_t0_avx2_shuff_2:
.value	0x302,0xffff
.value	0x3ff,0x504
.value	0x605,0xffff
.value	0x706,0xff08
.value	0x100,0xff02
.value	0x2ff,0xff03
.value	0x403,0xff05
.value	0xffff,0x605
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_t0_avx2_shuff_3:
.value	0x807,0xffff
.value	0x8ff,0xa09
.value	0xb0a,0xffff
.value	0xc0b,0xff0d
.value	0x605,0xff07
.value	0x7ff,0xff08
.value	0x908,0xff0a
.value	0xffff,0xb0a
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_t0_avx2_shuff_4:
.value	0x504,0xffff
.value	0x5ff,0x706
.value	0x807,0xffff
.value	0x908,0xff0a
.value	0x302,0xff04
.value	0x4ff,0xff05
.value	0x605,0xff07
.value	0xffff,0x807
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_t0_avx2_shuff_5:
.value	0x201,0xffff
.value	0x2ff,0x403
.value	0x504,0xffff
.value	0x605,0xff07
.value	0x807,0xff09
.value	0x9ff,0xff0a
.value	0xb0a,0xff0c
.value	0xffff,0xd0c
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_t0_avx2_shuff_6:
.value	0x706,0xffff
.value	0x7ff,0x908
.value	0xa09,0xffff
.value	0xb0a,0xff0c
.value	0x504,0xff06
.value	0x6ff,0x807
.value	0x807,0xff09
.value	0xffff,0xa09
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_t0_avx2_shuff_7:
.value	0x403,0xffff
.value	0x4ff,0x605
.value	0x706,0xffff
.value	0x807,0xff09
.value	0x201,0xff03
.value	0x3ff,0xff04
.value	0x504,0xff06
.value	0xffff,0x706
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_t0_avx2_vs_8:
.long	0x00000000,0x0000000d,0x00000002,0x00000007
.long	0x00000004,0x00000009,0x00000006,0x00000013
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_t0_avx2_mask:
.long	0x00001fff,0x00001fff,0x00001fff,0x00001fff
.long	0x00001fff,0x00001fff,0x00001fff,0x00001fff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_t0_avx2_d_max_half:
.long	0x00001000,0x00001000,0x00001000,0x00001000
.long	0x00001000,0x00001000,0x00001000,0x00001000
#ifndef __APPLE__
.text
.globl	wc_mldsa_decode_t0_avx2
.type	wc_mldsa_decode_t0_avx2,@function
.align	16
wc_mldsa_decode_t0_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_decode_t0_avx2
.p2align	4
_wc_mldsa_decode_t0_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm5, %ymm5, %ymm5
        vmovdqu	L_mldsa_decode_t0_avx2_shuff_0(%rip), %ymm5
        vmovdqu	L_mldsa_decode_t0_avx2_shuff_1(%rip), %ymm6
        vmovdqu	L_mldsa_decode_t0_avx2_shuff_2(%rip), %ymm7
        vmovdqu	L_mldsa_decode_t0_avx2_shuff_3(%rip), %ymm8
        vmovdqu	L_mldsa_decode_t0_avx2_shuff_4(%rip), %ymm9
        vmovdqu	L_mldsa_decode_t0_avx2_shuff_5(%rip), %ymm10
        vmovdqu	L_mldsa_decode_t0_avx2_shuff_6(%rip), %ymm11
        vmovdqu	L_mldsa_decode_t0_avx2_shuff_7(%rip), %ymm12
        vmovdqu	L_mldsa_decode_t0_avx2_vs_8(%rip), %ymm13
        vmovdqu	L_mldsa_decode_t0_avx2_mask(%rip), %ymm14
        vmovdqu	L_mldsa_decode_t0_avx2_d_max_half(%rip), %ymm15
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        # 1/32
        vpermq	$0x44, %ymm0, %ymm4
        vpshufb	%ymm5, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, (%rsi)
        # 2/32
        vpermq	$0xe9, %ymm0, %ymm4
        vpshufb	%ymm6, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 32(%rsi)
        # 3/32
        vperm2i128	$0x21, %ymm1, %ymm0, %ymm0
        vpermq	$0xe9, %ymm0, %ymm4
        vpshufb	%ymm7, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 64(%rsi)
        # 4/32
        vpermq	$0x94, %ymm1, %ymm4
        vpshufb	%ymm8, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 96(%rsi)
        # 5/32
        vperm2i128	$0x21, %ymm2, %ymm1, %ymm1
        vpermq	$0x94, %ymm1, %ymm4
        vpshufb	%ymm9, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 128(%rsi)
        # 6/32
        vpermq	$0x44, %ymm2, %ymm4
        vpshufb	%ymm10, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 160(%rsi)
        # 7/32
        vpermq	$0xe9, %ymm2, %ymm4
        vpshufb	%ymm11, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 192(%rsi)
        # 8/32
        vperm2i128	$0x21, %ymm3, %ymm2, %ymm2
        vpermq	$0xe9, %ymm2, %ymm4
        vpshufb	%ymm12, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 224(%rsi)
        # 9/32
        vpermq	$0x99, %ymm3, %ymm4
        vpshufb	%ymm5, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 256(%rsi)
        # 10/32
        vmovdqu	128(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vperm2i128	$0x21, %ymm0, %ymm3, %ymm3
        vpermq	$0x94, %ymm3, %ymm4
        vpshufb	%ymm6, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 288(%rsi)
        # 11/32
        vpermq	$0x94, %ymm0, %ymm4
        vpshufb	%ymm7, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 320(%rsi)
        # 12/32
        vpermq	$0xe9, %ymm0, %ymm4
        vpshufb	%ymm8, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 352(%rsi)
        # 13/32
        vperm2i128	$0x21, %ymm1, %ymm0, %ymm0
        vpermq	$0xe9, %ymm0, %ymm4
        vpshufb	%ymm9, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 384(%rsi)
        # 14/32
        vpermq	$0x99, %ymm1, %ymm4
        vpshufb	%ymm10, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 416(%rsi)
        # 15/32
        vmovdqu	192(%rdi), %ymm2
        vmovdqu	224(%rdi), %ymm3
        vperm2i128	$0x21, %ymm2, %ymm1, %ymm1
        vpermq	$0x94, %ymm1, %ymm4
        vpshufb	%ymm11, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 448(%rsi)
        # 16/32
        vpermq	$0x94, %ymm2, %ymm4
        vpshufb	%ymm12, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 480(%rsi)
        # 17/32
        vpermq	$0xee, %ymm2, %ymm4
        vpshufb	%ymm5, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 512(%rsi)
        # 18/32
        vperm2i128	$0x21, %ymm3, %ymm2, %ymm2
        vpermq	$0xe9, %ymm2, %ymm4
        vpshufb	%ymm6, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 544(%rsi)
        # 19/32
        vpermq	$0xe9, %ymm3, %ymm4
        vpshufb	%ymm7, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 576(%rsi)
        # 20/32
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vperm2i128	$0x21, %ymm0, %ymm3, %ymm3
        vpermq	$0x94, %ymm3, %ymm4
        vpshufb	%ymm8, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 608(%rsi)
        # 21/32
        vpermq	$0x94, %ymm0, %ymm4
        vpshufb	%ymm9, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 640(%rsi)
        # 22/32
        vpermq	$0xee, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 672(%rsi)
        # 23/32
        vperm2i128	$0x21, %ymm1, %ymm0, %ymm0
        vpermq	$0xe9, %ymm0, %ymm4
        vpshufb	%ymm11, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 704(%rsi)
        # 24/32
        vpermq	$0xe9, %ymm1, %ymm4
        vpshufb	%ymm12, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 736(%rsi)
        # 25/32
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vperm2i128	$0x21, %ymm2, %ymm1, %ymm1
        vpermq	$0x99, %ymm1, %ymm4
        vpshufb	%ymm5, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 768(%rsi)
        # 26/32
        vpermq	$0x94, %ymm2, %ymm4
        vpshufb	%ymm6, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 800(%rsi)
        # 27/32
        vpermq	$0x3e, %ymm2, %ymm4
        vpshufb	%ymm7, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 832(%rsi)
        # 28/32
        vperm2i128	$0x21, %ymm3, %ymm2, %ymm2
        vpermq	$0xe9, %ymm2, %ymm4
        vpshufb	%ymm8, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 864(%rsi)
        # 29/32
        vpermq	$0xe9, %ymm3, %ymm4
        vpshufb	%ymm9, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 896(%rsi)
        # 30/32
        vmovdqu	384(%rdi), %ymm0
        vmovdqu	416(%rdi), %ymm1
        vperm2i128	$0x21, %ymm0, %ymm3, %ymm3
        vpermq	$0x99, %ymm3, %ymm4
        vpshufb	%ymm10, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 928(%rsi)
        # 31/32
        vpermq	$0x94, %ymm0, %ymm4
        vpshufb	%ymm11, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 960(%rsi)
        # 32/32
        vpermq	$0x3e, %ymm0, %ymm4
        vpshufb	%ymm12, %ymm4, %ymm4
        vpsrlvd	%ymm13, %ymm4, %ymm4
        vpand	%ymm14, %ymm4, %ymm4
        vpsubd	%ymm4, %ymm15, %ymm4
        vmovdqu	%ymm4, 992(%rsi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_decode_t0_avx2,.-wc_mldsa_decode_t0_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_t1_avx2_shuff_0:
.value	0x100,0xffff
.value	0x1ff,0xff02
.value	0x302,0xffff
.value	0x3ff,0xff04
.value	0x605,0xffff
.value	0x6ff,0xff07
.value	0x807,0xffff
.value	0x8ff,0xff09
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_t1_avx2_shuff_1:
.value	0x302,0xffff
.value	0x3ff,0xff04
.value	0x504,0xffff
.value	0x5ff,0xff06
.value	0x807,0xffff
.value	0x8ff,0xff09
.value	0xa09,0xff08
.value	0xaff,0xff0b
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_t1_avx2_shuff_2:
.value	0x504,0xffff
.value	0x5ff,0xff06
.value	0x706,0xffff
.value	0x7ff,0xff08
.value	0x201,0xffff
.value	0x2ff,0xff03
.value	0x403,0xffff
.value	0x4ff,0xff05
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_t1_avx2_shuff_3:
.value	0x706,0xffff
.value	0x7ff,0xff08
.value	0x908,0xffff
.value	0x9ff,0xff0a
.value	0x403,0xffff
.value	0x4ff,0xff05
.value	0x605,0xffff
.value	0x6ff,0xff07
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_t1_avx2_vs_8:
.long	0x00000000,0x0000000a,0x00000004,0x0000000e
.long	0x00000000,0x0000000a,0x00000004,0x0000000e
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_t1_avx2_mask:
.long	0x000003ff,0x000003ff,0x000003ff,0x000003ff
.long	0x000003ff,0x000003ff,0x000003ff,0x000003ff
#ifndef __APPLE__
.text
.globl	wc_mldsa_decode_t1_avx2
.type	wc_mldsa_decode_t1_avx2,@function
.align	16
wc_mldsa_decode_t1_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_decode_t1_avx2
.p2align	4
_wc_mldsa_decode_t1_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm5, %ymm5, %ymm5
        vmovdqu	L_mldsa_decode_t1_avx2_shuff_0(%rip), %ymm5
        vmovdqu	L_mldsa_decode_t1_avx2_shuff_1(%rip), %ymm6
        vmovdqu	L_mldsa_decode_t1_avx2_shuff_2(%rip), %ymm7
        vmovdqu	L_mldsa_decode_t1_avx2_shuff_3(%rip), %ymm8
        vmovdqu	L_mldsa_decode_t1_avx2_vs_8(%rip), %ymm9
        vmovdqu	L_mldsa_decode_t1_avx2_mask(%rip), %ymm10
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        # 1/32
        vpermq	$0x44, %ymm0, %ymm4
        vpshufb	%ymm5, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, (%rsi)
        # 2/32
        vpermq	$0x99, %ymm0, %ymm4
        vpshufb	%ymm6, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 32(%rsi)
        # 3/32
        vpermq	$0x3e, %ymm0, %ymm4
        vpshufb	%ymm7, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 64(%rsi)
        # 4/32
        vperm2i128	$0x21, %ymm1, %ymm0, %ymm0
        vpermq	$0xe9, %ymm0, %ymm4
        vpshufb	%ymm8, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 96(%rsi)
        # 5/32
        vpermq	$0x99, %ymm1, %ymm4
        vpshufb	%ymm5, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 128(%rsi)
        # 6/32
        vpermq	$0xee, %ymm1, %ymm4
        vpshufb	%ymm6, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 160(%rsi)
        # 7/32
        vperm2i128	$0x21, %ymm2, %ymm1, %ymm1
        vpermq	$0xe9, %ymm1, %ymm4
        vpshufb	%ymm7, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 192(%rsi)
        # 8/32
        vpermq	$0x94, %ymm2, %ymm4
        vpshufb	%ymm8, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 224(%rsi)
        # 9/32
        vpermq	$0xee, %ymm2, %ymm4
        vpshufb	%ymm5, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 256(%rsi)
        # 10/32
        vperm2i128	$0x21, %ymm3, %ymm2, %ymm2
        vpermq	$0x99, %ymm2, %ymm4
        vpshufb	%ymm6, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 288(%rsi)
        # 11/32
        vpermq	$0x94, %ymm3, %ymm4
        vpshufb	%ymm7, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 320(%rsi)
        # 12/32
        vpermq	$0xe9, %ymm3, %ymm4
        vpshufb	%ymm8, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 352(%rsi)
        # 13/32
        vmovdqu	128(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vperm2i128	$0x21, %ymm0, %ymm3, %ymm3
        vpermq	$0x99, %ymm3, %ymm4
        vpshufb	%ymm5, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 384(%rsi)
        # 14/32
        vpermq	$0x44, %ymm0, %ymm4
        vpshufb	%ymm6, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 416(%rsi)
        # 15/32
        vpermq	$0xe9, %ymm0, %ymm4
        vpshufb	%ymm7, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 448(%rsi)
        # 16/32
        vpermq	$0x3e, %ymm0, %ymm4
        vpshufb	%ymm8, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 480(%rsi)
        # 17/32
        vpermq	$0x44, %ymm1, %ymm4
        vpshufb	%ymm5, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 512(%rsi)
        # 18/32
        vpermq	$0x99, %ymm1, %ymm4
        vpshufb	%ymm6, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 544(%rsi)
        # 19/32
        vpermq	$0x3e, %ymm1, %ymm4
        vpshufb	%ymm7, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 576(%rsi)
        # 20/32
        vmovdqu	192(%rdi), %ymm2
        vmovdqu	224(%rdi), %ymm3
        vperm2i128	$0x21, %ymm2, %ymm1, %ymm1
        vpermq	$0xe9, %ymm1, %ymm4
        vpshufb	%ymm8, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 608(%rsi)
        # 21/32
        vpermq	$0x99, %ymm2, %ymm4
        vpshufb	%ymm5, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 640(%rsi)
        # 22/32
        vpermq	$0xee, %ymm2, %ymm4
        vpshufb	%ymm6, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 672(%rsi)
        # 23/32
        vperm2i128	$0x21, %ymm3, %ymm2, %ymm2
        vpermq	$0xe9, %ymm2, %ymm4
        vpshufb	%ymm7, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 704(%rsi)
        # 24/32
        vpermq	$0x94, %ymm3, %ymm4
        vpshufb	%ymm8, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 736(%rsi)
        # 25/32
        vpermq	$0xee, %ymm3, %ymm4
        vpshufb	%ymm5, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 768(%rsi)
        # 26/32
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vperm2i128	$0x21, %ymm0, %ymm3, %ymm3
        vpermq	$0x99, %ymm3, %ymm4
        vpshufb	%ymm6, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 800(%rsi)
        # 27/32
        vpermq	$0x94, %ymm0, %ymm4
        vpshufb	%ymm7, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 832(%rsi)
        # 28/32
        vpermq	$0xe9, %ymm0, %ymm4
        vpshufb	%ymm8, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 864(%rsi)
        # 29/32
        vperm2i128	$0x21, %ymm1, %ymm0, %ymm0
        vpermq	$0x99, %ymm0, %ymm4
        vpshufb	%ymm5, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 896(%rsi)
        # 30/32
        vpermq	$0x44, %ymm1, %ymm4
        vpshufb	%ymm6, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 928(%rsi)
        # 31/32
        vpermq	$0xe9, %ymm1, %ymm4
        vpshufb	%ymm7, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 960(%rsi)
        # 32/32
        vpermq	$0x3e, %ymm1, %ymm4
        vpshufb	%ymm8, %ymm4, %ymm4
        vpsrlvd	%ymm9, %ymm4, %ymm4
        vpand	%ymm10, %ymm4, %ymm4
        vpslld	$13, %ymm4, %ymm4
        vmovdqu	%ymm4, 992(%rsi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_decode_t1_avx2,.-wc_mldsa_decode_t1_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_gamma1_17_avx2_shuff_0:
.value	0x100,0xff02
.value	0x302,0xff04
.value	0x504,0xff06
.value	0x706,0xff08
.value	0x1ff,0x302
.value	0x3ff,0x504
.value	0x5ff,0x706
.value	0x7ff,0x908
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_gamma1_17_avx2_shuff_1:
.value	0x302,0xff04
.value	0x504,0xff06
.value	0x706,0xff08
.value	0x908,0xff0a
.value	0x3ff,0x504
.value	0x5ff,0x706
.value	0x7ff,0x908
.value	0x9ff,0xb0a
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_gamma1_17_avx2_shuff_2:
.value	0x504,0xff06
.value	0x706,0xff08
.value	0x908,0xff0a
.value	0xb0a,0xff0c
.value	0x5ff,0x706
.value	0x7ff,0x908
.value	0x9ff,0xb0a
.value	0xbff,0xd0c
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_gamma1_17_avx2_shuff_3:
.value	0x706,0xff08
.value	0x908,0xff0a
.value	0xb0a,0xff0c
.value	0xd0c,0xff0e
.value	0x7ff,0x908
.value	0x9ff,0xb0a
.value	0xbff,0xd0c
.value	0xdff,0xf0e
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_gamma1_17_avx2_vs_8:
.long	0x00000000,0x00000002,0x00000004,0x00000006
.long	0x00000008,0x0000000a,0x0000000c,0x0000000e
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_gamma1_17_avx2_mask:
.long	0x0003ffff,0x0003ffff,0x0003ffff,0x0003ffff
.long	0x0003ffff,0x0003ffff,0x0003ffff,0x0003ffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_gamma1_17_avx2_gamma17:
.long	0x00020000,0x00020000,0x00020000,0x00020000
.long	0x00020000,0x00020000,0x00020000,0x00020000
#ifndef __APPLE__
.text
.globl	wc_mldsa_decode_gamma1_17_avx2
.type	wc_mldsa_decode_gamma1_17_avx2,@function
.align	16
wc_mldsa_decode_gamma1_17_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_decode_gamma1_17_avx2
.p2align	4
_wc_mldsa_decode_gamma1_17_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_mldsa_decode_gamma1_17_avx2_shuff_0(%rip), %ymm7
        vmovdqu	L_mldsa_decode_gamma1_17_avx2_shuff_1(%rip), %ymm8
        vmovdqu	L_mldsa_decode_gamma1_17_avx2_shuff_2(%rip), %ymm9
        vmovdqu	L_mldsa_decode_gamma1_17_avx2_shuff_3(%rip), %ymm10
        vmovdqu	L_mldsa_decode_gamma1_17_avx2_vs_8(%rip), %ymm11
        vmovdqu	L_mldsa_decode_gamma1_17_avx2_mask(%rip), %ymm12
        vmovdqu	L_mldsa_decode_gamma1_17_avx2_gamma17(%rip), %ymm13
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        vmovdqu	160(%rdi), %ymm5
        # 0/15
        vpermq	$0x94, %ymm0, %ymm6
        vpshufb	%ymm7, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, (%rsi)
        # 1/15
        vperm2i128	$33, %ymm1, %ymm0, %ymm6
        vpermq	$0x94, %ymm6, %ymm6
        vpshufb	%ymm8, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 32(%rsi)
        # 2/15
        vpermq	$0x94, %ymm1, %ymm6
        vpshufb	%ymm9, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 64(%rsi)
        # 3/15
        vperm2i128	$33, %ymm2, %ymm1, %ymm6
        vpermq	$0x94, %ymm6, %ymm6
        vpshufb	%ymm10, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 96(%rsi)
        # 4/15
        vpermq	$0xe9, %ymm2, %ymm6
        vpshufb	%ymm7, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 128(%rsi)
        # 5/15
        vperm2i128	$33, %ymm3, %ymm2, %ymm6
        vpermq	$0xe9, %ymm6, %ymm6
        vpshufb	%ymm8, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 160(%rsi)
        # 6/15
        vpermq	$0xe9, %ymm3, %ymm6
        vpshufb	%ymm9, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 192(%rsi)
        # 7/15
        vperm2i128	$33, %ymm4, %ymm3, %ymm6
        vpermq	$0xe9, %ymm6, %ymm6
        vpshufb	%ymm10, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 224(%rsi)
        # 8/15
        vperm2i128	$33, %ymm5, %ymm4, %ymm6
        vpermq	$0x94, %ymm6, %ymm6
        vpshufb	%ymm7, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 256(%rsi)
        # 9/15
        vpermq	$0x94, %ymm5, %ymm6
        vpshufb	%ymm8, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 288(%rsi)
        vmovdqu	192(%rdi), %ymm0
        vmovdqu	224(%rdi), %ymm1
        vmovdqu	256(%rdi), %ymm2
        # 10/15
        vperm2i128	$33, %ymm0, %ymm5, %ymm6
        vpermq	$0x94, %ymm6, %ymm6
        vpshufb	%ymm9, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 320(%rsi)
        # 11/15
        vpermq	$0x94, %ymm0, %ymm6
        vpshufb	%ymm10, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 352(%rsi)
        # 12/15
        vperm2i128	$33, %ymm1, %ymm0, %ymm6
        vpermq	$0xe9, %ymm6, %ymm6
        vpshufb	%ymm7, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 384(%rsi)
        # 13/15
        vpermq	$0xe9, %ymm1, %ymm6
        vpshufb	%ymm8, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 416(%rsi)
        # 14/15
        vperm2i128	$33, %ymm2, %ymm1, %ymm6
        vpermq	$0xe9, %ymm6, %ymm6
        vpshufb	%ymm9, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 448(%rsi)
        # 15/15
        vpermq	$0xe9, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 480(%rsi)
        vmovdqu	288(%rdi), %ymm0
        vmovdqu	320(%rdi), %ymm1
        vmovdqu	352(%rdi), %ymm2
        vmovdqu	384(%rdi), %ymm3
        vmovdqu	416(%rdi), %ymm4
        vmovdqu	448(%rdi), %ymm5
        # 0/15
        vpermq	$0x94, %ymm0, %ymm6
        vpshufb	%ymm7, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 512(%rsi)
        # 1/15
        vperm2i128	$33, %ymm1, %ymm0, %ymm6
        vpermq	$0x94, %ymm6, %ymm6
        vpshufb	%ymm8, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 544(%rsi)
        # 2/15
        vpermq	$0x94, %ymm1, %ymm6
        vpshufb	%ymm9, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 576(%rsi)
        # 3/15
        vperm2i128	$33, %ymm2, %ymm1, %ymm6
        vpermq	$0x94, %ymm6, %ymm6
        vpshufb	%ymm10, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 608(%rsi)
        # 4/15
        vpermq	$0xe9, %ymm2, %ymm6
        vpshufb	%ymm7, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 640(%rsi)
        # 5/15
        vperm2i128	$33, %ymm3, %ymm2, %ymm6
        vpermq	$0xe9, %ymm6, %ymm6
        vpshufb	%ymm8, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 672(%rsi)
        # 6/15
        vpermq	$0xe9, %ymm3, %ymm6
        vpshufb	%ymm9, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 704(%rsi)
        # 7/15
        vperm2i128	$33, %ymm4, %ymm3, %ymm6
        vpermq	$0xe9, %ymm6, %ymm6
        vpshufb	%ymm10, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 736(%rsi)
        # 8/15
        vperm2i128	$33, %ymm5, %ymm4, %ymm6
        vpermq	$0x94, %ymm6, %ymm6
        vpshufb	%ymm7, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 768(%rsi)
        # 9/15
        vpermq	$0x94, %ymm5, %ymm6
        vpshufb	%ymm8, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 800(%rsi)
        vmovdqu	480(%rdi), %ymm0
        vmovdqu	512(%rdi), %ymm1
        vmovdqu	544(%rdi), %ymm2
        # 10/15
        vperm2i128	$33, %ymm0, %ymm5, %ymm6
        vpermq	$0x94, %ymm6, %ymm6
        vpshufb	%ymm9, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 832(%rsi)
        # 11/15
        vpermq	$0x94, %ymm0, %ymm6
        vpshufb	%ymm10, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 864(%rsi)
        # 12/15
        vperm2i128	$33, %ymm1, %ymm0, %ymm6
        vpermq	$0xe9, %ymm6, %ymm6
        vpshufb	%ymm7, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 896(%rsi)
        # 13/15
        vpermq	$0xe9, %ymm1, %ymm6
        vpshufb	%ymm8, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 928(%rsi)
        # 14/15
        vperm2i128	$33, %ymm2, %ymm1, %ymm6
        vpermq	$0xe9, %ymm6, %ymm6
        vpshufb	%ymm9, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 960(%rsi)
        # 15/15
        vpermq	$0xe9, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm6, %ymm6
        vpsrlvd	%ymm11, %ymm6, %ymm6
        vpand	%ymm12, %ymm6, %ymm6
        vpsubd	%ymm6, %ymm13, %ymm6
        vmovdqu	%ymm6, 992(%rsi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_decode_gamma1_17_avx2,.-wc_mldsa_decode_gamma1_17_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_gamma1_20_avx2_shuff_0:
.value	0x100,0xff02
.value	0x302,0xff04
.value	0x605,0xff07
.value	0x807,0xff09
.value	0x2ff,0x403
.value	0x4ff,0x605
.value	0x7ff,0x908
.value	0x9ff,0xb0a
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_decode_gamma1_20_avx2_shuff_1:
.value	0x504,0xff06
.value	0x706,0xff08
.value	0xa09,0xff0b
.value	0xc0b,0xff0d
.value	0x6ff,0x807
.value	0x8ff,0xa09
.value	0xbff,0xd0c
.value	0xdff,0xf0e
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_gamma1_20_avx2_vs_8:
.long	0x00000000,0x00000004,0x00000000,0x00000004
.long	0x00000008,0x0000000c,0x00000008,0x0000000c
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_gamma1_20_avx2_mask:
.long	0x000fffff,0x000fffff,0x000fffff,0x000fffff
.long	0x000fffff,0x000fffff,0x000fffff,0x000fffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decode_gamma1_20_avx2_gamma19:
.long	0x00080000,0x00080000,0x00080000,0x00080000
.long	0x00080000,0x00080000,0x00080000,0x00080000
#ifndef __APPLE__
.text
.globl	wc_mldsa_decode_gamma1_19_avx2
.type	wc_mldsa_decode_gamma1_19_avx2,@function
.align	16
wc_mldsa_decode_gamma1_19_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_decode_gamma1_19_avx2
.p2align	4
_wc_mldsa_decode_gamma1_19_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_mldsa_decode_gamma1_20_avx2_shuff_0(%rip), %ymm6
        vmovdqu	L_mldsa_decode_gamma1_20_avx2_shuff_1(%rip), %ymm7
        vmovdqu	L_mldsa_decode_gamma1_20_avx2_vs_8(%rip), %ymm8
        vmovdqu	L_mldsa_decode_gamma1_20_avx2_mask(%rip), %ymm9
        vmovdqu	L_mldsa_decode_gamma1_20_avx2_gamma19(%rip), %ymm10
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vmovdqu	128(%rdi), %ymm4
        # 0/7
        vpermq	$0x94, %ymm0, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, (%rsi)
        # 1/7
        vperm2i128	$33, %ymm1, %ymm0, %ymm5
        vpermq	$0x94, %ymm5, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 32(%rsi)
        # 2/7
        vpermq	$0xe9, %ymm1, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 64(%rsi)
        # 3/7
        vperm2i128	$33, %ymm2, %ymm1, %ymm5
        vpermq	$0xe9, %ymm5, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 96(%rsi)
        # 4/7
        vperm2i128	$33, %ymm3, %ymm2, %ymm5
        vpermq	$0x94, %ymm5, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 128(%rsi)
        # 5/7
        vpermq	$0x94, %ymm3, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 160(%rsi)
        # 6/7
        vperm2i128	$33, %ymm4, %ymm3, %ymm5
        vpermq	$0xe9, %ymm5, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 192(%rsi)
        # 7/7
        vpermq	$0xe9, %ymm4, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 224(%rsi)
        vmovdqu	160(%rdi), %ymm0
        vmovdqu	192(%rdi), %ymm1
        vmovdqu	224(%rdi), %ymm2
        vmovdqu	256(%rdi), %ymm3
        vmovdqu	288(%rdi), %ymm4
        # 0/7
        vpermq	$0x94, %ymm0, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 256(%rsi)
        # 1/7
        vperm2i128	$33, %ymm1, %ymm0, %ymm5
        vpermq	$0x94, %ymm5, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 288(%rsi)
        # 2/7
        vpermq	$0xe9, %ymm1, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 320(%rsi)
        # 3/7
        vperm2i128	$33, %ymm2, %ymm1, %ymm5
        vpermq	$0xe9, %ymm5, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 352(%rsi)
        # 4/7
        vperm2i128	$33, %ymm3, %ymm2, %ymm5
        vpermq	$0x94, %ymm5, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 384(%rsi)
        # 5/7
        vpermq	$0x94, %ymm3, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 416(%rsi)
        # 6/7
        vperm2i128	$33, %ymm4, %ymm3, %ymm5
        vpermq	$0xe9, %ymm5, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 448(%rsi)
        # 7/7
        vpermq	$0xe9, %ymm4, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 480(%rsi)
        vmovdqu	320(%rdi), %ymm0
        vmovdqu	352(%rdi), %ymm1
        vmovdqu	384(%rdi), %ymm2
        vmovdqu	416(%rdi), %ymm3
        vmovdqu	448(%rdi), %ymm4
        # 0/7
        vpermq	$0x94, %ymm0, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 512(%rsi)
        # 1/7
        vperm2i128	$33, %ymm1, %ymm0, %ymm5
        vpermq	$0x94, %ymm5, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 544(%rsi)
        # 2/7
        vpermq	$0xe9, %ymm1, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 576(%rsi)
        # 3/7
        vperm2i128	$33, %ymm2, %ymm1, %ymm5
        vpermq	$0xe9, %ymm5, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 608(%rsi)
        # 4/7
        vperm2i128	$33, %ymm3, %ymm2, %ymm5
        vpermq	$0x94, %ymm5, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 640(%rsi)
        # 5/7
        vpermq	$0x94, %ymm3, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 672(%rsi)
        # 6/7
        vperm2i128	$33, %ymm4, %ymm3, %ymm5
        vpermq	$0xe9, %ymm5, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 704(%rsi)
        # 7/7
        vpermq	$0xe9, %ymm4, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 736(%rsi)
        vmovdqu	480(%rdi), %ymm0
        vmovdqu	512(%rdi), %ymm1
        vmovdqu	544(%rdi), %ymm2
        vmovdqu	576(%rdi), %ymm3
        vmovdqu	608(%rdi), %ymm4
        # 0/7
        vpermq	$0x94, %ymm0, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 768(%rsi)
        # 1/7
        vperm2i128	$33, %ymm1, %ymm0, %ymm5
        vpermq	$0x94, %ymm5, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 800(%rsi)
        # 2/7
        vpermq	$0xe9, %ymm1, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 832(%rsi)
        # 3/7
        vperm2i128	$33, %ymm2, %ymm1, %ymm5
        vpermq	$0xe9, %ymm5, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 864(%rsi)
        # 4/7
        vperm2i128	$33, %ymm3, %ymm2, %ymm5
        vpermq	$0x94, %ymm5, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 896(%rsi)
        # 5/7
        vpermq	$0x94, %ymm3, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 928(%rsi)
        # 6/7
        vperm2i128	$33, %ymm4, %ymm3, %ymm5
        vpermq	$0xe9, %ymm5, %ymm5
        vpshufb	%ymm6, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 960(%rsi)
        # 7/7
        vpermq	$0xe9, %ymm4, %ymm5
        vpshufb	%ymm7, %ymm5, %ymm5
        vpsrlvd	%ymm8, %ymm5, %ymm5
        vpand	%ymm9, %ymm5, %ymm5
        vpsubd	%ymm5, %ymm10, %ymm5
        vmovdqu	%ymm5, 992(%rsi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_decode_gamma1_19_avx2,.-wc_mldsa_decode_gamma1_19_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_gamma1_17_avx2_gamma17:
.long	0x00020000,0x00020000,0x00020000,0x00020000
.long	0x00020000,0x00020000,0x00020000,0x00020000
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_gamma1_17_avx2_shuff_even:
.value	0x100,0xff02
.value	0x908,0xff0a
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0x100,0xff02
.value	0x908,0xff0a
.value	0xffff,0xffff
.value	0xffff,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_gamma1_17_avx2_shuff_odd:
.value	0xffff,0x504
.value	0xff06,0xd0c
.value	0xff0e,0xffff
.value	0xffff,0xffff
.value	0xffff,0x504
.value	0xff06,0xd0c
.value	0xff0e,0xffff
.value	0xffff,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_gamma1_17_avx2_vs:
.long	0x00000000,0x00000002,0x00000004,0x00000006
.long	0x00000000,0x00000002,0x00000004,0x00000006
#ifndef __APPLE__
.text
.globl	wc_mldsa_encode_gamma1_17_avx2
.type	wc_mldsa_encode_gamma1_17_avx2,@function
.align	16
wc_mldsa_encode_gamma1_17_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_encode_gamma1_17_avx2
.p2align	4
_wc_mldsa_encode_gamma1_17_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm8, %ymm8, %ymm8
        vmovdqu	L_mldsa_encode_gamma1_17_avx2_gamma17(%rip), %ymm8
        vmovdqu	L_mldsa_encode_gamma1_17_avx2_shuff_even(%rip), %ymm9
        vmovdqu	L_mldsa_encode_gamma1_17_avx2_shuff_odd(%rip), %ymm10
        vmovdqu	L_mldsa_encode_gamma1_17_avx2_vs(%rip), %ymm11
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrb	$8, %xmm0, 8(%rsi)
        movq	%xmm4, 9(%rsi)
        vpextrb	$8, %xmm4, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm1, (%rsi)
        vpextrb	$8, %xmm1, 8(%rsi)
        movq	%xmm5, 9(%rsi)
        vpextrb	$8, %xmm5, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm2, (%rsi)
        vpextrb	$8, %xmm2, 8(%rsi)
        movq	%xmm6, 9(%rsi)
        vpextrb	$8, %xmm6, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm3, (%rsi)
        vpextrb	$8, %xmm3, 8(%rsi)
        movq	%xmm7, 9(%rsi)
        vpextrb	$8, %xmm7, 17(%rsi)
        addq	$18, %rsi
        vmovdqu	128(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vmovdqu	192(%rdi), %ymm2
        vmovdqu	224(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrb	$8, %xmm0, 8(%rsi)
        movq	%xmm4, 9(%rsi)
        vpextrb	$8, %xmm4, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm1, (%rsi)
        vpextrb	$8, %xmm1, 8(%rsi)
        movq	%xmm5, 9(%rsi)
        vpextrb	$8, %xmm5, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm2, (%rsi)
        vpextrb	$8, %xmm2, 8(%rsi)
        movq	%xmm6, 9(%rsi)
        vpextrb	$8, %xmm6, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm3, (%rsi)
        vpextrb	$8, %xmm3, 8(%rsi)
        movq	%xmm7, 9(%rsi)
        vpextrb	$8, %xmm7, 17(%rsi)
        addq	$18, %rsi
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrb	$8, %xmm0, 8(%rsi)
        movq	%xmm4, 9(%rsi)
        vpextrb	$8, %xmm4, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm1, (%rsi)
        vpextrb	$8, %xmm1, 8(%rsi)
        movq	%xmm5, 9(%rsi)
        vpextrb	$8, %xmm5, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm2, (%rsi)
        vpextrb	$8, %xmm2, 8(%rsi)
        movq	%xmm6, 9(%rsi)
        vpextrb	$8, %xmm6, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm3, (%rsi)
        vpextrb	$8, %xmm3, 8(%rsi)
        movq	%xmm7, 9(%rsi)
        vpextrb	$8, %xmm7, 17(%rsi)
        addq	$18, %rsi
        vmovdqu	384(%rdi), %ymm0
        vmovdqu	416(%rdi), %ymm1
        vmovdqu	448(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrb	$8, %xmm0, 8(%rsi)
        movq	%xmm4, 9(%rsi)
        vpextrb	$8, %xmm4, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm1, (%rsi)
        vpextrb	$8, %xmm1, 8(%rsi)
        movq	%xmm5, 9(%rsi)
        vpextrb	$8, %xmm5, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm2, (%rsi)
        vpextrb	$8, %xmm2, 8(%rsi)
        movq	%xmm6, 9(%rsi)
        vpextrb	$8, %xmm6, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm3, (%rsi)
        vpextrb	$8, %xmm3, 8(%rsi)
        movq	%xmm7, 9(%rsi)
        vpextrb	$8, %xmm7, 17(%rsi)
        addq	$18, %rsi
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vmovdqu	576(%rdi), %ymm2
        vmovdqu	608(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrb	$8, %xmm0, 8(%rsi)
        movq	%xmm4, 9(%rsi)
        vpextrb	$8, %xmm4, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm1, (%rsi)
        vpextrb	$8, %xmm1, 8(%rsi)
        movq	%xmm5, 9(%rsi)
        vpextrb	$8, %xmm5, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm2, (%rsi)
        vpextrb	$8, %xmm2, 8(%rsi)
        movq	%xmm6, 9(%rsi)
        vpextrb	$8, %xmm6, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm3, (%rsi)
        vpextrb	$8, %xmm3, 8(%rsi)
        movq	%xmm7, 9(%rsi)
        vpextrb	$8, %xmm7, 17(%rsi)
        addq	$18, %rsi
        vmovdqu	640(%rdi), %ymm0
        vmovdqu	672(%rdi), %ymm1
        vmovdqu	704(%rdi), %ymm2
        vmovdqu	736(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrb	$8, %xmm0, 8(%rsi)
        movq	%xmm4, 9(%rsi)
        vpextrb	$8, %xmm4, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm1, (%rsi)
        vpextrb	$8, %xmm1, 8(%rsi)
        movq	%xmm5, 9(%rsi)
        vpextrb	$8, %xmm5, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm2, (%rsi)
        vpextrb	$8, %xmm2, 8(%rsi)
        movq	%xmm6, 9(%rsi)
        vpextrb	$8, %xmm6, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm3, (%rsi)
        vpextrb	$8, %xmm3, 8(%rsi)
        movq	%xmm7, 9(%rsi)
        vpextrb	$8, %xmm7, 17(%rsi)
        addq	$18, %rsi
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vmovdqu	832(%rdi), %ymm2
        vmovdqu	864(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrb	$8, %xmm0, 8(%rsi)
        movq	%xmm4, 9(%rsi)
        vpextrb	$8, %xmm4, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm1, (%rsi)
        vpextrb	$8, %xmm1, 8(%rsi)
        movq	%xmm5, 9(%rsi)
        vpextrb	$8, %xmm5, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm2, (%rsi)
        vpextrb	$8, %xmm2, 8(%rsi)
        movq	%xmm6, 9(%rsi)
        vpextrb	$8, %xmm6, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm3, (%rsi)
        vpextrb	$8, %xmm3, 8(%rsi)
        movq	%xmm7, 9(%rsi)
        vpextrb	$8, %xmm7, 17(%rsi)
        addq	$18, %rsi
        vmovdqu	896(%rdi), %ymm0
        vmovdqu	928(%rdi), %ymm1
        vmovdqu	960(%rdi), %ymm2
        vmovdqu	992(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrb	$8, %xmm0, 8(%rsi)
        movq	%xmm4, 9(%rsi)
        vpextrb	$8, %xmm4, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm1, (%rsi)
        vpextrb	$8, %xmm1, 8(%rsi)
        movq	%xmm5, 9(%rsi)
        vpextrb	$8, %xmm5, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm2, (%rsi)
        vpextrb	$8, %xmm2, 8(%rsi)
        movq	%xmm6, 9(%rsi)
        vpextrb	$8, %xmm6, 17(%rsi)
        addq	$18, %rsi
        movq	%xmm3, (%rsi)
        vpextrb	$8, %xmm3, 8(%rsi)
        movq	%xmm7, 9(%rsi)
        vpextrb	$8, %xmm7, 17(%rsi)
        addq	$18, %rsi
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_encode_gamma1_17_avx2,.-wc_mldsa_encode_gamma1_17_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_gamma1_19_avx2_gamma19:
.long	0x00080000,0x00080000,0x00080000,0x00080000
.long	0x00080000,0x00080000,0x00080000,0x00080000
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_gamma1_19_avx2_shuff_even:
.value	0x100,0xff02
.value	0x8ff,0xa09
.value	0xffff,0xffff
.value	0xffff,0xffff
.value	0x100,0xff02
.value	0x8ff,0xa09
.value	0xffff,0xffff
.value	0xffff,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_mldsa_encode_gamma1_19_avx2_shuff_odd:
.value	0xffff,0x504
.value	0xff06,0xcff
.value	0xe0d,0xffff
.value	0xffff,0xffff
.value	0xffff,0x504
.value	0xff06,0xcff
.value	0xe0d,0xffff
.value	0xffff,0xffff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_encode_gamma1_19_avx2_vs:
.long	0x00000000,0x00000004,0x00000000,0x00000004
.long	0x00000000,0x00000004,0x00000000,0x00000004
#ifndef __APPLE__
.text
.globl	wc_mldsa_encode_gamma1_19_avx2
.type	wc_mldsa_encode_gamma1_19_avx2,@function
.align	16
wc_mldsa_encode_gamma1_19_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_encode_gamma1_19_avx2
.p2align	4
_wc_mldsa_encode_gamma1_19_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm8, %ymm8, %ymm8
        vmovdqu	L_mldsa_encode_gamma1_19_avx2_gamma19(%rip), %ymm8
        vmovdqu	L_mldsa_encode_gamma1_19_avx2_shuff_even(%rip), %ymm9
        vmovdqu	L_mldsa_encode_gamma1_19_avx2_shuff_odd(%rip), %ymm10
        vmovdqu	L_mldsa_encode_gamma1_19_avx2_vs(%rip), %ymm11
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrw	$4, %xmm0, 8(%rsi)
        movq	%xmm4, 10(%rsi)
        vpextrw	$4, %xmm4, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm1, (%rsi)
        vpextrw	$4, %xmm1, 8(%rsi)
        movq	%xmm5, 10(%rsi)
        vpextrw	$4, %xmm5, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm2, (%rsi)
        vpextrw	$4, %xmm2, 8(%rsi)
        movq	%xmm6, 10(%rsi)
        vpextrw	$4, %xmm6, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm3, (%rsi)
        vpextrw	$4, %xmm3, 8(%rsi)
        movq	%xmm7, 10(%rsi)
        vpextrw	$4, %xmm7, 18(%rsi)
        addq	$20, %rsi
        vmovdqu	128(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vmovdqu	192(%rdi), %ymm2
        vmovdqu	224(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrw	$4, %xmm0, 8(%rsi)
        movq	%xmm4, 10(%rsi)
        vpextrw	$4, %xmm4, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm1, (%rsi)
        vpextrw	$4, %xmm1, 8(%rsi)
        movq	%xmm5, 10(%rsi)
        vpextrw	$4, %xmm5, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm2, (%rsi)
        vpextrw	$4, %xmm2, 8(%rsi)
        movq	%xmm6, 10(%rsi)
        vpextrw	$4, %xmm6, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm3, (%rsi)
        vpextrw	$4, %xmm3, 8(%rsi)
        movq	%xmm7, 10(%rsi)
        vpextrw	$4, %xmm7, 18(%rsi)
        addq	$20, %rsi
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrw	$4, %xmm0, 8(%rsi)
        movq	%xmm4, 10(%rsi)
        vpextrw	$4, %xmm4, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm1, (%rsi)
        vpextrw	$4, %xmm1, 8(%rsi)
        movq	%xmm5, 10(%rsi)
        vpextrw	$4, %xmm5, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm2, (%rsi)
        vpextrw	$4, %xmm2, 8(%rsi)
        movq	%xmm6, 10(%rsi)
        vpextrw	$4, %xmm6, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm3, (%rsi)
        vpextrw	$4, %xmm3, 8(%rsi)
        movq	%xmm7, 10(%rsi)
        vpextrw	$4, %xmm7, 18(%rsi)
        addq	$20, %rsi
        vmovdqu	384(%rdi), %ymm0
        vmovdqu	416(%rdi), %ymm1
        vmovdqu	448(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrw	$4, %xmm0, 8(%rsi)
        movq	%xmm4, 10(%rsi)
        vpextrw	$4, %xmm4, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm1, (%rsi)
        vpextrw	$4, %xmm1, 8(%rsi)
        movq	%xmm5, 10(%rsi)
        vpextrw	$4, %xmm5, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm2, (%rsi)
        vpextrw	$4, %xmm2, 8(%rsi)
        movq	%xmm6, 10(%rsi)
        vpextrw	$4, %xmm6, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm3, (%rsi)
        vpextrw	$4, %xmm3, 8(%rsi)
        movq	%xmm7, 10(%rsi)
        vpextrw	$4, %xmm7, 18(%rsi)
        addq	$20, %rsi
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vmovdqu	576(%rdi), %ymm2
        vmovdqu	608(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrw	$4, %xmm0, 8(%rsi)
        movq	%xmm4, 10(%rsi)
        vpextrw	$4, %xmm4, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm1, (%rsi)
        vpextrw	$4, %xmm1, 8(%rsi)
        movq	%xmm5, 10(%rsi)
        vpextrw	$4, %xmm5, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm2, (%rsi)
        vpextrw	$4, %xmm2, 8(%rsi)
        movq	%xmm6, 10(%rsi)
        vpextrw	$4, %xmm6, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm3, (%rsi)
        vpextrw	$4, %xmm3, 8(%rsi)
        movq	%xmm7, 10(%rsi)
        vpextrw	$4, %xmm7, 18(%rsi)
        addq	$20, %rsi
        vmovdqu	640(%rdi), %ymm0
        vmovdqu	672(%rdi), %ymm1
        vmovdqu	704(%rdi), %ymm2
        vmovdqu	736(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrw	$4, %xmm0, 8(%rsi)
        movq	%xmm4, 10(%rsi)
        vpextrw	$4, %xmm4, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm1, (%rsi)
        vpextrw	$4, %xmm1, 8(%rsi)
        movq	%xmm5, 10(%rsi)
        vpextrw	$4, %xmm5, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm2, (%rsi)
        vpextrw	$4, %xmm2, 8(%rsi)
        movq	%xmm6, 10(%rsi)
        vpextrw	$4, %xmm6, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm3, (%rsi)
        vpextrw	$4, %xmm3, 8(%rsi)
        movq	%xmm7, 10(%rsi)
        vpextrw	$4, %xmm7, 18(%rsi)
        addq	$20, %rsi
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vmovdqu	832(%rdi), %ymm2
        vmovdqu	864(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrw	$4, %xmm0, 8(%rsi)
        movq	%xmm4, 10(%rsi)
        vpextrw	$4, %xmm4, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm1, (%rsi)
        vpextrw	$4, %xmm1, 8(%rsi)
        movq	%xmm5, 10(%rsi)
        vpextrw	$4, %xmm5, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm2, (%rsi)
        vpextrw	$4, %xmm2, 8(%rsi)
        movq	%xmm6, 10(%rsi)
        vpextrw	$4, %xmm6, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm3, (%rsi)
        vpextrw	$4, %xmm3, 8(%rsi)
        movq	%xmm7, 10(%rsi)
        vpextrw	$4, %xmm7, 18(%rsi)
        addq	$20, %rsi
        vmovdqu	896(%rdi), %ymm0
        vmovdqu	928(%rdi), %ymm1
        vmovdqu	960(%rdi), %ymm2
        vmovdqu	992(%rdi), %ymm3
        vpsubd	%ymm0, %ymm8, %ymm0
        vpsubd	%ymm1, %ymm8, %ymm1
        vpsubd	%ymm2, %ymm8, %ymm2
        vpsubd	%ymm3, %ymm8, %ymm3
        vpsllvd	%ymm11, %ymm0, %ymm0
        vpsllvd	%ymm11, %ymm1, %ymm1
        vpsllvd	%ymm11, %ymm2, %ymm2
        vpsllvd	%ymm11, %ymm3, %ymm3
        vpshufb	%ymm10, %ymm0, %ymm4
        vpshufb	%ymm10, %ymm1, %ymm5
        vpshufb	%ymm10, %ymm2, %ymm6
        vpshufb	%ymm10, %ymm3, %ymm7
        vpshufb	%ymm9, %ymm0, %ymm0
        vpshufb	%ymm9, %ymm1, %ymm1
        vpshufb	%ymm9, %ymm2, %ymm2
        vpshufb	%ymm9, %ymm3, %ymm3
        vpor	%ymm4, %ymm0, %ymm0
        vpor	%ymm5, %ymm1, %ymm1
        vpor	%ymm6, %ymm2, %ymm2
        vpor	%ymm7, %ymm3, %ymm3
        vextracti128	$0x01, %ymm0, %xmm4
        vextracti128	$0x01, %ymm1, %xmm5
        vextracti128	$0x01, %ymm2, %xmm6
        vextracti128	$0x01, %ymm3, %xmm7
        movq	%xmm0, (%rsi)
        vpextrw	$4, %xmm0, 8(%rsi)
        movq	%xmm4, 10(%rsi)
        vpextrw	$4, %xmm4, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm1, (%rsi)
        vpextrw	$4, %xmm1, 8(%rsi)
        movq	%xmm5, 10(%rsi)
        vpextrw	$4, %xmm5, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm2, (%rsi)
        vpextrw	$4, %xmm2, 8(%rsi)
        movq	%xmm6, 10(%rsi)
        vpextrw	$4, %xmm6, 18(%rsi)
        addq	$20, %rsi
        movq	%xmm3, (%rsi)
        vpextrw	$4, %xmm3, 8(%rsi)
        movq	%xmm7, 10(%rsi)
        vpextrw	$4, %xmm7, 18(%rsi)
        addq	$20, %rsi
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_encode_gamma1_19_avx2,.-wc_mldsa_encode_gamma1_19_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decompose_q88_avx2_q_low_88:
.long	0x00017400,0x00017400,0x00017400,0x00017400
.long	0x00017400,0x00017400,0x00017400,0x00017400
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decompose_q88_avx2_q_low_88_2:
.long	0x0002e800,0x0002e800,0x0002e800,0x0002e800
.long	0x0002e800,0x0002e800,0x0002e800,0x0002e800
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decompose_q88_avx2_q_2:
.long	0x003fefd4,0x003fefd4,0x003fefd4,0x003fefd4
.long	0x003fefd4,0x003fefd4,0x003fefd4,0x003fefd4
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decompose_q88_avx2_44:
.long	0x0000002c,0x0000002c,0x0000002c,0x0000002c
.long	0x0000002c,0x0000002c,0x0000002c,0x0000002c
#ifndef __APPLE__
.text
.globl	wc_mldsa_decompose_q88_avx2
.type	wc_mldsa_decompose_q88_avx2,@function
.align	16
wc_mldsa_decompose_q88_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_decompose_q88_avx2
.p2align	4
_wc_mldsa_decompose_q88_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_mldsa_decompose_q88_avx2_q_low_88(%rip), %ymm12
        vmovdqu	L_mldsa_decompose_q88_avx2_q_low_88_2(%rip), %ymm13
        vmovdqu	L_mldsa_decompose_q88_avx2_q_2(%rip), %ymm14
        vmovdqu	L_mldsa_decompose_q88_avx2_44(%rip), %ymm15
        # 1/4 vectors
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, (%rsi)
        vmovdqu	%ymm5, 32(%rsi)
        vmovdqu	%ymm6, 64(%rsi)
        vmovdqu	%ymm7, 96(%rsi)
        vmovdqu	%ymm8, (%rdx)
        vmovdqu	%ymm9, 32(%rdx)
        vmovdqu	%ymm10, 64(%rdx)
        vmovdqu	%ymm11, 96(%rdx)
        vmovdqu	128(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vmovdqu	192(%rdi), %ymm2
        vmovdqu	224(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 128(%rsi)
        vmovdqu	%ymm5, 160(%rsi)
        vmovdqu	%ymm6, 192(%rsi)
        vmovdqu	%ymm7, 224(%rsi)
        vmovdqu	%ymm8, 128(%rdx)
        vmovdqu	%ymm9, 160(%rdx)
        vmovdqu	%ymm10, 192(%rdx)
        vmovdqu	%ymm11, 224(%rdx)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 256(%rsi)
        vmovdqu	%ymm5, 288(%rsi)
        vmovdqu	%ymm6, 320(%rsi)
        vmovdqu	%ymm7, 352(%rsi)
        vmovdqu	%ymm8, 256(%rdx)
        vmovdqu	%ymm9, 288(%rdx)
        vmovdqu	%ymm10, 320(%rdx)
        vmovdqu	%ymm11, 352(%rdx)
        vmovdqu	384(%rdi), %ymm0
        vmovdqu	416(%rdi), %ymm1
        vmovdqu	448(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 384(%rsi)
        vmovdqu	%ymm5, 416(%rsi)
        vmovdqu	%ymm6, 448(%rsi)
        vmovdqu	%ymm7, 480(%rsi)
        vmovdqu	%ymm8, 384(%rdx)
        vmovdqu	%ymm9, 416(%rdx)
        vmovdqu	%ymm10, 448(%rdx)
        vmovdqu	%ymm11, 480(%rdx)
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vmovdqu	576(%rdi), %ymm2
        vmovdqu	608(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 512(%rsi)
        vmovdqu	%ymm5, 544(%rsi)
        vmovdqu	%ymm6, 576(%rsi)
        vmovdqu	%ymm7, 608(%rsi)
        vmovdqu	%ymm8, 512(%rdx)
        vmovdqu	%ymm9, 544(%rdx)
        vmovdqu	%ymm10, 576(%rdx)
        vmovdqu	%ymm11, 608(%rdx)
        vmovdqu	640(%rdi), %ymm0
        vmovdqu	672(%rdi), %ymm1
        vmovdqu	704(%rdi), %ymm2
        vmovdqu	736(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 640(%rsi)
        vmovdqu	%ymm5, 672(%rsi)
        vmovdqu	%ymm6, 704(%rsi)
        vmovdqu	%ymm7, 736(%rsi)
        vmovdqu	%ymm8, 640(%rdx)
        vmovdqu	%ymm9, 672(%rdx)
        vmovdqu	%ymm10, 704(%rdx)
        vmovdqu	%ymm11, 736(%rdx)
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vmovdqu	832(%rdi), %ymm2
        vmovdqu	864(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 768(%rsi)
        vmovdqu	%ymm5, 800(%rsi)
        vmovdqu	%ymm6, 832(%rsi)
        vmovdqu	%ymm7, 864(%rsi)
        vmovdqu	%ymm8, 768(%rdx)
        vmovdqu	%ymm9, 800(%rdx)
        vmovdqu	%ymm10, 832(%rdx)
        vmovdqu	%ymm11, 864(%rdx)
        vmovdqu	896(%rdi), %ymm0
        vmovdqu	928(%rdi), %ymm1
        vmovdqu	960(%rdi), %ymm2
        vmovdqu	992(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 896(%rsi)
        vmovdqu	%ymm5, 928(%rsi)
        vmovdqu	%ymm6, 960(%rsi)
        vmovdqu	%ymm7, 992(%rsi)
        vmovdqu	%ymm8, 896(%rdx)
        vmovdqu	%ymm9, 928(%rdx)
        vmovdqu	%ymm10, 960(%rdx)
        vmovdqu	%ymm11, 992(%rdx)
        # 2/4 vectors
        vmovdqu	1024(%rdi), %ymm0
        vmovdqu	1056(%rdi), %ymm1
        vmovdqu	1088(%rdi), %ymm2
        vmovdqu	1120(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 1024(%rsi)
        vmovdqu	%ymm5, 1056(%rsi)
        vmovdqu	%ymm6, 1088(%rsi)
        vmovdqu	%ymm7, 1120(%rsi)
        vmovdqu	%ymm8, 1024(%rdx)
        vmovdqu	%ymm9, 1056(%rdx)
        vmovdqu	%ymm10, 1088(%rdx)
        vmovdqu	%ymm11, 1120(%rdx)
        vmovdqu	1152(%rdi), %ymm0
        vmovdqu	1184(%rdi), %ymm1
        vmovdqu	1216(%rdi), %ymm2
        vmovdqu	1248(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 1152(%rsi)
        vmovdqu	%ymm5, 1184(%rsi)
        vmovdqu	%ymm6, 1216(%rsi)
        vmovdqu	%ymm7, 1248(%rsi)
        vmovdqu	%ymm8, 1152(%rdx)
        vmovdqu	%ymm9, 1184(%rdx)
        vmovdqu	%ymm10, 1216(%rdx)
        vmovdqu	%ymm11, 1248(%rdx)
        vmovdqu	1280(%rdi), %ymm0
        vmovdqu	1312(%rdi), %ymm1
        vmovdqu	1344(%rdi), %ymm2
        vmovdqu	1376(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 1280(%rsi)
        vmovdqu	%ymm5, 1312(%rsi)
        vmovdqu	%ymm6, 1344(%rsi)
        vmovdqu	%ymm7, 1376(%rsi)
        vmovdqu	%ymm8, 1280(%rdx)
        vmovdqu	%ymm9, 1312(%rdx)
        vmovdqu	%ymm10, 1344(%rdx)
        vmovdqu	%ymm11, 1376(%rdx)
        vmovdqu	1408(%rdi), %ymm0
        vmovdqu	1440(%rdi), %ymm1
        vmovdqu	1472(%rdi), %ymm2
        vmovdqu	1504(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 1408(%rsi)
        vmovdqu	%ymm5, 1440(%rsi)
        vmovdqu	%ymm6, 1472(%rsi)
        vmovdqu	%ymm7, 1504(%rsi)
        vmovdqu	%ymm8, 1408(%rdx)
        vmovdqu	%ymm9, 1440(%rdx)
        vmovdqu	%ymm10, 1472(%rdx)
        vmovdqu	%ymm11, 1504(%rdx)
        vmovdqu	1536(%rdi), %ymm0
        vmovdqu	1568(%rdi), %ymm1
        vmovdqu	1600(%rdi), %ymm2
        vmovdqu	1632(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 1536(%rsi)
        vmovdqu	%ymm5, 1568(%rsi)
        vmovdqu	%ymm6, 1600(%rsi)
        vmovdqu	%ymm7, 1632(%rsi)
        vmovdqu	%ymm8, 1536(%rdx)
        vmovdqu	%ymm9, 1568(%rdx)
        vmovdqu	%ymm10, 1600(%rdx)
        vmovdqu	%ymm11, 1632(%rdx)
        vmovdqu	1664(%rdi), %ymm0
        vmovdqu	1696(%rdi), %ymm1
        vmovdqu	1728(%rdi), %ymm2
        vmovdqu	1760(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 1664(%rsi)
        vmovdqu	%ymm5, 1696(%rsi)
        vmovdqu	%ymm6, 1728(%rsi)
        vmovdqu	%ymm7, 1760(%rsi)
        vmovdqu	%ymm8, 1664(%rdx)
        vmovdqu	%ymm9, 1696(%rdx)
        vmovdqu	%ymm10, 1728(%rdx)
        vmovdqu	%ymm11, 1760(%rdx)
        vmovdqu	1792(%rdi), %ymm0
        vmovdqu	1824(%rdi), %ymm1
        vmovdqu	1856(%rdi), %ymm2
        vmovdqu	1888(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 1792(%rsi)
        vmovdqu	%ymm5, 1824(%rsi)
        vmovdqu	%ymm6, 1856(%rsi)
        vmovdqu	%ymm7, 1888(%rsi)
        vmovdqu	%ymm8, 1792(%rdx)
        vmovdqu	%ymm9, 1824(%rdx)
        vmovdqu	%ymm10, 1856(%rdx)
        vmovdqu	%ymm11, 1888(%rdx)
        vmovdqu	1920(%rdi), %ymm0
        vmovdqu	1952(%rdi), %ymm1
        vmovdqu	1984(%rdi), %ymm2
        vmovdqu	2016(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 1920(%rsi)
        vmovdqu	%ymm5, 1952(%rsi)
        vmovdqu	%ymm6, 1984(%rsi)
        vmovdqu	%ymm7, 2016(%rsi)
        vmovdqu	%ymm8, 1920(%rdx)
        vmovdqu	%ymm9, 1952(%rdx)
        vmovdqu	%ymm10, 1984(%rdx)
        vmovdqu	%ymm11, 2016(%rdx)
        # 3/4 vectors
        vmovdqu	2048(%rdi), %ymm0
        vmovdqu	2080(%rdi), %ymm1
        vmovdqu	2112(%rdi), %ymm2
        vmovdqu	2144(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 2048(%rsi)
        vmovdqu	%ymm5, 2080(%rsi)
        vmovdqu	%ymm6, 2112(%rsi)
        vmovdqu	%ymm7, 2144(%rsi)
        vmovdqu	%ymm8, 2048(%rdx)
        vmovdqu	%ymm9, 2080(%rdx)
        vmovdqu	%ymm10, 2112(%rdx)
        vmovdqu	%ymm11, 2144(%rdx)
        vmovdqu	2176(%rdi), %ymm0
        vmovdqu	2208(%rdi), %ymm1
        vmovdqu	2240(%rdi), %ymm2
        vmovdqu	2272(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 2176(%rsi)
        vmovdqu	%ymm5, 2208(%rsi)
        vmovdqu	%ymm6, 2240(%rsi)
        vmovdqu	%ymm7, 2272(%rsi)
        vmovdqu	%ymm8, 2176(%rdx)
        vmovdqu	%ymm9, 2208(%rdx)
        vmovdqu	%ymm10, 2240(%rdx)
        vmovdqu	%ymm11, 2272(%rdx)
        vmovdqu	2304(%rdi), %ymm0
        vmovdqu	2336(%rdi), %ymm1
        vmovdqu	2368(%rdi), %ymm2
        vmovdqu	2400(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 2304(%rsi)
        vmovdqu	%ymm5, 2336(%rsi)
        vmovdqu	%ymm6, 2368(%rsi)
        vmovdqu	%ymm7, 2400(%rsi)
        vmovdqu	%ymm8, 2304(%rdx)
        vmovdqu	%ymm9, 2336(%rdx)
        vmovdqu	%ymm10, 2368(%rdx)
        vmovdqu	%ymm11, 2400(%rdx)
        vmovdqu	2432(%rdi), %ymm0
        vmovdqu	2464(%rdi), %ymm1
        vmovdqu	2496(%rdi), %ymm2
        vmovdqu	2528(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 2432(%rsi)
        vmovdqu	%ymm5, 2464(%rsi)
        vmovdqu	%ymm6, 2496(%rsi)
        vmovdqu	%ymm7, 2528(%rsi)
        vmovdqu	%ymm8, 2432(%rdx)
        vmovdqu	%ymm9, 2464(%rdx)
        vmovdqu	%ymm10, 2496(%rdx)
        vmovdqu	%ymm11, 2528(%rdx)
        vmovdqu	2560(%rdi), %ymm0
        vmovdqu	2592(%rdi), %ymm1
        vmovdqu	2624(%rdi), %ymm2
        vmovdqu	2656(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 2560(%rsi)
        vmovdqu	%ymm5, 2592(%rsi)
        vmovdqu	%ymm6, 2624(%rsi)
        vmovdqu	%ymm7, 2656(%rsi)
        vmovdqu	%ymm8, 2560(%rdx)
        vmovdqu	%ymm9, 2592(%rdx)
        vmovdqu	%ymm10, 2624(%rdx)
        vmovdqu	%ymm11, 2656(%rdx)
        vmovdqu	2688(%rdi), %ymm0
        vmovdqu	2720(%rdi), %ymm1
        vmovdqu	2752(%rdi), %ymm2
        vmovdqu	2784(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 2688(%rsi)
        vmovdqu	%ymm5, 2720(%rsi)
        vmovdqu	%ymm6, 2752(%rsi)
        vmovdqu	%ymm7, 2784(%rsi)
        vmovdqu	%ymm8, 2688(%rdx)
        vmovdqu	%ymm9, 2720(%rdx)
        vmovdqu	%ymm10, 2752(%rdx)
        vmovdqu	%ymm11, 2784(%rdx)
        vmovdqu	2816(%rdi), %ymm0
        vmovdqu	2848(%rdi), %ymm1
        vmovdqu	2880(%rdi), %ymm2
        vmovdqu	2912(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 2816(%rsi)
        vmovdqu	%ymm5, 2848(%rsi)
        vmovdqu	%ymm6, 2880(%rsi)
        vmovdqu	%ymm7, 2912(%rsi)
        vmovdqu	%ymm8, 2816(%rdx)
        vmovdqu	%ymm9, 2848(%rdx)
        vmovdqu	%ymm10, 2880(%rdx)
        vmovdqu	%ymm11, 2912(%rdx)
        vmovdqu	2944(%rdi), %ymm0
        vmovdqu	2976(%rdi), %ymm1
        vmovdqu	3008(%rdi), %ymm2
        vmovdqu	3040(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 2944(%rsi)
        vmovdqu	%ymm5, 2976(%rsi)
        vmovdqu	%ymm6, 3008(%rsi)
        vmovdqu	%ymm7, 3040(%rsi)
        vmovdqu	%ymm8, 2944(%rdx)
        vmovdqu	%ymm9, 2976(%rdx)
        vmovdqu	%ymm10, 3008(%rdx)
        vmovdqu	%ymm11, 3040(%rdx)
        # 4/4 vectors
        vmovdqu	3072(%rdi), %ymm0
        vmovdqu	3104(%rdi), %ymm1
        vmovdqu	3136(%rdi), %ymm2
        vmovdqu	3168(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 3072(%rsi)
        vmovdqu	%ymm5, 3104(%rsi)
        vmovdqu	%ymm6, 3136(%rsi)
        vmovdqu	%ymm7, 3168(%rsi)
        vmovdqu	%ymm8, 3072(%rdx)
        vmovdqu	%ymm9, 3104(%rdx)
        vmovdqu	%ymm10, 3136(%rdx)
        vmovdqu	%ymm11, 3168(%rdx)
        vmovdqu	3200(%rdi), %ymm0
        vmovdqu	3232(%rdi), %ymm1
        vmovdqu	3264(%rdi), %ymm2
        vmovdqu	3296(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 3200(%rsi)
        vmovdqu	%ymm5, 3232(%rsi)
        vmovdqu	%ymm6, 3264(%rsi)
        vmovdqu	%ymm7, 3296(%rsi)
        vmovdqu	%ymm8, 3200(%rdx)
        vmovdqu	%ymm9, 3232(%rdx)
        vmovdqu	%ymm10, 3264(%rdx)
        vmovdqu	%ymm11, 3296(%rdx)
        vmovdqu	3328(%rdi), %ymm0
        vmovdqu	3360(%rdi), %ymm1
        vmovdqu	3392(%rdi), %ymm2
        vmovdqu	3424(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 3328(%rsi)
        vmovdqu	%ymm5, 3360(%rsi)
        vmovdqu	%ymm6, 3392(%rsi)
        vmovdqu	%ymm7, 3424(%rsi)
        vmovdqu	%ymm8, 3328(%rdx)
        vmovdqu	%ymm9, 3360(%rdx)
        vmovdqu	%ymm10, 3392(%rdx)
        vmovdqu	%ymm11, 3424(%rdx)
        vmovdqu	3456(%rdi), %ymm0
        vmovdqu	3488(%rdi), %ymm1
        vmovdqu	3520(%rdi), %ymm2
        vmovdqu	3552(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 3456(%rsi)
        vmovdqu	%ymm5, 3488(%rsi)
        vmovdqu	%ymm6, 3520(%rsi)
        vmovdqu	%ymm7, 3552(%rsi)
        vmovdqu	%ymm8, 3456(%rdx)
        vmovdqu	%ymm9, 3488(%rdx)
        vmovdqu	%ymm10, 3520(%rdx)
        vmovdqu	%ymm11, 3552(%rdx)
        vmovdqu	3584(%rdi), %ymm0
        vmovdqu	3616(%rdi), %ymm1
        vmovdqu	3648(%rdi), %ymm2
        vmovdqu	3680(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 3584(%rsi)
        vmovdqu	%ymm5, 3616(%rsi)
        vmovdqu	%ymm6, 3648(%rsi)
        vmovdqu	%ymm7, 3680(%rsi)
        vmovdqu	%ymm8, 3584(%rdx)
        vmovdqu	%ymm9, 3616(%rdx)
        vmovdqu	%ymm10, 3648(%rdx)
        vmovdqu	%ymm11, 3680(%rdx)
        vmovdqu	3712(%rdi), %ymm0
        vmovdqu	3744(%rdi), %ymm1
        vmovdqu	3776(%rdi), %ymm2
        vmovdqu	3808(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 3712(%rsi)
        vmovdqu	%ymm5, 3744(%rsi)
        vmovdqu	%ymm6, 3776(%rsi)
        vmovdqu	%ymm7, 3808(%rsi)
        vmovdqu	%ymm8, 3712(%rdx)
        vmovdqu	%ymm9, 3744(%rdx)
        vmovdqu	%ymm10, 3776(%rdx)
        vmovdqu	%ymm11, 3808(%rdx)
        vmovdqu	3840(%rdi), %ymm0
        vmovdqu	3872(%rdi), %ymm1
        vmovdqu	3904(%rdi), %ymm2
        vmovdqu	3936(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 3840(%rsi)
        vmovdqu	%ymm5, 3872(%rsi)
        vmovdqu	%ymm6, 3904(%rsi)
        vmovdqu	%ymm7, 3936(%rsi)
        vmovdqu	%ymm8, 3840(%rdx)
        vmovdqu	%ymm9, 3872(%rdx)
        vmovdqu	%ymm10, 3904(%rdx)
        vmovdqu	%ymm11, 3936(%rdx)
        vmovdqu	3968(%rdi), %ymm0
        vmovdqu	4000(%rdi), %ymm1
        vmovdqu	4032(%rdi), %ymm2
        vmovdqu	4064(%rdi), %ymm3
        vpmulld	%ymm15, %ymm0, %ymm8
        vpmulld	%ymm15, %ymm1, %ymm9
        vpmulld	%ymm15, %ymm2, %ymm10
        vpmulld	%ymm15, %ymm3, %ymm11
        vpaddd	%ymm14, %ymm8, %ymm8
        vpaddd	%ymm14, %ymm9, %ymm9
        vpaddd	%ymm14, %ymm10, %ymm10
        vpaddd	%ymm14, %ymm11, %ymm11
        vpsrld	$23, %ymm8, %ymm8
        vpsrld	$23, %ymm9, %ymm9
        vpsrld	$23, %ymm10, %ymm10
        vpsrld	$23, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpcmpeqd	%ymm15, %ymm8, %ymm0
        vpcmpeqd	%ymm15, %ymm9, %ymm1
        vpcmpeqd	%ymm15, %ymm10, %ymm2
        vpcmpeqd	%ymm15, %ymm11, %ymm3
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vpaddd	%ymm2, %ymm6, %ymm6
        vpaddd	%ymm3, %ymm7, %ymm7
        vpcmpgtd	%ymm8, %ymm15, %ymm0
        vpcmpgtd	%ymm9, %ymm15, %ymm1
        vpcmpgtd	%ymm10, %ymm15, %ymm2
        vpcmpgtd	%ymm11, %ymm15, %ymm3
        vpand	%ymm0, %ymm8, %ymm8
        vpand	%ymm1, %ymm9, %ymm9
        vpand	%ymm2, %ymm10, %ymm10
        vpand	%ymm3, %ymm11, %ymm11
        vmovdqu	%ymm4, 3968(%rsi)
        vmovdqu	%ymm5, 4000(%rsi)
        vmovdqu	%ymm6, 4032(%rsi)
        vmovdqu	%ymm7, 4064(%rsi)
        vmovdqu	%ymm8, 3968(%rdx)
        vmovdqu	%ymm9, 4000(%rdx)
        vmovdqu	%ymm10, 4032(%rdx)
        vmovdqu	%ymm11, 4064(%rdx)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_decompose_q88_avx2,.-wc_mldsa_decompose_q88_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decompose_q32_avx2_q_low_32:
.long	0x0003ff00,0x0003ff00,0x0003ff00,0x0003ff00
.long	0x0003ff00,0x0003ff00,0x0003ff00,0x0003ff00
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decompose_q32_avx2_q_low_32_2:
.long	0x0007fe00,0x0007fe00,0x0007fe00,0x0007fe00
.long	0x0007fe00,0x0007fe00,0x0007fe00,0x0007fe00
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decompose_q32_avx2_q_low_32_m1:
.long	0x0003feff,0x0003feff,0x0003feff,0x0003feff
.long	0x0003feff,0x0003feff,0x0003feff,0x0003feff
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_decompose_q32_avx2_mask:
.long	0x0000000f,0x0000000f,0x0000000f,0x0000000f
.long	0x0000000f,0x0000000f,0x0000000f,0x0000000f
#ifndef __APPLE__
.text
.globl	wc_mldsa_decompose_q32_avx2
.type	wc_mldsa_decompose_q32_avx2,@function
.align	16
wc_mldsa_decompose_q32_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_decompose_q32_avx2
.p2align	4
_wc_mldsa_decompose_q32_avx2:
#endif /* __APPLE__ */
        vmovdqu	L_mldsa_decompose_q32_avx2_q_low_32(%rip), %ymm12
        vmovdqu	L_mldsa_decompose_q32_avx2_q_low_32_2(%rip), %ymm13
        vmovdqu	L_mldsa_decompose_q32_avx2_q_low_32_m1(%rip), %ymm14
        vmovdqu	L_mldsa_decompose_q32_avx2_mask(%rip), %ymm15
L_mldsa_decompose_q32_avx2_start_256:
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vmovdqu	64(%rdi), %ymm2
        vmovdqu	96(%rdi), %ymm3
        vpaddd	%ymm14, %ymm0, %ymm8
        vpaddd	%ymm14, %ymm1, %ymm9
        vpaddd	%ymm14, %ymm2, %ymm10
        vpaddd	%ymm14, %ymm3, %ymm11
        vpsrld	$19, %ymm8, %ymm8
        vpsrld	$19, %ymm9, %ymm9
        vpsrld	$19, %ymm10, %ymm10
        vpsrld	$19, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsrld	$4, %ymm8, %ymm0
        vpsrld	$4, %ymm9, %ymm1
        vpsrld	$4, %ymm10, %ymm2
        vpsrld	$4, %ymm11, %ymm3
        vpsubd	%ymm0, %ymm4, %ymm4
        vpsubd	%ymm1, %ymm5, %ymm5
        vpsubd	%ymm2, %ymm6, %ymm6
        vpsubd	%ymm3, %ymm7, %ymm7
        vpand	%ymm15, %ymm8, %ymm8
        vpand	%ymm15, %ymm9, %ymm9
        vpand	%ymm15, %ymm10, %ymm10
        vpand	%ymm15, %ymm11, %ymm11
        vmovdqu	%ymm4, (%rdx)
        vmovdqu	%ymm5, 32(%rdx)
        vmovdqu	%ymm6, 64(%rdx)
        vmovdqu	%ymm7, 96(%rdx)
        vmovdqu	%ymm8, (%rcx)
        vmovdqu	%ymm9, 32(%rcx)
        vmovdqu	%ymm10, 64(%rcx)
        vmovdqu	%ymm11, 96(%rcx)
        vmovdqu	128(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vmovdqu	192(%rdi), %ymm2
        vmovdqu	224(%rdi), %ymm3
        vpaddd	%ymm14, %ymm0, %ymm8
        vpaddd	%ymm14, %ymm1, %ymm9
        vpaddd	%ymm14, %ymm2, %ymm10
        vpaddd	%ymm14, %ymm3, %ymm11
        vpsrld	$19, %ymm8, %ymm8
        vpsrld	$19, %ymm9, %ymm9
        vpsrld	$19, %ymm10, %ymm10
        vpsrld	$19, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsrld	$4, %ymm8, %ymm0
        vpsrld	$4, %ymm9, %ymm1
        vpsrld	$4, %ymm10, %ymm2
        vpsrld	$4, %ymm11, %ymm3
        vpsubd	%ymm0, %ymm4, %ymm4
        vpsubd	%ymm1, %ymm5, %ymm5
        vpsubd	%ymm2, %ymm6, %ymm6
        vpsubd	%ymm3, %ymm7, %ymm7
        vpand	%ymm15, %ymm8, %ymm8
        vpand	%ymm15, %ymm9, %ymm9
        vpand	%ymm15, %ymm10, %ymm10
        vpand	%ymm15, %ymm11, %ymm11
        vmovdqu	%ymm4, 128(%rdx)
        vmovdqu	%ymm5, 160(%rdx)
        vmovdqu	%ymm6, 192(%rdx)
        vmovdqu	%ymm7, 224(%rdx)
        vmovdqu	%ymm8, 128(%rcx)
        vmovdqu	%ymm9, 160(%rcx)
        vmovdqu	%ymm10, 192(%rcx)
        vmovdqu	%ymm11, 224(%rcx)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vmovdqu	320(%rdi), %ymm2
        vmovdqu	352(%rdi), %ymm3
        vpaddd	%ymm14, %ymm0, %ymm8
        vpaddd	%ymm14, %ymm1, %ymm9
        vpaddd	%ymm14, %ymm2, %ymm10
        vpaddd	%ymm14, %ymm3, %ymm11
        vpsrld	$19, %ymm8, %ymm8
        vpsrld	$19, %ymm9, %ymm9
        vpsrld	$19, %ymm10, %ymm10
        vpsrld	$19, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsrld	$4, %ymm8, %ymm0
        vpsrld	$4, %ymm9, %ymm1
        vpsrld	$4, %ymm10, %ymm2
        vpsrld	$4, %ymm11, %ymm3
        vpsubd	%ymm0, %ymm4, %ymm4
        vpsubd	%ymm1, %ymm5, %ymm5
        vpsubd	%ymm2, %ymm6, %ymm6
        vpsubd	%ymm3, %ymm7, %ymm7
        vpand	%ymm15, %ymm8, %ymm8
        vpand	%ymm15, %ymm9, %ymm9
        vpand	%ymm15, %ymm10, %ymm10
        vpand	%ymm15, %ymm11, %ymm11
        vmovdqu	%ymm4, 256(%rdx)
        vmovdqu	%ymm5, 288(%rdx)
        vmovdqu	%ymm6, 320(%rdx)
        vmovdqu	%ymm7, 352(%rdx)
        vmovdqu	%ymm8, 256(%rcx)
        vmovdqu	%ymm9, 288(%rcx)
        vmovdqu	%ymm10, 320(%rcx)
        vmovdqu	%ymm11, 352(%rcx)
        vmovdqu	384(%rdi), %ymm0
        vmovdqu	416(%rdi), %ymm1
        vmovdqu	448(%rdi), %ymm2
        vmovdqu	480(%rdi), %ymm3
        vpaddd	%ymm14, %ymm0, %ymm8
        vpaddd	%ymm14, %ymm1, %ymm9
        vpaddd	%ymm14, %ymm2, %ymm10
        vpaddd	%ymm14, %ymm3, %ymm11
        vpsrld	$19, %ymm8, %ymm8
        vpsrld	$19, %ymm9, %ymm9
        vpsrld	$19, %ymm10, %ymm10
        vpsrld	$19, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsrld	$4, %ymm8, %ymm0
        vpsrld	$4, %ymm9, %ymm1
        vpsrld	$4, %ymm10, %ymm2
        vpsrld	$4, %ymm11, %ymm3
        vpsubd	%ymm0, %ymm4, %ymm4
        vpsubd	%ymm1, %ymm5, %ymm5
        vpsubd	%ymm2, %ymm6, %ymm6
        vpsubd	%ymm3, %ymm7, %ymm7
        vpand	%ymm15, %ymm8, %ymm8
        vpand	%ymm15, %ymm9, %ymm9
        vpand	%ymm15, %ymm10, %ymm10
        vpand	%ymm15, %ymm11, %ymm11
        vmovdqu	%ymm4, 384(%rdx)
        vmovdqu	%ymm5, 416(%rdx)
        vmovdqu	%ymm6, 448(%rdx)
        vmovdqu	%ymm7, 480(%rdx)
        vmovdqu	%ymm8, 384(%rcx)
        vmovdqu	%ymm9, 416(%rcx)
        vmovdqu	%ymm10, 448(%rcx)
        vmovdqu	%ymm11, 480(%rcx)
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vmovdqu	576(%rdi), %ymm2
        vmovdqu	608(%rdi), %ymm3
        vpaddd	%ymm14, %ymm0, %ymm8
        vpaddd	%ymm14, %ymm1, %ymm9
        vpaddd	%ymm14, %ymm2, %ymm10
        vpaddd	%ymm14, %ymm3, %ymm11
        vpsrld	$19, %ymm8, %ymm8
        vpsrld	$19, %ymm9, %ymm9
        vpsrld	$19, %ymm10, %ymm10
        vpsrld	$19, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsrld	$4, %ymm8, %ymm0
        vpsrld	$4, %ymm9, %ymm1
        vpsrld	$4, %ymm10, %ymm2
        vpsrld	$4, %ymm11, %ymm3
        vpsubd	%ymm0, %ymm4, %ymm4
        vpsubd	%ymm1, %ymm5, %ymm5
        vpsubd	%ymm2, %ymm6, %ymm6
        vpsubd	%ymm3, %ymm7, %ymm7
        vpand	%ymm15, %ymm8, %ymm8
        vpand	%ymm15, %ymm9, %ymm9
        vpand	%ymm15, %ymm10, %ymm10
        vpand	%ymm15, %ymm11, %ymm11
        vmovdqu	%ymm4, 512(%rdx)
        vmovdqu	%ymm5, 544(%rdx)
        vmovdqu	%ymm6, 576(%rdx)
        vmovdqu	%ymm7, 608(%rdx)
        vmovdqu	%ymm8, 512(%rcx)
        vmovdqu	%ymm9, 544(%rcx)
        vmovdqu	%ymm10, 576(%rcx)
        vmovdqu	%ymm11, 608(%rcx)
        vmovdqu	640(%rdi), %ymm0
        vmovdqu	672(%rdi), %ymm1
        vmovdqu	704(%rdi), %ymm2
        vmovdqu	736(%rdi), %ymm3
        vpaddd	%ymm14, %ymm0, %ymm8
        vpaddd	%ymm14, %ymm1, %ymm9
        vpaddd	%ymm14, %ymm2, %ymm10
        vpaddd	%ymm14, %ymm3, %ymm11
        vpsrld	$19, %ymm8, %ymm8
        vpsrld	$19, %ymm9, %ymm9
        vpsrld	$19, %ymm10, %ymm10
        vpsrld	$19, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsrld	$4, %ymm8, %ymm0
        vpsrld	$4, %ymm9, %ymm1
        vpsrld	$4, %ymm10, %ymm2
        vpsrld	$4, %ymm11, %ymm3
        vpsubd	%ymm0, %ymm4, %ymm4
        vpsubd	%ymm1, %ymm5, %ymm5
        vpsubd	%ymm2, %ymm6, %ymm6
        vpsubd	%ymm3, %ymm7, %ymm7
        vpand	%ymm15, %ymm8, %ymm8
        vpand	%ymm15, %ymm9, %ymm9
        vpand	%ymm15, %ymm10, %ymm10
        vpand	%ymm15, %ymm11, %ymm11
        vmovdqu	%ymm4, 640(%rdx)
        vmovdqu	%ymm5, 672(%rdx)
        vmovdqu	%ymm6, 704(%rdx)
        vmovdqu	%ymm7, 736(%rdx)
        vmovdqu	%ymm8, 640(%rcx)
        vmovdqu	%ymm9, 672(%rcx)
        vmovdqu	%ymm10, 704(%rcx)
        vmovdqu	%ymm11, 736(%rcx)
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vmovdqu	832(%rdi), %ymm2
        vmovdqu	864(%rdi), %ymm3
        vpaddd	%ymm14, %ymm0, %ymm8
        vpaddd	%ymm14, %ymm1, %ymm9
        vpaddd	%ymm14, %ymm2, %ymm10
        vpaddd	%ymm14, %ymm3, %ymm11
        vpsrld	$19, %ymm8, %ymm8
        vpsrld	$19, %ymm9, %ymm9
        vpsrld	$19, %ymm10, %ymm10
        vpsrld	$19, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsrld	$4, %ymm8, %ymm0
        vpsrld	$4, %ymm9, %ymm1
        vpsrld	$4, %ymm10, %ymm2
        vpsrld	$4, %ymm11, %ymm3
        vpsubd	%ymm0, %ymm4, %ymm4
        vpsubd	%ymm1, %ymm5, %ymm5
        vpsubd	%ymm2, %ymm6, %ymm6
        vpsubd	%ymm3, %ymm7, %ymm7
        vpand	%ymm15, %ymm8, %ymm8
        vpand	%ymm15, %ymm9, %ymm9
        vpand	%ymm15, %ymm10, %ymm10
        vpand	%ymm15, %ymm11, %ymm11
        vmovdqu	%ymm4, 768(%rdx)
        vmovdqu	%ymm5, 800(%rdx)
        vmovdqu	%ymm6, 832(%rdx)
        vmovdqu	%ymm7, 864(%rdx)
        vmovdqu	%ymm8, 768(%rcx)
        vmovdqu	%ymm9, 800(%rcx)
        vmovdqu	%ymm10, 832(%rcx)
        vmovdqu	%ymm11, 864(%rcx)
        vmovdqu	896(%rdi), %ymm0
        vmovdqu	928(%rdi), %ymm1
        vmovdqu	960(%rdi), %ymm2
        vmovdqu	992(%rdi), %ymm3
        vpaddd	%ymm14, %ymm0, %ymm8
        vpaddd	%ymm14, %ymm1, %ymm9
        vpaddd	%ymm14, %ymm2, %ymm10
        vpaddd	%ymm14, %ymm3, %ymm11
        vpsrld	$19, %ymm8, %ymm8
        vpsrld	$19, %ymm9, %ymm9
        vpsrld	$19, %ymm10, %ymm10
        vpsrld	$19, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsubd	%ymm4, %ymm12, %ymm4
        vpsubd	%ymm5, %ymm12, %ymm5
        vpsubd	%ymm6, %ymm12, %ymm6
        vpsubd	%ymm7, %ymm12, %ymm7
        vpsrld	$31, %ymm4, %ymm4
        vpsrld	$31, %ymm5, %ymm5
        vpsrld	$31, %ymm6, %ymm6
        vpsrld	$31, %ymm7, %ymm7
        vpaddd	%ymm4, %ymm8, %ymm8
        vpaddd	%ymm5, %ymm9, %ymm9
        vpaddd	%ymm6, %ymm10, %ymm10
        vpaddd	%ymm7, %ymm11, %ymm11
        vpmulld	%ymm13, %ymm8, %ymm4
        vpmulld	%ymm13, %ymm9, %ymm5
        vpmulld	%ymm13, %ymm10, %ymm6
        vpmulld	%ymm13, %ymm11, %ymm7
        vpsubd	%ymm4, %ymm0, %ymm4
        vpsubd	%ymm5, %ymm1, %ymm5
        vpsubd	%ymm6, %ymm2, %ymm6
        vpsubd	%ymm7, %ymm3, %ymm7
        vpsrld	$4, %ymm8, %ymm0
        vpsrld	$4, %ymm9, %ymm1
        vpsrld	$4, %ymm10, %ymm2
        vpsrld	$4, %ymm11, %ymm3
        vpsubd	%ymm0, %ymm4, %ymm4
        vpsubd	%ymm1, %ymm5, %ymm5
        vpsubd	%ymm2, %ymm6, %ymm6
        vpsubd	%ymm3, %ymm7, %ymm7
        vpand	%ymm15, %ymm8, %ymm8
        vpand	%ymm15, %ymm9, %ymm9
        vpand	%ymm15, %ymm10, %ymm10
        vpand	%ymm15, %ymm11, %ymm11
        vmovdqu	%ymm4, 896(%rdx)
        vmovdqu	%ymm5, 928(%rdx)
        vmovdqu	%ymm6, 960(%rdx)
        vmovdqu	%ymm7, 992(%rdx)
        vmovdqu	%ymm8, 896(%rcx)
        vmovdqu	%ymm9, 928(%rcx)
        vmovdqu	%ymm10, 960(%rcx)
        vmovdqu	%ymm11, 992(%rcx)
        addq	$0x400, %rdi
        addq	$0x400, %rdx
        addq	$0x400, %rcx
        sub	$0x01, %rsi
        jne	L_mldsa_decompose_q32_avx2_start_256
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	wc_mldsa_decompose_q32_avx2,.-wc_mldsa_decompose_q32_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_use_hint_88_avx2_q:
.long	0x007fe001,0x007fe001,0x007fe001,0x007fe001
.long	0x007fe001,0x007fe001,0x007fe001,0x007fe001
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_use_hint_88_avx2_q_low_88:
.long	0x00017400,0x00017400,0x00017400,0x00017400
.long	0x00017400,0x00017400,0x00017400,0x00017400
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_use_hint_88_avx2_q_low_88_2:
.long	0x0002e800,0x0002e800,0x0002e800,0x0002e800
.long	0x0002e800,0x0002e800,0x0002e800,0x0002e800
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_use_hint_88_avx2_q_2:
.long	0x003fefd4,0x003fefd4,0x003fefd4,0x003fefd4
.long	0x003fefd4,0x003fefd4,0x003fefd4,0x003fefd4
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_use_hint_88_avx2_44:
.long	0x0000002c,0x0000002c,0x0000002c,0x0000002c
.long	0x0000002c,0x0000002c,0x0000002c,0x0000002c
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_use_hint_88_avx2_vsl:
.long	0x0000001f,0x0000001e,0x0000001d,0x0000001c
.long	0x0000001b,0x0000001a,0x00000019,0x00000018
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
L_mldsa_use_hint_88_avx2_one:
.long	0x00000001,0x00000001,0x00000001,0x00000001
.long	0x00000001,0x00000001,0x00000001,0x00000001
#ifndef __APPLE__
.text
.globl	wc_mldsa_use_hint_88_avx2
.type	wc_mldsa_use_hint_88_avx2,@function
.align	16
wc_mldsa_use_hint_88_avx2:
#else
.section	__TEXT,__text
.globl	_wc_mldsa_use_hint_88_avx2
.p2align	4
_wc_mldsa_use_hint_88_avx2:
#endif /* __APPLE__ */
        vpxor	%ymm8, %ymm8, %ymm8
        vmovdqu	L_mldsa_use_hint_88_avx2_q(%rip), %ymm8
        vmovdqu	L_mldsa_use_hint_88_avx2_q_low_88(%rip), %ymm9
        vmovdqu	L_mldsa_use_hint_88_avx2_q_low_88_2(%rip), %ymm10
        vmovdqu	L_mldsa_use_hint_88_avx2_q_2(%rip), %ymm11
        vmovdqu	L_mldsa_use_hint_88_avx2_44(%rip), %ymm12
        vmovdqu	L_mldsa_use_hint_88_avx2_vsl(%rip), %ymm13
        vmovdqu	L_mldsa_use_hint_88_avx2_one(%rip), %ymm14
        xorq	%rax, %rax
        mov	(%rsi), %r8b
        # 1/4 vectors
        mov	80(%rsi), %dl
        vmovdqu	(%rdi), %ymm0
        vmovdqu	32(%rdi), %ymm1
        vpsrad	$31, %ymm0, %ymm2
        vpsrad	$31, %ymm1, %ymm3
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm0, %ymm4
        vpmulld	%ymm12, %ymm1, %ymm5
        vpaddd	%ymm11, %ymm4, %ymm4
        vpaddd	%ymm11, %ymm5, %ymm5
        vpsrld	$23, %ymm4, %ymm4
        vpsrld	$23, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm9, %ymm2
        vpsubd	%ymm3, %ymm9, %ymm3
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpcmpeqd	%ymm12, %ymm4, %ymm0
        vpcmpeqd	%ymm12, %ymm5, %ymm1
        vpaddd	%ymm0, %ymm2, %ymm2
        vpaddd	%ymm1, %ymm3, %ymm3
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        movq	$0x01, %r9
        xorq	%r10, %r10
        xorq	%rcx, %rcx
L_mldsa_use_hint_88_avx2_hints_next_0_0:
        cmp	%dl, %al
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_0
        mov	%r8b, %cl
        cmpq	$16, %rcx
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_0
        mov	%r9, %r11
        shlq	%cl, %r11
        orq	%r11, %r10
        inc	%al
        mov	(%rsi,%rax,1), %r8b
        jmp	L_mldsa_use_hint_88_avx2_hints_next_0_0
L_mldsa_use_hint_88_avx2_hints_done_0_0:
        movd	%r10d, %xmm6
        shr	$8, %r10
        movd	%r10d, %xmm7
        vpbroadcastd	%xmm6, %ymm6
        vpbroadcastd	%xmm7, %ymm7
        vpsllvd	%ymm13, %ymm6, %ymm6
        vpsllvd	%ymm13, %ymm7, %ymm7
        vpsrad	$31, %ymm6, %ymm6
        vpsrad	$31, %ymm7, %ymm7
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpslld	$0x01, %ymm2, %ymm2
        vpslld	$0x01, %ymm3, %ymm3
        vpsubd	%ymm2, %ymm14, %ymm2
        vpsubd	%ymm3, %ymm14, %ymm3
        vpand	%ymm6, %ymm2, %ymm2
        vpand	%ymm7, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        vpsrad	$31, %ymm4, %ymm0
        vpsrad	$31, %ymm5, %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vmovdqu	%ymm4, (%rdi)
        vmovdqu	%ymm5, 32(%rdi)
        vmovdqu	64(%rdi), %ymm0
        vmovdqu	96(%rdi), %ymm1
        vpsrad	$31, %ymm0, %ymm2
        vpsrad	$31, %ymm1, %ymm3
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm0, %ymm4
        vpmulld	%ymm12, %ymm1, %ymm5
        vpaddd	%ymm11, %ymm4, %ymm4
        vpaddd	%ymm11, %ymm5, %ymm5
        vpsrld	$23, %ymm4, %ymm4
        vpsrld	$23, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm9, %ymm2
        vpsubd	%ymm3, %ymm9, %ymm3
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpcmpeqd	%ymm12, %ymm4, %ymm0
        vpcmpeqd	%ymm12, %ymm5, %ymm1
        vpaddd	%ymm0, %ymm2, %ymm2
        vpaddd	%ymm1, %ymm3, %ymm3
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        movq	$0x01, %r9
        xorq	%r10, %r10
        xorq	%rcx, %rcx
L_mldsa_use_hint_88_avx2_hints_next_0_1:
        cmp	%dl, %al
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_1
        mov	%r8b, %cl
        sub	$16, %cl
        cmpq	$16, %rcx
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_1
        mov	%r9, %r11
        shlq	%cl, %r11
        orq	%r11, %r10
        inc	%al
        mov	(%rsi,%rax,1), %r8b
        jmp	L_mldsa_use_hint_88_avx2_hints_next_0_1
L_mldsa_use_hint_88_avx2_hints_done_0_1:
        movd	%r10d, %xmm6
        shr	$8, %r10
        movd	%r10d, %xmm7
        vpbroadcastd	%xmm6, %ymm6
        vpbroadcastd	%xmm7, %ymm7
        vpsllvd	%ymm13, %ymm6, %ymm6
        vpsllvd	%ymm13, %ymm7, %ymm7
        vpsrad	$31, %ymm6, %ymm6
        vpsrad	$31, %ymm7, %ymm7
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpslld	$0x01, %ymm2, %ymm2
        vpslld	$0x01, %ymm3, %ymm3
        vpsubd	%ymm2, %ymm14, %ymm2
        vpsubd	%ymm3, %ymm14, %ymm3
        vpand	%ymm6, %ymm2, %ymm2
        vpand	%ymm7, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        vpsrad	$31, %ymm4, %ymm0
        vpsrad	$31, %ymm5, %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vmovdqu	%ymm4, 64(%rdi)
        vmovdqu	%ymm5, 96(%rdi)
        vmovdqu	128(%rdi), %ymm0
        vmovdqu	160(%rdi), %ymm1
        vpsrad	$31, %ymm0, %ymm2
        vpsrad	$31, %ymm1, %ymm3
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm0, %ymm4
        vpmulld	%ymm12, %ymm1, %ymm5
        vpaddd	%ymm11, %ymm4, %ymm4
        vpaddd	%ymm11, %ymm5, %ymm5
        vpsrld	$23, %ymm4, %ymm4
        vpsrld	$23, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm9, %ymm2
        vpsubd	%ymm3, %ymm9, %ymm3
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpcmpeqd	%ymm12, %ymm4, %ymm0
        vpcmpeqd	%ymm12, %ymm5, %ymm1
        vpaddd	%ymm0, %ymm2, %ymm2
        vpaddd	%ymm1, %ymm3, %ymm3
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        movq	$0x01, %r9
        xorq	%r10, %r10
        xorq	%rcx, %rcx
L_mldsa_use_hint_88_avx2_hints_next_0_2:
        cmp	%dl, %al
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_2
        mov	%r8b, %cl
        sub	$32, %cl
        cmpq	$16, %rcx
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_2
        mov	%r9, %r11
        shlq	%cl, %r11
        orq	%r11, %r10
        inc	%al
        mov	(%rsi,%rax,1), %r8b
        jmp	L_mldsa_use_hint_88_avx2_hints_next_0_2
L_mldsa_use_hint_88_avx2_hints_done_0_2:
        movd	%r10d, %xmm6
        shr	$8, %r10
        movd	%r10d, %xmm7
        vpbroadcastd	%xmm6, %ymm6
        vpbroadcastd	%xmm7, %ymm7
        vpsllvd	%ymm13, %ymm6, %ymm6
        vpsllvd	%ymm13, %ymm7, %ymm7
        vpsrad	$31, %ymm6, %ymm6
        vpsrad	$31, %ymm7, %ymm7
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpslld	$0x01, %ymm2, %ymm2
        vpslld	$0x01, %ymm3, %ymm3
        vpsubd	%ymm2, %ymm14, %ymm2
        vpsubd	%ymm3, %ymm14, %ymm3
        vpand	%ymm6, %ymm2, %ymm2
        vpand	%ymm7, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        vpsrad	$31, %ymm4, %ymm0
        vpsrad	$31, %ymm5, %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vmovdqu	%ymm4, 128(%rdi)
        vmovdqu	%ymm5, 160(%rdi)
        vmovdqu	192(%rdi), %ymm0
        vmovdqu	224(%rdi), %ymm1
        vpsrad	$31, %ymm0, %ymm2
        vpsrad	$31, %ymm1, %ymm3
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm0, %ymm4
        vpmulld	%ymm12, %ymm1, %ymm5
        vpaddd	%ymm11, %ymm4, %ymm4
        vpaddd	%ymm11, %ymm5, %ymm5
        vpsrld	$23, %ymm4, %ymm4
        vpsrld	$23, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm9, %ymm2
        vpsubd	%ymm3, %ymm9, %ymm3
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpcmpeqd	%ymm12, %ymm4, %ymm0
        vpcmpeqd	%ymm12, %ymm5, %ymm1
        vpaddd	%ymm0, %ymm2, %ymm2
        vpaddd	%ymm1, %ymm3, %ymm3
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        movq	$0x01, %r9
        xorq	%r10, %r10
        xorq	%rcx, %rcx
L_mldsa_use_hint_88_avx2_hints_next_0_3:
        cmp	%dl, %al
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_3
        mov	%r8b, %cl
        sub	$48, %cl
        cmpq	$16, %rcx
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_3
        mov	%r9, %r11
        shlq	%cl, %r11
        orq	%r11, %r10
        inc	%al
        mov	(%rsi,%rax,1), %r8b
        jmp	L_mldsa_use_hint_88_avx2_hints_next_0_3
L_mldsa_use_hint_88_avx2_hints_done_0_3:
        movd	%r10d, %xmm6
        shr	$8, %r10
        movd	%r10d, %xmm7
        vpbroadcastd	%xmm6, %ymm6
        vpbroadcastd	%xmm7, %ymm7
        vpsllvd	%ymm13, %ymm6, %ymm6
        vpsllvd	%ymm13, %ymm7, %ymm7
        vpsrad	$31, %ymm6, %ymm6
        vpsrad	$31, %ymm7, %ymm7
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpslld	$0x01, %ymm2, %ymm2
        vpslld	$0x01, %ymm3, %ymm3
        vpsubd	%ymm2, %ymm14, %ymm2
        vpsubd	%ymm3, %ymm14, %ymm3
        vpand	%ymm6, %ymm2, %ymm2
        vpand	%ymm7, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        vpsrad	$31, %ymm4, %ymm0
        vpsrad	$31, %ymm5, %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vmovdqu	%ymm4, 192(%rdi)
        vmovdqu	%ymm5, 224(%rdi)
        vmovdqu	256(%rdi), %ymm0
        vmovdqu	288(%rdi), %ymm1
        vpsrad	$31, %ymm0, %ymm2
        vpsrad	$31, %ymm1, %ymm3
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm0, %ymm4
        vpmulld	%ymm12, %ymm1, %ymm5
        vpaddd	%ymm11, %ymm4, %ymm4
        vpaddd	%ymm11, %ymm5, %ymm5
        vpsrld	$23, %ymm4, %ymm4
        vpsrld	$23, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm9, %ymm2
        vpsubd	%ymm3, %ymm9, %ymm3
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpcmpeqd	%ymm12, %ymm4, %ymm0
        vpcmpeqd	%ymm12, %ymm5, %ymm1
        vpaddd	%ymm0, %ymm2, %ymm2
        vpaddd	%ymm1, %ymm3, %ymm3
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        movq	$0x01, %r9
        xorq	%r10, %r10
        xorq	%rcx, %rcx
L_mldsa_use_hint_88_avx2_hints_next_0_4:
        cmp	%dl, %al
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_4
        mov	%r8b, %cl
        sub	$0x40, %cl
        cmpq	$16, %rcx
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_4
        mov	%r9, %r11
        shlq	%cl, %r11
        orq	%r11, %r10
        inc	%al
        mov	(%rsi,%rax,1), %r8b
        jmp	L_mldsa_use_hint_88_avx2_hints_next_0_4
L_mldsa_use_hint_88_avx2_hints_done_0_4:
        movd	%r10d, %xmm6
        shr	$8, %r10
        movd	%r10d, %xmm7
        vpbroadcastd	%xmm6, %ymm6
        vpbroadcastd	%xmm7, %ymm7
        vpsllvd	%ymm13, %ymm6, %ymm6
        vpsllvd	%ymm13, %ymm7, %ymm7
        vpsrad	$31, %ymm6, %ymm6
        vpsrad	$31, %ymm7, %ymm7
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpslld	$0x01, %ymm2, %ymm2
        vpslld	$0x01, %ymm3, %ymm3
        vpsubd	%ymm2, %ymm14, %ymm2
        vpsubd	%ymm3, %ymm14, %ymm3
        vpand	%ymm6, %ymm2, %ymm2
        vpand	%ymm7, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        vpsrad	$31, %ymm4, %ymm0
        vpsrad	$31, %ymm5, %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vmovdqu	%ymm4, 256(%rdi)
        vmovdqu	%ymm5, 288(%rdi)
        vmovdqu	320(%rdi), %ymm0
        vmovdqu	352(%rdi), %ymm1
        vpsrad	$31, %ymm0, %ymm2
        vpsrad	$31, %ymm1, %ymm3
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm0, %ymm4
        vpmulld	%ymm12, %ymm1, %ymm5
        vpaddd	%ymm11, %ymm4, %ymm4
        vpaddd	%ymm11, %ymm5, %ymm5
        vpsrld	$23, %ymm4, %ymm4
        vpsrld	$23, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm9, %ymm2
        vpsubd	%ymm3, %ymm9, %ymm3
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpcmpeqd	%ymm12, %ymm4, %ymm0
        vpcmpeqd	%ymm12, %ymm5, %ymm1
        vpaddd	%ymm0, %ymm2, %ymm2
        vpaddd	%ymm1, %ymm3, %ymm3
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        movq	$0x01, %r9
        xorq	%r10, %r10
        xorq	%rcx, %rcx
L_mldsa_use_hint_88_avx2_hints_next_0_5:
        cmp	%dl, %al
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_5
        mov	%r8b, %cl
        sub	$0x50, %cl
        cmpq	$16, %rcx
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_5
        mov	%r9, %r11
        shlq	%cl, %r11
        orq	%r11, %r10
        inc	%al
        mov	(%rsi,%rax,1), %r8b
        jmp	L_mldsa_use_hint_88_avx2_hints_next_0_5
L_mldsa_use_hint_88_avx2_hints_done_0_5:
        movd	%r10d, %xmm6
        shr	$8, %r10
        movd	%r10d, %xmm7
        vpbroadcastd	%xmm6, %ymm6
        vpbroadcastd	%xmm7, %ymm7
        vpsllvd	%ymm13, %ymm6, %ymm6
        vpsllvd	%ymm13, %ymm7, %ymm7
        vpsrad	$31, %ymm6, %ymm6
        vpsrad	$31, %ymm7, %ymm7
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpslld	$0x01, %ymm2, %ymm2
        vpslld	$0x01, %ymm3, %ymm3
        vpsubd	%ymm2, %ymm14, %ymm2
        vpsubd	%ymm3, %ymm14, %ymm3
        vpand	%ymm6, %ymm2, %ymm2
        vpand	%ymm7, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        vpsrad	$31, %ymm4, %ymm0
        vpsrad	$31, %ymm5, %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vmovdqu	%ymm4, 320(%rdi)
        vmovdqu	%ymm5, 352(%rdi)
        vmovdqu	384(%rdi), %ymm0
        vmovdqu	416(%rdi), %ymm1
        vpsrad	$31, %ymm0, %ymm2
        vpsrad	$31, %ymm1, %ymm3
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm0, %ymm4
        vpmulld	%ymm12, %ymm1, %ymm5
        vpaddd	%ymm11, %ymm4, %ymm4
        vpaddd	%ymm11, %ymm5, %ymm5
        vpsrld	$23, %ymm4, %ymm4
        vpsrld	$23, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm9, %ymm2
        vpsubd	%ymm3, %ymm9, %ymm3
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpcmpeqd	%ymm12, %ymm4, %ymm0
        vpcmpeqd	%ymm12, %ymm5, %ymm1
        vpaddd	%ymm0, %ymm2, %ymm2
        vpaddd	%ymm1, %ymm3, %ymm3
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        movq	$0x01, %r9
        xorq	%r10, %r10
        xorq	%rcx, %rcx
L_mldsa_use_hint_88_avx2_hints_next_0_6:
        cmp	%dl, %al
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_6
        mov	%r8b, %cl
        sub	$0x60, %cl
        cmpq	$16, %rcx
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_6
        mov	%r9, %r11
        shlq	%cl, %r11
        orq	%r11, %r10
        inc	%al
        mov	(%rsi,%rax,1), %r8b
        jmp	L_mldsa_use_hint_88_avx2_hints_next_0_6
L_mldsa_use_hint_88_avx2_hints_done_0_6:
        movd	%r10d, %xmm6
        shr	$8, %r10
        movd	%r10d, %xmm7
        vpbroadcastd	%xmm6, %ymm6
        vpbroadcastd	%xmm7, %ymm7
        vpsllvd	%ymm13, %ymm6, %ymm6
        vpsllvd	%ymm13, %ymm7, %ymm7
        vpsrad	$31, %ymm6, %ymm6
        vpsrad	$31, %ymm7, %ymm7
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpslld	$0x01, %ymm2, %ymm2
        vpslld	$0x01, %ymm3, %ymm3
        vpsubd	%ymm2, %ymm14, %ymm2
        vpsubd	%ymm3, %ymm14, %ymm3
        vpand	%ymm6, %ymm2, %ymm2
        vpand	%ymm7, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        vpsrad	$31, %ymm4, %ymm0
        vpsrad	$31, %ymm5, %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vmovdqu	%ymm4, 384(%rdi)
        vmovdqu	%ymm5, 416(%rdi)
        vmovdqu	448(%rdi), %ymm0
        vmovdqu	480(%rdi), %ymm1
        vpsrad	$31, %ymm0, %ymm2
        vpsrad	$31, %ymm1, %ymm3
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm0, %ymm4
        vpmulld	%ymm12, %ymm1, %ymm5
        vpaddd	%ymm11, %ymm4, %ymm4
        vpaddd	%ymm11, %ymm5, %ymm5
        vpsrld	$23, %ymm4, %ymm4
        vpsrld	$23, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm9, %ymm2
        vpsubd	%ymm3, %ymm9, %ymm3
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpcmpeqd	%ymm12, %ymm4, %ymm0
        vpcmpeqd	%ymm12, %ymm5, %ymm1
        vpaddd	%ymm0, %ymm2, %ymm2
        vpaddd	%ymm1, %ymm3, %ymm3
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        movq	$0x01, %r9
        xorq	%r10, %r10
        xorq	%rcx, %rcx
L_mldsa_use_hint_88_avx2_hints_next_0_7:
        cmp	%dl, %al
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_7
        mov	%r8b, %cl
        sub	$0x70, %cl
        cmpq	$16, %rcx
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_7
        mov	%r9, %r11
        shlq	%cl, %r11
        orq	%r11, %r10
        inc	%al
        mov	(%rsi,%rax,1), %r8b
        jmp	L_mldsa_use_hint_88_avx2_hints_next_0_7
L_mldsa_use_hint_88_avx2_hints_done_0_7:
        movd	%r10d, %xmm6
        shr	$8, %r10
        movd	%r10d, %xmm7
        vpbroadcastd	%xmm6, %ymm6
        vpbroadcastd	%xmm7, %ymm7
        vpsllvd	%ymm13, %ymm6, %ymm6
        vpsllvd	%ymm13, %ymm7, %ymm7
        vpsrad	$31, %ymm6, %ymm6
        vpsrad	$31, %ymm7, %ymm7
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpslld	$0x01, %ymm2, %ymm2
        vpslld	$0x01, %ymm3, %ymm3
        vpsubd	%ymm2, %ymm14, %ymm2
        vpsubd	%ymm3, %ymm14, %ymm3
        vpand	%ymm6, %ymm2, %ymm2
        vpand	%ymm7, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        vpsrad	$31, %ymm4, %ymm0
        vpsrad	$31, %ymm5, %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vmovdqu	%ymm4, 448(%rdi)
        vmovdqu	%ymm5, 480(%rdi)
        vmovdqu	512(%rdi), %ymm0
        vmovdqu	544(%rdi), %ymm1
        vpsrad	$31, %ymm0, %ymm2
        vpsrad	$31, %ymm1, %ymm3
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm0, %ymm4
        vpmulld	%ymm12, %ymm1, %ymm5
        vpaddd	%ymm11, %ymm4, %ymm4
        vpaddd	%ymm11, %ymm5, %ymm5
        vpsrld	$23, %ymm4, %ymm4
        vpsrld	$23, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm9, %ymm2
        vpsubd	%ymm3, %ymm9, %ymm3
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpcmpeqd	%ymm12, %ymm4, %ymm0
        vpcmpeqd	%ymm12, %ymm5, %ymm1
        vpaddd	%ymm0, %ymm2, %ymm2
        vpaddd	%ymm1, %ymm3, %ymm3
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        movq	$0x01, %r9
        xorq	%r10, %r10
        xorq	%rcx, %rcx
L_mldsa_use_hint_88_avx2_hints_next_0_8:
        cmp	%dl, %al
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_8
        mov	%r8b, %cl
        sub	$0x80, %cl
        cmpq	$16, %rcx
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_8
        mov	%r9, %r11
        shlq	%cl, %r11
        orq	%r11, %r10
        inc	%al
        mov	(%rsi,%rax,1), %r8b
        jmp	L_mldsa_use_hint_88_avx2_hints_next_0_8
L_mldsa_use_hint_88_avx2_hints_done_0_8:
        movd	%r10d, %xmm6
        shr	$8, %r10
        movd	%r10d, %xmm7
        vpbroadcastd	%xmm6, %ymm6
        vpbroadcastd	%xmm7, %ymm7
        vpsllvd	%ymm13, %ymm6, %ymm6
        vpsllvd	%ymm13, %ymm7, %ymm7
        vpsrad	$31, %ymm6, %ymm6
        vpsrad	$31, %ymm7, %ymm7
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpslld	$0x01, %ymm2, %ymm2
        vpslld	$0x01, %ymm3, %ymm3
        vpsubd	%ymm2, %ymm14, %ymm2
        vpsubd	%ymm3, %ymm14, %ymm3
        vpand	%ymm6, %ymm2, %ymm2
        vpand	%ymm7, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        vpsrad	$31, %ymm4, %ymm0
        vpsrad	$31, %ymm5, %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vmovdqu	%ymm4, 512(%rdi)
        vmovdqu	%ymm5, 544(%rdi)
        vmovdqu	576(%rdi), %ymm0
        vmovdqu	608(%rdi), %ymm1
        vpsrad	$31, %ymm0, %ymm2
        vpsrad	$31, %ymm1, %ymm3
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm0, %ymm4
        vpmulld	%ymm12, %ymm1, %ymm5
        vpaddd	%ymm11, %ymm4, %ymm4
        vpaddd	%ymm11, %ymm5, %ymm5
        vpsrld	$23, %ymm4, %ymm4
        vpsrld	$23, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm9, %ymm2
        vpsubd	%ymm3, %ymm9, %ymm3
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpcmpeqd	%ymm12, %ymm4, %ymm0
        vpcmpeqd	%ymm12, %ymm5, %ymm1
        vpaddd	%ymm0, %ymm2, %ymm2
        vpaddd	%ymm1, %ymm3, %ymm3
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        movq	$0x01, %r9
        xorq	%r10, %r10
        xorq	%rcx, %rcx
L_mldsa_use_hint_88_avx2_hints_next_0_9:
        cmp	%dl, %al
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_9
        mov	%r8b, %cl
        sub	$0x90, %cl
        cmpq	$16, %rcx
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_9
        mov	%r9, %r11
        shlq	%cl, %r11
        orq	%r11, %r10
        inc	%al
        mov	(%rsi,%rax,1), %r8b
        jmp	L_mldsa_use_hint_88_avx2_hints_next_0_9
L_mldsa_use_hint_88_avx2_hints_done_0_9:
        movd	%r10d, %xmm6
        shr	$8, %r10
        movd	%r10d, %xmm7
        vpbroadcastd	%xmm6, %ymm6
        vpbroadcastd	%xmm7, %ymm7
        vpsllvd	%ymm13, %ymm6, %ymm6
        vpsllvd	%ymm13, %ymm7, %ymm7
        vpsrad	$31, %ymm6, %ymm6
        vpsrad	$31, %ymm7, %ymm7
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpslld	$0x01, %ymm2, %ymm2
        vpslld	$0x01, %ymm3, %ymm3
        vpsubd	%ymm2, %ymm14, %ymm2
        vpsubd	%ymm3, %ymm14, %ymm3
        vpand	%ymm6, %ymm2, %ymm2
        vpand	%ymm7, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        vpsrad	$31, %ymm4, %ymm0
        vpsrad	$31, %ymm5, %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vmovdqu	%ymm4, 576(%rdi)
        vmovdqu	%ymm5, 608(%rdi)
        vmovdqu	640(%rdi), %ymm0
        vmovdqu	672(%rdi), %ymm1
        vpsrad	$31, %ymm0, %ymm2
        vpsrad	$31, %ymm1, %ymm3
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm0, %ymm4
        vpmulld	%ymm12, %ymm1, %ymm5
        vpaddd	%ymm11, %ymm4, %ymm4
        vpaddd	%ymm11, %ymm5, %ymm5
        vpsrld	$23, %ymm4, %ymm4
        vpsrld	$23, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm9, %ymm2
        vpsubd	%ymm3, %ymm9, %ymm3
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpcmpeqd	%ymm12, %ymm4, %ymm0
        vpcmpeqd	%ymm12, %ymm5, %ymm1
        vpaddd	%ymm0, %ymm2, %ymm2
        vpaddd	%ymm1, %ymm3, %ymm3
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        movq	$0x01, %r9
        xorq	%r10, %r10
        xorq	%rcx, %rcx
L_mldsa_use_hint_88_avx2_hints_next_0_10:
        cmp	%dl, %al
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_10
        mov	%r8b, %cl
        sub	$0xa0, %cl
        cmpq	$16, %rcx
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_10
        mov	%r9, %r11
        shlq	%cl, %r11
        orq	%r11, %r10
        inc	%al
        mov	(%rsi,%rax,1), %r8b
        jmp	L_mldsa_use_hint_88_avx2_hints_next_0_10
L_mldsa_use_hint_88_avx2_hints_done_0_10:
        movd	%r10d, %xmm6
        shr	$8, %r10
        movd	%r10d, %xmm7
        vpbroadcastd	%xmm6, %ymm6
        vpbroadcastd	%xmm7, %ymm7
        vpsllvd	%ymm13, %ymm6, %ymm6
        vpsllvd	%ymm13, %ymm7, %ymm7
        vpsrad	$31, %ymm6, %ymm6
        vpsrad	$31, %ymm7, %ymm7
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpslld	$0x01, %ymm2, %ymm2
        vpslld	$0x01, %ymm3, %ymm3
        vpsubd	%ymm2, %ymm14, %ymm2
        vpsubd	%ymm3, %ymm14, %ymm3
        vpand	%ymm6, %ymm2, %ymm2
        vpand	%ymm7, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        vpsrad	$31, %ymm4, %ymm0
        vpsrad	$31, %ymm5, %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vmovdqu	%ymm4, 640(%rdi)
        vmovdqu	%ymm5, 672(%rdi)
        vmovdqu	704(%rdi), %ymm0
        vmovdqu	736(%rdi), %ymm1
        vpsrad	$31, %ymm0, %ymm2
        vpsrad	$31, %ymm1, %ymm3
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm0, %ymm4
        vpmulld	%ymm12, %ymm1, %ymm5
        vpaddd	%ymm11, %ymm4, %ymm4
        vpaddd	%ymm11, %ymm5, %ymm5
        vpsrld	$23, %ymm4, %ymm4
        vpsrld	$23, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm9, %ymm2
        vpsubd	%ymm3, %ymm9, %ymm3
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpcmpeqd	%ymm12, %ymm4, %ymm0
        vpcmpeqd	%ymm12, %ymm5, %ymm1
        vpaddd	%ymm0, %ymm2, %ymm2
        vpaddd	%ymm1, %ymm3, %ymm3
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        movq	$0x01, %r9
        xorq	%r10, %r10
        xorq	%rcx, %rcx
L_mldsa_use_hint_88_avx2_hints_next_0_11:
        cmp	%dl, %al
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_11
        mov	%r8b, %cl
        sub	$0xb0, %cl
        cmpq	$16, %rcx
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_11
        mov	%r9, %r11
        shlq	%cl, %r11
        orq	%r11, %r10
        inc	%al
        mov	(%rsi,%rax,1), %r8b
        jmp	L_mldsa_use_hint_88_avx2_hints_next_0_11
L_mldsa_use_hint_88_avx2_hints_done_0_11:
        movd	%r10d, %xmm6
        shr	$8, %r10
        movd	%r10d, %xmm7
        vpbroadcastd	%xmm6, %ymm6
        vpbroadcastd	%xmm7, %ymm7
        vpsllvd	%ymm13, %ymm6, %ymm6
        vpsllvd	%ymm13, %ymm7, %ymm7
        vpsrad	$31, %ymm6, %ymm6
        vpsrad	$31, %ymm7, %ymm7
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpslld	$0x01, %ymm2, %ymm2
        vpslld	$0x01, %ymm3, %ymm3
        vpsubd	%ymm2, %ymm14, %ymm2
        vpsubd	%ymm3, %ymm14, %ymm3
        vpand	%ymm6, %ymm2, %ymm2
        vpand	%ymm7, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        vpsrad	$31, %ymm4, %ymm0
        vpsrad	$31, %ymm5, %ymm1
        vpand	%ymm12, %ymm0, %ymm0
        vpand	%ymm12, %ymm1, %ymm1
        vpaddd	%ymm0, %ymm4, %ymm4
        vpaddd	%ymm1, %ymm5, %ymm5
        vmovdqu	%ymm4, 704(%rdi)
        vmovdqu	%ymm5, 736(%rdi)
        vmovdqu	768(%rdi), %ymm0
        vmovdqu	800(%rdi), %ymm1
        vpsrad	$31, %ymm0, %ymm2
        vpsrad	$31, %ymm1, %ymm3
        vpand	%ymm8, %ymm2, %ymm2
        vpand	%ymm8, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm0, %ymm0
        vpaddd	%ymm3, %ymm1, %ymm1
        vpmulld	%ymm12, %ymm0, %ymm4
        vpmulld	%ymm12, %ymm1, %ymm5
        vpaddd	%ymm11, %ymm4, %ymm4
        vpaddd	%ymm11, %ymm5, %ymm5
        vpsrld	$23, %ymm4, %ymm4
        vpsrld	$23, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpsubd	%ymm2, %ymm9, %ymm2
        vpsubd	%ymm3, %ymm9, %ymm3
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpmulld	%ymm10, %ymm4, %ymm2
        vpmulld	%ymm10, %ymm5, %ymm3
        vpsubd	%ymm2, %ymm0, %ymm2
        vpsubd	%ymm3, %ymm1, %ymm3
        vpcmpeqd	%ymm12, %ymm4, %ymm0
        vpcmpeqd	%ymm12, %ymm5, %ymm1
        vpaddd	%ymm0, %ymm2, %ymm2
        vpaddd	%ymm1, %ymm3, %ymm3
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpand	%ymm1, %ymm5, %ymm5
        movq	$0x01, %r9
        xorq	%r10, %r10
        xorq	%rcx, %rcx
L_mldsa_use_hint_88_avx2_hints_next_0_12:
        cmp	%dl, %al
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_12
        mov	%r8b, %cl
        sub	$0xc0, %cl
        cmpq	$16, %rcx
        jge	L_mldsa_use_hint_88_avx2_hints_done_0_12
        mov	%r9, %r11
        shlq	%cl, %r11
        orq	%r11, %r10
        inc	%al
        mov	(%rsi,%rax,1), %r8b
        jmp	L_mldsa_use_hint_88_avx2_hints_next_0_12
L_mldsa_use_hint_88_avx2_hints_done_0_12:
        movd	%r10d, %xmm6
        shr	$8, %r10
        movd	%r10d, %xmm7
        vpbroadcastd	%xmm6, %ymm6
        vpbroadcastd	%xmm7, %ymm7
        vpsllvd	%ymm13, %ymm6, %ymm6
        vpsllvd	%ymm13, %ymm7, %ymm7
        vpsrad	$31, %ymm6, %ymm6
        vpsrad	$31, %ymm7, %ymm7
        vpsrld	$31, %ymm2, %ymm2
        vpsrld	$31, %ymm3, %ymm3
        vpslld	$0x01, %ymm2, %ymm2
        vpslld	$0x01, %ymm3, %ymm3
        vpsubd	%ymm2, %ymm14, %ymm2
        vpsubd	%ymm3, %ymm14, %ymm3
        vpand	%ymm6, %ymm2, %ymm2
        vpand	%ymm7, %ymm3, %ymm3
        vpaddd	%ymm2, %ymm4, %ymm4
        vpaddd	%ymm3, %ymm5, %ymm5
        vpcmpgtd	%ymm4, %ymm12, %ymm0
        vpcmpgtd	%ymm5, %ymm12, %ymm1
        vpand	%ymm0, %ymm4, %ymm4
        vpan