/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc.interceptors;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.jdbc.ResultSetInternalMethods;
import com.mysql.cj.api.jdbc.Statement;
import com.mysql.cj.api.jdbc.interceptors.StatementInterceptor;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.core.util.Util;
import com.mysql.cj.jdbc.util.ResultSetUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ServerStatusDiffInterceptor
implements StatementInterceptor {
    private Map<String, String> preExecuteValues = new HashMap<String, String>();
    private Map<String, String> postExecuteValues = new HashMap<String, String>();
    private Log log;

    @Override
    public void init(MysqlConnection conn, Properties props, Log l2) {
        this.log = l2;
    }

    @Override
    public ResultSetInternalMethods postProcess(String sql, Statement interceptedStatement, ResultSetInternalMethods originalResultSet, JdbcConnection connection) throws SQLException {
        this.populateMapWithSessionStatusValues(connection, this.postExecuteValues);
        this.log.logInfo("Server status change for statement:\n" + Util.calculateDifferences(this.preExecuteValues, this.postExecuteValues));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateMapWithSessionStatusValues(JdbcConnection connection, Map<String, String> toPopulate) throws SQLException {
        java.sql.Statement stmt = null;
        ResultSet rs = null;
        try {
            toPopulate.clear();
            stmt = connection.createStatement();
            rs = stmt.executeQuery("SHOW SESSION STATUS");
            ResultSetUtil.resultSetToMap(toPopulate, rs);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public ResultSetInternalMethods preProcess(String sql, Statement interceptedStatement, JdbcConnection connection) throws SQLException {
        this.populateMapWithSessionStatusValues(connection, this.preExecuteValues);
        return null;
    }

    @Override
    public boolean executeTopLevelOnly() {
        return true;
    }

    @Override
    public void destroy() {
    }
}

