/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import oracle.sql.OPAQUE;

public class ClassRef {
    static final XMLTypeClassRef XMLTYPE = XMLTypeClassRef.newInstance();
    public static final Locale LOCALE = Locale.newInstance();
    private final String className;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    static final ClassRef newInstance(String string) throws ClassNotFoundException {
        return new ClassRef(string);
    }

    private ClassRef(String string) throws ClassNotFoundException {
        this.className = string;
    }

    Class get() {
        try {
            return Class.forName(this.className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            noClassDefFoundError.initCause(classNotFoundException);
            throw noClassDefFoundError;
        }
    }

    public static class Locale {
        protected final Method localeJDK7getDefault;
        protected final Object localeCategoryEnumFORMAT;

        static final Locale newInstance() {
            try {
                return new Locale();
            }
            catch (Exception exception) {
                return null;
            }
        }

        private Locale() {
            LocaleCategoryClassRef localeCategoryClassRef = LocaleCategoryClassRef.newInstance();
            Method method = null;
            Object var3_3 = null;
            if (localeCategoryClassRef != null) {
                try {
                    T[] TArray;
                    for (Object t : TArray = localeCategoryClassRef.get().getEnumConstants()) {
                        if (((Enum)t).name() != "FORMAT") continue;
                        var3_3 = t;
                        break;
                    }
                    method = java.util.Locale.class.getDeclaredMethod("getDefault", localeCategoryClassRef.get());
                }
                catch (Throwable throwable) {
                    method = null;
                    var3_3 = null;
                }
            }
            this.localeJDK7getDefault = method;
            this.localeCategoryEnumFORMAT = var3_3;
        }

        public java.util.Locale getDefault() {
            try {
                if (this.localeJDK7getDefault == null) {
                    return java.util.Locale.getDefault();
                }
                return (java.util.Locale)this.localeJDK7getDefault.invoke(null, this.localeCategoryEnumFORMAT);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
    }

    public static class LocaleCategoryClassRef
    extends ClassRef {
        static final LocaleCategoryClassRef newInstance() {
            try {
                return new LocaleCategoryClassRef();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return null;
        }

        private LocaleCategoryClassRef() throws ClassNotFoundException {
            super("java.util.Locale$Category");
        }
    }

    static class XMLTypeClassRef
    extends ClassRef {
        protected final Method CREATEXML;

        static final XMLTypeClassRef newInstance() {
            try {
                return new XMLTypeClassRef();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return null;
        }

        private XMLTypeClassRef() throws ClassNotFoundException {
            super("oracle.xdb.XMLType");
            Method method = null;
            try {
                method = this.get().getDeclaredMethod("createXML", OPAQUE.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.CREATEXML = method;
        }

        OPAQUE createXML(OPAQUE oPAQUE) throws SQLException {
            this.get();
            try {
                return (OPAQUE)this.CREATEXML.invoke(null, oPAQUE);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
    }
}

